/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.BitSet;

public class BitSetUtils {
    public static BigInteger toBigInteger(BitSet bits) {
        if (bits == null) {
            return null;
        }
        byte[] littleEndian = bits.toByteArray();
        if (littleEndian.length == 0) {
            return BigInteger.ZERO;
        }
        int n = littleEndian.length;
        byte[] bigEndian = new byte[n];
        int i = 0;
        while (i < n) {
            bigEndian[i] = littleEndian[n - 1 - i];
            ++i;
        }
        return new BigInteger(1, bigEndian);
    }

    public static BitSet toBitSet(BigInteger bits) {
        if (bits == null) {
            return null;
        }
        if (bits.signum() == 0) {
            return new BitSet();
        }
        byte[] bigEndian = bits.toByteArray();
        if (bigEndian.length == 0) {
            return new BitSet();
        }
        int n = bigEndian.length;
        byte[] littleEndian = new byte[n];
        int i = 0;
        while (i < n) {
            littleEndian[i] = bigEndian[n - 1 - i];
            ++i;
        }
        return BitSet.valueOf(littleEndian);
    }

    public static BitSet shiftLeft(BitSet src, int n) {
        if (src.isEmpty()) {
            return (BitSet)src.clone();
        }
        if (n < 0) {
            return BitSetUtils.shiftRight(src, -n);
        }
        if (n == 0) {
            return (BitSet)src.clone();
        }
        long[] srcArr = src.toLongArray();
        int wordShift = n >>> 6;
        int bitShift = n & 0x3F;
        long[] dstArr = new long[srcArr.length + wordShift + 1];
        int i = 0;
        while (i < srcArr.length) {
            int dstIdx;
            long v = srcArr[i];
            int n2 = dstIdx = i + wordShift;
            dstArr[n2] = dstArr[n2] | v << bitShift;
            if (bitShift != 0) {
                int n3 = dstIdx + 1;
                dstArr[n3] = dstArr[n3] | v >>> 64 - bitShift;
            }
            ++i;
        }
        return BitSet.valueOf(dstArr);
    }

    public static BitSet shiftRight(BitSet src, int n) {
        if (src.isEmpty()) {
            return (BitSet)src.clone();
        }
        if (n < 0) {
            return BitSetUtils.shiftLeft(src, -n);
        }
        if (n == 0) {
            return (BitSet)src.clone();
        }
        long[] srcArr = src.toLongArray();
        int wordShift = n >>> 6;
        int bitShift = n & 0x3F;
        if (wordShift >= srcArr.length) {
            return new BitSet();
        }
        int dstLen = srcArr.length - wordShift;
        long[] dstArr = new long[dstLen];
        int i = 0;
        while (i < dstLen) {
            long low = srcArr[i + wordShift] >>> bitShift;
            long high = 0L;
            if (bitShift != 0 && i + wordShift + 1 < srcArr.length) {
                high = srcArr[i + wordShift + 1] << 64 - bitShift;
            }
            dstArr[i] = low | high;
            ++i;
        }
        return BitSet.valueOf(dstArr);
    }

    public static BitSet shiftAndMask(BitSet src, int n, int lhsBitMask) {
        if (lhsBitMask <= 0) {
            return new BitSet();
        }
        if (src.isEmpty()) {
            return new BitSet();
        }
        if (n == 0 && lhsBitMask >= src.length()) {
            return (BitSet)src.clone();
        }
        long[] srcArr = src.toLongArray();
        int wordShift = n >>> 6;
        int bitShift = n & 0x3F;
        if (wordShift >= srcArr.length) {
            return new BitSet();
        }
        int dstLen = srcArr.length - wordShift;
        long[] dstArr = new long[dstLen];
        int lastAllowedBit = lhsBitMask - 1;
        int lastAllowedWord = lastAllowedBit >>> 6;
        int i = 0;
        while (i < dstLen) {
            int bitsToKeep;
            long low = srcArr[i + wordShift] >>> bitShift;
            long high = 0L;
            if (bitShift != 0 && i + wordShift + 1 < srcArr.length) {
                high = srcArr[i + wordShift + 1] << 64 - bitShift;
            }
            long combined = low | high;
            if (i > lastAllowedWord) {
                combined = 0L;
            } else if (i == lastAllowedWord && (bitsToKeep = lhsBitMask & 0x3F) != 0) {
                combined &= (1L << bitsToKeep) - 1L;
            }
            dstArr[i] = combined;
            ++i;
        }
        return BitSet.valueOf(dstArr);
    }

    public static BitSet valueOf(int i) {
        BitSet result = new BitSet();
        if (i == 0) {
            return result;
        }
        result.set(i - 1);
        return result;
    }

    public static BitSet getPowerOfTwo(int size) {
        BitSet result = new BitSet();
        result.set(size);
        return result;
    }

    public static BitSet getPowerOfTwoMask(int size) {
        BitSet result = new BitSet();
        int i = 0;
        while (i < size) {
            result.set(i);
            ++i;
        }
        return result;
    }

    public static BitSet getPowerOfTwoMaskShiftLeft(int size, int shiftLeftBits) {
        BitSet result = new BitSet();
        int i = 0;
        while (i < size) {
            result.set(i + shiftLeftBits);
            ++i;
        }
        return result;
    }
}

