/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.List;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VhdlFunction;
import ro.amiq.dvt.utils.VhdlPackageInstantiation;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;

public class BitVectorContext {
    public static final DVTNumber NO_CONTEXT = VlogBitVector.create(false, 0, 0, BigInteger.ZERO);
    private static final DVTNumber PACKED_UPDATE_NO_SIGN = VlogBitVector.create(false, 0, 0, BigInteger.ZERO);
    private static final DVTNumber PACKED_UPDATE_SIGNED = VlogBitVector.create(true, 0, 0, BigInteger.ZERO);
    private static final DVTNumber PACKED_UPDATE_UNSIGNED = VlogBitVector.create(false, 0, 0, BigInteger.ZERO);
    private boolean isIndexSTDULogic;
    private boolean isFlexible;
    private boolean forceBitVector;
    private boolean allowTypeEvaluation;
    private boolean isSizeKnown;
    private boolean preserveSign;
    private boolean isCast;
    private boolean hasRealOrigin;
    private List<MaskType> driveStrengths;
    private XArrayValueHolder arraySelectSource;
    private DVTNumber contextNumber;
    private IRfNamedElement contextType;
    private IRfNamedElement timescaleScope;
    private final IRfNamedElement origin;

    protected BitVectorContext(DVTNumber contextNumber, IRfNamedElement contextType, IRfNamedElement origin) {
        if (contextNumber == null && contextType == null) {
            throw new IllegalArgumentException("Context number and context type cannot be both null!");
        }
        this.contextNumber = contextNumber;
        this.contextType = contextType;
        this.origin = origin;
        this.isFlexible = false;
        this.isSizeKnown = false;
        this.forceBitVector = true;
        this.allowTypeEvaluation = false;
        this.isCast = false;
        this.isIndexSTDULogic = false;
        this.hasRealOrigin = contextNumber instanceof VlogRealNumber;
    }

    public static BitVectorContext of(DVTNumber contextNumber, IRfNamedElement origin) {
        return new BitVectorContext(contextNumber, null, origin);
    }

    public static BitVectorContext of(DVTNumber contextNumber, IRfNamedElement contextType, IRfNamedElement origin) {
        return new BitVectorContext(contextNumber, contextType, origin);
    }

    public static BitVectorContext of(IRfNamedElement origin, boolean allowTypeEvaluation) {
        BitVectorContext result = new BitVectorContext(NO_CONTEXT, null, origin);
        result.allowTypeEvaluation = allowTypeEvaluation;
        return result;
    }

    public static BitVectorContext flexibleDefault(int startingSize, boolean isString, IRfNamedElement origin) {
        BitVectorContext bitVectorHandler = new BitVectorContext(VlogBitVector.create(true, startingSize <= 0 ? 0 : startingSize - 1, 0, null, false, isString), null, origin);
        bitVectorHandler.isFlexible = true;
        bitVectorHandler.forceBitVector = false;
        return bitVectorHandler;
    }

    public static BitVectorContext ofPackedUpdate(IRfNamedElement origin, boolean allowTypeEvaluation, int specifiedSign) {
        DVTNumber packedUpdate = specifiedSign == 0 ? PACKED_UPDATE_NO_SIGN : (specifiedSign == 1 ? PACKED_UPDATE_SIGNED : PACKED_UPDATE_UNSIGNED);
        BitVectorContext bitVectorHandler = new BitVectorContext(packedUpdate, null, origin);
        bitVectorHandler.allowTypeEvaluation = allowTypeEvaluation;
        bitVectorHandler.isFlexible = false;
        return bitVectorHandler;
    }

    public BitVectorContext weaken(boolean keepPackedDimensions) {
        if (this.contextNumber == null) {
            return this;
        }
        boolean isFromDataType = !this.isFlexible;
        BitVectorContext bitVectorContext = new BitVectorContext(VlogBitVector.create(isFromDataType || this.contextNumber.hasSign(), this.contextNumber.getSize() - 1, 0, keepPackedDimensions ? this.contextNumber.getPacked() : null, this.contextNumber.is4State()), null, this.origin);
        bitVectorContext.forceBitVector = false;
        bitVectorContext.allowTypeEvaluation = this.allowTypeEvaluation;
        bitVectorContext.isFlexible = true;
        return bitVectorContext;
    }

    public BitVectorContext setULogicIndex(boolean value) {
        this.isIndexSTDULogic = value;
        return this;
    }

    public boolean isIndexSTDULogic() {
        return this.isIndexSTDULogic;
    }

    public boolean isSizeKnown() {
        return this.isSizeKnown;
    }

    public void setSizeKnown(boolean set) {
        if (!set || this.contextNumber instanceof VlogBitVector) {
            this.isSizeKnown = set;
        }
    }

    public boolean isVlog() {
        return !ELUtils.isVHDL(this.origin);
    }

    public boolean isPackedUpdateContext() {
        return this.contextNumber == PACKED_UPDATE_NO_SIGN || this.contextNumber == PACKED_UPDATE_SIGNED || this.contextNumber == PACKED_UPDATE_UNSIGNED;
    }

    public boolean hasUnconstrainedFirstDimension() {
        return this.contextNumber instanceof IDVTRangeSelectable && ((IDVTRangeSelectable)((Object)this.contextNumber)).isUnconstrainedFirstDimension();
    }

    public boolean isVHDLMethod() {
        return this.contextNumber instanceof VhdlFunction;
    }

    public boolean isVHDLPackageInstantiation() {
        return this.contextNumber instanceof VhdlPackageInstantiation;
    }

    public IRfNamedElement getOrigin() {
        return this.origin;
    }

    public boolean hasDriveStrength() {
        return this.driveStrengths != null && this.driveStrengths.size() == 2;
    }

    public List<MaskType> getDriveStrengths() {
        return this.driveStrengths;
    }

    public void setDriveStrengths(List<MaskType> driveStrengths) {
        this.driveStrengths = driveStrengths;
    }

    public IELParamValue transformDriveStrengths(IELParamValue value) {
        if (!this.hasDriveStrength()) {
            return value;
        }
        if (value instanceof ELParamValues.ParamValueType) {
            return value;
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            DVTNumber dvtNumber = value.getDVTNumber();
            if (!(dvtNumber instanceof VlogBitVector)) {
                return value;
            }
            VlogBitVector bitVector = (VlogBitVector)dvtNumber;
            return ELParamValues.ParamValueNumber.of(bitVector.transformWithDriveStrength(this.driveStrengths.get(0), this.driveStrengths.get(1)), value.getElement(), value.getEnumTypeWrapper());
        }
        return value;
    }

    public boolean newContextForOperands(HidOperator operator) {
        if (this.isNoContext() || this.isPackedUpdateContext()) {
            return true;
        }
        if (this.contextNumber instanceof VlogAbstractRealNumber) {
            return true;
        }
        if (this.contextNumber instanceof VlogBitVector && ((VlogBitVector)this.contextNumber).isString()) {
            return true;
        }
        return operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && operator.isRelational() || operator.isEqualityOrInequality();
    }

    public ELParamValueScope transform(ELParamValueScope paramValueScope) {
        IELParamValue paramValue = XUtils.getValue(paramValueScope);
        IELParamValue transformed = this.transform(paramValue);
        return ELParamValueScope.of(transformed, XUtils.getScope(paramValueScope));
    }

    public IELParamValue transform(IELParamValue paramValue) {
        if (paramValue instanceof ELParamValues.ParamValueType) {
            return paramValue;
        }
        if (paramValue instanceof ELParamValues.ParamValueNumber) {
            DVTNumber transformed = this.transform(paramValue.getDVTNumber());
            IELParamValue transformedValue = ELParamValues.ParamValueNumber.of(transformed, paramValue.getElement(), paramValue.getEnumTypeWrapper());
            if (!this.isPackedUpdateContext()) {
                transformedValue.setOriginal(paramValue);
            }
            return transformedValue;
        }
        return paramValue;
    }

    public DVTNumber transformUnsizedXLiteral(VlogBitVector number) {
        if (this.isNoContext()) {
            return number;
        }
        if (this.isPackedUpdateContext()) {
            boolean finalSign = this.contextNumber == PACKED_UPDATE_SIGNED || this.contextNumber != PACKED_UPDATE_UNSIGNED && number.hasSign();
            int[] nArray = new int[2];
            nArray[0] = number.getSize() - 1;
            return VlogBitVector.create(finalSign, number.getSize() - 1, 0, nArray, true, false, false, false, number.getMemberInfoByName(), number.getMasks(), number.bigIntegerValue());
        }
        if (this.contextNumber instanceof VlogBitVector) {
            VlogBitVector bvContext;
            if (this.preserveSign && this.contextNumber.hasSign() != number.hasSign()) {
                this.contextNumber = VlogBitVector.copy((VlogBitVector)this.contextNumber, number.hasSign());
            }
            if ((bvContext = (VlogBitVector)this.contextNumber).hasUnknownSize()) {
                return bvContext;
            }
            if (number.hasUnknownSize()) {
                return number;
            }
            if (bvContext.isString()) {
                int[] nArray;
                int newRight;
                boolean takeFromContext;
                VlogBitVector bvNumber = number;
                boolean isVlog = this.isVlog();
                if (isVlog && !bvNumber.isString()) {
                    bvNumber = bvNumber.toVlogStringCompatibleBitVector();
                }
                boolean bl = takeFromContext = !isVlog && (bvContext.getLeft() != -1 || bvContext.getRight() != -1);
                if (!takeFromContext && bvNumber.isString()) {
                    return bvNumber;
                }
                int newLeft = takeFromContext ? bvContext.getLeft() : bvNumber.getLeft();
                int n = newRight = takeFromContext ? bvContext.getRight() : bvNumber.getRight();
                if (takeFromContext) {
                    nArray = bvContext.getArrayDimensions();
                } else {
                    int[] nArray2 = new int[2];
                    nArray2[0] = Math.min(newLeft, newRight);
                    nArray = nArray2;
                    nArray2[1] = Math.max(newLeft, newRight);
                }
                int[] arrayDimensions = nArray;
                return VlogBitVector.create(false, newLeft, newRight, arrayDimensions, false, true, false, false, null, bvContext.getMasks()).from(bvNumber);
            }
            if (bvContext.isStruct(true)) {
                return bvContext.fromXUnsizedLiteral(number);
            }
            if (this.isFlexible) {
                if (bvContext.hasSign() && !number.hasSign()) {
                    bvContext = VlogBitVector.copy(bvContext, false);
                    this.contextNumber = bvContext;
                }
                if (number.getSize() == bvContext.getSize()) {
                    return number;
                }
                if (number.getSize() > bvContext.getSize()) {
                    this.contextNumber = VlogBitVector.create(bvContext.hasSign(), number.getSize() - 1, 0, null, false);
                    return number;
                }
                return VlogBitVector.create(number.hasSign(), bvContext.getSize() - 1, 0, bvContext.getArrayDimensions(), false).fromXUnsizedLiteral(number);
            }
            VlogBitVector result = bvContext.fromXUnsizedLiteral(number);
            if (!bvContext.is4State()) {
                EnumMap<MaskType, BitSet> newMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
                newMasks.put(MaskType.UNKNOWN, result.getMask(MaskType.UNKNOWN));
                result = VlogBitVector.copy(result, newMasks);
            }
            return result;
        }
        if (this.contextNumber instanceof VlogRealNumber) {
            return VlogRealNumber.ZERO.from(number, this.isCast);
        }
        if (this.contextNumber instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.ZERO.from(number, this.isCast);
        }
        if (this.contextNumber instanceof DVTUnpackedArray) {
            return this.contextNumber.from(number, this.isCast);
        }
        if (this.contextNumber instanceof DVTUnpackedStruct) {
            return this.contextNumber.from(number, this.isCast);
        }
        return number;
    }

    public DVTNumber transform(DVTNumber number) {
        if (this.contextNumber == null && this.contextType instanceof IRfListType) {
            throw new UnsupportedOperationException("Invalid list context!");
        }
        if (DVTNumber.isUndefined(number)) {
            return number;
        }
        if (this.isNoContext()) {
            return number;
        }
        if (this.isPackedUpdateContext()) {
            boolean finalSign;
            boolean bl = finalSign = this.contextNumber == PACKED_UPDATE_SIGNED || this.contextNumber != PACKED_UPDATE_UNSIGNED && number.hasSign();
            if (number instanceof VlogBitVector) {
                int[] nArray = new int[2];
                nArray[0] = number.getSize() - 1;
                return VlogBitVector.create(finalSign, number.getSize() - 1, 0, nArray, true, false, false, false, ((VlogBitVector)number).getMemberInfoByName(), ((VlogBitVector)number).getMasks(), number.bigIntegerValue());
            }
            return number;
        }
        if (this.contextNumber instanceof VhdlEnum) {
            VlogBitVector vbvContext = (VlogBitVector)this.contextNumber;
            if (vbvContext.isUnconstrainedFirstDimension()) {
                return number;
            }
            return ((VlogBitVector)this.contextNumber).from(number, this.isCast);
        }
        if (this.contextNumber instanceof VlogBitVector) {
            return this.transformToBitVector(number);
        }
        if (this.contextNumber instanceof VlogRealNumber) {
            return VlogRealNumber.ZERO.from(number, this.isCast);
        }
        if (this.contextNumber instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.ZERO.from(number, this.isCast);
        }
        if (this.contextNumber instanceof DVTUnpackedArray) {
            if (((DVTUnpackedArray)this.contextNumber).isUnconstrainedFirstDimension() && number instanceof DVTUnpackedArray) {
                return number;
            }
            return this.contextNumber.from(number, this.isCast);
        }
        if (this.contextNumber instanceof DVTUnpackedStruct) {
            return this.contextNumber.from(number, this.isCast);
        }
        return number;
    }

    public boolean isNoContext() {
        return this.contextNumber == NO_CONTEXT;
    }

    public DVTNumber getVLOGValueForUnconstrainedVHDLArray(DVTNumber value) {
        if (!(value instanceof VlogBitVector)) {
            return value;
        }
        VlogBitVector bitVector = (VlogBitVector)value;
        if (this.isString()) {
            int[] bitVectorPacked = bitVector.getArrayDimensions();
            int[] newPacked = new int[]{1, Math.abs(bitVectorPacked[0] - bitVectorPacked[1]) + 1};
            return VlogBitVector.create(false, bitVector.getSize() - 1, 0, newPacked, false, true).from(bitVector);
        }
        if (this.contextNumber instanceof VhdlEnum && !bitVector.isString()) {
            int[] thisPacked = bitVector.getArrayDimensions();
            int[] contextPacked = ((VhdlEnum)this.contextNumber).getArrayDimensions();
            if (contextPacked.length > 4 || thisPacked.length > 2) {
                return DVTNumber.UNDEFINED;
            }
            int[] newPacked = new int[thisPacked.length + 2];
            int i = 0;
            while (i < thisPacked.length - 1) {
                newPacked[i] = 0;
                newPacked[i + 1] = Math.abs(thisPacked[i] - thisPacked[i + 1]);
                i += 2;
            }
            newPacked[thisPacked.length] = contextPacked[contextPacked.length - 2];
            newPacked[thisPacked.length + 1] = contextPacked[contextPacked.length - 1];
            return VlogBitVector.create(bitVector.hasSign(), bitVector.getLeft(), bitVector.getRight(), newPacked, bitVector.is4State(), false, false, false, bitVector.getMemberInfoByName(), bitVector.getMasks(), bitVector.getNumber());
        }
        return value;
    }

    private DVTNumber transformToBitVector(DVTNumber number) {
        VlogBitVector bvContext;
        if (!(number instanceof VlogBitVector)) {
            if (this.forceBitVector | this.isCast) {
                return this.contextNumber.from(number, this.isCast);
            }
            if (number instanceof VlogShortrealNumber && this.isFlexible) {
                this.contextNumber = VlogShortrealNumber.ZERO;
            }
            if ((number instanceof VlogRealNumber || this.hasRealOrigin) && this.isFlexible) {
                this.contextNumber = VlogRealNumber.ZERO;
                this.hasRealOrigin = true;
            }
            if (this.hasRealOrigin && number instanceof VlogShortrealNumber) {
                return VlogRealNumber.ZERO.from(number, this.isCast);
            }
            if (VlogAbstractRealNumber.isInfinite(number) || VlogAbstractRealNumber.isNaN(number)) {
                return this.isFlexible ? number : VlogBitVector.create(this.contextNumber.hasSign(), this.contextNumber.getSize() - 1, 0, BigInteger.ZERO);
            }
            return number;
        }
        if (this.preserveSign && this.contextNumber.hasSign() != number.hasSign()) {
            this.contextNumber = VlogBitVector.copy((VlogBitVector)this.contextNumber, number.hasSign());
        }
        if ((bvContext = (VlogBitVector)this.contextNumber).hasUnknownSize()) {
            return bvContext;
        }
        if (number.hasUnknownSize()) {
            return number;
        }
        if (bvContext.isString()) {
            int[] nArray;
            int newRight;
            boolean takeFromContext;
            VlogBitVector bvNumber = (VlogBitVector)number;
            boolean isVlog = this.isVlog();
            if (isVlog && !bvNumber.isString()) {
                bvNumber = bvNumber.toVlogStringCompatibleBitVector();
            }
            boolean bl = takeFromContext = !isVlog && (bvContext.getLeft() != -1 || bvContext.getRight() != -1);
            if (!takeFromContext && bvNumber.isString()) {
                return bvNumber;
            }
            int newLeft = takeFromContext ? bvContext.getLeft() : bvNumber.getLeft();
            int n = newRight = takeFromContext ? bvContext.getRight() : bvNumber.getRight();
            if (takeFromContext) {
                nArray = bvContext.getArrayDimensions();
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = Math.min(newLeft, newRight);
                nArray = nArray2;
                nArray2[1] = Math.max(newLeft, newRight);
            }
            int[] arrayDimensions = nArray;
            return VlogBitVector.create(false, newLeft, newRight, arrayDimensions, false, true, false, false, null, bvContext.getMasks()).from(bvNumber);
        }
        if (bvContext.isStruct(true)) {
            return bvContext.from(number, false);
        }
        if (this.isFlexible) {
            if (bvContext.hasSign() && !number.hasSign()) {
                bvContext = VlogBitVector.copy(bvContext, false);
                this.contextNumber = bvContext;
            }
            if (!bvContext.hasSign() && number.hasSign()) {
                number = ((VlogBitVector)number).signedToUnsigned();
            }
            if (number.getSize() == bvContext.getSize()) {
                return number;
            }
            if (number.getSize() > bvContext.getSize()) {
                this.contextNumber = VlogBitVector.create(bvContext.hasSign(), number.getSize() - 1, 0, null, false);
                return number;
            }
            return VlogBitVector.create(number.hasSign(), bvContext.getSize() - 1, 0, bvContext.getArrayDimensions(), false).from(number, false);
        }
        VlogBitVector result = (VlogBitVector)bvContext.from(number, false);
        if (!bvContext.is4State()) {
            EnumMap<MaskType, BitSet> newMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
            newMasks.put(MaskType.UNKNOWN, result.getMask(MaskType.UNKNOWN));
            result = VlogBitVector.copy(result, newMasks);
        }
        return result;
    }

    public int getSize() {
        return this.contextNumber != null ? this.contextNumber.getSize() : -1;
    }

    public IRfNamedElement getContextType() {
        return this.contextType;
    }

    public boolean isCast() {
        return this.isCast;
    }

    public boolean is4State() {
        return this.contextNumber.is4State();
    }

    public boolean hasSign() {
        return this.contextNumber.hasSign();
    }

    public DVTNumber getContextNumber() {
        return this.contextNumber;
    }

    public boolean allowTypeEvaluation() {
        if (this.allowTypeEvaluation) {
            return true;
        }
        return this.origin instanceof IRfFieldElement && ((IRfFieldElement)this.origin).isTypeParameter();
    }

    public void setAllowTypeEvaluation(boolean set) {
        this.allowTypeEvaluation = set;
    }

    public boolean isUnpackedArrayContext() {
        return this.contextNumber instanceof DVTUnpackedArray || this.contextNumber == null && this.contextType instanceof IRfListType && !((IRfListType)this.contextType).isPacked();
    }

    public boolean isStructContext() {
        return this.isUnpackedStructContext() || this.isPackedStructContext();
    }

    public boolean isPackedStructContext() {
        return this.contextNumber instanceof VlogBitVector && ((VlogBitVector)this.contextNumber).isStruct(true) || this.contextNumber == null && this.contextType instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)this.contextType).isStruct() && ((IRfCompositeTypeElement)this.contextType).isPacked();
    }

    public boolean isUnpackedStructContext() {
        return this.contextNumber instanceof DVTUnpackedStruct || this.contextNumber == null && this.contextType instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)this.contextType).isStruct() && !((IRfCompositeTypeElement)this.contextType).isPacked();
    }

    public boolean isString() {
        return this.contextNumber instanceof VlogBitVector && ((VlogBitVector)this.contextNumber).isString();
    }

    public void setPreserveSign(boolean preserve) {
        this.preserveSign = preserve;
    }

    public void setIsCast(boolean cast) {
        this.isCast = cast;
    }

    public void setTimescaleScope(IRfNamedElement scope) {
        this.timescaleScope = scope;
    }

    public IRfNamedElement getTimescaleScope() {
        return this.timescaleScope == null ? this.origin : this.timescaleScope;
    }

    public void setArraySelectSource(XArrayValueHolder arraySource) {
        this.arraySelectSource = arraySource;
    }

    public XArrayValueHolder getArraySelectSource() {
        return this.arraySelectSource;
    }

    public void setHasRealOrigin(boolean hasRealOrigin) {
        this.hasRealOrigin = hasRealOrigin;
    }

    public boolean hasRealOrigin() {
        return this.hasRealOrigin;
    }
}

