/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

public class BufferUtils {
    private static final char[] kHexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String stringToHex(String s) {
        byte[] stringBytes = s.getBytes();
        return BufferUtils.bufferToHex(stringBytes);
    }

    public static String bufferToHex(byte[] buffer) {
        return BufferUtils.bufferToHex(buffer, 0, buffer.length);
    }

    public static String bufferToHex(byte[] buffer, int startOffset, int length) {
        StringBuilder hexString = new StringBuilder(2 * length);
        int endOffset = startOffset + length;
        int i = startOffset;
        while (i < endOffset) {
            BufferUtils.appendHexPair(buffer[i], hexString);
            ++i;
        }
        return hexString.toString();
    }

    public static String hexToString(String hexString) throws NumberFormatException {
        byte[] bytes = BufferUtils.hexToBuffer(hexString);
        return new String(bytes);
    }

    public static byte[] hexToBuffer(String hexString) throws NumberFormatException {
        int length = hexString.length();
        byte[] buffer = new byte[(length + 1) / 2];
        boolean evenByte = true;
        byte nextByte = 0;
        int bufferOffset = 0;
        if (length % 2 == 1) {
            evenByte = false;
        }
        int i = 0;
        while (i < length) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new NumberFormatException("Invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = (byte)(nibble << 4);
            } else {
                nextByte = (byte)(nextByte + (byte)nibble);
                buffer[bufferOffset++] = nextByte;
            }
            evenByte = !evenByte;
            ++i;
        }
        return buffer;
    }

    private static void appendHexPair(byte b, StringBuilder hexString) {
        char highNibble = kHexChars[(b & 0xF0) >> 4];
        char lowNibble = kHexChars[b & 0xF];
        hexString.append(highNibble);
        hexString.append(lowNibble);
    }
}

