/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;

public final class ByteBufferInputStream
extends InputStream
implements DataInput {
    private RandomAccessFile fAccessFile;
    private FileChannel fChannel;
    private ByteBuffer fByteBuffer;

    private static RuntimeException convertException(RuntimeException e) throws IOException {
        if (e instanceof BufferUnderflowException) {
            throw (IOException)new EOFException().initCause(e);
        }
        if (e instanceof NullPointerException) {
            throw new ClosedChannelException();
        }
        return e;
    }

    public ByteBufferInputStream(File file) throws IOException {
        this.fAccessFile = new RandomAccessFile(file, "r");
        this.fChannel = this.fAccessFile.getChannel();
        this.fByteBuffer = this.fChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
    }

    @Override
    public int available() throws IOException {
        try {
            int ba = this.fByteBuffer.remaining();
            return ba;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.fByteBuffer.clear();
        this.fByteBuffer = null;
        this.fAccessFile.close();
        this.fChannel.close();
    }

    public ByteBuffer getBuffer() {
        return this.fByteBuffer;
    }

    @Override
    public int read() throws IOException {
        block3: {
            try {
                if (this.fByteBuffer.remaining() != 0) break block3;
                return -1;
            }
            catch (RuntimeException e) {
                throw ByteBufferInputStream.convertException(e);
            }
        }
        int ch = this.fByteBuffer.get() & 0xFF;
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remain;
        block3: {
            try {
                remain = this.fByteBuffer.remaining();
                if (remain != 0) break block3;
                return -1;
            }
            catch (RuntimeException e) {
                throw ByteBufferInputStream.convertException(e);
            }
        }
        int actualLen = Math.min(len, remain);
        this.fByteBuffer.get(b, off, actualLen);
        return actualLen;
    }

    @Override
    public boolean readBoolean() throws IOException {
        try {
            return this.fByteBuffer.get() != 0;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public byte readByte() throws IOException {
        try {
            return this.fByteBuffer.get();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public char readChar() throws IOException {
        try {
            return this.fByteBuffer.getChar();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public double readDouble() throws IOException {
        try {
            return this.fByteBuffer.getDouble();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public float readFloat() throws IOException {
        try {
            return this.fByteBuffer.getFloat();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        try {
            this.fByteBuffer.get(b);
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.fByteBuffer.get(b, off, len);
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            return this.fByteBuffer.getInt();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sbuf = null;
        try {
            byte b;
            while ((b = this.fByteBuffer.get()) != 10) {
                if (sbuf == null) {
                    sbuf = new StringBuilder();
                }
                if (b == 13) continue;
                sbuf.append((char)b);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
        return sbuf != null ? sbuf.toString() : null;
    }

    @Override
    public long readLong() throws IOException {
        try {
            return this.fByteBuffer.getLong();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public short readShort() throws IOException {
        try {
            return this.fByteBuffer.getShort();
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public int readUnsignedByte() throws IOException {
        try {
            return this.fByteBuffer.get() & 0xFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public int readUnsignedShort() throws IOException {
        try {
            return this.fByteBuffer.getShort() & 0xFFFF;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            int actualSkip = (int)Math.min(n, (long)this.fByteBuffer.remaining());
            this.fByteBuffer.position(this.fByteBuffer.position() + actualSkip);
            return actualSkip;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        try {
            int limit = this.fByteBuffer.limit();
            int curpos = this.fByteBuffer.position();
            int actualn = Math.min(limit, n);
            this.fByteBuffer.position(curpos + actualn);
            return actualn;
        }
        catch (RuntimeException e) {
            throw ByteBufferInputStream.convertException(e);
        }
    }
}

