/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.CommentUtilsCommon;

public class CommentUtils
extends CommentUtilsCommon {
    private static CommentUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommentUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new CommentUtils();
            }
        }
        return INSTANCE;
    }

    @Override
    public String getNewLine() {
        return "<br>";
    }

    @Override
    protected String getImagePath(String text) {
        return text;
    }

    public void setTooltipFormatterPreference(DVTComment.CommentFormat format) {
        PrefConst.setTooltipMarkupLanguage(format.getPreferenceName());
    }

    @Override
    public DVTComment.CommentFormat getTooltipFormatterPreference() {
        return DVTComment.CommentFormat.parseDVTPreference(PrefConst.getTooltipMarkupLanguage());
    }

    @Override
    public boolean shouldUseOldTooltip() {
        return DVTComment.CommentFormat.OLD_VERBATIM.equals((Object)this.getTooltipFormatterPreference()) || !EclipseUtils.hasWorkingBrowser();
    }

    public static int getTooltipMaxSizePreference() {
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        return store.getInt("tooltip.size");
    }

    public void setTooltipMaxSizePreference(int value) {
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        store.setValue("tooltip.size", value);
    }

    public static boolean useHtml() {
        return true;
    }

    @Override
    protected String getLineBreak() {
        return "<br>";
    }

    @Override
    protected int getLineBreakLength() {
        return 4;
    }
}

