/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.comment.formatter.CommentConstants;
import ro.amiq.dvt.comment.formatter.DVTComment;
import ro.amiq.dvt.comment.formatter.JavadocCommentFormatter;
import ro.amiq.dvt.comment.formatter.MarkdownCommentFormatter;
import ro.amiq.dvt.comment.formatter.NaturalDocsCommentFormatter;
import ro.amiq.dvt.diagrams.wavedrom.Wavedrom;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public abstract class CommentUtilsCommon {
    public static final String HEADING_TITLE = "heading_title";
    public static final String HEADING_CONTENT = "heading_content";
    public static final String TOPIC_TITLE = "topic_title";
    public static final String TOPIC_CONTENT = "topic_content";
    protected static final String MARKDOWN_NEWLINE = "  \n";
    private final Set<String> SPECIAL_HTML_TAGS = new HashSet<String>(Arrays.asList("div", "li", "dd", "dt"));
    private final Set<String> SPACE_DELIMITED_HTML_TAGS = new HashSet<String>(Arrays.asList("code", "dt", "dd", "div", "ol", "pre", "p", "section", "table"));
    private static final Pattern START_OF_THE_LINE_WHITE_SPACES = Pattern.compile("^[ \\t\\v\\f]*");
    private static final Pattern THICK_UNICODE_PATTERN = Pattern.compile("&#96;");
    private static final String IGNORE_NATURAL_DOCS_PRE = "```HTML_IGNORE_PRE_MARK```";
    private static final String IGNORE_NATURAL_DOCS_CODE = "```HTML_IGNORE_CODE_MARK```";
    private static final Pattern BEAUTIFY_PATTERN_BFM = Pattern.compile("\\b[bB][fF][mM]\\b");
    private static final Pattern BEAUTIFY_PATTERN_TCM = Pattern.compile("\\b[tT][cC][mM]\\b");
    private static final Pattern BEAUTIFY_PATTERN_DUT = Pattern.compile("\\b[dD][uU][tT]\\b");
    private static final Pattern BEAUTIFY_PATTERN_EVC = Pattern.compile("\\b[eE][vV][cC]\\b");
    private static final Pattern BEAUTIFY_PATTERN_BFMS = Pattern.compile("\\b[bB][fF][mM][sS]\\b");
    private static final Pattern BEAUTIFY_PATTERN_TCMS = Pattern.compile("\\b[tT][cC][mM][sS]\\b");
    private static final Pattern BEAUTIFY_PATTERN_DUTS = Pattern.compile("\\b[dD][uU][tT][sS]\\b");
    private static final Pattern BEAUTIFY_PATTERN_EVCS = Pattern.compile("\\b[eE][vV][cC][sS]\\b");
    private static final Pattern BEAUTIFY_PATTERN_AT = Pattern.compile("\\s@\\s");
    private static final Pattern NON_STANDARD_BI_HTML_TAG = Pattern.compile("<(/)?bi>");
    private static final Pattern NON_STANDARD_BR_LT_HTML_TAG = Pattern.compile("<(?!/?([bBiI]|br|BR)>)");
    private static final Pattern NON_STANDARD_BR_GT_HTML_TAG = Pattern.compile("(?<!</?([bBiI]|br|BR))>");

    protected int skipNextLines(int index, String[] lines) {
        int nrOfLinesSkipped = 0;
        while (lines[index].isEmpty() && index < lines.length) {
            ++nrOfLinesSkipped;
            ++index;
        }
        if (index < lines.length && this.startsWithClosedSpecialHtmlTag(lines[index])) {
            return nrOfLinesSkipped;
        }
        return 0;
    }

    protected boolean startsWithClosedSpecialHtmlTag(String text) {
        for (String tag : this.SPECIAL_HTML_TAGS) {
            if (!text.startsWith("</" + tag + ">")) continue;
            return true;
        }
        return false;
    }

    public DVTComment.CommentFormat getCommentFormat(String content) {
        DVTComment.CommentFormat format = this.getTooltipFormatterPreference();
        if (this.shouldUseOldTooltip()) {
            return DVTComment.CommentFormat.OLD_VERBATIM;
        }
        if (format == DVTComment.CommentFormat.AUTO) {
            return this.autodetectContentFormatter(content);
        }
        return format;
    }

    public abstract boolean shouldUseOldTooltip();

    public abstract DVTComment.CommentFormat getTooltipFormatterPreference();

    protected boolean startsWithSpaceDelimitedHtmlTag(String text) {
        String startTag = "<";
        if (!text.startsWith(startTag)) {
            return false;
        }
        if ((text = text.substring(startTag.length())) == null || text.isEmpty()) {
            return false;
        }
        for (String tag : this.SPACE_DELIMITED_HTML_TAGS) {
            if (!text.startsWith(tag)) continue;
            return true;
        }
        return false;
    }

    private String removeWhiteSpacesFromStartOfTheLine(String text) {
        return DVTStringUtil.replaceAll(START_OF_THE_LINE_WHITE_SPACES, text, " ");
    }

    public String splitTextIntoBlockElements(String text) {
        return this.splitTextIntoBlockElements(text, false);
    }

    public String splitTextIntoBlockElements(String text, boolean toHTML) {
        StringBuilder result = new StringBuilder();
        StringBuilder paragraph = new StringBuilder();
        StringBuilder section = new StringBuilder();
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length - 1) {
            String currentLine = lines[i];
            if (!currentLine.isEmpty()) {
                if (section.length() > 0 && (currentLine.trim().isEmpty() || !currentLine.startsWith(" "))) {
                    section.append(" ");
                }
                section.append(this.removeWhiteSpacesFromStartOfTheLine(currentLine));
                section.append("\n");
                ++i;
                continue;
            }
            if (section.length() == 0) {
                ++i;
                continue;
            }
            int skipLines = this.skipNextLines(i, lines);
            if (skipLines > 0) {
                i += skipLines;
                continue;
            }
            paragraph.append(toHTML ? this.wrapIntoParagraph(section.toString(), toHTML) : this.wrapIntoSection(section.toString()));
            section.setLength(0);
            String nextLine = lines[i + 1];
            if (nextLine.isEmpty() || this.startsWithSpaceDelimitedHtmlTag(nextLine)) {
                result.append(this.wrapIntoParagraph(paragraph.toString(), toHTML));
                paragraph.setLength(0);
            }
            ++i;
        }
        String lastLine = lines[lines.length - 1];
        if (!lastLine.isEmpty()) {
            if (section.length() > 0 && (lastLine.trim().isEmpty() || !lastLine.startsWith(" "))) {
                section.append(" ");
            }
            section.append(this.removeWhiteSpacesFromStartOfTheLine(lastLine));
            section.append("\n");
        }
        if (section.length() > 0) {
            paragraph.append(toHTML ? this.wrapIntoParagraph(section.toString(), toHTML) : this.wrapIntoSection(section.toString()));
            result.append(this.wrapIntoParagraph(paragraph.toString(), toHTML));
        }
        return result.toString();
    }

    public String wrapIntoSection(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return MARKDOWN_NEWLINE + text + MARKDOWN_NEWLINE;
    }

    public String wrapIntoParagraph(String text) {
        return this.wrapIntoParagraph(text, false);
    }

    public String wrapIntoParagraph(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<p>\n\n" + text + "\n\n</p>";
        }
        return MARKDOWN_NEWLINE + text + MARKDOWN_NEWLINE;
    }

    public String wrapIntoDefintionList(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (!toHTML) {
            return text;
        }
        return "<dl>" + text + "</dl>";
    }

    public String wrapIntoDefinitionName(String text, boolean beginWithNL, boolean toHTML) {
        if (text.trim().isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<dt class='def_name_wrapper'>\n\n" + text.trim() + "\n\n" + "</dt>";
        }
        if (beginWithNL) {
            return "  \n**" + this.removeInnerStars(text.trim()) + "**" + MARKDOWN_NEWLINE;
        }
        return " **" + this.removeInnerStars(text.trim()) + "**" + MARKDOWN_NEWLINE;
    }

    public String wrapIntoDefinitionDescription(String text, boolean toHTML) {
        if (toHTML) {
            return "<dd class='def_description_wrapper'>\n\n" + text.trim() + "\n\n" + "</dd>";
        }
        if (text.trim().isEmpty()) {
            return text;
        }
        return MARKDOWN_NEWLINE + text.trim() + MARKDOWN_NEWLINE;
    }

    public String wrapIntoBold(String text) {
        return this.wrapIntoBold(text, false);
    }

    public String wrapIntoBold(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<b class='bold_wrapper'>" + text + "</b>";
        }
        return " **" + text.trim() + "** ";
    }

    public String wrapIntoItalic(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return " *" + text.trim() + "* ";
    }

    public String wrapIntoItalicBold(String text) {
        if (text.isEmpty()) {
            return text;
        }
        return " ___" + text.trim() + "___ ";
    }

    public String wrapIntoUnderline(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (!toHTML) {
            return text.trim();
        }
        return "<u class='underline_wrapper'>" + text + "</u>";
    }

    public String replaceUnicodeCharacters(String text) {
        text = DVTStringUtil.replaceAll(CommentConstants.LT_PATTERN, text, "<");
        text = DVTStringUtil.replaceAll(CommentConstants.GT_PATTERN, text, ">");
        return DVTStringUtil.replaceAll(THICK_UNICODE_PATTERN, text, "`");
    }

    private boolean hasInnerCodeBlock(String text) {
        return text.contains(IGNORE_NATURAL_DOCS_CODE) || text.contains(IGNORE_NATURAL_DOCS_PRE);
    }

    public String wrapIntoPre(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "\n<pre class='pre_section'>" + text + "</pre>\n";
        }
        if (this.hasInnerCodeBlock(text)) {
            return text;
        }
        String result = "\n```\n" + this.replaceUnicodeCharacters(text);
        if (text.charAt(text.length() - 1) != '\n') {
            result = String.valueOf(result) + "\n";
        }
        result = String.valueOf(result) + "```\n";
        return result;
    }

    public String wrapIntoListItem(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<li class='list_wrapper'>\n\n" + text + "\n" + "</li>";
        }
        return "  \n+ " + text + MARKDOWN_NEWLINE;
    }

    public String wrapIntoUnorderedList(String text, boolean toHTML) {
        if (text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<ul class='unordered_list_wrapper'>\n\n" + text + "\n" + "</ul>";
        }
        return MARKDOWN_NEWLINE + text + MARKDOWN_NEWLINE;
    }

    protected String removeInnerStars(String text) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != '*') {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public String wrapIntoDiv(String text, String className, boolean toHTML) {
        if (text.isEmpty() || className.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<div class='" + className + "'>" + "\n\n" + text + "\n\n" + "</div>\n";
        }
        if (HEADING_TITLE.equals(className) || TOPIC_TITLE.equals(className)) {
            return "  \n***" + this.removeInnerStars(text).trim() + "***" + MARKDOWN_NEWLINE;
        }
        if (HEADING_CONTENT.equals(className) || TOPIC_CONTENT.equals(className)) {
            return MARKDOWN_NEWLINE + text + MARKDOWN_NEWLINE;
        }
        return MARKDOWN_NEWLINE + text + MARKDOWN_NEWLINE;
    }

    public String wrapIntoImg(String text, String altName, boolean specialImage) {
        if (text.isEmpty() || altName.isEmpty()) {
            return text;
        }
        String imagePath = specialImage ? this.getImagePath(text) : text;
        return "  \n  \n![" + altName + "]" + "(" + imagePath + ")" + MARKDOWN_NEWLINE + MARKDOWN_NEWLINE;
    }

    protected abstract String getImagePath(String var1);

    public String wrapIntoA(String link, String text, boolean toHTML) {
        if (link.isEmpty() || text.isEmpty()) {
            return text;
        }
        if (toHTML) {
            return "<a class='a_wrapper' href=\"" + link + "\">" + text + "</a>";
        }
        return "[" + text + "]" + "(" + link + ")";
    }

    public String wrapIntoMail(String link, String text) {
        if (link.isEmpty() || text.isEmpty()) {
            return text;
        }
        return "[" + text + "]" + "(mailto:" + link + ")";
    }

    public String wrapIntoCode(String text, boolean surroundWithNewLines, boolean toHTML) {
        String processedText;
        if (text.isEmpty()) {
            return text;
        }
        String string = processedText = toHTML ? text : this.replaceUnicodeCharacters(text);
        if (this.hasInnerCodeBlock(text)) {
            return processedText;
        }
        if (toHTML) {
            return "<code>" + processedText.trim() + "</code>";
        }
        if (surroundWithNewLines) {
            return "  \n```  \n" + processedText.trim() + "  \n```  \n";
        }
        return " ```" + processedText.trim() + "``` ";
    }

    public String getHorizontalLine(boolean toHTML) {
        if (toHTML) {
            return "<hr class='horizontal_line'>";
        }
        return "  \n***  \n";
    }

    public static String getLimitSizeFooterText(int sizeLimit) {
        return "...<br><b>Comment was trimmed because it exceeds the " + sizeLimit + " characters threshold.<br>" + "You can change the threshold value from <a href=\"" + "ro.amiq.dvt.EditorsPreferencePage" + "?openPreferenceDialog" + "\">Editors Preference Page</a>.";
    }

    public DVTComment.CommentFormat autodetectContentFormatter(String comment) {
        if (MarkdownCommentFormatter.INSTANCE.hasCodeBlock(comment)) {
            return DVTComment.CommentFormat.MARKDOWN;
        }
        if (this.hasAtLeastOneSpecialTag(comment, JavadocCommentFormatter.SPECIAL_TAGS)) {
            return DVTComment.CommentFormat.JAVADOC;
        }
        if (this.hasAtLeastOneSpecialTag(comment, NaturalDocsCommentFormatter.SPECIAL_TAGS) || NaturalDocsCommentFormatter.INSTANCE.isValid(comment)) {
            return DVTComment.CommentFormat.NATURAL_DOCS;
        }
        if (System.getenv("DVT_DISABLE_MARKDOWN") != null || "true".equals(System.getenv("DVT_DISABLE_MARKDOWN"))) {
            return DVTComment.CommentFormat.NATURAL_DOCS;
        }
        return DVTComment.CommentFormat.MARKDOWN;
    }

    private boolean hasAtLeastOneSpecialTag(String comment, Pattern[] specialTags) {
        if (specialTags == null) {
            return false;
        }
        Matcher matcher = null;
        Pattern[] patternArray = specialTags;
        int n = specialTags.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            matcher = pattern.matcher(comment);
            if (matcher.find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getBitfieldDiagramDiv(String elementContent) {
        return "<div class=\"bitfield\">" + elementContent + "</div>";
    }

    public static String getCustomDiagramOutputPath(IRfNamedElement element, String diagramDescriptionText) {
        return CommentUtilsCommon.getCustomDiagramOutputPath(element, diagramDescriptionText, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCustomDiagramOutputPath(IRfNamedElement element, String diagramDescriptionText, boolean wrapIntoImg) {
        try {
            String fileName;
            File outputFile;
            File inputFile;
            if (element == null) {
                return "[FAILURE] Could not determine the identifier!";
            }
            String filePath = element.getDeclaration().getParserPath().toString();
            String workingDirectory = DVTUtilsCommon.INSTANCE.getProject(element).getLocation().toOSString();
            File currentFile = new File(filePath);
            if (!currentFile.exists()) {
                return "[FAILURE] Source file of the diagram description does not exist!";
            }
            Map<String, String> pragmaDiagramVariables = CommentUtilsCommon.parsePragmaDiagramVariables(diagramDescriptionText.trim());
            if (pragmaDiagramVariables == null || pragmaDiagramVariables.isEmpty()) {
                return "[FAILURE] Could not parse the pragma variables!";
            }
            String programPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(pragmaDiagramVariables.get("@program"));
            if (programPath == null || programPath.isEmpty()) {
                return "[FAILURE] Program path was not specified!";
            }
            if (!new File(programPath = programPath.replaceFirst("^~", System.getProperty("user.home"))).isAbsolute()) {
                programPath = String.valueOf(currentFile.getParentFile().getAbsolutePath()) + File.separator + programPath;
            }
            if (!Files.isExecutable(Paths.get(programPath, new String[0]))) {
                return "[FAILURE] Program " + programPath + " is not an executable!";
            }
            boolean replaceParameterAndMacros = pragmaDiagramVariables.containsKey("@replace_params") ? Boolean.valueOf(pragmaDiagramVariables.get("@replace_params")) : true;
            File file = inputFile = pragmaDiagramVariables.containsKey("@input_file") ? new File(pragmaDiagramVariables.get("@input_file").replaceFirst("^~", System.getProperty("user.home"))) : null;
            if (inputFile == null) {
                String input = pragmaDiagramVariables.get("@input");
                if (input == null) {
                    return "[FAILURE] No input provided!";
                }
                inputFile = Files.createTempFile("dvt_diagram_description_input_", null, new FileAttribute[0]).toFile();
                FileUtils.writeStringToFile((File)inputFile, (String)(replaceParameterAndMacros ? CommentUtilsCommon.enhanceComment(element, input) : input));
            }
            if (!inputFile.isAbsolute()) {
                inputFile = new File(String.valueOf(currentFile.getParentFile().getAbsolutePath()) + File.separator + inputFile.getPath());
            }
            File file2 = outputFile = pragmaDiagramVariables.containsKey("@output_file") ? new File(pragmaDiagramVariables.get("@output_file").replaceFirst("^~", System.getProperty("user.home"))) : null;
            if (outputFile == null) {
                outputFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "dvt_diagram_description_output_" + System.currentTimeMillis() + ".tmp");
            }
            if (!outputFile.isAbsolute()) {
                outputFile = new File(String.valueOf(currentFile.getParentFile().getAbsolutePath()) + File.separator + pragmaDiagramVariables.get("@output_file"));
            }
            String string = fileName = pragmaDiagramVariables.containsKey("@output_file") ? pragmaDiagramVariables.get("@output_file") : "dvt_diagram_description_output_" + System.currentTimeMillis() + ".svg";
            if (!wrapIntoImg) {
                outputFile = new File(LanguageContributor.get(element.getLanguageKind()).getOutputLocation(), "diagrams" + File.separator + fileName);
            }
            outputFile.getParentFile().mkdirs();
            File parametersFile = null;
            IRfSingleLangProject rfProject = element.getRfProject();
            Map<String, String> paramsMap = rfProject.getPreprocessingParamsForDiagrams(element, currentFile.getAbsolutePath(), element.getLine());
            if (!paramsMap.isEmpty()) {
                parametersFile = Files.createTempFile("dvt_diagram_description_params_", null, new FileAttribute[0]).toFile();
                StringBuilder sb = new StringBuilder();
                Iterator<Map.Entry<String, String>> iterator = paramsMap.entrySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        FileUtils.writeStringToFile((File)parametersFile, (String)sb.toString());
                        break;
                    }
                    Map.Entry<String, String> entry = iterator.next();
                    sb.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
                }
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(programPath);
            command.add(inputFile.getAbsolutePath());
            command.add(outputFile.getAbsolutePath());
            if (parametersFile != null) {
                command.add(parametersFile.getAbsolutePath());
            }
            if (pragmaDiagramVariables.containsKey("@args")) {
                command.addAll(Arrays.asList(pragmaDiagramVariables.get("@args").split(DVTStringUtil.MULTIPLE_WS.toString())));
            }
            String processOutput = DVTUtilsCommon.INSTANCE.executeProgram(command, workingDirectory, 5000);
            if (!outputFile.exists()) {
                return "[FAILURE] Diagram output file could not be generated! Program output:<br>" + DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, processOutput, "<br>") + "[PROGRAM CALL]:" + DVTStringUtil.join(command, " ");
            }
            if (inputFile.getAbsolutePath().contains(System.getProperty("java.io.tmpdir"))) {
                inputFile.deleteOnExit();
            }
            if (parametersFile != null) {
                parametersFile.deleteOnExit();
            }
            if (!wrapIntoImg) {
                return outputFile.getAbsolutePath();
            }
            if (outputFile.getAbsolutePath().contains(System.getProperty("java.io.tmpdir"))) {
                outputFile.deleteOnExit();
            }
            return MessageFormat.format("<br><img src=''file://{0}?t={1}''/><br>", outputFile.getAbsolutePath(), System.currentTimeMillis());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return diagramDescriptionText;
        }
    }

    private static Map<String, String> parsePragmaDiagramVariables(String pragmaDiagramDescription) {
        HashSet<String> availablePragmas = new HashSet<String>();
        availablePragmas.add("@program");
        availablePragmas.add("@input_file");
        availablePragmas.add("@output_file");
        availablePragmas.add("@input");
        availablePragmas.add("@args");
        availablePragmas.add("@replace_params");
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder data = new StringBuilder();
        StringBuilder possiblePragma = new StringBuilder();
        boolean pragmaMode = false;
        String currentPragma = "";
        int i = 0;
        while (i < pragmaDiagramDescription.length()) {
            switch (pragmaDiagramDescription.charAt(i)) {
                case '\n': 
                case ' ': {
                    if (availablePragmas.contains(possiblePragma.toString().trim())) {
                        if (!currentPragma.isEmpty()) {
                            result.put(currentPragma, data.toString().trim());
                            data.setLength(0);
                        }
                        currentPragma = possiblePragma.toString();
                    } else {
                        data.append(possiblePragma.toString());
                    }
                    data.append(pragmaDiagramDescription.charAt(i));
                    possiblePragma.setLength(0);
                    pragmaMode = false;
                    break;
                }
                case '@': {
                    pragmaMode = true;
                }
                default: {
                    if (pragmaMode) {
                        possiblePragma.append(pragmaDiagramDescription.charAt(i));
                        break;
                    }
                    data.append(pragmaDiagramDescription.charAt(i));
                }
            }
            ++i;
        }
        result.put(currentPragma, data.append(possiblePragma.toString()).toString().trim());
        return result;
    }

    public String[] cleanArray(String[] linkPath) {
        ArrayList<String> newArray = new ArrayList<String>();
        if (linkPath.length == 0) {
            return linkPath;
        }
        boolean prevIsEmpty = false;
        int i = 0;
        while (i < linkPath.length) {
            if (linkPath[i].isEmpty() && !prevIsEmpty && i != 0 && i != linkPath.length - 1) {
                prevIsEmpty = true;
            } else {
                linkPath[i] = linkPath[i].replace(" #", "#");
                newArray.add(linkPath[i].endsWith("()") ? linkPath[i].substring(0, linkPath[i].length() - 2) : linkPath[i]);
                prevIsEmpty = false;
            }
            ++i;
        }
        return newArray.toArray(new String[newArray.size()]);
    }

    public boolean containsUnpermittedPatterns(String text) {
        if (text.isEmpty() || text.length() == 1) {
            return false;
        }
        String[] stringArray = CommentConstants.UNPERMITTED_LINK_SPLIT_PATTERN;
        int n = CommentConstants.UNPERMITTED_LINK_SPLIT_PATTERN.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (text.contains(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String enhanceComment(IRfNamedElement element, String comment) {
        String elementName;
        if (comment.isEmpty()) {
            return comment;
        }
        String string = elementName = element == null ? "" : element.getName();
        if (elementName == null || elementName.isEmpty()) {
            comment = String.valueOf(comment.substring(0, 1).toUpperCase()) + comment.substring(1);
        } else if (!comment.regionMatches(true, 0, elementName, 0, elementName.length())) {
            comment = String.valueOf(comment.substring(0, 1).toUpperCase()) + comment.substring(1);
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (element instanceof IRfDesignElement) {
            IRfSingleLangProject rfProject = element.getRfProject();
            paramsMap.putAll(rfProject.getPreprocessingParamsForDiagrams(element, element.getDeclaration().getParserPath().toString(), element.getLine()));
        }
        for (Map.Entry entry : paramsMap.entrySet()) {
            comment = comment.replaceAll("((?<!\\\\)" + (String)entry.getKey() + ")", (String)entry.getValue());
            comment = comment.replaceAll("\\\\" + (String)entry.getKey(), (String)entry.getKey());
        }
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_BFM, comment, "BFM");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_TCM, comment, "TCM");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_DUT, comment, "DUT");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_EVC, comment, "eVC");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_BFMS, comment, "BFMs");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_TCMS, comment, "TCMs");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_DUTS, comment, "DUTs");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_EVCS, comment, "eVCs");
        comment = DVTStringUtil.replaceAll(BEAUTIFY_PATTERN_AT, comment, " at ");
        return comment;
    }

    public String trimComment(String content) {
        String lineBreak = this.getLineBreak();
        int brLength = this.getLineBreakLength();
        while (content.startsWith(lineBreak)) {
            content = content.substring(brLength);
        }
        while (content.endsWith(lineBreak)) {
            content = content.substring(0, content.length() - brLength);
        }
        return content;
    }

    public String cleanUpSpecialCharacters(String comment, boolean toHTML) {
        comment = DVTStringUtil.replaceAll(NON_STANDARD_BI_HTML_TAG, comment, "<$1b><$1i>");
        comment = DVTStringUtil.replaceAll(NON_STANDARD_BR_LT_HTML_TAG, comment, "&lt;");
        comment = DVTStringUtil.replaceAll(NON_STANDARD_BR_GT_HTML_TAG, comment, "&gt;");
        return comment;
    }

    public String replaceHtmlTagSymbols(String comment, boolean toHTML) {
        if (comment.trim().isEmpty()) {
            return comment;
        }
        Matcher matcher = CommentConstants.HTML_TAG_PATTERN.matcher(comment);
        StringBuilder sb = new StringBuilder();
        int lastMatchIndex = 0;
        while (matcher.find()) {
            String tagName = matcher.group(3).trim();
            if (!CommentConstants.HTML_TAGS.contains(tagName)) continue;
            sb.append(comment.substring(lastMatchIndex, matcher.start()));
            sb.append("<" + matcher.group(2).trim() + tagName + ">");
            lastMatchIndex = matcher.end();
        }
        sb.append(comment.substring(lastMatchIndex));
        return sb.toString();
    }

    public String getElementLocation(IRfNamedElement namedElement) {
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration != null && declaration.getDefFile() != null) {
            return new Path(declaration.getDefFile().getParserPath().getCanonicalPath()).toFile().getParentFile().getAbsolutePath();
        }
        if (namedElement instanceof IRfFieldElement) {
            IRfNamedElement associatedType = ((IRfFieldElement)namedElement).getAssociatedType();
            if (associatedType != null && associatedType.getDeclaration() != null) {
                return new Path(associatedType.getDeclaration().getDefFile().getParserPath().getCanonicalPath()).toFile().getParentFile().getAbsolutePath();
            }
            return null;
        }
        if (namedElement.getMacroParserPath() != null) {
            return new Path(namedElement.getMacroParserPath().getCanonicalPath()).toFile().getParentFile().getAbsolutePath();
        }
        return null;
    }

    public String getWavedromDiv(String wavedrom, boolean specialDiagram) throws NoSuchMethodException, ScriptException {
        if (specialDiagram) {
            return Wavedrom.getInstance().generateSVGForSpecador(wavedrom);
        }
        return Wavedrom.getInstance().generateSVG(wavedrom);
    }

    protected abstract String getLineBreak();

    protected abstract int getLineBreakLength();

    public abstract String getNewLine();
}

