/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.ICompiledFilesContributor;

public class CompiledFilesContributorsExtensionRegistry {
    public static final String COMPILED_FILES_CONTRIBUTORS_EXTENSION_POINT_ID = "ro.amiq.dvt.compiledFilesContributors";
    public static final String COMPILED_FILES_CONTRIBUTOR_ELEMENT = "compiledFilesContributor";
    private static volatile List<ICompiledFilesContributor> fDelegates;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ICompiledFilesContributor> getDelegates() {
        if (fDelegates == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                CompiledFilesContributorsExtensionRegistry.computeDelegates();
            }
        }
        return fDelegates;
    }

    private static void computeDelegates() {
        fDelegates = new ArrayList<ICompiledFilesContributor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(COMPILED_FILES_CONTRIBUTORS_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            if (configurationElements != null) {
                IConfigurationElement[] iConfigurationElementArray = configurationElements;
                int n3 = configurationElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!COMPILED_FILES_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + COMPILED_FILES_CONTRIBUTORS_EXTENSION_POINT_ID));
                    }
                    try {
                        ICompiledFilesContributor compiledFilesHandlerDelegate = (ICompiledFilesContributor)configurationElement.createExecutableExtension("class");
                        fDelegates.add(compiledFilesHandlerDelegate);
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

