/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.utils.IDVTListElement;

public final class DVTArrayList<V extends IDVTListElement>
implements Serializable,
Iterable<V> {
    private static final long serialVersionUID = 3L;
    private V[] vals = new IDVTListElement[2];
    private short size = 0;
    private List<V> list;
    private static final short MAX_TABLE_SIZE = 2;

    public final V get(int i) {
        if (this.list != null) {
            return (V)((IDVTListElement)this.list.get(i));
        }
        if (i < this.size) {
            return this.vals[i];
        }
        return null;
    }

    public final int size() {
        if (this.list != null) {
            return this.list.size();
        }
        return this.size;
    }

    public final boolean contains(V value) {
        if (this.list != null) {
            return this.list.contains(value);
        }
        return this.index(value) < this.size;
    }

    private final short index(V value) {
        int valueHash = value.hashCode();
        short i = 0;
        while (i < this.size) {
            if (this.vals[i] == value) {
                return i;
            }
            int candidateHash = this.vals[i].hashCode();
            if (valueHash == candidateHash && this.vals[i].equals(value)) {
                return i;
            }
            i = (short)(i + 1);
        }
        return this.size;
    }

    public final void add(V value) {
        if (this.list != null) {
            this.list.add(value);
            return;
        }
        if (this.size == 2) {
            this.list = new ArrayList<V>(4);
            int i = 0;
            while (i < this.size) {
                this.list.add(this.vals[i]);
                ++i;
            }
            this.list.add(value);
            this.vals = null;
            this.size = 0;
        } else {
            this.vals[this.size] = value;
            this.size = (short)(this.size + 1);
        }
    }

    public final void add0(V value) {
        if (this.list != null) {
            this.list.add(0, value);
            return;
        }
        if (this.size == 2) {
            this.list = new ArrayList<V>(4);
            this.list.add(value);
            int i = 0;
            while (i < this.size) {
                this.list.add(this.vals[i]);
                ++i;
            }
            this.vals = null;
            this.size = 0;
        } else {
            int i = this.size;
            while (i > 0) {
                this.vals[i] = this.vals[i - 1];
                --i;
            }
            this.vals[0] = value;
            this.size = (short)(this.size + 1);
        }
    }

    public final V remove(int index) {
        IDVTListElement removed = null;
        if (this.list != null) {
            removed = (IDVTListElement)this.list.remove(index);
            if (this.list.size() == 2) {
                this.vals = new IDVTListElement[2];
                this.list.toArray(this.vals);
                this.list = null;
                this.size = (short)2;
            }
        } else if (index < this.size) {
            int i = index;
            while (i < this.size - 1) {
                this.vals[i] = this.vals[i + 1];
                ++i;
            }
            removed = this.vals[this.size - 1];
            this.vals[this.size - 1] = null;
            this.size = (short)(this.size - 1);
        }
        return (V)removed;
    }

    public void remove(V value) {
        if (this.list != null) {
            this.list.remove(value);
            if (this.list.size() == 2) {
                this.vals = new IDVTListElement[2];
                this.list.toArray(this.vals);
                this.list = null;
                this.size = (short)2;
            }
        } else {
            int index = this.index(value);
            if (index < this.size) {
                int i = index;
                while (i < this.size - 1) {
                    this.vals[i] = this.vals[i + 1];
                    ++i;
                }
                this.vals[this.size - 1] = null;
                this.size = (short)(this.size - 1);
            }
        }
    }

    public boolean isEmpty() {
        if (this.list != null) {
            return this.list.isEmpty();
        }
        return this.size == 0;
    }

    public Collection<V> values() {
        if (this.list != null) {
            return this.list;
        }
        return new Values();
    }

    public void clear() {
        this.list = null;
        this.vals = new IDVTListElement[2];
        this.size = 0;
    }

    public void deepClean() {
        Collection<V> values = this.values();
        if (values == null) {
            this.clear();
            return;
        }
        for (IDVTListElement value : values) {
            try {
                value.deepClean();
            }
            catch (Exception exception) {}
        }
        this.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        DVTArrayList<V> result = new DVTArrayList<V>();
        if (this.list != null) {
            result.list = new ArrayList<V>(this.list);
        }
        result.size = this.size;
        if (this.vals != null) {
            result.vals = (IDVTListElement[])Arrays.copyOf(this.vals, 2);
        }
        return result;
    }

    @Override
    public Iterator<V> iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        return new ValueIterator();
    }

    private final class ValueIterator
    implements Iterator<V> {
        int index = 0;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DVTArrayList.this.size;
        }

        @Override
        public void remove() {
            int i = this.index - 1;
            while (i < DVTArrayList.this.size - 1) {
                DVTArrayList.this.vals[i] = DVTArrayList.this.vals[i + 1];
                ++i;
            }
            DVTArrayList.this.vals[DVTArrayList.this.size - 1] = null;
            DVTArrayList.this.size = (short)(DVTArrayList.this.size - 1);
            --this.index;
        }

        @Override
        public V next() {
            return DVTArrayList.this.vals[this.index++];
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final int size() {
            return DVTArrayList.this.size;
        }

        @Override
        public final boolean contains(Object value) {
            if (value == null) {
                return false;
            }
            int valueHash = value.hashCode();
            short i = 0;
            while (i < DVTArrayList.this.size) {
                int candidateHash = DVTArrayList.this.vals[i].hashCode();
                if (valueHash == candidateHash && DVTArrayList.this.vals[i].equals(value)) {
                    return true;
                }
                i = (short)(i + 1);
            }
            return false;
        }

        @Override
        public final void clear() {
            DVTArrayList.this.clear();
        }
    }
}

