/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.interpreter.IDVTXRuntimeJob;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;

public class DVTBuildUtils {
    public static final String CLEANING_JOB_NAME = "Cleaning_";
    public static final String RESTORING_JOB_NAME = "Restoring";
    public static final String REBUILDING_JOB_NAME = "Rebuilding_";
    public static final String REBUILDING_JOB_PLATFORM_NAME = "Building";
    private static final AtomicBoolean fShowMultipleRebuildMessage = new AtomicBoolean(true);

    public static void fullBuildWithProgress(IProject project) {
        DVTBuildUtils.fullBuildWithProgress(project, false);
    }

    public static void fullBuildWithProgress(final IProject project, boolean waitForBuildDone) {
        if (!DVTNature.updateDeprecatedProject(project)) {
            return;
        }
        if (!DVTBuildUtils.shouldContinueRebuilding(project)) {
            return;
        }
        Job job = new Job(REBUILDING_JOB_NAME + project.getName()){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        boolean autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                        if (!autobuild) {
                            project.build(6, monitor);
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(null);
        if (waitForBuildDone) {
            DVTJobsUtils.scheduleAndJoin(job);
        } else {
            job.schedule();
        }
    }

    public static void testFullBuildWithProgress(final IProject project) {
        if (!DVTNature.updateDeprecatedProject(project)) {
            return;
        }
        Job job = new Job(REBUILDING_JOB_NAME + project.getName()){

            public IStatus run(IProgressMonitor monitor) {
                IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                boolean autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                preferences.putBoolean("description.autobuilding", false);
                try {
                    try {
                        monitor.beginTask("", 100);
                        project.build(15, monitor);
                        project.build(6, monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                        if (!autobuild) {
                            preferences.remove("description.autobuilding");
                        }
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                    autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                    if (!autobuild) {
                        preferences.remove("description.autobuilding");
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(null);
        job.schedule();
    }

    public static void externalBuildWithProgress(IProject project, boolean waitForBuildDone) {
        DVTBuildUtils.builderIDBuildWithProgress("ro.amiq.dvt.DVTExternBuilder", project, new HashMap<String, String>(), waitForBuildDone);
    }

    public static void externalBuildWithProgress(IProject project) {
        DVTBuildUtils.builderIDBuildWithProgress("ro.amiq.dvt.DVTExternBuilder", project, new HashMap<String, String>(), false);
    }

    public static void externalBuildWithProgress(IProject project, Map<String, String> args) {
        DVTBuildUtils.builderIDBuildWithProgress("ro.amiq.dvt.DVTExternBuilder", project, args, false);
    }

    public static void builderIDCommandWithProgress(final String builderID, final IProject project, final boolean clean, final boolean build, boolean waitForBuildDone, final boolean testsOnly) {
        if (!DVTNature.updateDeprecatedProject(project)) {
            return;
        }
        final HashMap args = new HashMap();
        Job job = new Job(build ? REBUILDING_JOB_NAME + project.getName() : CLEANING_JOB_NAME + project.getName()){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    if (testsOnly) {
                        args.put("testsOnly", "true");
                    }
                    if (!clean || !build) {
                        if (clean && !build) {
                            args.put("justClean", "true");
                        } else {
                            if (!clean && build) {
                                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", "Unsupported Operation"));
                            }
                            if (!clean && !build) {
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                        }
                    }
                    try {
                        if (!testsOnly) {
                            project.build(15, builderID, args, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        }
                        boolean autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                        if (clean || !autobuild) {
                            project.build(6, builderID, args, monitor);
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(null);
        if (waitForBuildDone) {
            DVTJobsUtils.scheduleAndJoin(job);
        } else {
            job.schedule();
        }
    }

    private static void builderIDBuildWithProgress(final String builderID, final IProject project, final Map<String, String> args, boolean waitForBuildDone) {
        if (!DVTNature.updateDeprecatedProject(project)) {
            return;
        }
        if (!DVTBuildUtils.shouldContinueRebuilding(project)) {
            return;
        }
        Job job = new Job(REBUILDING_JOB_NAME + project.getName()){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        project.build(15, builderID, args, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        boolean autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                        if (args != null && args.size() > 0 || !autobuild) {
                            project.build(6, builderID, args, monitor);
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(null);
        if (waitForBuildDone) {
            DVTJobsUtils.scheduleAndJoin(job);
        } else {
            job.schedule();
        }
    }

    public static void waitForAllBuildJobsDone(Object family) {
        DVTJobsUtils.runWithBusyIndicator(() -> {
            try {
                Job[] jobs;
                int i = 0;
                while (i < 5) {
                    try {
                        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        break;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        break;
                    }
                    ++i;
                }
                Job[] jobArray = jobs = Job.getJobManager().find(family);
                int n = jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job.getState() != 4) {
                        job.cancel();
                        job.schedule();
                    }
                    ++n2;
                }
                int i2 = 0;
                while (i2 < 5) {
                    try {
                        Job.getJobManager().join(family, (IProgressMonitor)new NullProgressMonitor());
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        break;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        break;
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void runInternalBuilder(IProject project, boolean waitForBuildDone) {
        if (!DVTBuildUtils.shouldContinueRebuilding(project)) {
            return;
        }
        try {
            DVTBuildUtils.builderIDCommandWithProgress("ro.amiq.dvt.MixedLangBuilder", project.getProject(), true, true, waitForBuildDone, false);
        }
        catch (Exception exception) {}
    }

    public static void testsInternalBuilder(IProject project) {
        DVTBuildUtils.internalBuilderAction(project, true, false, false, true);
    }

    public static void runInternalBuilder(IProject project) {
        DVTBuildUtils.internalBuilderAction(project, true, false, false, false);
    }

    public static void asyncExecInternalBuilder(IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTBuildUtils.internalBuilderAction(project, true, false, true, false));
    }

    public static void cleanInternalBuilder(IProject project) {
        DVTBuildUtils.internalBuilderAction(project, false, false, false, false);
    }

    private static void internalBuilderAction(IProject project, boolean rebuild, boolean waitForBuildDone, boolean skipRestoreCheck, boolean testsOnly) {
        if (!DVTBuildUtils.shouldContinueRebuilding(skipRestoreCheck, project)) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                ArrayList<String> builderIDs = new ArrayList<String>();
                builderIDs.add("ro.amiq.dvt.MixedLangBuilder");
                if (!builderIDs.isEmpty()) {
                    DVTBuildUtils.builderIDCommandWithProgress("ro.amiq.dvt.MixedLangBuilder", project.getProject(), true, rebuild, waitForBuildDone, testsOnly);
                }
            }
            catch (Exception exception) {}
        });
    }

    public static void buildFull(IProject project, IProgressMonitor monitor) {
        try {
            project.build(15, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static boolean buildWithProgressDialog(final IProject project) {
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.build(15, "ro.amiq.dvt.MixedLangBuilder", Collections.emptyMap(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        boolean autobuild = ResourcesPlugin.getWorkspace().isAutoBuilding();
                        if (!autobuild) {
                            project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return !progressDialog.getProgressMonitor().isCanceled();
    }

    public static void cleanExternalBuilders(IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                DVTBuildUtils.builderIDCommandWithProgress("ro.amiq.dvt.DVTExternBuilder", project.getProject(), true, false, false, false);
            }
            catch (Exception exception) {}
        });
    }

    public static void cleanAllBuilders(IProject project) {
        DVTBuildUtils.cleanInternalBuilder(project);
        DVTBuildUtils.cleanExternalBuilders(project);
    }

    private static boolean shouldContinueRebuilding(IProject project) {
        return DVTBuildUtils.shouldContinueRebuilding(false, project);
    }

    private static boolean shouldContinueRebuilding(boolean skipRestoreCheck, IProject project) {
        Job[] allJobs;
        if (!fShowMultipleRebuildMessage.get()) {
            return true;
        }
        ArrayList<JobWrapper> jobsToStopCandidate = new ArrayList<JobWrapper>();
        Job[] jobArray = allJobs = Job.getJobManager().find(null);
        int n = allJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            String currJobName = job.getName();
            if (!skipRestoreCheck && currJobName.startsWith(RESTORING_JOB_NAME) && job.getResult() == null) {
                jobsToStopCandidate.add(new JobWrapper(job, JobKind.RESTORE));
            } else {
                JobKind[] jobKindArray = JobKind.values();
                int n3 = jobKindArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String jobKindName;
                    JobKind jobKind = jobKindArray[n4];
                    if (jobKind != JobKind.RESTORE && currJobName.startsWith(jobKindName = jobKind.getJobName()) && job.getState() != 1) {
                        IProject jobProject;
                        boolean jobIsFullBuild = "FULL_BUILD".equals(job.getProperty(DVTMixedLangBuilder.BUILD_KIND_QNAME));
                        if (!jobIsFullBuild) {
                            job.cancel();
                        } else if (!(job instanceof IDVTXRuntimeJob) || (jobProject = ((IDVTXRuntimeJob)job).getProject()) == null || jobProject == project) {
                            jobsToStopCandidate.add(new JobWrapper(job, jobKind));
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (jobsToStopCandidate.isEmpty()) {
            return true;
        }
        AtomicInteger option = new AtomicInteger(-1);
        if (Display.getCurrent() == null) {
            Shell shell = DVTUiUtils.getActiveWorkbenchShell();
            shell.getDisplay().syncExec(() -> option.set(DVTBuildUtils.popStopDialog(shell, (JobWrapper)jobsToStopCandidate.get(0))));
        } else {
            option.set(DVTBuildUtils.popStopDialog(Display.getCurrent().getActiveShell(), (JobWrapper)jobsToStopCandidate.get(0)));
        }
        if (option.get() == 1) {
            for (JobWrapper jobWrapper : jobsToStopCandidate) {
                Job job = jobWrapper.getJob();
                if (job == null) continue;
                job.cancel();
            }
            return true;
        }
        return option.get() != 0 && option.get() != -1;
    }

    protected static int popStopDialog(Shell shell, JobWrapper job) {
        String messageText = job.getJobKind().getPopupMessage();
        return new MessageDialog(shell, "", null, messageText, 2, new String[]{"No", "Yes"}, 0).open();
    }

    public static void showMultipleRebuildMessage(boolean state) {
        fShowMultipleRebuildMessage.set(state);
    }

    public static String getRebuildJobName(IProject project) {
        return REBUILDING_JOB_NAME + project.getName();
    }

    public static String getCleanJobName(IProject project) {
        return CLEANING_JOB_NAME + project.getName();
    }

    public static String getRebuildJobName(String projectName) {
        return REBUILDING_JOB_NAME + projectName;
    }

    public static String getCleanJobName(String projectName) {
        return CLEANING_JOB_NAME + projectName;
    }

    public static String getRestoreJobName(String projectName) {
        return RESTORING_JOB_NAME + projectName;
    }

    static enum JobKind {
        REBUILD("Rebuilding_", "A build is already in progress. Do you want to stop it and start a new one?"),
        REBUILD_PLATFORM("Building", "A build is already in progress. Do you want to stop it and start a new one?"),
        RESTORE("Restoring", "A restore is in progress. Do you want to stop it and start a build?"),
        XSIM("DVT Run All", "A run is in progress. Do you want to stop it and start a build?"),
        UVM_RE("UVM Runtime Elaboration", "A UVM Runtime Elaboration is in progress. Do you want to stop it and start a build?");

        private String jobName;
        private String popupMessage;

        private JobKind(String jobName, String popupMessage) {
            this.jobName = jobName;
            this.popupMessage = popupMessage;
        }

        public String getJobName() {
            return this.jobName;
        }

        public String getPopupMessage() {
            return this.popupMessage;
        }
    }

    static class JobWrapper {
        private JobKind jobKind;
        private Job job;

        public JobWrapper(Job job, JobKind jobKind) {
            this.job = job;
            this.jobKind = jobKind;
        }

        public Job getJob() {
            return this.job;
        }

        public JobKind getJobKind() {
            return this.jobKind;
        }
    }
}

