/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTConsoleHyperlinkUtilsCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.FileLinkListSelectionDialog;

public class DVTConsoleHyperlinkUtils
extends DVTConsoleHyperlinkUtilsCommon {
    private DVTConsoleHyperlinkUtils() {
    }

    public static DVTConsoleHyperlinkUtils getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void open(Runnable openHyperlink) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(openHyperlink);
    }

    @Override
    public void openFileHyperlink(IProject project, String filePath, int line) {
        this.openFileHyperlink(project, filePath, line, "", "");
    }

    public void openFileHyperlink(IProject project, String filePath, int line, String reportObject, String uvmTestTop) {
        this.openFileHyperlink(project, filePath, line, reportObject, uvmTestTop, null, false);
    }

    public void openFileHyperlink(IProject project, String filePath, int line, IPath workingDir, boolean considerWorkingSets) {
        this.openFileHyperlink(project, filePath, line, "", "", workingDir, considerWorkingSets);
    }

    private void openFileHyperlink(IProject project, String filePath, int line, String reportObject, String uvmTestTop, IPath workingDir, boolean considerWorkingSets) {
        block14: {
            try {
                File f2 = workingDir != null && !new Path(filePath).isAbsolute() ? new File(workingDir.toFile(), filePath) : new File(filePath);
                if (!f2.exists()) {
                    IFile candidate = DVTFileUtils.getInstance().findProjectFile(project, filePath);
                    if (candidate != null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(() -> DVTFileUtils.getInstance().openEditor(candidate, line, null));
                        return;
                    }
                    final String baseName = f2.getName();
                    final ArrayList<IFile> candidates = new ArrayList<IFile>();
                    IWorkingSet[] workingSets = this.getWorkingSets();
                    boolean continueFiltering = true;
                    if (considerWorkingSets && workingSets != null && workingSets.length > 0) {
                        ArrayList<IAdaptable> elems = new ArrayList<IAdaptable>();
                        IWorkingSet[] iWorkingSetArray = workingSets;
                        int n = workingSets.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                            elems.addAll(Arrays.asList(iWorkingSet.getElements()));
                            ++n2;
                        }
                        for (IAdaptable iAdaptable : elems) {
                            IFile resIFile = (IFile)iAdaptable.getAdapter(IFile.class);
                            if (resIFile == null) {
                                IFolder refFolder = (IFolder)iAdaptable.getAdapter(IFolder.class);
                                File folderFile = null;
                                if (refFolder != null) {
                                    folderFile = new File(refFolder.getLocation().toOSString());
                                } else {
                                    IProject reproject = (IProject)iAdaptable.getAdapter(IProject.class);
                                    if (reproject != null) {
                                        folderFile = new File(reproject.getLocation().toOSString());
                                    }
                                }
                                if (folderFile == null) continue;
                                List<File> allFiles = this.getAllFilesRecursively(folderFile);
                                for (File file : allFiles) {
                                    if (!file.getName().equals(baseName)) continue;
                                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                    IPath location = Path.fromOSString((String)file.getAbsolutePath());
                                    IFile iFile = workspace.getRoot().getFileForLocation(location);
                                    if (iFile == null) continue;
                                    candidates.add(iFile);
                                }
                                continue;
                            }
                            if (!resIFile.getName().endsWith(baseName)) continue;
                            candidates.add(resIFile);
                        }
                        if (!candidates.isEmpty()) {
                            continueFiltering = false;
                        }
                    }
                    if (continueFiltering) {
                        project.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) throws CoreException {
                                if (resource.getName().equals(baseName)) {
                                    candidates.add(resource);
                                }
                                return true;
                            }
                        });
                    }
                    PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                        if (candidates.size() > 1) {
                            FileLinkListSelectionDialog dialog = new FileLinkListSelectionDialog(Utils.getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(){

                                protected String decorateText(String input, Object element) {
                                    if (element instanceof IResource) {
                                        return ((IResource)element).getFullPath().toOSString();
                                    }
                                    return super.decorateText(input, element);
                                }
                            });
                            dialog.setElements(candidates.toArray());
                            dialog.setMultipleSelection(false);
                            dialog.setTitle("Select File To Open");
                            dialog.setMessage("Which '" + baseName + "' do you want to open?");
                            dialog.setHelpAvailable(false);
                            if (dialog.open() != 0) {
                                return;
                            }
                            DVTFileUtils.getInstance().openEditor((IFile)dialog.getFirstResult(), line, null);
                            return;
                        }
                        if (candidates.size() == 1) {
                            if (((IResource)candidates.get(0)).getProject().isAccessible()) {
                                DVTFileUtils.getInstance().openEditor((IFile)candidates.get(0), line, null);
                            }
                            return;
                        }
                        new MessageDialog(Utils.getActiveShell(), "Could not find file", MessageDialog.getDefaultImage(), "Could not find '" + f2.getName() + "'. There is no file with this name inside the current project!", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                    });
                    break block14;
                }
                IFile iFile = DVTFileUtils.getInstance().findProjectFile(project, f2.getAbsolutePath());
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                    if (iFile != null) {
                        DVTFileUtils.getInstance().openEditor(iFile, line, null);
                    } else if (f2.getName() != null && (f2.getName().endsWith(".vcd") || f2.getName().endsWith(".dst"))) {
                        DVTFileUtils.getInstance().openEditor(f2, line, "ro.amiq.dvt.diagrams.wave");
                    } else {
                        DVTFileUtils.getInstance().openEditor(f2, line);
                    }
                });
                this.updateBreadcrumb(reportObject, uvmTestTop, f2.getAbsolutePath(), project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    @Override
    protected void updateDesignBreadcrumb(ElementPath elementPath) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> super.updateDesignBreadcrumb(elementPath));
    }

    private IWorkingSet[] getWorkingSets() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        return activePage.getWorkingSets();
    }

    private List<File> getAllFilesRecursively(File directory) {
        ArrayList<File> result = new ArrayList<File>();
        if (directory == null) {
            return result;
        }
        if (directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null) {
                    result.addAll(this.getAllFilesRecursively(file));
                }
                ++n2;
            }
        } else {
            result.add(directory);
        }
        return result;
    }

    @Override
    public void popNoComponentFoundDialog(String hierarchyPath) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog messageDialog = new MessageDialog(Utils.getActiveShell(), "Could not find component", MessageDialog.getDefaultImage(), String.format("Could not find any component with the '%s' hierarchy path inside the current project!", hierarchyPath), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            messageDialog.open();
        });
    }

    private static class InstanceHolder {
        private static final DVTConsoleHyperlinkUtils INSTANCE = new DVTConsoleHyperlinkUtils();

        private InstanceHolder() {
        }
    }
}

