/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VHViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTConsoleHyperlinkUtilsCommon {
    protected static final String NO_COMPONENT_FOUND_MESSAGE_FORMAT = "Could not find any component with the '%s' hierarchy path inside the current project!";

    public abstract void openFileHyperlink(IProject var1, String var2, int var3);

    public abstract void popNoComponentFoundDialog(String var1);

    public abstract void open(Runnable var1);

    public void openHierarchyPathHyperlink(IProject project, String hierarchyPath) {
        this.openHierarchyPathHyperlink(project, hierarchyPath, "");
    }

    public void openHierarchyPathHyperlink(IProject project, String hierarchyPath, String uvmTestTop) {
        if (project == null) {
            this.popNoComponentFoundDialog(hierarchyPath);
            return;
        }
        GoToInfo xvmComponentPath = this.getUVMComponentPath(project, hierarchyPath, uvmTestTop);
        if (xvmComponentPath != null) {
            this.open(() -> xvmComponentPath.open(project, true));
            return;
        }
        ElementPath elementPath = this.computeElementPath(hierarchyPath);
        if (elementPath == null) {
            this.popNoComponentFoundDialog(hierarchyPath);
            return;
        }
        IRfNamedElement designInstanceElement = this.getDesignInstanceElement(project, elementPath);
        if (designInstanceElement != null) {
            this.open(() -> DVTRfUtils.goToDeclaration(designInstanceElement, true));
            this.updateDesignBreadcrumb(elementPath.removeLastSegment());
            return;
        }
        this.popNoComponentFoundDialog(hierarchyPath);
    }

    protected ElementPath computeElementPath(String hierarchyPath) {
        return hierarchyPath.contains("/") ? ElementPath.from(hierarchyPath, "/") : ElementPath.from(hierarchyPath, ".");
    }

    protected void updateDesignBreadcrumb(ElementPath elementPath) {
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return;
        }
        DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, elementPath);
    }

    protected IRfNamedElement getDesignInstanceElement(IProject project, ElementPath elementPath) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        IELMemory memory = elManager.getMemory();
        if (memory == null) {
            return null;
        }
        ELInstance instance = memory.instanceFor(elementPath);
        if (instance == null) {
            return null;
        }
        return instance.getDescription();
    }

    protected void updateBreadcrumb(String reportObject, String uvmTestTop, String filePath, IProject project) {
        IVHViewContributor vhContributor;
        if (reportObject == null || reportObject.isEmpty()) {
            return;
        }
        List<String> names = this.splitHierarchyPath(reportObject);
        List<String> types = Collections.singletonList(uvmTestTop);
        IVHViewContributor iVHViewContributor = vhContributor = !XViewsUtils.getXVHContributor().isXVMDatabaseReady() ? VHViewUtils.getViewContributor(LanguageKind.VLOG) : XViewsUtils.getXVHContributor();
        if (vhContributor.isValidVHElement(names, types, project)) {
            vhContributor.setVHBreadcrumbData(names, types, filePath, project);
            return;
        }
        ElementPath elementPath = this.computeElementPath(reportObject);
        if (elementPath == null) {
            return;
        }
        IRfNamedElement designInstanceElement = this.getDesignInstanceElement(project, elementPath);
        if (designInstanceElement == null) {
            return;
        }
        this.updateDesignBreadcrumb(elementPath);
    }

    public boolean isValidHyperlink(String hierarchyPath, String uvmTestTop, IProject project) {
        return this.isValidVHElement(hierarchyPath, uvmTestTop, project) || this.isValidDesignElement(hierarchyPath, project);
    }

    private boolean isValidDesignElement(String hierarchyPath, IProject project) {
        ElementPath computeElementPath = this.computeElementPath(hierarchyPath);
        if (computeElementPath == null) {
            return false;
        }
        return this.getDesignInstanceElement(project, computeElementPath) != null;
    }

    private boolean isValidVHElement(String reportObject, String uvmTestTop, IProject project) {
        List<String> names = this.splitHierarchyPath(reportObject);
        List<String> types = Collections.singletonList(uvmTestTop);
        IVHViewContributor vhContributor = !XViewsUtils.getXVHContributor().isXVMDatabaseReady() ? VHViewUtils.getViewContributor(LanguageKind.VLOG) : XViewsUtils.getXVHContributor();
        return vhContributor.isValidVHElement(names, types, project);
    }

    private GoToInfo getUVMComponentPath(IProject project, String logHierarchyPath, String logUvmTestTop) {
        List<String> segments = this.splitHierarchyPath(logHierarchyPath);
        IVHViewContributor vhContributor = !XViewsUtils.getXVHContributor().isXVMDatabaseReady() ? VHViewUtils.getViewContributor(LanguageKind.VLOG) : XViewsUtils.getXVHContributor();
        return vhContributor.getTypeMarker(segments, Collections.singletonList(logUvmTestTop), project);
    }

    protected List<String> splitHierarchyPath(String logHierarchyPath) {
        logHierarchyPath = logHierarchyPath.replace("/", ".");
        return Arrays.asList(DVTStringUtil.split(".", logHierarchyPath));
    }

    protected String noComponentFoundMessage(String hierarchyPath) {
        return String.format(NO_COMPONENT_FOUND_MESSAGE_FORMAT, hierarchyPath);
    }
}

