/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashSet;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum DVTDeleteOnExit {
    INSTANCE;

    private final HashSet<Path> paths = new HashSet();

    private DVTDeleteOnExit() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Path path : DVTDeleteOnExit.this.paths) {
                    try {
                        DVTFileUtils.getInstance().removeRecursive(path);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public void registerFile(File file) {
        try {
            this.paths.add(file.toPath());
        }
        catch (InvalidPathException invalidPathException) {}
    }

    public void registerPath(Path path) {
        this.paths.add(path);
    }
}

