/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.osgi.service.prefs.Preferences;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTDocumentCommonBase;

public class DVTDocumentCommon
extends DVTDocumentCommonBase {
    public static String getLineDelimiter(IEditorPart editor) {
        if (editor == null) {
            return DVTDocumentCommon.getLineDelimiterByProject(null);
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return DVTDocumentCommon.getLineDelimiterByProject(null);
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return DVTDocumentCommon.getLineDelimiterByProject(null);
        }
        return DVTDocumentCommon.getLineDelimiterByProject(file.getProject());
    }

    public static String getLineDelimiterByProject(IProject project) {
        Preferences node = null;
        String delimiter = null;
        try {
            if (project != null) {
                node = Platform.getPreferencesService().getRootNode().node("project").node(project.getName());
            }
            if (node != null && node.nodeExists("org.eclipse.core.runtime")) {
                delimiter = node.node("org.eclipse.core.runtime").get("line.separator", null);
            }
            if (delimiter != null) {
                return delimiter;
            }
            node = Platform.getPreferencesService().getRootNode().node("instance");
            if (node != null && node.nodeExists("org.eclipse.core.runtime")) {
                delimiter = node.node("org.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (Exception exception) {}
        if (delimiter == null) {
            return System.getProperty("line.separator", "\n");
        }
        return delimiter;
    }

    public static String getLineDelimiter(ParserPath path, IRfSingleLangProject rfProject) {
        return DVTDocumentCommon.getLineDelimiterByProject(rfProject.getProject());
    }

    public static class RecoveryCommand
    extends DocumentCommand {
        public void loadFrom(DocumentCommand c) {
            this.offset = c.offset;
            this.caretOffset = c.caretOffset;
            this.shiftsCaret = c.shiftsCaret;
            this.length = c.length;
            this.text = c.text;
        }

        public void saveIn(DocumentCommand c) {
            c.offset = this.offset;
            c.caretOffset = this.caretOffset;
            c.shiftsCaret = this.shiftsCaret;
            c.length = this.length;
            c.text = this.text;
        }
    }
}

