/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public abstract class DVTDocumentCommonBase {
    public static IRegion getWhitespaceBlockAtOffset(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char chr;
            int line = document.getLineOfOffset(offset);
            int startLineOffset = document.getLineOffset(line);
            int endLineOffset = startLineOffset + document.getLineLength(line);
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            int ch = TextUtils.getChar(document, pos - 1);
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            while (pos >= startLineOffset) {
                ch = scanner.read();
                chr = (char)ch;
                if (!Character.isWhitespace(ch) || DVTDocumentCommon.isTextNewLine(document, Character.toString(chr)) || chr == '\uffff') break;
                --pos;
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (pos <= endLineOffset) {
                ch = scanner.read();
                chr = (char)ch;
                if (!Character.isWhitespace(ch) || DVTDocumentCommon.isTextNewLine(document, Character.toString(chr)) || chr == '\uffff') break;
                ++pos;
            }
            end = pos;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new Region(Math.max(0, start), Math.max(0, end - start));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNotFollowedByIdentifier(IDocument document, int offset) {
        if (document == null || offset < 0 || offset > document.getLength()) {
            return false;
        }
        if (offset == document.getLength()) {
            return true;
        }
        try {
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int end = Math.max(start + document.getLineLength(line), offset);
            int i = offset;
            while (true) {
                if (i >= end) {
                    return true;
                }
                char c = document.getChar(i);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (Character.isJavaIdentifierPart(c)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int isNextCharacter(IDocument document, int offset, char character) {
        if (document == null) return -1;
        if (offset < 0) return -1;
        if (offset >= document.getLength()) {
            return -1;
        }
        try {
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int end = Math.max(start + document.getLineLength(line), offset);
            int i = offset;
            while (true) {
                if (i >= end) {
                    return -1;
                }
                char c = document.getChar(i);
                if (c == character) {
                    return i;
                }
                if (!Character.isWhitespace(c)) return -1;
                if (c == '\n') return -1;
                if (c == '\r') return -1;
                if (c == '\uffff') return -1;
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    public static int findEndOfWhiteSpace(IDocument document, int offset, int end) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isTextNewLine(IDocument d, String text) {
        if (d == null || text == null) {
            return false;
        }
        String[] delimiters = d.getLegalLineDelimiters();
        boolean hasNewline = false;
        int i = 0;
        i = 0;
        while (i < delimiters.length) {
            if (text.startsWith(delimiters[i])) {
                hasNewline = true;
                break;
            }
            ++i;
        }
        if (!hasNewline) {
            return false;
        }
        i = 0;
        while (i < text.length()) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getIndentOfLine(IDocument document, int line, int offset) {
        if (document == null || line < 0) {
            return "";
        }
        try {
            int start = document.getLineOffset(line);
            int end = offset >= 0 ? Math.min(offset, start + document.getLineLength(line)) : start + document.getLineLength(line);
            int whiteend = DVTDocumentCommonBase.findEndOfWhiteSpace(document, start, end);
            return document.get(start, Math.max(whiteend - start, 0));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }
}

