/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.MatchBeginEndPositionInfo;
import ro.amiq.dvt.utils.Utils;

public class DVTDocumentUtilsCommon {
    public static final int MAX_INCLUDED_FILE_LENGTH = 500;
    public static final String FOLDING_POSITION = "__dvt_folding_position";
    private static final int COMMENT_MAX_LINES_TO_LOOK_UP = 3;
    private static final int BUFFER_SIZE = 100;
    protected static Set<Character> OPEN_BRACKETS = new HashSet<Character>(Arrays.asList(Character.valueOf('('), Character.valueOf('['), Character.valueOf('{')));
    protected static Set<Character> CLOSED_BRACKETS = new HashSet<Character>(Arrays.asList(Character.valueOf('}'), Character.valueOf(']'), Character.valueOf(')')));

    public static boolean isOpenBracket(Character c) {
        if (c == null) {
            return false;
        }
        return OPEN_BRACKETS.contains(c);
    }

    public static boolean isClosedBracket(Character c) {
        if (c == null) {
            return false;
        }
        return CLOSED_BRACKETS.contains(c);
    }

    public static String getIndent(int insertOffset, IDocument document) {
        block4: {
            if (document != null) break block4;
            return "";
        }
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(insertOffset);
            String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < line.length()) {
                if (!Character.isWhitespace(line.charAt(i))) break;
                sb.append(line.charAt(i));
                ++i;
            }
            return sb.toString();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static boolean regionContains(IRegion region, int offset) {
        return region.getOffset() <= offset && region.getOffset() + region.getLength() >= offset;
    }

    public static int getCharOffset(char chr, int startOffset, boolean forward, int bufferSize, IDocument document, String partitioning) throws BadLocationException, BadPartitioningException {
        int nextChar;
        DVTCharacterScanner cs = new DVTCharacterScanner(bufferSize, document, startOffset, forward);
        while ((nextChar = cs.read()) != -1) {
            if (forward && cs.getOffset() > startOffset + bufferSize || !forward && cs.getOffset() < startOffset - bufferSize) {
                return -1;
            }
            if (cs.getOffset() - (forward ? 1 : 0) >= 0 && !"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, cs.getOffset() - (forward ? 1 : 0), false)) || Character.isWhitespace(nextChar) || nextChar != chr) continue;
            cs.unread();
            return cs.getOffset();
        }
        return -1;
    }

    public static int getMatchingRightBracketOffset(int offset, DVTEditor editor, IDocument document) {
        ICharacterPairMatcher bracketMatcher = editor.getBracketMatcher();
        IRegion closedBracketRegion = bracketMatcher.match(document, offset);
        if (closedBracketRegion == null) {
            return -1;
        }
        return closedBracketRegion.getOffset() + closedBracketRegion.getLength();
    }

    public static int getMatchingLeftBracketOffset(int offset, DVTEditor editor, IDocument document) {
        ICharacterPairMatcher bracketMatcher = editor.getBracketMatcher();
        IRegion closedBracketRegion = bracketMatcher.match(document, offset);
        if (closedBracketRegion == null) {
            return -1;
        }
        return closedBracketRegion.getOffset();
    }

    public static boolean hasNestedParentheses(IDocument document, int startOffset, int endOffset, String partitionType) {
        int countOpenParen = 0;
        try {
            int i = startOffset;
            while (i < endOffset) {
                if (((IDocumentExtension3)document).getContentType(partitionType, i, false).equals("__dftl_partition_content_type")) {
                    if (OPEN_BRACKETS.contains(Character.valueOf(document.getChar(i)))) {
                        ++countOpenParen;
                    } else if (CLOSED_BRACKETS.contains(Character.valueOf(document.getChar(i)))) {
                        --countOpenParen;
                    }
                }
                ++i;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
        return countOpenParen == 0;
    }

    public static char nextCodeChar(IDocument document, int offset, String partitioning, boolean forward) {
        int nextChar;
        block5: {
            nextChar = -1;
            if (document != null) break block5;
            return '\uffff';
        }
        try {
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, offset, forward);
            int documentLength = document.getLength();
            while ((nextChar = cs.read()) != -1) {
                int csOffset = cs.getOffset();
                if (csOffset - 1 >= 0 && csOffset - 1 < documentLength && (forward || csOffset + 1 >= 0 && csOffset + 1 < documentLength) && (!"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false)) || cs.getOffset() - (forward ? 1 : 0) >= 0 && !"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false)) || (char)nextChar == '\n' || (char)nextChar == '\r' || Character.isWhitespace((char)nextChar))) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return (char)nextChar;
    }

    public static int nextCodeCharOffset(IDocument document, int offset, boolean forward, String partitioning) {
        return DVTDocumentUtilsCommon.nextCodeCharOffset(document, offset, forward, partitioning, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int nextCodeCharOffset(IDocument document, int offset, boolean forward, String partitioning, boolean stopAtComment, boolean stopAtNewline) {
        try {
            if (document == null) {
                return -1;
            }
            int nextChar = -1;
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, offset, forward);
            int documentLength = document.getLength();
            while ((nextChar = cs.read()) != -1) {
                int csOffset = cs.getOffset();
                if (csOffset - 1 < 0 || csOffset - 1 >= documentLength) {
                    return -1;
                }
                if (!(forward || csOffset + 1 >= 0 && csOffset + 1 < documentLength)) {
                    return -1;
                }
                if (!"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false))) {
                    if (!stopAtComment) continue;
                    return -1;
                }
                if (cs.getOffset() - (forward ? 1 : 0) >= 0 && !"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false))) {
                    if (!stopAtComment) continue;
                    return -1;
                }
                if ((char)nextChar == '\n' || (char)nextChar == '\r') {
                    if (!stopAtNewline) continue;
                    return -1;
                }
                if (Character.isWhitespace((char)nextChar)) continue;
            }
            return cs.getOffset();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object[] nextCodeCharOffsetPair(IDocument document, int offset, boolean forward, String partitioning) {
        try {
            if (document == null) {
                return null;
            }
            Object[] result = new Object[2];
            int nextChar = -1;
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, offset, forward);
            int documentLength = document.getLength();
            while ((nextChar = cs.read()) != -1) {
                int csOffset = cs.getOffset();
                if (csOffset - 1 < 0 || csOffset - 1 >= documentLength) {
                    return null;
                }
                if (!(forward || csOffset + 1 >= 0 && csOffset + 1 < documentLength)) {
                    return null;
                }
                if (!"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false)) || cs.getOffset() - (forward ? 1 : 0) >= 0 && !"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType(partitioning, csOffset - (forward ? 1 : 0), false)) || Character.isWhitespace((char)nextChar) || (char)nextChar == '\n' || (char)nextChar == '\r') continue;
            }
            cs.unread();
            result[0] = Character.valueOf((char)nextChar);
            result[1] = cs.getOffset();
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static boolean isEmptyLineBefore(int offset, IDocument document, String partition) throws BadLocationException {
        int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
        int nextCodeCharOffset = DVTDocumentUtils.nextCodeCharOffset(document, offset - 1, false, partition);
        return nextCodeCharOffset <= lineOffset;
    }

    public static boolean isOnTheSameLine(IDocument document, int offset1, int offset2) throws BadLocationException {
        int lineOffset2;
        int lineOffset1 = document.getLineOffset(document.getLineOfOffset(offset1));
        return lineOffset1 == (lineOffset2 = document.getLineOffset(document.getLineOfOffset(offset2)));
    }

    public static int documentLineOffset(Object document, int line) throws Exception {
        return ((IDocument)document).getLineOffset(line);
    }

    public static void addDocumentPosition(Object document, String string, Object position) throws Exception {
        ((IDocument)document).addPosition(string, (Position)position);
    }

    public static void addDocumentPositions(IDocument document, String category, Collection<Position> positions) throws Exception {
        if (document == null || positions.isEmpty()) {
            return;
        }
        if (document instanceof DVTSynchronizableDocument) {
            ((DVTSynchronizableDocument)document).addPositions(category, positions);
        } else {
            for (Position position : positions) {
                document.addPosition(category, position);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInlineComment(IDocument document, int offset, String partitioning) {
        try {
            String contentType;
            if (offset < 0) {
                return "";
            }
            String[] commentTypes = DVTDocumentUtilsCommon.getMLandSLFromPartition(partitioning);
            if (commentTypes == null) {
                return "";
            }
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, offset, true);
            while (true) {
                int nextChar;
                if ((nextChar = cs.read()) == -1) {
                    return "";
                }
                if (cs.getOffset() - 1 < 0) {
                    return "";
                }
                if ((char)nextChar == '\n') return "";
                if ((char)nextChar == '\r') {
                    return "";
                }
                if (Character.isWhitespace((char)nextChar)) continue;
                contentType = ((IDocumentExtension3)document).getContentType(partitioning, cs.getOffset() - 1, false);
                if (contentType.equals("__dftl_partition_content_type")) {
                    return "";
                }
                if (contentType.equals(commentTypes[0])) return DVTDocumentUtilsCommon.getComment(cs, document, partitioning, contentType, commentTypes, true);
                if (contentType.equals(commentTypes[1])) break;
            }
            return DVTDocumentUtilsCommon.getComment(cs, document, partitioning, contentType, commentTypes, true);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAboveComment(IDocument document, int line, String partitioning) {
        try {
            String contentType;
            String[] commentTypes = DVTDocumentUtilsCommon.getMLandSLFromPartition(partitioning);
            if (commentTypes == null) {
                return "";
            }
            int endCommentAreaOffset = document.getLineOffset(line) - 1;
            if (endCommentAreaOffset <= 0) {
                return "";
            }
            int upperLineLimit = Math.max(0, line - 3);
            DVTCharacterScanner cs = new DVTCharacterScanner(100, document, endCommentAreaOffset, false);
            while (true) {
                int nextChar;
                if ((nextChar = cs.read()) == -1) {
                    return "";
                }
                int csOffset = cs.getOffset();
                if (cs.getOffset() < 0) {
                    return "";
                }
                int currentLine = document.getLineOfOffset(cs.getOffset() - 1);
                if (currentLine < upperLineLimit) {
                    return "";
                }
                if (Character.isWhitespace((char)nextChar)) continue;
                contentType = ((IDocumentExtension3)document).getContentType(partitioning, csOffset, false);
                if (contentType.equals("__dftl_partition_content_type")) {
                    return "";
                }
                if (contentType.equals(commentTypes[0])) return DVTDocumentUtilsCommon.getComment(cs, document, partitioning, contentType, commentTypes, false);
                if (contentType.equals(commentTypes[1])) break;
            }
            return DVTDocumentUtilsCommon.getComment(cs, document, partitioning, contentType, commentTypes, false);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getComment(DVTCharacterScanner cs, IDocument document, String partition, String startContentType, String[] commentTypes, boolean isInline) {
        try {
            int nextChar;
            int nextCodeOffset;
            String result = "";
            int direction = isInline ? 0 : 1;
            cs.setOffset(cs.getOffset() + direction);
            int nextLineOfCode = -1;
            if (!isInline && (nextCodeOffset = DVTDocumentUtilsCommon.nextCodeCharOffset(document, cs.getOffset(), false, partition)) != -1) {
                nextLineOfCode = document.getLineOfOffset(nextCodeOffset);
            }
            while ((nextChar = cs.read()) != -1) {
                int currOffset = cs.getOffset();
                if (currOffset - (isInline ? 1 : 0) < 0) {
                    return "";
                }
                char currentChar = (char)nextChar;
                String currentContentType = ((IDocumentExtension3)document).getContentType(partition, cs.getOffset() - (isInline ? 1 : 0), false);
                if (Character.isWhitespace((char)nextChar) && (char)nextChar != '\n' && (char)nextChar != '\r') {
                    result = DVTDocumentUtilsCommon.appendOrPrepend(result, Character.valueOf(currentChar), isInline);
                    continue;
                }
                if (!currentContentType.equals(startContentType)) {
                    return Utils.formatComment(result);
                }
                if ((char)nextChar == '\n' || (char)nextChar == '\r') {
                    if (isInline && commentTypes[0].equals(currentContentType)) {
                        return result;
                    }
                    result = DVTDocumentUtilsCommon.appendOrPrepend(result, Character.valueOf(currentChar), isInline);
                    continue;
                }
                if (!currentContentType.equals(startContentType)) break;
                if (!isInline && DVTDocumentUtilsCommon.possibleInlineComment(document, currOffset, nextLineOfCode)) {
                    if ("__vlog_sl_comment".equals(startContentType)) {
                        return Utils.formatComment(result);
                    }
                    return "";
                }
                result = DVTDocumentUtilsCommon.appendOrPrepend(result, Character.valueOf(currentChar), isInline);
            }
            cs.setOffset(cs.getOffset() + direction);
            return Utils.formatComment(result);
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return "";
        }
    }

    public static String appendOrPrepend(String comment, Character currentChar, boolean append) {
        if (append) {
            return String.valueOf(comment) + Character.toString(currentChar.charValue());
        }
        return String.valueOf(Character.toString(currentChar.charValue())) + comment;
    }

    private static boolean possibleInlineComment(IDocument document, int currOffset, int nextCodeCharLine) throws BadLocationException {
        if (nextCodeCharLine == -1) {
            return false;
        }
        return nextCodeCharLine == document.getLineOfOffset(currOffset);
    }

    public static String getFormattedComment(String appendedComment) {
        if (appendedComment == null) {
            return "";
        }
        return appendedComment.replace("\r\n", " ").replace("\n", " ");
    }

    public static String[] getMLandSLFromPartition(String partition) {
        String[] result = new String[2];
        switch (partition) {
            case "__vlog_partitioning": {
                result[0] = "__vlog_sl_comment";
                result[1] = "__vlog_ml_comment";
                return result;
            }
            case "__vhdl_partitioning": {
                result[0] = "__vhdl_sl_comment";
                result[1] = "__vhdl_ml_comment";
                return result;
            }
            case "__pss_partitioning": {
                result[0] = "__pss_sl_comment";
                result[1] = "__pss_ml_comment";
                return result;
            }
            case "__e_partitioning": {
                result[0] = "__e_sl_comment";
                result[1] = "__e_ml_comment";
                return result;
            }
        }
        return null;
    }

    public static final Map<String, List<Integer>> getAllBackwardListOfOffsetsForWords(IDocument document, Set<String> words, int minOffsetLimit, int offset, boolean includePreprocDir, boolean allowOnlyWhitespaces) {
        try {
            HashMap<String, List<Integer>> result = new HashMap<String, List<Integer>>();
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, offset), false);
            String content = null;
            String currWord = "";
            while (scanner.getOffset() >= minOffsetLimit) {
                int ch = scanner.read();
                if (ch == -1) {
                    scanner.unread();
                    return result;
                }
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                if (!content.equals("__dftl_partition_content_type")) continue;
                if (Character.isJavaIdentifierPart(ch)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append((char)ch);
                    sb.append(currWord);
                    currWord = sb.toString();
                    continue;
                }
                if (allowOnlyWhitespaces && !Character.isWhitespace(ch) && (char)ch != '`') {
                    return result;
                }
                if (words.contains(currWord)) {
                    if (includePreprocDir && !DVTDocumentUtilsCommon.isPrecededByBacktickSkippingWS(document, scanner.getOffset(), minOffsetLimit)) {
                        currWord = "";
                        continue;
                    }
                    if (!result.containsKey(currWord)) {
                        result.put(currWord, new ArrayList());
                    }
                    ((List)result.get(currWord)).add(scanner.getOffset() - 1);
                }
                currWord = "";
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyMap();
        }
    }

    private static boolean isPrecededByBacktickSkippingWS(IDocument document, int offset, int minOffset) {
        DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, offset, false);
        int pos = offset;
        while (pos > minOffset) {
            char ch = (char)scanner.read();
            if (!Character.isWhitespace(ch)) {
                return ch == '`';
            }
            --pos;
        }
        return false;
    }

    public static int convertPositionToLine(IDocument document, int offset) {
        try {
            if (document != null && document.getLength() >= offset) {
                return document.getLineOfOffset(offset) + 1;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return -1;
    }

    public static int convertLineToOffset(IDocument document, int line) {
        block3: {
            try {
                if (document != null) break block3;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return document.getLineOffset(line - 1);
    }

    public static MatchBeginEndPositionInfo getMatchingBeginEndBlockForOffset(int offset, IDocument document, DVTWordFinder wordFinder) {
        return DVTDocumentUtilsCommon.getMatchingBeginEndBlockForOffset(offset, document, wordFinder, false);
    }

    public static MatchBeginEndPositionInfo getMatchingBeginEndBlockForOffset(int offset, IDocument document, DVTWordFinder wordFinder, boolean shouldLookForOptionalSyntax) {
        try {
            IRegion region = wordFinder.getWordAtOffset(document, offset, true);
            if (region.getLength() == 0 && region.getOffset() == 0) {
                region = new Region(offset, 0);
            }
            if (!document.containsPositionCategory(FOLDING_POSITION)) {
                return new MatchBeginEndPositionInfo(region, null);
            }
            Position[] positions = document.getPositions(FOLDING_POSITION);
            if (positions == null) {
                return new MatchBeginEndPositionInfo(region, null);
            }
            String word = document.get(region.getOffset(), region.getLength());
            if (shouldLookForOptionalSyntax && word.equalsIgnoreCase("begin")) {
                int nested = 1;
                int i = 0;
                while (i < positions.length) {
                    DVTFoldingPosition currentPosition = (DVTFoldingPosition)positions[i];
                    if (region.getOffset() < currentPosition.getOffset()) {
                        if (currentPosition.getSubType() == DVTFoldingPosition.SubType.END) {
                            if (--nested == 0) {
                                int optionalEndSyntaxLength = DVTDocumentUtilsCommon.getOptionalEndSyntaxLength(document, currentPosition.getOffset());
                                int regionLength = currentPosition.getOffset() - region.getOffset() + optionalEndSyntaxLength;
                                return new MatchBeginEndPositionInfo((IRegion)new Region(region.getOffset(), regionLength), DVTFoldingPosition.SubType.START);
                            }
                        } else if (currentPosition.getSubType() == DVTFoldingPosition.SubType.START) {
                            ++nested;
                        }
                    }
                    ++i;
                }
            }
            int startIndex = -1;
            DVTFoldingPosition blockPosition = null;
            int i = 0;
            while (i < positions.length) {
                DVTFoldingPosition currentPosition = (DVTFoldingPosition)positions[i];
                if (currentPosition.getType() != DVTFoldingPosition.Type.PAREN) {
                    if (shouldLookForOptionalSyntax && currentPosition.getSubType() == DVTFoldingPosition.SubType.END && currentPosition.overlapsWith(region.getOffset() - 2, region.getLength())) {
                        blockPosition = currentPosition;
                        startIndex = i;
                        break;
                    }
                    if (currentPosition.overlapsWith(region.getOffset(), region.getLength()) && (i + 1 >= positions.length || !((DVTFoldingPosition)positions[i + 1]).isIncludedBy(region.getOffset(), region.getLength()) || ((DVTFoldingPosition)positions[i + 1]).length == 0)) {
                        blockPosition = currentPosition;
                        startIndex = i;
                        break;
                    }
                }
                ++i;
            }
            if (blockPosition == null || startIndex < 0 || startIndex >= positions.length) {
                return new MatchBeginEndPositionInfo(region, null);
            }
            return DVTDocumentUtilsCommon.computeMatchingRegion(document, region, positions, startIndex, blockPosition, shouldLookForOptionalSyntax);
        }
        catch (BadLocationException | BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    private static MatchBeginEndPositionInfo computeMatchingRegion(IDocument document, IRegion region, Position[] positions, int startIndex, DVTFoldingPosition blockPosition, boolean shouldLookForOptionalSyntax) {
        DVTFoldingPosition.SubType positionSubType;
        block16: {
            int nested;
            block17: {
                nested = 1;
                positionSubType = blockPosition.getSubType();
                if (positionSubType != DVTFoldingPosition.SubType.START) break block17;
                int i = startIndex + 1;
                while (i < positions.length) {
                    DVTFoldingPosition currentPosition = (DVTFoldingPosition)positions[i];
                    if (currentPosition.getType() == blockPosition.getType()) {
                        DVTFoldingPosition.SubType currentSubType = currentPosition.getSubType();
                        if (currentSubType == DVTFoldingPosition.SubType.START) {
                            ++nested;
                        } else if (currentSubType == DVTFoldingPosition.SubType.END) {
                            --nested;
                        }
                        if (nested <= 0) {
                            if (shouldLookForOptionalSyntax) {
                                int optionalEndSyntaxLength = DVTDocumentUtilsCommon.getOptionalEndSyntaxLength(document, currentPosition.getOffset());
                                int regionLength = currentPosition.getOffset() - region.getOffset() + optionalEndSyntaxLength;
                                region = new Region(region.getOffset(), regionLength);
                            } else {
                                region = new Region(region.getOffset(), currentPosition.getOffset() - region.getOffset() + 1);
                            }
                            break block16;
                        }
                    }
                    ++i;
                }
                break block16;
            }
            if (positionSubType != DVTFoldingPosition.SubType.END) break block16;
            int i = startIndex - 1;
            while (i >= 0) {
                DVTFoldingPosition currentPosition = (DVTFoldingPosition)positions[i];
                if (currentPosition.getType() == blockPosition.getType()) {
                    DVTFoldingPosition.SubType currentSubType = currentPosition.getSubType();
                    if (currentSubType == DVTFoldingPosition.SubType.START) {
                        --nested;
                    } else if (currentPosition.getSubType() == DVTFoldingPosition.SubType.END) {
                        ++nested;
                    }
                    if (nested <= 0 && currentPosition.getMeta() != DVTFoldingPosition.ELSEIF) {
                        if (shouldLookForOptionalSyntax) {
                            int optionalEndSyntaxLength = DVTDocumentUtilsCommon.getOptionalEndSyntaxLength(document, region.getOffset());
                            int regionLength = region.getOffset() - currentPosition.getOffset() + optionalEndSyntaxLength;
                            region = new Region(currentPosition.getOffset(), regionLength);
                        } else {
                            region = new Region(currentPosition.getOffset(), region.getOffset() - currentPosition.getOffset() + region.getLength());
                        }
                        break;
                    }
                }
                --i;
            }
        }
        return new MatchBeginEndPositionInfo(region, positionSubType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getOptionalEndSyntaxLength(IDocument document, int currOffset) {
        int optionalSyntaxLength = 0;
        try {
            int nextOffset = currOffset + 1;
            char nextChar = document.getChar(nextOffset);
            if (nextChar == ';') {
                return 0;
            }
            while (true) {
                if (nextChar == ';') {
                    return optionalSyntaxLength + 1;
                }
                ++optionalSyntaxLength;
                nextChar = document.getChar(++nextOffset);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    public static IRegion getIncludedFileRegion(IDocument document, int anchor, DVTStringBuilder sb) {
        int start;
        char c;
        int offset;
        block11: {
            offset = anchor;
            while (offset >= 0 && offset < document.getLength()) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == '\"' || c == '<' || c == '>') break;
                if (sb != null) {
                    sb.prepend(c);
                }
                --offset;
            }
            start = offset--;
            boolean foundImport = false;
            DVTStringBuilder matchInclude = new DVTStringBuilder();
            while (offset >= 0) {
                c = document.getChar(offset);
                if (c == '<' || c == '>' || c == '\"' || c == '\n' || anchor - offset > 500) break;
                matchInclude.prepend(c);
                if (matchInclude.length() > 8) {
                    matchInclude.deleteLastChar();
                }
                if (matchInclude.toString().equals("`include")) {
                    foundImport = true;
                    break;
                }
                --offset;
            }
            if (foundImport) break block11;
            return null;
        }
        try {
            int end;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (Character.isWhitespace(c) || c == ';' || c == ',' || c == '\"' || c == '<' || c == '>' || c == '\n') break;
                if (offset != anchor && sb != null) {
                    sb.append(c);
                }
                ++offset;
            }
            if (start == (end = offset)) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static String getIncludedFileName(IDocument document, int offset) {
        if (document == null) {
            return null;
        }
        DVTStringBuilder sb = new DVTStringBuilder();
        IRegion region = DVTDocumentUtilsCommon.getIncludedFileRegion(document, offset, sb);
        if (region == null) {
            return null;
        }
        String text = sb.toString();
        if (text.charAt(0) == '`') {
            return null;
        }
        return text;
    }

    public static String getTextAtRegion(IDocument document, IRegion region) {
        block3: {
            try {
                if (document != null && region != null) break block3;
                return null;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return document.get(region.getOffset(), region.getLength());
    }

    public static List<int[]> findParenthesesPairs(String input) {
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        int i = 0;
        while (i < input.length()) {
            char currentChar = input.charAt(i);
            if (OPEN_BRACKETS.contains(Character.valueOf(currentChar))) {
                stack.push(i);
            } else if (CLOSED_BRACKETS.contains(Character.valueOf(currentChar)) && !stack.isEmpty()) {
                int openIndex = (Integer)stack.pop();
                pairs.add(new int[]{openIndex, i});
            }
            ++i;
        }
        return pairs;
    }
}

