/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class DVTExceptionHandler {
    public static final int INTERNAL_ERROR = 1;
    private static DVTExceptionHandler fgInstance = new DVTExceptionHandler();

    public static void log(Throwable t, String message) {
        DVTPlugin.getDefault().getLog().log((IStatus)new Status(4, "ro.amiq.dvt", 4, message, t));
    }

    public static void handle(CoreException e, String title, String message) {
        DVTExceptionHandler.handle(e, DVTUiUtils.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, String title, String message) {
        DVTExceptionHandler.handle(e, DVTUiUtils.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        DVTExceptionHandler.log(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    public static void log(Throwable e) {
        DVTPlugin.getDefault().getLog().log((IStatus)new Status(4, "ro.amiq.dvt", 1, "Internal Error", e));
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            DVTExceptionHandler.log(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    public static void displayMessageDialog(Throwable t, Shell shell, String title, String message) {
        fgInstance.displayMessageDialog(t, t.getMessage(), shell, title, message);
    }

    public static void displayMessageDialog(Throwable t, String title, String message) {
        DVTExceptionHandler.displayMessageDialog(t, DVTUiUtils.getActiveWorkbenchShell(), title, message);
    }

    private void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write("See error log for details");
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

