/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.resources.properties.LazyPersistentPropertiesManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.editor.FileAcessEditorDecorator;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTTextChangePerformer;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTFileUtilsCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IWithDocument;
import ro.amiq.dvt.utils.TextFileBufferInfo;
import ro.amiq.dvt.utils.Utils;

public class DVTFileUtils
extends DVTFileUtilsCommon {
    private static final String SELECTED_RESOURCES_LOC = "selected_resources_loc";
    public static final String DVT_CHECKOUT_HOOK = "DVT_CHECKOUT_HOOK";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static volatile DVTFileUtils fInstance;
    private static final Object fSyncInstance;
    private IProject fLastProject;
    private String fInputParserPath;
    private String fOutputParserPath;
    private Object fSyncLastDirectory = new Object();
    private ProjectSelectionValidator fcontainerSelValidator;

    static {
        fSyncInstance = new Object();
    }

    protected DVTFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTFileUtils getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTFileUtils();
            }
        }
        return fInstance;
    }

    @Override
    public Map<ParserPath, IDocument> evalNonFileBufferParserPathDocuments() {
        Map<IFile, IDocument> evalNonFileBufferDocuments = this.evalNonFileBufferDocuments();
        if (evalNonFileBufferDocuments == null || evalNonFileBufferDocuments.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ParserPath, IDocument> result = new HashMap<ParserPath, IDocument>();
        for (Map.Entry<IFile, IDocument> entry : evalNonFileBufferDocuments.entrySet()) {
            ParserPath parserPath = this.resource2parser((IResource)entry.getKey());
            if (parserPath == null) continue;
            result.put(parserPath, entry.getValue());
        }
        return result;
    }

    public Map<IFile, IDocument> evalNonFileBufferDocuments() {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = DVTPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    @Override
    public Map<IFile, IDocument> evalNonFileBufferDocuments(IFile file) {
        return this.evalNonFileBufferDocuments();
    }

    private void evaluateTextEditor(Map<IFile, IDocument> result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            LocationKind locationKind;
            TextFileBufferInfo textFileBufferInfo;
            IPath path;
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    @Override
    public IDocument getOpenDocument(IFile file) {
        LocationKind locationKind;
        TextFileBufferInfo textFileBufferInfo;
        IPath path;
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = this.evalNonFileBufferDocuments().get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(path = (textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file)).getPath(), locationKind = textFileBufferInfo.getLocationKind())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    @Override
    public <T> T withDocument(IFile file, IWithDocument<T> withDocument) {
        return this.withDocument(file.getFullPath().toOSString(), withDocument);
    }

    public int getCommentOffset(IProject project, IDocument document, String fileName, int line) {
        int returnedValue = -1;
        try {
            IFile file = this.findProjectFileUsingAbsolutePath(project, fileName);
            if (file == null) {
                return returnedValue;
            }
            IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
            String textLine = document.get(info.getOffset(), info.getLength());
            returnedValue = this.findCommentOffset(textLine);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return returnedValue;
    }

    @Override
    protected LocationKind getLocationKind(IFile file) {
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
        return textFileBufferInfo.getLocationKind();
    }

    @Override
    protected IPath getIPath(IFile file) {
        TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
        return textFileBufferInfo.getPath();
    }

    public int getLineLength(IFile file, int line) {
        try {
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
            IPath path = textFileBufferInfo.getPath();
            LocationKind locationKind = textFileBufferInfo.getLocationKind();
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            int length = document.getLineLength(line);
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
            return length;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public String getEditorIDForFile(IFile file) {
        if (file == null) {
            return null;
        }
        String[] fileExtensions = this.getExtensionsForContentType("ro.amiq.vlogdt.VlogSource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.vlogdt.ui.editor.VlogEditor";
        }
        fileExtensions = this.getExtensionsForContentType("ro.amiq.vhdldt.VhdlSource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.vhdldt.ui.editor.VhdlEditor";
        }
        fileExtensions = this.getExtensionsForContentType("ro.amiq.edt.ESource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.edt.ui.editor.EEditor";
        }
        fileExtensions = this.getExtensionsForContentType("ro.amiq.slndt.SLNSource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.slndt.ui.editor.SLNEditor";
        }
        fileExtensions = this.getExtensionsForContentType("ro.amiq.msdldt.MSDLSource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.msdldt.ui.editor.MSDLEditor";
        }
        fileExtensions = this.getExtensionsForContentType("ro.amiq.pssdt.PSSSource", false);
        if (this.validExtension(fileExtensions, file.getName())) {
            return "ro.amiq.pssdt.ui.editor.PSSEditor";
        }
        return null;
    }

    @Override
    public void openEditor(final IFile file, int line, String selectedIdentifier, boolean activate, String preferredEditorId) {
        if (file == null || !file.exists() || !file.isAccessible()) {
            return;
        }
        int offset = 0;
        int length = 0;
        try {
            int[] offsetLength;
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
            IPath path = textFileBufferInfo.getPath();
            LocationKind locationKind = textFileBufferInfo.getLocationKind();
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            if ((offsetLength = this.getIdentifierOffsetInLine(line, selectedIdentifier, document, -1)) != null && offsetLength.length == 2) {
                offset = offsetLength[0];
                length = offsetLength[1];
            }
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        try {
            IMarker marker = new IMarker(){
                Map<String, Object> attributes = new HashMap<String, Object>();

                public Object getAdapter(Class adapter) {
                    return null;
                }

                public void setAttributes(String[] attributeNames, Object[] values) throws CoreException {
                }

                public void setAttributes(Map<String, ? extends Object> attributes) throws CoreException {
                }

                public void setAttribute(String attributeName, boolean value) throws CoreException {
                    this.attributes.put(attributeName, value);
                }

                public void setAttribute(String attributeName, Object value) throws CoreException {
                    this.attributes.put(attributeName, value);
                }

                public void setAttribute(String attributeName, int value) throws CoreException {
                    this.attributes.put(attributeName, value);
                }

                public boolean isSubtypeOf(String superType) throws CoreException {
                    return false;
                }

                public String getType() throws CoreException {
                    return "org.eclipse.core.resources.textmarker";
                }

                public IResource getResource() {
                    return file;
                }

                public long getId() {
                    return 0L;
                }

                public long getCreationTime() throws CoreException {
                    return 0L;
                }

                public Object[] getAttributes(String[] attributeNames) throws CoreException {
                    return null;
                }

                public Map<String, Object> getAttributes() throws CoreException {
                    return this.attributes;
                }

                public boolean getAttribute(String attributeName, boolean defaultValue) {
                    Object result = this.attributes.get(attributeName);
                    return result == null ? defaultValue : (Boolean)result;
                }

                public String getAttribute(String attributeName, String defaultValue) {
                    Object result = this.attributes.get(attributeName);
                    return result == null ? defaultValue : (String)result;
                }

                public int getAttribute(String attributeName, int defaultValue) {
                    Object result = this.attributes.get(attributeName);
                    return result == null ? defaultValue : (Integer)result;
                }

                public Object getAttribute(String attributeName) throws CoreException {
                    return this.attributes.get(attributeName);
                }

                public boolean exists() {
                    return true;
                }

                public void delete() throws CoreException {
                }
            };
            if (preferredEditorId != null) {
                IEditorDescriptor preferredEditorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor(preferredEditorId);
                if (preferredEditorDescriptor == null) {
                    preferredEditorId = DEFAULT_TEXT_EDITOR_ID;
                }
                if (DVTFileUtils.isLargeFile(file.getLocationURI())) {
                    preferredEditorId = "ro.amiq.dvt.ui.editor.LargeFileEditor";
                }
                marker.setAttribute("org.eclipse.ui.editorID", (Object)preferredEditorId);
            }
            marker.setAttribute("lineNumber", line);
            if (length > 0) {
                marker.setAttribute("charStart", offset);
                marker.setAttribute("charEnd", offset + length);
            }
            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)marker, (boolean)activate);
            marker.delete();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void openEditor(IFile file, int line, String selectIdentifier) {
        this.openEditor(file, line, selectIdentifier, true, null);
    }

    @Override
    public void openEditor(final IFile file, final IRegion region) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (!(editor instanceof TextEditor)) {
                        return;
                    }
                    TextEditor textEditor = (TextEditor)editor;
                    IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                    if (documentProvider == null) {
                        return;
                    }
                    IEditorInput editorInput = textEditor.getEditorInput();
                    if (editorInput == null) {
                        return;
                    }
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    if (document == null) {
                        return;
                    }
                    if (region != null) {
                        textEditor.selectAndReveal(region.getOffset(), region.getLength());
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    @Override
    public void openEditor(java.io.File file, int line) {
        this.openEditor(file, line, DEFAULT_TEXT_EDITOR_ID);
    }

    public void openEditorWithOffset(IFile file, int offset, int length) {
        if (file == null) {
            return;
        }
        String editorId = this.getEditorIDForFile(file);
        if (editorId == null) {
            return;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return;
        }
        this.openEditorWithOffset(location.toFile(), offset, length, true, editorId);
    }

    @Override
    public void openEditorWithOffset(final java.io.File file, final int offset, final int length, final boolean activate, final String defaultEditorID) {
        if (offset < 0 || length < 0) {
            return;
        }
        ro.amiq.dvt.ui.Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                try {
                    IEditorPart editor;
                    IEditorDescriptor editorDesc;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    String editorId = defaultEditorID;
                    if (DVTFileUtils.DEFAULT_TEXT_EDITOR_ID.equals(defaultEditorID) && (editorDesc = workbench.getEditorRegistry().getDefaultEditor(file.getName())) != null) {
                        editorId = editorDesc.getId();
                    }
                    if (!((editor = IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editorId, (boolean)activate)) instanceof TextEditor)) {
                        return;
                    }
                    ((TextEditor)editor).selectAndReveal(offset, length);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    @Override
    public void openEditor(final java.io.File file, final int line, final String identifier, final String defaultEditorID, final boolean activate) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IEditorPart editor;
                    IEditorDescriptor editorDesc;
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    String editorId = defaultEditorID;
                    if (DVTFileUtils.DEFAULT_TEXT_EDITOR_ID.equals(defaultEditorID) && (editorDesc = workbench.getEditorRegistry().getDefaultEditor(file.getName())) != null) {
                        editorId = editorDesc.getId();
                    }
                    if (DVTFileUtils.isLargeFile(file.toURI())) {
                        editorId = "ro.amiq.dvt.ui.editor.LargeFileEditor";
                    }
                    if (!((editor = IDE.openEditor((IWorkbenchPage)page, (URI)file.toURI(), (String)editorId, (boolean)activate)) instanceof TextEditor)) {
                        return;
                    }
                    TextEditor textEditor = (TextEditor)editor;
                    IDocumentProvider documentProvider = textEditor.getDocumentProvider();
                    if (documentProvider == null) {
                        return;
                    }
                    IEditorInput editorInput = textEditor.getEditorInput();
                    if (editorInput == null) {
                        return;
                    }
                    IDocument document = documentProvider.getDocument((Object)editorInput);
                    if (document == null) {
                        return;
                    }
                    try {
                        int[] identifierInfo;
                        IRegion lineInfo = document.getLineInformation(line > 0 ? line - 1 : line);
                        int regionOffset = lineInfo.getOffset();
                        int regionLength = lineInfo.getLength();
                        if (identifier != null && !identifier.isEmpty() && (identifierInfo = DVTFileUtils.this.getIdentifierOffsetInLine(line, identifier, document, -1)) != null && identifierInfo.length == 2 && identifierInfo[1] != 0) {
                            regionOffset = identifierInfo[0];
                            regionLength = identifierInfo[1];
                        }
                        textEditor.selectAndReveal(regionOffset, regionLength);
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    public void openEditor(java.io.File file, int line, String defaultEditorID) {
        this.openEditor(file, line, null, defaultEditorID, true);
    }

    @Override
    public synchronized String parser2resource(IProject project, ParserPath parserPath) {
        block6: {
            try {
                if (parserPath != null) break block6;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        if (this.fLastProject != null && this.fInputParserPath != null && this.fLastProject.equals((Object)project) && this.fInputParserPath.equals(parserPath.path)) {
            return this.fOutputParserPath;
        }
        this.fLastProject = project;
        this.fInputParserPath = parserPath.path;
        LazyPersistentPropertiesManager.IPropertyValue resourceRelativePath = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)project, new LazyPersistentPropertiesManager.ParserPathProperty(parserPath.path));
        if (resourceRelativePath == null) {
            this.fOutputParserPath = parserPath.path;
            return parserPath.path;
        }
        IFile file = project.getFile(resourceRelativePath.value());
        if (file != null && file.exists() && file.getLocation() != null) {
            String result;
            this.fOutputParserPath = result = file.getLocation().toOSString();
            return result;
        }
        this.fOutputParserPath = parserPath.path;
        return parserPath.path;
    }

    @Override
    public ParserPath resource2parser(IResource file) {
        block4: {
            try {
                if (file != null && file.getLocation() != null) break block4;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        String resourceRelativePath = file.getProjectRelativePath().toOSString();
        LazyPersistentPropertiesManager.IPropertyValue parserPath = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)file.getProject(), new LazyPersistentPropertiesManager.ResourcePathProperty(resourceRelativePath));
        if (parserPath == null) {
            String result = file.getLocation().toOSString();
            return new ParserPath(result);
        }
        ParserPath parserPathObject = new ParserPath(parserPath.value());
        return parserPathObject;
    }

    @Override
    public IFile findProjectFile(IProject project, String parserPath) {
        return this.internalFindProjectFile(project, parserPath, false, false);
    }

    @Override
    public IFile findProjectFileUsingAbsolutePath(IProject project, String parserPath) {
        return this.internalFindProjectFile(project, parserPath, true, false);
    }

    public IFile findProjectFileAndRegister(IProject project, String parserPath, String callerMethodName) {
        return this.internalFindProjectFile(project, parserPath, true, "createResource".equals(callerMethodName));
    }

    public IFile findProjectFileAndRegister(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks) {
        String fileName;
        List<IFile> candidates;
        java.io.File parserPathFile;
        IPath symlinkPath;
        Assert.isTrue((boolean)parserPath.isAbsolute());
        IFile candidate = this.internalFindProjectFile2(project, parserPath);
        if (candidate == null && (symlinkPath = directorySymlinks.get(Path.fromOSString((String)(parserPathFile = parserPath.toFile()).getParent()))) != null) {
            String fileName2 = parserPathFile.getName();
            symlinkPath = symlinkPath.append(fileName2);
            candidate = this.internalFindProjectFile2(project, symlinkPath);
        }
        if (candidate == null && (candidates = fileCandidates.get(fileName = (parserPathFile = parserPath.toFile()).getName())) != null) {
            try {
                String physicalPath1 = parserPathFile.getCanonicalPath();
                for (IFile resource : candidates) {
                    String physicalPath2;
                    IPath resourcePath = resource.getLocation();
                    if (resourcePath == null || !physicalPath1.equals(physicalPath2 = resourcePath.toFile().getCanonicalPath())) continue;
                    candidate = resource;
                    break;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (candidate == null) {
            return null;
        }
        String resourcePath = candidate.getProjectRelativePath().toOSString();
        PropertiesManager.addParser2ResourceMapProperty(project, parserPath.toOSString(), resourcePath);
        return candidate;
    }

    private IFile internalFindProjectFile(IProject project, final String parserPath, boolean absolute, boolean register) {
        IFile file;
        if (parserPath == null || project == null) {
            return null;
        }
        if (parserPath.trim().isEmpty()) {
            return null;
        }
        final IPath resourceNamePath = Path.fromOSString((String)parserPath);
        Assert.isTrue((boolean)(!absolute | resourceNamePath.isAbsolute()));
        Assert.isTrue((!(register & !absolute) ? 1 : 0) != 0);
        LazyPersistentPropertiesManager.IPropertyValue resourceRelativePath = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)project, new LazyPersistentPropertiesManager.ParserPathProperty(parserPath));
        if (resourceRelativePath != null && (file = project.getFile(resourceRelativePath.value())) != null && file.exists() && file.getLocation() != null) {
            return file;
        }
        IPath location = project.getLocation();
        if (location != null && location.isPrefixOf(resourceNamePath)) {
            IPath relative = resourceNamePath.makeRelativeTo(location);
            if (relative.isEmpty()) {
                return null;
            }
            IFile file2 = project.getFile(relative);
            if (file2 != null && file2.exists() && file2.getLocation() != null) {
                String resourcePath = file2.getProjectRelativePath().toOSString();
                if (register) {
                    PropertiesManager.addParser2ResourceMapProperty(project, parserPath, resourcePath);
                }
                return file2;
            }
        }
        final IPath[] knownPath = new IPath[1];
        final String knownName = resourceNamePath.lastSegment();
        final ArrayList candidates = new ArrayList();
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 1 && proxy.getName().equals(knownName)) {
                    IResource requestResource = proxy.requestResource();
                    IPath rawProxyPath = requestResource.getLocation();
                    if (rawProxyPath == null) {
                        return false;
                    }
                    IPath requestResourceRelativePath = requestResource.getProjectRelativePath();
                    if (requestResourceRelativePath.segment(0).equals("DVT Auto-Linked")) {
                        if (resourceNamePath.equals((Object)rawProxyPath)) {
                            candidates.clear();
                            candidates.add((IFile)requestResource);
                        }
                        return false;
                    }
                    IPath proxyPath = Path.fromOSString((String)Utils.physicalPath(rawProxyPath.toOSString(), true));
                    if (knownPath[0] == null) {
                        knownPath[0] = Path.fromOSString((String)Utils.physicalPath(parserPath, true));
                    }
                    if (knownPath[0].isAbsolute()) {
                        if (proxyPath.equals((Object)knownPath[0])) {
                            candidates.clear();
                            candidates.add((IFile)requestResource);
                            return false;
                        }
                    } else if (proxyPath.removeFirstSegments(proxyPath.segmentCount() - knownPath[0].segmentCount()).equals((Object)knownPath[0])) {
                        candidates.add((IFile)requestResource);
                        return true;
                    }
                }
                return true;
            }
        };
        try {
            if (project.isAccessible()) {
                project.accept(visitor, 0);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        IFile[] sortedCandidates = candidates.toArray(new IFile[candidates.size()]);
        Arrays.sort(sortedCandidates, new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                if (o1.isLinked() && o2.isLinked()) {
                    if (o1.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.isLinked()) {
                    return 1;
                }
                return -1;
            }
        });
        IFile iFile = null;
        if (sortedCandidates.length == 0 || (iFile = sortedCandidates[0]) == null) {
            return null;
        }
        String resourcePath = iFile.getProjectRelativePath().toOSString();
        if (register) {
            PropertiesManager.addParser2ResourceMapProperty(project, parserPath, resourcePath);
        }
        return iFile;
    }

    private IFile internalFindProjectFile2(IProject project, IPath parserPathPath) {
        IPath autoLinkedPath;
        IFile file;
        IFile file2;
        if (parserPathPath == null || project == null) {
            return null;
        }
        LazyPersistentPropertiesManager.IPropertyValue resourceRelativePath = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)project, new LazyPersistentPropertiesManager.ParserPathProperty(parserPathPath.toOSString()));
        if (resourceRelativePath != null && (file2 = project.getFile(resourceRelativePath.value())) != null && file2.exists() && file2.getLocation() != null) {
            return file2;
        }
        IPath location = project.getLocation();
        if (location != null && location.isPrefixOf(parserPathPath)) {
            IPath relative = parserPathPath.makeRelativeTo(location);
            if (relative.isEmpty()) {
                return null;
            }
            file = project.getFile(relative);
            if (file != null && file.exists() && file.getLocation() != null) {
                return file;
            }
        }
        if ((file = project.getFile(autoLinkedPath = Path.fromOSString((String)"DVT Auto-Linked").append(parserPathPath))) != null && file.exists() && file.getLocation() != null) {
            return file;
        }
        return null;
    }

    public void cacheDirectories(IProject project, final Set<String> compiledFileNames, final Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks) {
        Assert.isNotNull(fileCandidates);
        Assert.isNotNull(directorySymlinks);
        final HashSet directoryCandidates = new HashSet();
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                String resourceName = proxy.getName();
                if (proxy.getType() == 1 && compiledFileNames.contains(resourceName)) {
                    IResource requestResource = proxy.requestResource();
                    IPath requestResourceRelativePath = requestResource.getProjectRelativePath();
                    if (requestResourceRelativePath.segment(0).equals("DVT Auto-Linked")) {
                        return false;
                    }
                    ArrayList<IFile> candidates = (ArrayList<IFile>)fileCandidates.get(resourceName);
                    if (candidates == null) {
                        candidates = new ArrayList<IFile>();
                        fileCandidates.put(resourceName, candidates);
                    }
                    candidates.add((IFile)requestResource);
                    IContainer directoryPath = requestResource.getParent();
                    if (directoryPath != null && !directoryPath.isVirtual()) {
                        directoryCandidates.add(directoryPath);
                    }
                }
                return true;
            }
        };
        try {
            project.accept(visitor, 0);
        }
        catch (CoreException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DVTExceptionHandler.handle(e, "", "Resource find");
                }
            });
        }
        for (IResource candidate : directoryCandidates) {
            IPath symlink = candidate.getLocation();
            if (symlink == null) continue;
            try {
                IPath physical = Path.fromOSString((String)symlink.toFile().getCanonicalPath());
                if (symlink.equals((Object)physical)) continue;
                directorySymlinks.put(physical, symlink);
            }
            catch (Exception exception) {}
        }
    }

    public IFile[] getWorkspaceFiles(IProject project, String filePath) {
        try {
            IFile candidate = null;
            candidate = Path.fromOSString((String)filePath).isAbsolute() ? this.findProjectFileUsingAbsolutePath(project, filePath) : this.findProjectFile(project, filePath);
            if (candidate != null) {
                return new IFile[]{candidate};
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        IFile[] sortedCandidates = this.internalGetWorkspaceFilesFromAbsolutePath(project, filePath);
        if (sortedCandidates == null || sortedCandidates.length == 0) {
            IFile projectFile = this.findProjectFile(project, filePath);
            if (projectFile != null) {
                return new IFile[]{projectFile};
            }
            return new IFile[0];
        }
        Arrays.sort(sortedCandidates, new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                if (o1.isLinked() && o2.isLinked()) {
                    if (o1.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) {
                        return 1;
                    }
                    return -1;
                }
                if (o1.isLinked()) {
                    return 1;
                }
                return -1;
            }
        });
        return sortedCandidates;
    }

    private IFile[] internalGetWorkspaceFilesFromAbsolutePath(IProject project, String absolutePath) {
        try {
            IFile tmp;
            IFile[] iFileArray;
            IPath location = Path.fromOSString((String)absolutePath);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ArrayList<IFile> result = new ArrayList<IFile>();
            IFile file = null;
            file = workspace.getRoot().getFileForLocation(location);
            if (file != null && file.exists() && (project == null || file.getProject().getName().equals(project.getName()))) {
                result.add(file);
                return result.toArray(new IFile[result.size()]);
            }
            IFile[] files = workspace.getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)location.makeAbsolute()));
            if (files == null || files.length == 0) {
                IResource tmp2;
                ArrayList<IPath> paths = this.allPathsForLocation(URIUtil.toURI((IPath)location.makeAbsolute()), workspace);
                for (IPath path : paths) {
                    tmp2 = this.resourceFor(path, workspace);
                    if (tmp2 == null || !(tmp2 instanceof IFile) || !tmp2.exists() || tmp2.getProject() == null || project != null && !tmp2.getProject().getName().equals(project.getName())) continue;
                    result.add((IFile)tmp2);
                }
                if (result.isEmpty()) {
                    for (IPath path : paths) {
                        tmp2 = this.resourceFor(path, workspace);
                        if (tmp2 == null || !(tmp2 instanceof IFile) || project != null && !tmp2.getProject().getName().equals(project.getName())) continue;
                        result.add((IFile)tmp2);
                    }
                }
            } else {
                iFileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    tmp = iFileArray[n2];
                    if (tmp != null && tmp.exists() && tmp.getProject() != null && (project == null || tmp.getProject().getName().equals(project.getName()))) {
                        result.add(tmp);
                    }
                    ++n2;
                }
            }
            if (files != null && result.isEmpty()) {
                iFileArray = files;
                int n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    tmp = iFileArray[n3];
                    if (tmp != null && tmp.exists() && (project == null || tmp.getProject().getName().equals(project.getName()))) {
                        result.add(tmp);
                    }
                    ++n3;
                }
            }
            return result.toArray(new IFile[result.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IFile[0];
        }
    }

    protected IResource resourceFor(IPath path, IWorkspace workspace) {
        int numSegments = path.segmentCount();
        if (numSegments < 2) {
            return null;
        }
        IWorkspaceRoot root = workspace.getRoot();
        if (path.isRoot()) {
            return root;
        }
        return root.getFile(path);
    }

    protected ArrayList<IPath> allPathsForLocation(URI location, IWorkspace workspace) {
        boolean isFileLocation = "file".equals(location.getScheme());
        IWorkspaceRoot root = workspace.getRoot();
        ArrayList<IPath> results = new ArrayList<IPath>();
        if (URIUtil.equals((URI)location, (URI)root.getLocationURI())) {
            results.add((IPath)Path.ROOT);
            return results;
        }
        IPathVariableManager varMan = workspace.getPathVariableManager();
        IProject[] projects = root.getProjects(8);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            URI testLocation = project.getLocationURI();
            if (testLocation != null) {
                if (isFileLocation && !"file".equals(testLocation.getScheme())) {
                    testLocation = this.getFileURI(testLocation);
                }
                if (testLocation != null) {
                    HashMap links;
                    ProjectDescription description;
                    URI relative = testLocation.relativize(location);
                    if (!relative.isAbsolute() && !relative.equals(testLocation)) {
                        IPath suffix = Path.fromOSString((String)relative.getPath());
                        results.add(project.getFullPath().append(suffix));
                    }
                    if ((description = ((Project)project).internalGetDescription()) != null && (links = description.getLinks()) != null) {
                        for (LinkDescription link : links.values()) {
                            testLocation = varMan.resolveURI(link.getLocationURI());
                            if (isFileLocation && !"file".equals(testLocation.getScheme())) {
                                testLocation = this.getFileURI(testLocation);
                            }
                            if (testLocation == null || (relative = testLocation.relativize(location)).isAbsolute() || relative.equals(testLocation)) continue;
                            IPath suffix = Path.fromOSString((String)relative.getPath());
                            results.add(project.getFullPath().append(link.getProjectRelativePath()).append(suffix));
                        }
                    }
                }
            }
            ++i;
        }
        return results;
    }

    private URI getFileURI(URI locationURI) {
        try {
            IFileStore testLocationStore = EFS.getStore((URI)locationURI);
            java.io.File storeAsFile = testLocationStore.toLocalFile(0, null);
            if (storeAsFile != null) {
                return URIUtil.toURI((String)storeAsFile.getAbsolutePath());
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLastDirectory() {
        if (this.fLastDirectory == null) {
            Object object = this.fSyncLastDirectory;
            synchronized (object) {
                this.fLastDirectory = System.getProperty("user.home");
            }
        }
        return this.fLastDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLastDirectory(String lastDirectory) {
        Object object = this.fSyncLastDirectory;
        synchronized (object) {
            java.io.File f2;
            if (lastDirectory != null && (f2 = new java.io.File(lastDirectory)).exists()) {
                this.fLastDirectory = f2.isDirectory() ? lastDirectory : f2.getParent();
            }
        }
    }

    public String getFileContentType(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 1) {
            IContentDescription description;
            IFile file = (IFile)resource;
            if (!file.exists()) {
                return null;
            }
            try {
                description = file.getContentDescription();
            }
            catch (CoreException coreException) {
                return null;
            }
            if (description != null) {
                IContentType type = description.getContentType();
                return type.getId();
            }
        }
        return null;
    }

    @Override
    public String[] getExtensionsForContentType(String contTypeId, boolean prependStarDot) {
        String[] ext;
        block9: {
            IContentType ct;
            block8: {
                IContentTypeManager manager;
                block7: {
                    manager = Platform.getContentTypeManager();
                    if (manager != null) break block7;
                    return null;
                }
                ct = manager.getContentType(contTypeId);
                if (ct != null) break block8;
                return null;
            }
            ext = ct.getFileSpecs(8);
            if (!prependStarDot) {
                return ext;
            }
            if (ext != null) break block9;
            return null;
        }
        try {
            int i = 0;
            while (i < ext.length) {
                ext[i] = "*." + ext[i];
                ++i;
            }
            return ext;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public boolean isLinked(IResource resource) {
        if (resource.isLinked()) {
            return true;
        }
        IContainer parent = resource.getParent();
        while (parent != null && !(parent instanceof IProject)) {
            if (parent.isLinked()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public int writeStringToFileWithCheckout(IProject project, java.io.File file, String content) {
        final IFile[] checkOutList = new IFile[]{DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, file.getAbsolutePath())};
        boolean userDeclined = DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])checkOutList, new Callable<IStatus>(){

            @Override
            public IStatus call() {
                return ResourcesPlugin.getWorkspace().validateEdit(checkOutList, (Object)FileModificationValidationContext.VALIDATE_PROMPT);
            }
        }, false, null);
        if (userDeclined) {
            return 8;
        }
        if (!file.canWrite()) {
            return 4;
        }
        this.writeStringToFile(file, content, true);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<java.io.File> copyDirectory(java.io.File srcFile, java.io.File dstFile, final String[] filterPatterns, boolean makeAllWritable) {
        ArrayList<java.io.File> notCopiedList = new ArrayList<java.io.File>();
        if (srcFile.isDirectory()) {
            String[] files;
            if (!dstFile.exists()) {
                dstFile.mkdirs();
            }
            String[] stringArray = files = srcFile.list(new FilenameFilter(){

                @Override
                public boolean accept(java.io.File dir, String name) {
                    if (filterPatterns == null) {
                        return true;
                    }
                    String[] stringArray = filterPatterns;
                    int n = filterPatterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String filterPattern = stringArray[n2];
                        if (name.matches(filterPattern)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
            });
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                notCopiedList.addAll(this.copyDirectory(new java.io.File(srcFile, file), new java.io.File(dstFile, file), filterPatterns, makeAllWritable));
                ++n2;
            }
            return notCopiedList;
        }
        try {
            Throwable throwable = null;
            Object var7_16 = null;
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                try {
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFile));){
                        int len;
                        byte[] buf = new byte[1024];
                        while ((len = ((InputStream)in).read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        if (srcFile.canExecute()) {
                            dstFile.setExecutable(true);
                        }
                        if (makeAllWritable) {
                            dstFile.setWritable(true);
                        } else if (!srcFile.canWrite()) {
                            dstFile.setReadOnly();
                        }
                    }
                    if (in == null) return notCopiedList;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    ((InputStream)in).close();
                    throw throwable;
                }
                ((InputStream)in).close();
                return notCopiedList;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            notCopiedList.add(srcFile);
        }
        return notCopiedList;
    }

    @Override
    public String readFileContent(IFile file) {
        String result = "";
        try {
            InputStream is = file.getContents();
            byte[] buf = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int len = is.read(buf);
            while (len > 0) {
                bos.write(buf, 0, len);
                len = is.read(buf);
            }
            is.close();
            result = new String(bos.toByteArray());
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return result;
    }

    @Override
    public IDocument getDocument(ITextEditor editor) {
        IDocumentProvider provider;
        IEditorInput editorInput;
        block7: {
            block6: {
                block5: {
                    try {
                        if (editor != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                editorInput = editor.getEditorInput();
                if (editorInput != null) break block6;
                return null;
            }
            provider = editor.getDocumentProvider();
            if (provider != null) break block7;
            return null;
        }
        IDocument document = provider.getDocument((Object)editorInput);
        return document;
    }

    private boolean popFileList(final List<String> files) {
        final AtomicBoolean result = new AtomicBoolean();
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Confirm Checkout", null, "Do you want to check out the following files ?", 5, new String[]{"OK", "Cancel"}, 0){

                    protected Control createCustomArea(Composite parent) {
                        parent.setLayout((Layout)new GridLayout());
                        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2560);
                        GridData layoutData = new GridData(4, 4, true, true);
                        layoutData.heightHint = 100;
                        list.setLayoutData((Object)layoutData);
                        list.setItems(files.toArray(new String[files.size()]));
                        list.setSelection(new String[0]);
                        return parent;
                    }
                };
                result.set(dialog.open() == 0);
            }
        });
        return result.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkOutFiles(List<IResource> filesToCheckOut, boolean doCheckoutAsJob, IProgressMonitor jobMonitor) {
        if (filesToCheckOut == null || filesToCheckOut.isEmpty()) {
            return false;
        }
        try {
            ILaunchConfigurationWorkingCopy checkOutLaunchConfig = null;
            ArrayList<String> checkOutList = new ArrayList<String>();
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getName().equalsIgnoreCase(DVT_CHECKOUT_HOOK)) {
                    checkOutLaunchConfig = config.getWorkingCopy();
                }
                ++n2;
            }
            if (checkOutLaunchConfig == null) {
                return false;
            }
            String checkOutCommandOriginal = checkOutLaunchConfig.getAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", "");
            StringBuffer checkOutCommandUpdated = new StringBuffer();
            String checkOutRunConfigPattern = "\\$\\{selected_resources_loc(:([^}]*?))?\\}";
            String checkOutListSeparator = ":";
            Pattern p = Pattern.compile(checkOutRunConfigPattern);
            Matcher m = p.matcher(checkOutCommandOriginal);
            if (!m.find()) {
                return false;
            }
            m.reset();
            checkOutLaunchConfig.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            for (IResource i : filesToCheckOut) {
                checkOutList.add(i.getLocation().toOSString());
            }
            while (m.find()) {
                if (m.group(2) != null) {
                    checkOutListSeparator = m.group(2);
                }
                String checkoutListString = DVTStringUtil.join(checkOutList, checkOutListSeparator);
                m.appendReplacement(checkOutCommandUpdated, checkoutListString);
            }
            m.appendTail(checkOutCommandUpdated);
            checkOutLaunchConfig.setAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", checkOutCommandUpdated.toString());
            System.setProperty("ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate.ExitValue", "");
            if (checkOutLaunchConfig.getAttribute("ro.amiq.dvt.launch.REQUIRE_CHECKOUT_CONFIRMATION", true)) {
                if (!this.popFileList(checkOutList)) {
                    return true;
                }
                if (doCheckoutAsJob) {
                    DebugUITools.launch((ILaunchConfiguration)checkOutLaunchConfig, (String)"run");
                    this.updateAllEditorsAccessDecorator();
                } else {
                    checkOutLaunchConfig.launch("run", jobMonitor, false);
                    this.updateAllEditorsAccessDecorator();
                }
            } else if (doCheckoutAsJob) {
                DebugUITools.launch((ILaunchConfiguration)checkOutLaunchConfig, (String)"run");
                this.updateAllEditorsAccessDecorator();
            } else {
                checkOutLaunchConfig.launch("run", jobMonitor, false);
                this.updateAllEditorsAccessDecorator();
            }
            String exitVal = System.getProperty("ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate.ExitValue");
            System.setProperty("ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate.ExitValue", "");
            if (exitVal != null && exitVal.trim().equals("0")) return false;
            return true;
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    private void updateAllEditorsAccessDecorator() {
        for (IWorkbenchPartReference iWorkbenchPartReference : ro.amiq.dvt.ui.Utils.getCurrentlyOpenEditorReferences()) {
            FileAcessEditorDecorator.getInstance().handleRO(iWorkbenchPartReference);
        }
    }

    public boolean fixFileModificationValidatorPermissions(IResource[] files, Callable<IStatus> r, boolean doCheckoutAsJob, IProgressMonitor monitor) {
        IFileInfo oldFileInfo;
        ArrayList<IResource> readOnlyFilesSubset = new ArrayList<IResource>();
        IResource[] iResourceArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource != null && resource.getResourceAttributes() != null && resource.getResourceAttributes().isReadOnly()) {
                readOnlyFilesSubset.add(resource);
            }
            ++n2;
        }
        boolean userDeclinedCheckingOutFiles = this.checkOutFiles(readOnlyFilesSubset, doCheckoutAsJob, monitor);
        HashMap<IResource, IFileInfo> oldFileInfos = new HashMap<IResource, IFileInfo>();
        IResource[] iResourceArray2 = files;
        int n3 = files.length;
        int n4 = 0;
        while (n4 < n3) {
            IResource file = iResourceArray2[n4];
            oldFileInfo = this.getEFSFileInfo(file);
            if (oldFileInfo != null) {
                oldFileInfos.put(file, oldFileInfo);
            }
            ++n4;
        }
        if (!userDeclinedCheckingOutFiles) {
            IStatus status = null;
            try {
                status = r.call();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (status == null || !status.isOK()) {
                userDeclinedCheckingOutFiles = true;
            }
        }
        iResourceArray2 = files;
        n3 = files.length;
        int n5 = 0;
        while (n5 < n3) {
            IFileInfo newFileInfo;
            IResource file = iResourceArray2[n5];
            oldFileInfo = (IFileInfo)oldFileInfos.get(file);
            if (oldFileInfo != null && (newFileInfo = this.getEFSFileInfo(file)) != null) {
                boolean newOwnerSymlink;
                boolean oldOwnerRead = oldFileInfo.getAttribute(0x400000);
                boolean oldOwnerWrite = oldFileInfo.getAttribute(0x800000);
                boolean oldOwnerExecute = oldFileInfo.getAttribute(0x1000000);
                boolean newOwnerRead = newFileInfo.getAttribute(0x400000);
                boolean newOwnerWrite = newFileInfo.getAttribute(0x800000);
                boolean newOwnerExecute = newFileInfo.getAttribute(0x1000000);
                boolean oldOwnerSymlink = oldFileInfo.getAttribute(32);
                if (oldOwnerSymlink == (newOwnerSymlink = newFileInfo.getAttribute(32)) && (oldOwnerRead != newOwnerRead || oldOwnerWrite != newOwnerWrite || oldOwnerExecute != newOwnerExecute)) {
                    if (!newFileInfo.getAttribute(0x2000000) && oldFileInfo.getAttribute(0x2000000)) {
                        newFileInfo.setAttribute(0x2000000, true);
                    }
                    if (!newFileInfo.getAttribute(0x4000000) && oldFileInfo.getAttribute(0x4000000)) {
                        newFileInfo.setAttribute(0x4000000, true);
                    }
                    if (!newFileInfo.getAttribute(0x8000000) && oldFileInfo.getAttribute(0x8000000)) {
                        newFileInfo.setAttribute(0x8000000, true);
                    }
                    if (!newFileInfo.getAttribute(0x10000000) && oldFileInfo.getAttribute(0x10000000)) {
                        newFileInfo.setAttribute(0x10000000, true);
                    }
                    if (!newFileInfo.getAttribute(0x20000000) && oldFileInfo.getAttribute(0x20000000)) {
                        newFileInfo.setAttribute(0x20000000, true);
                    }
                    if (!newFileInfo.getAttribute(0x40000000) && oldFileInfo.getAttribute(0x40000000)) {
                        newFileInfo.setAttribute(0x40000000, true);
                    }
                    newFileInfo.setAttribute(0x200000, oldFileInfo.getAttribute(0x200000));
                    this.putEFSFileInfo(file, newFileInfo);
                }
            }
            ++n5;
        }
        return userDeclinedCheckingOutFiles;
    }

    public IFileInfo getEFSFileInfo(IResource file) {
        IFileStore store = null;
        if (file == null) {
            return null;
        }
        try {
            store = EFS.getStore((URI)file.getLocationURI());
        }
        catch (CoreException coreException) {
            return null;
        }
        IFileInfo fileInfo = store.fetchInfo();
        if (!fileInfo.exists()) {
            return null;
        }
        return fileInfo;
    }

    public void putEFSFileInfo(IResource file, IFileInfo info) {
        try {
            IFileStore store = null;
            store = EFS.getStore((URI)file.getLocationURI());
            store.putInfo(info, 1024, null);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    @Override
    public boolean ensureFileInSyncWithUserAccept(final IResource resource, IProgressMonitor progressMonitor) throws CoreException {
        if (resource.isSynchronized(0)) {
            return true;
        }
        boolean[] result = new boolean[1];
        CoreException[] exc = new CoreException[1];
        final int[] action = new int[1];
        final int[] dialogResult = new int[1];
        ro.amiq.dvt.ui.Utils.getActiveShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (TestHelper.isTestMode()) {
                    action[0] = 1;
                    return;
                }
                dialogResult[0] = new MessageDialog(ro.amiq.dvt.ui.Utils.getActiveShell(), "Resource out of sync", MessageDialog.getDefaultImage(), "Resource " + resource.getProjectRelativePath().toOSString() + " is out of sync with the filesystem. What do you want to do?", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0){
                    Button refreshProject;
                    Button refreshResource;
                    Button cntinue;

                    protected Control createCustomArea(Composite parent) {
                        Composite container = new Composite(parent, 0);
                        container.setLayout((Layout)RowLayoutFactory.fillDefaults().type(512).create());
                        this.refreshProject = new Button(container, 16);
                        this.refreshProject.setText("Refresh resource project [" + resource.getProject().getName() + "] (time consuming)");
                        this.refreshProject.setSelection(true);
                        this.refreshResource = new Button(container, 16);
                        this.refreshResource.setText("Refresh resource only (other resources in this project might be out of sync)");
                        this.cntinue = new Button(container, 16);
                        this.cntinue.setText("Continue without any action (this resource will be skipped)");
                        return container;
                    }

                    public boolean close() {
                        action[0] = this.refreshProject.getSelection() ? 0 : (this.refreshResource.getSelection() ? 1 : (this.cntinue.getSelection() ? 2 : 2));
                        return super.close();
                    }
                }.open();
            }
        });
        if (dialogResult[0] != 0) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
        try {
            SubProgressMonitor spm = new SubProgressMonitor(progressMonitor, 99);
            spm.setTaskName("Refreshing");
            if (action[0] == 2) {
                result[0] = false;
            } else if (action[0] == 1) {
                resource.refreshLocal(2, (IProgressMonitor)spm);
                result[0] = true;
            } else if (action[0] == 0) {
                resource.getProject().refreshLocal(2, (IProgressMonitor)spm);
                result[0] = true;
            }
        }
        catch (CoreException e) {
            exc[0] = e;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        if (exc[0] != null) {
            throw exc[0];
        }
        return result[0];
    }

    public void manageLinkedResourceCreation(IResourceDelta delta, final String autoLinkedRoot) {
        if (delta == null) {
            return;
        }
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        DVTFileUtils.this.manageLinkedResourceCreationInternal(delta, (IProject)resource, autoLinkedRoot);
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void manageLinkedResourceCreationInternal(IResourceDelta delta, final IProject project, final String autoLinkedRoot) {
        try {
            final HashMap<IResource, IResource> resourcePathChanges = new HashMap<IResource, IResource>();
            delta.accept(new IResourceDeltaVisitor(){
                private Map<String, AutoLinkRoot> fRoots = null;
                private IPath fAutoLinkedRootPath = null;

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getKind() == 2) {
                        return false;
                    }
                    if (delta.getKind() != 1) {
                        return true;
                    }
                    IResource newResource = delta.getResource();
                    if (newResource.getFullPath().segmentCount() > 1 && newResource.getFullPath().segment(1).equals(autoLinkedRoot)) {
                        return false;
                    }
                    if (newResource.isVirtual() || newResource.getLocation() == null) {
                        return true;
                    }
                    IPath newResourceLocation = newResource.getLocation();
                    String newResourceTranslatedPath = DVTAutoLinkManager.getInstance().inverseTranslateAutoLinkedFileFullPath(newResourceLocation.toOSString());
                    if (newResource instanceof IFolder) {
                        AutoLinkRoot foundRoot;
                        IPath tailAutoLinkPath;
                        IFolder autolinkedFolder;
                        if (this.fAutoLinkedRootPath == null) {
                            this.fAutoLinkedRootPath = Path.fromOSString((String)autoLinkedRoot);
                        }
                        if ((autolinkedFolder = project.getFolder(this.fAutoLinkedRootPath.append(newResourceTranslatedPath))).exists()) {
                            return true;
                        }
                        if (this.fRoots == null) {
                            this.fRoots = BuildConfigManager.getAutoLinkedRoots(project);
                        }
                        if ((tailAutoLinkPath = DVTFileUtils.this.equalPathFromAutoLinkRoot(newResourceLocation, foundRoot = DVTFileUtils.this.autoLinkRootForFile(newResourceLocation, this.fRoots))) == null) {
                            return false;
                        }
                        autolinkedFolder = project.getFolder(this.fAutoLinkedRootPath.append(tailAutoLinkPath));
                        return autolinkedFolder.exists();
                    }
                    if (newResource instanceof IFile) {
                        IFile autolinkedFile;
                        if (this.fAutoLinkedRootPath == null) {
                            this.fAutoLinkedRootPath = Path.fromOSString((String)autoLinkedRoot);
                        }
                        if ((autolinkedFile = project.getFile(this.fAutoLinkedRootPath.append(newResourceTranslatedPath))).exists() && !autolinkedFile.equals((Object)newResource)) {
                            resourcePathChanges.put(autolinkedFile, newResource);
                        } else {
                            AutoLinkRoot foundRoot;
                            IPath tailAutoLinkPath;
                            if (this.fRoots == null) {
                                this.fRoots = BuildConfigManager.getAutoLinkedRoots(project);
                            }
                            if ((tailAutoLinkPath = DVTFileUtils.this.equalPathFromAutoLinkRoot(newResourceLocation, foundRoot = DVTFileUtils.this.autoLinkRootForFile(newResourceLocation, this.fRoots))) == null) {
                                return false;
                            }
                            autolinkedFile = project.getFile(this.fAutoLinkedRootPath.append(tailAutoLinkPath));
                            if (autolinkedFile.exists() && !autolinkedFile.equals((Object)newResource)) {
                                resourcePathChanges.put(autolinkedFile, newResource);
                            }
                        }
                        return false;
                    }
                    return true;
                }
            });
            LazyPersistentPropertiesManager.INSTANCE.updateProjectResourcePathMapping(project, resourcePathChanges);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public AutoLinkRoot autoLinkRootForFile(IPath filePath, Map<String, AutoLinkRoot> currAutoLinkedRoots) {
        if (filePath == null || currAutoLinkedRoots == null) {
            return null;
        }
        AutoLinkRoot maxPath = null;
        int maxMatchingPath = 0;
        for (AutoLinkRoot root : currAutoLinkedRoots.values()) {
            int currentMatchingPath;
            IPath rootPath = root.getExpandedPath();
            if (rootPath == null || (currentMatchingPath = rootPath.matchingFirstSegments(filePath)) == 0 || currentMatchingPath < rootPath.segmentCount() || currentMatchingPath <= maxMatchingPath) continue;
            maxMatchingPath = currentMatchingPath;
            maxPath = root;
        }
        return maxPath;
    }

    public IPath equalPathFromAutoLinkRoot(IPath resourcePath, AutoLinkRoot foundRoot) {
        if (resourcePath == null || foundRoot == null) {
            return null;
        }
        IPath rootPath = foundRoot.getExpandedPath();
        if (resourcePath.segmentCount() < rootPath.segmentCount()) {
            return null;
        }
        resourcePath = resourcePath.removeFirstSegments(rootPath.segmentCount());
        return Path.fromOSString((String)foundRoot.getAlias()).append(resourcePath);
    }

    public Map<IResource, IPath> resolveResourcesPaths(List<IResource> resources) {
        HashMap<IResource, IPath> resolvedPaths = new HashMap<IResource, IPath>();
        if (resources == null) {
            return resolvedPaths;
        }
        for (IResource resource : resources) {
            if (resource == null) continue;
            IPath location = resource.getFullPath();
            IProject project = resource.getProject();
            if (location == null || project == null) continue;
            if (resource.isVirtual()) {
                if (location.lastSegment().equals("DVT Auto-Linked") || !location.toOSString().contains("DVT Auto-Linked")) {
                    resolvedPaths.put(resource, null);
                    continue;
                }
                location = DVTFileUtils.getInstance().resolveAutoLinkPath(resource);
            } else {
                location = resource.getLocation();
            }
            if (location == null) continue;
            location = this.makeUNCPath(location);
            resolvedPaths.put(resource, location);
        }
        return resolvedPaths;
    }

    public IPath makeUNCPath(IPath path) {
        if (path == null) {
            return path;
        }
        if (DVTAutoLinkManager.getInstance().isWindows() && path.getDevice() == null) {
            return path.makeUNC(true);
        }
        return path;
    }

    public boolean isAutoLinkedResource(IProject project, IPath path) {
        IFile file;
        if (project == null || path == null) {
            return false;
        }
        IFolder directory = project.getFolder("DVT Auto-Linked");
        if (directory == null || !directory.exists()) {
            return false;
        }
        Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        AutoLinkRoot autoLinkRootForFile = DVTFileUtils.getInstance().autoLinkRootForFile(path, autoLinkedRoots);
        String relativePath = path.toOSString();
        if (autoLinkRootForFile != null) {
            relativePath = DVTStringUtil.replace(relativePath, autoLinkRootForFile.getExpandedPath().toOSString(), autoLinkRootForFile.getAlias(), true);
        }
        if ((file = directory.getFile(relativePath)) == null) {
            return false;
        }
        return file.exists();
    }

    @Override
    public IEditorPart getActiveEditor() {
        IWorkbenchPage activePage;
        block7: {
            IWorkbenchWindow activeWindow;
            block6: {
                IWorkbench workbench;
                block5: {
                    try {
                        workbench = DVTPlugin.getDefault().getWorkbench();
                        if (workbench != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                activeWindow = workbench.getActiveWorkbenchWindow();
                if (activeWindow != null) break block6;
                return null;
            }
            activePage = activeWindow.getActivePage();
            if (activePage != null) break block7;
            return null;
        }
        return activePage.getActiveEditor();
    }

    public ISelectionValidator makeContainerSelectionValidator() {
        if (this.fcontainerSelValidator == null) {
            this.fcontainerSelValidator = new ProjectSelectionValidator();
        }
        return this.fcontainerSelValidator;
    }

    public static String getTextFromEditor(IFile targetFile) {
        if (targetFile == null) {
            return null;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorReference[] references = activePage.getEditorReferences();
        if (references == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IEditorReference reference = iEditorReferenceArray[n2];
            IEditorPart editor = reference.getEditor(false);
            if (editor instanceof DVTEditor && (file = (IFile)editor.getAdapter(IResource.class)) != null && file.equals((Object)targetFile)) {
                return ((DVTEditor)editor).getTextViewer().getDocument().get();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String computeOneIndent(IPreferenceStore prefStore, DVTEditor textEditor) {
        if (textEditor == null) {
            return "";
        }
        IPreferenceStore combinedPrefStore = DVTPlugin.getDefault().getCombinedPreferenceStore();
        if (TextUtils.getEditorSpacesForTabs(combinedPrefStore)) {
            return DVTDocumentUtils.getTabOrSpace(textEditor, combinedPrefStore);
        }
        if (prefStore == null) {
            return "";
        }
        return DVTDocumentUtils.getTabOrSpace(textEditor, prefStore);
    }

    public static void createHistoryEntryFromString(IFile iFile, String string) {
        try {
            if (iFile == null) {
                return;
            }
            File file = (File)iFile;
            FileSystemResourceManager localManager = file.getLocalManager();
            if (localManager == null) {
                return;
            }
            IPath key = iFile.getFullPath();
            if (key == null) {
                return;
            }
            IFileStore fileStore = localManager.getStore((IResource)file);
            if (fileStore == null) {
                return;
            }
            IFileInfo fileInfo = fileStore.fetchInfo();
            if (fileInfo == null) {
                return;
            }
            IHistoryStore historyStore = localManager.getHistoryStore();
            Field blobStoreField = HistoryStore2.class.getDeclaredField("blobStore");
            blobStoreField.setAccessible(true);
            BlobStore blobStore = (BlobStore)blobStoreField.get(historyStore);
            UniversalUniqueIdentifier uuid = new UniversalUniqueIdentifier();
            blobStore.folderFor(uuid).mkdir(0, null);
            IFileStore destination = blobStore.fileFor(uuid);
            Throwable throwable = null;
            Object var13_15 = null;
            try (OutputStream os = destination.openOutputStream(0, (IProgressMonitor)new NullProgressMonitor());){
                os.write(string.getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Field treeField = HistoryStore2.class.getDeclaredField("tree");
            treeField.setAccessible(true);
            BucketTree tree = (BucketTree)treeField.get(historyStore);
            tree.loadBucketFor(key);
            long lastModified = fileInfo.getLastModified();
            HistoryBucket currentBucket = (HistoryBucket)tree.getCurrent();
            currentBucket.addBlob(key, uuid, lastModified - 1L);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    public Map<Position, Annotation> testGetAllFoldingAnnotations(ProjectionAnnotationModel model) {
        HashMap<Position, Annotation> annotations = new HashMap<Position, Annotation>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            Object annotation = e.next();
            if (!(annotation instanceof ProjectionAnnotation) || !((position = model.getPosition((Annotation)((ProjectionAnnotation)annotation))) instanceof DVTSemanticFoldingPosition) && !(position instanceof DVTFoldingPosition)) continue;
            annotations.put(position, (Annotation)annotation);
        }
        return annotations;
    }

    public String getPrefix(IFile file, int length) {
        try {
            byte[] buf = new byte[length];
            InputStream is = file.getContents();
            int len = is.read(buf);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(buf, 0, len);
            is.close();
            return new String(bos.toByteArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IFile getFileFromViewer(ITextViewer viewer) {
        if (!(viewer instanceof DVTProjectionViewer)) {
            return null;
        }
        DVTEditor editor = ((DVTProjectionViewer)viewer).getEditor();
        if (editor == null) {
            return null;
        }
        Object adapter = editor.getAdapter(IResource.class);
        if (!(adapter instanceof IResource)) {
            return null;
        }
        return (IFile)adapter;
    }

    public static boolean isLargeFile(URI fileURI) {
        IEclipsePreferences preferencesStore = DVTPlugin.getDefault().getPreferences();
        if (preferencesStore == null) {
            return false;
        }
        float maximumSizeFromPreferenceStore = preferencesStore.getFloat("editor.maxiumSizeOfFile", 25.0f);
        float fileSize = DVTFileUtils.computeFileSizeMB(fileURI);
        return fileSize > maximumSizeFromPreferenceStore;
    }

    public static float computeFileSizeMB(URI uri) {
        IFileInfo fileInfo;
        block7: {
            IFileStore fileStore;
            block6: {
                block5: {
                    try {
                        if (uri != null) break block5;
                        return 0.0f;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return 0.0f;
                    }
                }
                fileStore = EFS.getStore((URI)uri);
                if (fileStore != null) break block6;
                return 0.0f;
            }
            fileInfo = fileStore.fetchInfo();
            if (fileInfo != null) break block7;
            return 0.0f;
        }
        return (float)fileInfo.getLength() / 1024.0f / 1024.0f;
    }

    @Override
    public String getFilePath(DVTEditor editor) {
        if (editor == null) {
            return null;
        }
        IResource resource = (IResource)editor.getAdapter(IResource.class);
        if (resource == null) {
            return null;
        }
        return resource.getLocation().toOSString();
    }

    public void doSelection(IRegion region, IEditorPart activeEditor) {
        if (activeEditor instanceof DVTEditor) {
            ((DVTEditor)activeEditor).testGetSourceViewer().setSelectedRange(region.getOffset(), region.getLength());
        }
    }

    public IFile findFileInProjectOrIncdirs(String filePath, IProject project) {
        if (filePath == null || project == null) {
            return null;
        }
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        for (Invocation invocation : invocations) {
            List<String> incdirs = BuildConfigManager.getIncdirs(project, invocation);
            for (String incdir : incdirs) {
                String fullPath = String.valueOf(incdir) + filePath;
                IFile resource = this.findProjectFileUsingAbsolutePath(project, fullPath);
                if (!(resource instanceof IFile)) continue;
                return resource;
            }
        }
        return null;
    }

    public IPath getProjectRelativePathWithProjectPath(String path, IProject project) {
        if (path == null || project == null) {
            return null;
        }
        LazyPersistentPropertiesManager.IPropertyValue resourceRelativePath = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)project, new LazyPersistentPropertiesManager.ParserPathProperty(path));
        if (resourceRelativePath == null) {
            return null;
        }
        String resourcePath = resourceRelativePath.value();
        if (resourcePath == null) {
            return null;
        }
        return project.getFullPath().append(resourcePath);
    }

    public IPath getProjectRelativePathWithProjectPath(IFile file) {
        if (file == null || file.getProject() == null) {
            return null;
        }
        IProject project = file.getProject();
        IPath projectRelativePath = file.getProjectRelativePath();
        if (projectRelativePath == null) {
            return null;
        }
        String resourcePath = projectRelativePath.toOSString();
        if (resourcePath == null) {
            return null;
        }
        return project.getFullPath().append(resourcePath);
    }

    @Override
    public TextFileBufferInfo getTextFileBufferInfo(IFile file) {
        IPath path = file.getFullPath();
        LocationKind locationKind = LocationKind.NORMALIZE;
        IPath resourceRelativePathPrependedWithProjectPath = this.getProjectRelativePathWithProjectPath(file);
        if (resourceRelativePathPrependedWithProjectPath != null) {
            path = resourceRelativePathPrependedWithProjectPath;
            locationKind = LocationKind.IFILE;
        }
        return new TextFileBufferInfo(path, locationKind);
    }

    @Override
    public TextFileBufferInfo getTextFileBufferInfo(ParserPath parserPath, IProject project) {
        IPath path = Path.fromOSString((String)parserPath.path);
        LocationKind locationKind = LocationKind.NORMALIZE;
        IPath resourceRelativePath = DVTFileUtils.getInstance().getProjectRelativePathWithProjectPath(parserPath.path, project);
        if (resourceRelativePath != null) {
            locationKind = LocationKind.IFILE;
            path = resourceRelativePath;
        }
        return new TextFileBufferInfo(path, locationKind);
    }

    public void openZipFile(java.io.File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile zip = new ZipFile(file);){
                java.io.File extractTemporaryFileFromZip = this.extractTemporaryFileFromZip(zip);
                IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActiveWorkbenchWindow().getActivePage(), (URI)extractTemporaryFileFromZip.toURI(), (String)DEFAULT_TEXT_EDITOR_ID, (boolean)true);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ZipException zipException) {
            this.openFile(file);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void openFile(java.io.File file) {
        try {
            IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActiveWorkbenchWindow().getActivePage(), (URI)file.toURI(), (String)DEFAULT_TEXT_EDITOR_ID, (boolean)true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected java.io.File createTmpDir() {
        return Files.createTempDir();
    }

    public IFile getEditorFile(IEditorPart editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        if (!(input instanceof FileEditorInput)) {
            return null;
        }
        return ((FileEditorInput)input).getFile();
    }

    public IProject getSelectedProject() {
        IProject[] project = new IProject[]{DVTPlugin.getSelectionManager().getLastSelectedProject()};
        if (project[0] == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                iProjectArray[0] = ProjectSelectionDialog.selectProject();
            });
        }
        return project[0];
    }

    @Override
    public void performTextChangeAndSave(IDocument document, String displayString, DVTTextFileChange change, String file) {
        try {
            DVTTextChangePerformer.getInstance().performTextChange(null, document, displayString, (Change)change);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean isProjectChanged(IResourceDelta delta, IResource resource) {
        boolean isProject;
        if (!(resource instanceof IProject)) {
            return false;
        }
        boolean bl = isProject = (resource.getType() & 4) != 0;
        if (!isProject) {
            return false;
        }
        int flags = delta.getFlags();
        int kind = delta.getKind();
        return (flags & 0x4000) != 0 && kind == 4;
    }

    public boolean isProjectAdded(IResourceDelta delta, IResource resource) {
        boolean isProject;
        if (!(resource instanceof IProject)) {
            return false;
        }
        boolean bl = isProject = (resource.getType() & 4) != 0;
        if (!isProject) {
            return false;
        }
        int flags = delta.getFlags();
        int kind = delta.getKind();
        return (flags & 0x4000) != 0 && kind == 1;
    }

    public boolean isProjectRemoved(IResourceDelta delta, IResource resource) {
        boolean isProject;
        if (!(resource instanceof IProject)) {
            return false;
        }
        boolean bl = isProject = (resource.getType() & 4) != 0;
        if (!isProject) {
            return false;
        }
        int flags = delta.getFlags();
        int kind = delta.getKind();
        return flags == 0 && kind == 2;
    }

    private static class ProjectSelectionValidator
    implements ISelectionValidator {
        private ProjectSelectionValidator() {
        }

        public String isValid(Object selection) {
            if (!(selection instanceof Path)) {
                return null;
            }
            Path path = (Path)selection;
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (resource == null) {
                return "Could not find the selected resource.";
            }
            IProject project = resource.getProject();
            if (!project.isOpen()) {
                return "A closed project is not valid.";
            }
            if (!Utils.hasDvtNature(project)) {
                return "A non DVT project folder and its folders are not valid.";
            }
            return null;
        }
    }
}

