/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTFileUtilsBatchBase {
    private List<File> fTempFiles = new ArrayList<File>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readFileContent(File file) {
        String result = "";
        try {
            if (file == null) {
                return result;
            }
            if (!file.exists()) {
                return result;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream is = file.toURI().toURL().openStream();
                try {
                    try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                        byte[] buf = new byte[1024];
                        int len = is.read(buf);
                        while (len > 0) {
                            bos.write(buf, 0, len);
                            len = is.read(buf);
                        }
                        result = new String(bos.toByteArray());
                    }
                    if (is == null) return result;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return result;
    }

    public void cleanup() {
        for (File file : this.fTempFiles) {
            file.delete();
        }
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        this.fTempFiles.add(tempFile);
        return tempFile;
    }

    public String md5Files(Stream<Path> stream) {
        String md5 = "000";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            stream.sorted().forEach(path -> {
                try {
                    md.update(Files.readAllBytes(path));
                }
                catch (Exception exception) {}
            });
            md5 = DVTStringUtil.bytes2hex(md.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        return md5;
    }

    public void removeRecursive(Path path) throws IOException {
        this.removeRecursive(path, true);
    }

    public void removeRecursive(final Path path, final boolean deleteRoot) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e == null && (deleteRoot || dir != path)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String computeIndent(IDocument document, int offset) {
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            String lineString = document.get(lineInfo.getOffset(), lineInfo.getLength());
            StringBuilder indent = new StringBuilder();
            int i = 0;
            while (i < lineString.length()) {
                char ch = lineString.charAt(i);
                if (!Character.isWhitespace(ch)) break;
                indent.append(ch);
                ++i;
            }
            return indent.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldIncrementalBuild(IDocument document, FileCompileInfo fileInfo, IProject project) {
        try {
            if (project == null || document == null && (fileInfo == null || fileInfo.getFile() == null)) {
                if (fileInfo == null) return true;
                fileInfo.setIncrCompiled(true);
                return true;
            }
            int disableIncrBuildNumberOfLines = BuildConfigManager.getDisableIncrementalBuildNumberOfLines(project);
            if (disableIncrBuildNumberOfLines <= 0) {
                if (fileInfo == null) return true;
                fileInfo.setIncrCompiled(true);
                return true;
            }
            int nofLines = -1;
            try (BufferedReader lineNofReader = null;){
                if (document != null) {
                    nofLines = document.getNumberOfLines();
                    if (nofLines <= disableIncrBuildNumberOfLines) return true;
                    if (fileInfo == null) return false;
                    fileInfo.setIncrCompiled(false);
                    return false;
                }
                if (fileInfo == null) return true;
                if (fileInfo.getFile() == null) return true;
                IPath location = fileInfo.getFile().getLocation();
                if (location == null) {
                    fileInfo.setIncrCompiled(true);
                    return true;
                }
                File file = location.toFile();
                if (file == null) {
                    fileInfo.setIncrCompiled(true);
                    return true;
                }
                lineNofReader = new BufferedReader(new FileReader(file));
                int i = 0;
                if (i <= disableIncrBuildNumberOfLines) {
                }
                fileInfo.setIncrCompiled(false);
                return false;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public int[] getIdentifierOffsetInLine(int line, String selectIdentifier, IDocument document, int startingOffsetOnLine) throws BadPartitioningException {
        try {
            int endLineOffset;
            IRegion info;
            if (document == null) {
                return new int[0];
            }
            int offset = startingOffsetOnLine < 0 ? info.getOffset() : startingOffsetOnLine;
            String lineText = document.get(offset, (endLineOffset = (info = document.getLineInformation(line < 1 ? 0 : line - 1)).getOffset() + info.getLength()) - offset);
            if (lineText == null || selectIdentifier == null || selectIdentifier.length() == 0) {
                int[] nArray = new int[2];
                nArray[0] = offset;
                return nArray;
            }
            String partitioning = this.getPartitioning((IDocumentExtension3)document);
            if (partitioning == null) {
                int[] nArray = new int[2];
                nArray[0] = offset;
                return nArray;
            }
            int index = 0;
            while ((index = lineText.indexOf(selectIdentifier, index)) > -1) {
                boolean afterCh;
                boolean beforeCh;
                String currentContentType = ((IDocumentExtension3)document).getContentType(partitioning, index + offset, false);
                if (currentContentType == null) {
                    int[] nArray = new int[2];
                    nArray[0] = offset;
                    return nArray;
                }
                if (!currentContentType.equals("__dftl_partition_content_type") && !currentContentType.equals("__vlog_escaped_id")) {
                    index += selectIdentifier.length();
                    continue;
                }
                boolean bl = index > 0 ? !Character.isJavaIdentifierPart(lineText.charAt(index - 1)) : (beforeCh = true);
                boolean bl2 = index + selectIdentifier.length() <= lineText.length() - 1 ? !Character.isJavaIdentifierPart(lineText.charAt(index + selectIdentifier.length())) : (afterCh = true);
                if (beforeCh && afterCh) {
                    return new int[]{index + offset, selectIdentifier.length()};
                }
                index += selectIdentifier.length();
            }
            int[] nArray = new int[2];
            nArray[0] = offset;
            return nArray;
        }
        catch (BadLocationException badLocationException) {
            return new int[0];
        }
    }

    public final String getPartitioning(IDocumentExtension3 document) {
        if (document == null) {
            return null;
        }
        if (document.getDocumentPartitioner("__vlog_partitioning") != null) {
            return "__vlog_partitioning";
        }
        if (document.getDocumentPartitioner("__vhdl_partitioning") != null) {
            return "__vhdl_partitioning";
        }
        if (document.getDocumentPartitioner("__e_partitioning") != null) {
            return "__e_partitioning";
        }
        if (document.getDocumentPartitioner("__pss_partitioning") != null) {
            return "__pss_partitioning";
        }
        if (document.getDocumentPartitioner("__msdl_partitioning") != null) {
            return "__msdl_partitioning";
        }
        return null;
    }

    public int getCharOffset(char ch, int startOffset, boolean forward, int bufferSize, IDocument document) throws BadLocationException, BadPartitioningException {
        int nextChar;
        DVTCharacterScanner scanner = new DVTCharacterScanner(bufferSize, document, startOffset, forward);
        while ((nextChar = scanner.read()) != -1) {
            String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset() - 1, false);
            if (!"__dftl_partition_content_type".equals(contentType) || Character.isWhitespace(nextChar) || nextChar != ch) continue;
            scanner.unread();
            return scanner.getOffset();
        }
        return -1;
    }

    public Map<DVTSemanticFoldingPosition, Annotation> getAnnotationsByPositions(ProjectionAnnotationModel model) {
        HashMap<DVTSemanticFoldingPosition, Annotation> annotations = new HashMap<DVTSemanticFoldingPosition, Annotation>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position position;
            Object annotation = e.next();
            if (!(annotation instanceof ProjectionAnnotation) || !((position = model.getPosition((Annotation)((ProjectionAnnotation)annotation))) instanceof DVTSemanticFoldingPosition)) continue;
            annotations.put((DVTSemanticFoldingPosition)position, (Annotation)annotation);
        }
        return annotations;
    }

    public abstract String getLastDirectory();

    public abstract void setLastDirectory(String var1);

    public abstract void openEditor(IFile var1, int var2, String var3);

    public abstract void openEditor(IFile var1, int var2, String var3, boolean var4, String var5);

    public abstract void openEditor(File var1, int var2, String var3, String var4, boolean var5);

    public abstract void openEditor(File var1, int var2);

    public abstract void openEditor(IFile var1, IRegion var2);
}

