/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTFileUtilsBatchBase;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IWithDocument;
import ro.amiq.dvt.utils.TextFileBufferInfo;

public abstract class DVTFileUtilsCommon
extends DVTFileUtilsBatchBase {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 0x100000;
    public static final String STAR_CHARACTER = "*";
    private static final String QUESTION_MARK_CHARACTER = "?";
    public static final String STAR_CHARACTER_REPLACEMENT = "STAR_CHARACTER_REPLACEMENT";
    public static final String QUESTION_MARK_CHARACTER_REPLACEMENT = "QUESTION_MARK_CHARACTER_REPLACEMENT";
    protected String fLastDirectory;

    public Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        if (changedFiles == null) {
            return null;
        }
        HashSet<ParserPath> result = new HashSet<ParserPath>(changedFiles.size());
        for (FileCompileInfo changedFile : changedFiles) {
            if (changedFile == null) continue;
            result.add(this.resource2parser((IResource)changedFile.getFile()));
        }
        return result;
    }

    public boolean writeStringToFile(File file, String string, boolean append) {
        block12: {
            Throwable throwable = null;
            Object var5_7 = null;
            BufferedWriter fw = new BufferedWriter(new FileWriter(file, append));
            try {
                fw.write(string);
                if (fw == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fw != null) {
                            ((Writer)fw).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            ((Writer)fw).close();
        }
        return true;
    }

    public java.nio.file.Path createDirectory(String rootDirPath, String createdDirName) {
        try {
            java.nio.file.Path createdDir = Paths.get(rootDirPath, createdDirName);
            Files.createDirectories(createdDir, new FileAttribute[0]);
            return createdDir;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public boolean validExtension(String[] extensionList, String name) {
        if (extensionList == null) {
            return false;
        }
        String[] stringArray = extensionList;
        int n = extensionList.length;
        int n2 = 0;
        while (n2 < n) {
            String extension = stringArray[n2];
            int index = name.length() - extension.length() - 1;
            if (index > 0 && name.charAt(index) == '.' && name.endsWith(extension)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String cropFirstLine(String comment, int maxLength) {
        int i = 0;
        while (i < comment.length()) {
            if (i >= maxLength) {
                return String.valueOf(comment.substring(0, maxLength - 1).trim()) + "...";
            }
            char ch = comment.charAt(i);
            if (ch == '\n') {
                return comment.substring(0, i);
            }
            ++i;
        }
        return comment;
    }

    /*
     * Unable to fully structure code
     */
    public String displayUpperCaseTaskTag(boolean caseSensitive, boolean hideTaskTag, String commentToDisplay, String taskTagCandidate) {
        block1: {
            startCapitalize = caseSensitive != false ? commentToDisplay.indexOf(taskTagCandidate) : commentToDisplay.toUpperCase().indexOf(taskTagCandidate);
            endCapitalize = startCapitalize + taskTagCandidate.length();
            result = new StringBuilder();
            if (hideTaskTag) ** GOTO lbl10
            result.append(commentToDisplay.substring(startCapitalize, endCapitalize).toUpperCase());
            break block1;
            while (Character.isWhitespace(ch = commentToDisplay.charAt(endCapitalize)) || ch == ':') {
                ++endCapitalize;
lbl10:
                // 2 sources

                if (endCapitalize < commentToDisplay.length()) continue;
            }
        }
        result.append(commentToDisplay.substring(endCapitalize));
        return result.toString();
    }

    public int getMatchingBracketOffset(int offset, DVTEditor editor, IDocument document) {
        ICharacterPairMatcher bracketMatcher = editor.getBracketMatcher();
        IRegion closedBracketRegion = bracketMatcher.match(document, offset);
        if (closedBracketRegion == null) {
            return -1;
        }
        return closedBracketRegion.getOffset() + closedBracketRegion.getLength();
    }

    public String computeFirstLineIndent(IDocument document, String indent, int offset) {
        if (document == null || indent == null) {
            return "";
        }
        String currLineIndent = DVTFileUtilsBatchBase.computeIndent(document, offset);
        if (currLineIndent == null) {
            return "";
        }
        if (currLineIndent.length() > indent.length()) {
            return "";
        }
        return indent.substring(currLineIndent.length());
    }

    public int getLineFromOffset(IFile file, int offset) {
        try {
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            IPath path = this.getIPath(file);
            LocationKind locationKind = this.getLocationKind(file);
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            int line = document.getLineOfOffset(offset);
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
            return line + 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    protected final boolean containsDotDot(String pathString) {
        return pathString.startsWith(".." + File.separator) || pathString.endsWith(String.valueOf(File.separator) + "..") || pathString.contains(String.valueOf(File.separator) + ".." + File.separator);
    }

    public final IPath pathOf(File file) {
        String pathString = file.getPath();
        IPath defaultPath = Path.fromOSString((String)pathString);
        try {
            if (this.containsDotDot(pathString) && !defaultPath.toFile().exists()) {
                return Path.fromOSString((String)file.getCanonicalPath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return defaultPath;
    }

    public final IPath pathOf(String pathString) {
        IPath defaultPath = Path.fromOSString((String)pathString);
        try {
            if (this.containsDotDot(pathString) && !defaultPath.toFile().exists()) {
                return Path.fromOSString((String)new File(pathString).getCanonicalPath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return defaultPath;
    }

    public String getLineFromFile(IFile file, int line) {
        if (file == null || !file.exists() || !file.isAccessible()) {
            return "";
        }
        int offset = 0;
        String lineText = "";
        try {
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            IPath path = this.getIPath(file);
            LocationKind locationKind = this.getLocationKind(file);
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
            offset = info.getOffset();
            lineText = document.get(offset, info.getLength());
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
            return lineText;
        }
        catch (Exception exception) {
            return lineText;
        }
    }

    public int getLineOffset(IFile file, int line) {
        try {
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
            IPath path = textFileBufferInfo.getPath();
            LocationKind locationKind = textFileBufferInfo.getLocationKind();
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            int offset = document.getLineOffset(line);
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
            return offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public boolean isInCommentSection(IDocument document, int offset) {
        DVTCharacterScanner scanner = new DVTCharacterScanner(2, document, offset, true);
        try {
            String content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
            if (!"__dftl_partition_content_type".equals(content)) {
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public int getLineCodeStartOffset(IFile resource, IDocument document, int lineNumber) {
        block4: {
            if (document != null) break block4;
            return -1;
        }
        try {
            int ch;
            String content;
            int offset = this.getLineOffset(resource, lineNumber);
            int maxLineNo = document.getNumberOfLines();
            int maxOffset = (maxLineNo == lineNumber + 1 ? document.getLength() : this.getLineOffset(resource, lineNumber + 1)) - 1;
            DVTCharacterScanner scanner = new DVTCharacterScanner(100, document, offset, true);
            do {
                content = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", scanner.getOffset(), false);
                ch = scanner.read();
            } while (scanner.getOffset() <= maxOffset && (!"__dftl_partition_content_type".equals(content) || "__dftl_partition_content_type".equals(content) && Character.isWhitespace((char)ch)));
            scanner.unread();
            return scanner.getOffset() < maxOffset ? scanner.getOffset() : -1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public void selectAndReveal(int line, String selectIdentifier, IEditorPart editorPart) throws BadLocationException {
        Matcher matcher;
        if (!(editorPart instanceof DVTEditor)) {
            return;
        }
        DVTEditor dvtEditor = (DVTEditor)editorPart;
        IDocument document = dvtEditor.getDocument();
        IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
        int offset = info.getOffset();
        int length = info.getLength();
        String lineText = document.get(offset, length);
        if (selectIdentifier != null && (matcher = Pattern.compile("\\b(" + selectIdentifier + ")\\b").matcher(lineText)).find()) {
            offset += matcher.start(0);
            length = selectIdentifier.length();
        }
        dvtEditor.selectAndReveal(offset, length);
    }

    public File extractTemporaryFileFromZip(ZipFile zip) {
        Path path = new Path(zip.getName());
        File tmpFile = new File(this.createTmpDir(), path.lastSegment());
        Enumeration<? extends ZipEntry> zipEntries = zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedInputStream inputStream = new BufferedInputStream(zip.getInputStream(zipEntry));){
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public char[] toCharArray(String filePath) throws IOException {
        char[] charData = new char[0x400000];
        int charDataSize = 0;
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            char[] buf = new char[0x100000];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                if (charData.length <= charDataSize + numRead) {
                    char[] newCharData = new char[charData.length + Math.min(0x2000000, charData.length * 2)];
                    System.arraycopy(charData, 0, newCharData, 0, charDataSize);
                    charData = newCharData;
                }
                System.arraycopy(buf, 0, charData, charDataSize, numRead);
                charDataSize += numRead;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        char[] result = new char[charDataSize];
        System.arraycopy(charData, 0, result, 0, charDataSize);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFile(File srcFile, File dstFile) {
        block19: {
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try {
                    BufferedInputStream in = new BufferedInputStream(new FileInputStream(srcFile));
                    try {
                        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dstFile));){
                            int len;
                            byte[] buf = new byte[1024];
                            while ((len = ((InputStream)in).read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                        }
                        if (in == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (in == null) throw throwable;
                        ((InputStream)in).close();
                        throw throwable;
                    }
                    ((InputStream)in).close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        try {
            if (srcFile.canExecute()) {
                dstFile.setExecutable(true);
            }
            if (srcFile.canWrite()) return;
            dstFile.setReadOnly();
            return;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getFileName(String filePath) {
        int fileNameStartIndex = filePath.lastIndexOf(FILE_SEPARATOR) + 1;
        return filePath.substring(fileNameStartIndex);
    }

    public String getBaseFileName(String filePath) {
        int fileNameStartIndex = filePath.lastIndexOf(FILE_SEPARATOR) + 1;
        int extStartIndex = filePath.lastIndexOf(".");
        if (extStartIndex == -1) {
            return filePath.substring(fileNameStartIndex);
        }
        return filePath.substring(fileNameStartIndex, extStartIndex);
    }

    public String getFileMd5(String filePath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(filePath);){
                int read = 0;
                byte[] buf = new byte[8192];
                MessageDigest md = MessageDigest.getInstance("MD5");
                while ((read = fis.read(buf)) > 0) {
                    md.update(buf, 0, read);
                }
                byte[] hashValue = md.digest();
                return DVTStringUtil.bytes2hex(hashValue);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IFile getProjectFile(IProject project, String osString) {
        block4: {
            if (project != null) break block4;
            return null;
        }
        try {
            IFile candidate = null;
            candidate = Path.fromOSString((String)osString).isAbsolute() ? this.findProjectFileUsingAbsolutePath(project, osString) : this.findProjectFile(project, osString);
            if (candidate != null) {
                return candidate;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public boolean isBinary(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                byte[] buf = new byte[((InputStream)is).available() / 10 > 50000 ? 50000 : ((InputStream)is).available() / 10];
                ((InputStream)is).read(buf);
                String s = new String(buf);
                CharsetEncoder encoder = StandardCharsets.ISO_8859_1.newEncoder();
                boolean bl = !encoder.canEncode(s);
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return true;
        }
    }

    public boolean deleteFile(File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            Files.delete(file.toPath());
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public java.nio.file.Path relativize(java.nio.file.Path basePath, java.nio.file.Path otherPath) {
        try {
            return basePath.relativize(otherPath);
        }
        catch (Exception exception) {
            return otherPath;
        }
    }

    public String replaceSpecialCharactersInGlobPattern(String pattern) {
        return pattern.replace(STAR_CHARACTER, STAR_CHARACTER_REPLACEMENT).replace(QUESTION_MARK_CHARACTER, QUESTION_MARK_CHARACTER_REPLACEMENT);
    }

    public String undoSpecialCharactersInGlobPatternReplacement(String pattern) {
        return pattern.replace(STAR_CHARACTER_REPLACEMENT, STAR_CHARACTER).replace(QUESTION_MARK_CHARACTER_REPLACEMENT, QUESTION_MARK_CHARACTER);
    }

    public boolean pathStartsWithADriveLetter(String path) {
        if (path.length() < 2) {
            return false;
        }
        return Character.isLetter(path.charAt(0)) && path.charAt(1) == ':';
    }

    public void addComment(IProject project, String fileName, int line, String text, boolean isMultiLineComment, boolean isEndOfLine) {
        this.addComment(project, fileName, line, text, isMultiLineComment, isEndOfLine, false, null);
    }

    public void addComment(IProject project, String fileName, int line, String text, boolean isMultiLineComment, boolean isEndOfLine, boolean doSave, String displayString) {
        try {
            IFile file = this.findProjectFileUsingAbsolutePath(project, fileName);
            if (file == null) {
                return;
            }
            IFile[] fileArray = new IFile[]{file};
            try {
                DVTFileModificationValidator.validateEdit((IProgressMonitor)new NullProgressMonitor(), fileArray);
            }
            catch (CoreException coreException) {
                return;
            }
            TextFileBufferInfo textFileBufferInfo = DVTFileUtils.getInstance().getTextFileBufferInfo(file);
            IPath path = textFileBufferInfo.getPath();
            LocationKind locationKind = textFileBufferInfo.getLocationKind();
            IDocument document = this.getOpenDocument(file);
            boolean shouldDisconnect = false;
            ITextFileBufferManager bufferManager = null;
            ITextFileBuffer textFileBuffer = null;
            if (document == null) {
                bufferManager = FileBuffers.getTextFileBufferManager();
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                if (textFileBuffer == null) {
                    shouldDisconnect = true;
                    bufferManager.connect(path, locationKind, null);
                }
                textFileBuffer = bufferManager.getTextFileBuffer(path, locationKind);
                document = textFileBuffer.getDocument();
            }
            IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
            String textLine = document.get(info.getOffset(), info.getLength());
            int insOffset = 0;
            int textLineIndex = 0;
            insOffset = isEndOfLine ? this.findCommentOffset(textLine) : this.findDefineOffset(textLine);
            textLineIndex = insOffset - 1;
            if (insOffset < 0) {
                insOffset = 0;
            }
            if (textLineIndex < 0) {
                textLineIndex = 0;
            }
            String pragma = "";
            if (isMultiLineComment) {
                pragma = String.valueOf(pragma) + (textLine.isEmpty() || Character.isWhitespace(textLine.charAt(textLineIndex)) ? "/*" : " /*");
                pragma = String.valueOf(pragma) + (Character.isWhitespace(text.charAt(0)) ? text : " " + text);
                pragma = String.valueOf(pragma) + (Character.isWhitespace(pragma.charAt(pragma.length() - 1)) ? "*/ " : " */ ");
            } else {
                pragma = String.valueOf(pragma) + (textLine.isEmpty() || Character.isWhitespace(textLine.charAt(textLineIndex)) ? "//" : " //");
                pragma = String.valueOf(pragma) + (Character.isWhitespace(text.charAt(0)) ? text : " " + text);
                pragma = String.valueOf(pragma) + (Character.isWhitespace(pragma.charAt(pragma.length() - 1)) ? " " : "  ");
            }
            if (doSave) {
                DVTTextFileChange change = new DVTTextFileChange(displayString, file);
                change.setEdit((TextEdit)new MultiTextEdit());
                InsertEdit edit = new InsertEdit(info.getOffset() + insOffset, pragma);
                change.addEdit((TextEdit)edit, (IRegion)new Region(info.getOffset() + insOffset, 0));
                this.performTextChangeAndSave(document, displayString, change, fileName);
            } else {
                document.replace(info.getOffset() + insOffset, 0, pragma);
            }
            if (textFileBuffer != null) {
                textFileBuffer.commit(null, true);
            }
            if (bufferManager != null && shouldDisconnect) {
                bufferManager.disconnect(path, locationKind, null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int findDefineOffset(String line) {
        defineKeyWords = new HashSet<String>(Arrays.asList(new String[]{"define", "ifdef", "ifndef"}));
        ch = ' ';
        code = true;
        backslash = false;
        searchForKeyword = false;
        tempValueToReturn = 0;
        tempKeyWord = new StringBuilder();
        i = 0;
        while (i < line.length()) {
            ch = line.charAt(i);
            if (!code || !searchForKeyword) ** GOTO lbl-1000
            if (Character.isWhitespace(ch)) {
                if (!tempKeyWord.toString().isEmpty()) {
                    if (defineKeyWords.contains(tempKeyWord.toString())) {
                        return tempValueToReturn;
                    }
                    searchForKeyword = false;
                    tempKeyWord = new StringBuilder();
                }
            } else {
                tempKeyWord.append(ch);
                checkValidity = false;
                for (String word : defineKeyWords) {
                    if (!word.startsWith(tempKeyWord.toString())) continue;
                    checkValidity = true;
                }
                if (!checkValidity) {
                    searchForKeyword = false;
                    tempKeyWord = new StringBuilder();
                } else lbl-1000:
                // 2 sources

                {
                    if (code) {
                        if (ch == '`') {
                            searchForKeyword = true;
                            tempValueToReturn = i;
                        }
                        if (ch == '\"' && !backslash) {
                            code = false;
                        }
                    } else if (ch == '\"' && !backslash) {
                        code = true;
                    }
                    backslash = ch == '\\' ? backslash == false : false;
                }
            }
            ++i;
        }
        if (code && searchForKeyword && !tempKeyWord.toString().isEmpty() && defineKeyWords.contains(tempKeyWord.toString())) {
            return tempValueToReturn;
        }
        return line.length();
    }

    public int findCommentOffset(String textLine) {
        int pch = 32;
        int ch = 32;
        boolean code = true;
        boolean backslash = false;
        int i = 0;
        while (i < textLine.length()) {
            pch = ch;
            ch = textLine.charAt(i);
            if (code) {
                if (pch == 47 && (ch == 47 || ch == 42)) {
                    return i - 1;
                }
                if (ch == 34 && !backslash) {
                    code = false;
                }
            } else if (ch == 34 && !backslash) {
                code = true;
            }
            backslash = ch == 92 ? !backslash : false;
            ++i;
        }
        return textLine.length();
    }

    public boolean checkIfMacroExists(IProject project, IDocument document, String fileName, int line) {
        boolean returnedValue = false;
        try {
            IFile file = this.findProjectFileUsingAbsolutePath(project, fileName);
            if (file == null) {
                return returnedValue;
            }
            IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
            String textLine = document.get(info.getOffset(), info.getLength());
            int defineOffset = this.findDefineOffset(textLine);
            if (defineOffset != textLine.length()) {
                returnedValue = true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return returnedValue;
    }

    public <T> T withDocument(String fileFullPath, IWithDocument<T> withDocument) {
        if (fileFullPath == null) {
            return null;
        }
        IPath filePath = Path.fromOSString((String)fileFullPath);
        boolean disconnect = false;
        ITextFileBufferManager bufferManager = null;
        try {
            bufferManager = FileBuffers.getTextFileBufferManager();
            if (bufferManager == null) {
                return null;
            }
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(filePath, LocationKind.NORMALIZE);
            if (textFileBuffer == null) {
                bufferManager.connect(filePath, LocationKind.NORMALIZE, null);
                textFileBuffer = bufferManager.getTextFileBuffer(filePath, LocationKind.NORMALIZE);
                disconnect = true;
            }
            if (textFileBuffer == null) {
                return null;
            }
            IDocument document = textFileBuffer.getDocument();
            if (document == null) {
                return null;
            }
            T t = withDocument.doStuffWithDocument(document);
            return t;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        finally {
            if (disconnect && bufferManager != null) {
                try {
                    bufferManager.disconnect(filePath, LocationKind.NORMALIZE, null);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        return null;
    }

    public String getLinesFromFile(IFile file, int startLine, int endLine, DocumentManager manager) {
        boolean shouldDeactivate;
        if (file == null || !file.exists() || !file.isAccessible()) {
            return "";
        }
        if (startLine > endLine) {
            return "";
        }
        IFileInfo cachedFileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(file.getLocation());
        if (cachedFileInfo != null && cachedFileInfo.getLength() > (long)DVTInspectViewUtils.getInstance().getInspectMaxFileSize()) {
            return "";
        }
        int offset = 0;
        StringBuilder result = new StringBuilder();
        boolean bl = shouldDeactivate = manager == null;
        if (manager == null) {
            manager = new DocumentManager(true);
        }
        ParserPath parserPath = this.resource2parser((IResource)file);
        try {
            file.refreshLocal(2, null);
            IDocument document = manager.getDocument(parserPath, file.getProject());
            if (document == null) {
                return "";
            }
            try {
                int line = startLine;
                while (line <= endLine) {
                    IRegion info = document.getLineInformation(line < 1 ? 0 : line - 1);
                    offset = info.getOffset();
                    result.append(String.valueOf(document.get(offset, info.getLength())) + "\n");
                    ++line;
                }
            }
            catch (BadLocationException badLocationException) {}
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            String string = result.toString();
            return string;
        }
        finally {
            if (shouldDeactivate) {
                manager.deactivate();
            }
        }
    }

    protected abstract File createTmpDir();

    protected abstract IPath getIPath(IFile var1);

    protected abstract LocationKind getLocationKind(IFile var1);

    public abstract void openEditorWithOffset(File var1, int var2, int var3, boolean var4, String var5);

    public abstract IFile findProjectFileUsingAbsolutePath(IProject var1, String var2);

    public abstract IFile findProjectFile(IProject var1, String var2);

    public abstract String parser2resource(IProject var1, ParserPath var2);

    public abstract ParserPath resource2parser(IResource var1);

    public abstract String[] getExtensionsForContentType(String var1, boolean var2);

    public abstract boolean ensureFileInSyncWithUserAccept(IResource var1, IProgressMonitor var2) throws CoreException;

    public abstract Map<ParserPath, IDocument> evalNonFileBufferParserPathDocuments();

    public abstract IDocument getDocument(ITextEditor var1);

    public abstract String getFilePath(DVTEditor var1);

    public abstract IEditorPart getActiveEditor();

    public abstract String computeOneIndent(IPreferenceStore var1, DVTEditor var2);

    public abstract IDocument getOpenDocument(IFile var1);

    public abstract Map<IFile, IDocument> evalNonFileBufferDocuments(IFile var1);

    public abstract String readFileContent(IFile var1);

    public abstract TextFileBufferInfo getTextFileBufferInfo(IFile var1);

    public abstract TextFileBufferInfo getTextFileBufferInfo(ParserPath var1, IProject var2);

    public abstract void performTextChangeAndSave(IDocument var1, String var2, DVTTextFileChange var3, String var4);

    public java.nio.file.Path copyFolderContent(java.nio.file.Path parentDestinationFolder, java.nio.file.Path destPathRelativeToParent, java.nio.file.Path sourcePath) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<java.nio.file.Path> paths = Files.walk(sourcePath, new FileVisitOption[0]);){
                java.nio.file.Path destFolderPath = parentDestinationFolder.resolve(destPathRelativeToParent);
                File file = destFolderPath.toFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                paths.forEach(internalSourcePath -> {
                    try {
                        java.nio.file.Path destinationPath = destFolderPath.resolve(sourcePath.relativize((java.nio.file.Path)internalSourcePath));
                        Files.copy(internalSourcePath, destinationPath, new CopyOption[0]);
                    }
                    catch (IOException iOException) {}
                });
                return destFolderPath;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError(DVTStringUtil.appendString("Unable to create destination folder ", parentDestinationFolder.resolve(destPathRelativeToParent).toString(), System.lineSeparator()));
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IPath resolveAutoLinkPath(IResource resource) {
        String alias;
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resource);
        if (parserPath != null) {
            return Path.fromOSString((String)parserPath.path);
        }
        IPath path = this.stripAutoLinkDirectory(resource.getFullPath());
        path = Path.fromOSString((String)DVTAutoLinkManager.getInstance().translateAutoLinkedFileFullPath(path.toOSString()));
        if (path.toFile().exists()) {
            return path;
        }
        Map<String, AutoLinkRoot> roots = BuildConfigManager.getAutoLinkedRoots(resource.getProject());
        AutoLinkRoot root = roots.get(alias = path.segment(0));
        if (root == null || root.getExpandedPath() == null) {
            return path;
        }
        IPath p = root.getExpandedPath();
        return p.append(path.removeFirstSegments(1));
    }

    private IPath stripAutoLinkDirectory(IPath path) {
        if (!path.toOSString().contains("DVT Auto-Linked")) {
            return path;
        }
        if (path.segment(0).equals("DVT Auto-Linked")) {
            if (path.getDevice() == null) {
                return Path.fromOSString((String)(String.valueOf(File.separator) + path.removeFirstSegments(1).toOSString()));
            }
            return Path.fromOSString((String)(String.valueOf(path.getDevice()) + File.separator + path.removeFirstSegments(1).toOSString()));
        }
        if (path.getDevice() == null) {
            return this.stripAutoLinkDirectory(Path.fromOSString((String)(String.valueOf(File.separator) + path.removeFirstSegments(1).toOSString())));
        }
        return this.stripAutoLinkDirectory(Path.fromOSString((String)(String.valueOf(path.getDevice()) + File.separator + path.removeFirstSegments(1).toOSString())));
    }

    public abstract <T> T withDocument(IFile var1, IWithDocument<T> var2);
}

