/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import ro.amiq.dvt.optimized.collections.ExtendedSet;

public class DVTHashSet<K>
implements ExtendedSet<K>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 53637291017L;
    private transient Entry<?>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<Map.Entry<K, K>> entrySet;
    private static final int KEYS = 0;
    private static final int ENTRIES = 1;

    public DVTHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)Math.min((float)initialCapacity * loadFactor, 2.1474836E9f);
    }

    public DVTHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DVTHashSet() {
        this(11, 0.75f);
    }

    @Override
    public final int size() {
        return this.count;
    }

    @Override
    public final boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean contains(Object key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int hash(Object key) {
        return key.hashCode();
    }

    @Override
    public final K get(Object key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.key;
            }
            e = e.next;
        }
        return null;
    }

    protected final void rehash() {
        int newCapacity;
        int oldCapacity = this.table.length;
        Entry<?>[] oldMap = this.table;
        int n = newCapacity = oldCapacity < 64 ? oldCapacity * 3 / 2 : (oldCapacity << 1) + 1;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldCapacity == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 2.1474836E9f);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<Object> old = oldMap[i];
            while (old != null) {
                Entry<?> e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    private final void addEntry(int hash, K key, int index) {
        ++this.modCount;
        Entry<?>[] tab = this.table;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            hash = this.hash(key);
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        Entry<?> e = tab[index];
        tab[index] = new Entry<K>(hash, key, e);
        ++this.count;
    }

    @Override
    public final boolean add(K key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> entry = tab[index];
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                return false;
            }
            entry = entry.next;
        }
        this.addEntry(hash, key, index);
        return true;
    }

    public final K addIfAbsent(K key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> entry = tab[index];
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                return entry.key;
            }
            entry = entry.next;
        }
        this.addEntry(hash, key, index);
        return key;
    }

    public final void addNoExistCheck(K key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        this.addEntry(hash, key, index);
    }

    @Override
    public final boolean remove(Object key) {
        Entry<?>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> e = tab[index];
        Entry<?> prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends K> t) {
        for (K e : t) {
            this.add(e);
        }
        return true;
    }

    @Override
    public final void clear() {
        Entry<?>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public final Object clone() {
        try {
            DVTHashSet t = (DVTHashSet)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                Entry<?> entry = t.table[i] = this.table[i] != null ? (Entry<?>)this.table[i].clone() : null;
            }
            t.entrySet = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<K, K>> it = this.entrySet().iterator();
        sb.append('{');
        int i = 0;
        while (true) {
            Map.Entry<K, K> e;
            K key;
            sb.append((key = (e = it.next()).getKey()) == this ? "(this Set)" : key.toString());
            if (i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    private final <T> Iterator<T> getIterator(int type) {
        if (this.count == 0) {
            return Collections.emptyIterator();
        }
        return new Enumerator(type, true);
    }

    private final Set<Map.Entry<K, K>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DVTHashSet)) {
            return false;
        }
        DVTHashSet t = (DVTHashSet)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            K key;
            Iterator<Map.Entry<K, K>> i = this.entrySet().iterator();
            do {
                if (!i.hasNext()) {
                    return true;
                }
                Map.Entry<K, K> e = i.next();
                key = e.getKey();
                if (t.get(key) != null) return false;
            } while (t.contains(key));
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public final int hashCode() {
        Entry<?>[] tab;
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        Entry<?>[] entryArray = tab = this.table;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<Object> entry = entryArray[n2];
            while (entry != null) {
                h += entry.hashCode();
                entry = entry.next;
            }
            ++n2;
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    @Override
    public final void forEach(Consumer<? super K> action) {
        Entry<?>[] tab;
        Objects.requireNonNull(action);
        int expectedModCount = this.modCount;
        Entry<?>[] entryArray = tab = this.table;
        int n = tab.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<Object> entry = entryArray[n2];
            while (entry != null) {
                action.accept(entry.key);
                entry = entry.next;
                if (expectedModCount == this.modCount) continue;
                throw new ConcurrentModificationException();
            }
            ++n2;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Entry entryStack = null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        int index = 0;
        while (index < this.table.length) {
            Entry<Object> entry = this.table[index];
            while (entry != null) {
                entryStack = new Entry(0, entry.key, entryStack);
                entry = entry.next;
            }
            ++index;
        }
        while (entryStack != null) {
            s.writeObject(entryStack.key);
            entryStack = entryStack.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new StreamCorruptedException("Illegal Load: " + this.loadFactor);
        }
        int origlength = s.readInt();
        int elements = s.readInt();
        if (elements < 0) {
            throw new StreamCorruptedException("Illegal # of Elements: " + elements);
        }
        origlength = Math.max(origlength, (int)((float)elements / this.loadFactor) + 1);
        int length = (int)(((double)elements + (double)elements / 20.0) / (double)this.loadFactor) + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        length = Math.min(length, origlength);
        this.table = new Entry[length];
        this.threshold = (int)Math.min((float)length * this.loadFactor, 2.1474836E9f);
        this.count = 0;
        while (elements > 0) {
            Object key = s.readObject();
            this.reconstitutionPut(this.table, key);
            --elements;
        }
    }

    private final void reconstitutionPut(Entry<?>[] tab, K key) throws StreamCorruptedException {
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<Object> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                throw new StreamCorruptedException();
            }
            e = e.next;
        }
        e = tab[index];
        tab[index] = new Entry<K>(hash, key, e);
        ++this.count;
    }

    @Override
    public final Iterator<K> iterator() {
        return this.getIterator(0);
    }

    @Override
    public final Object[] toArray() {
        Object[] a = new Object[this.size()];
        int index = 0;
        Iterator<K> iter = this.iterator();
        while (iter.hasNext()) {
            a[index] = iter.next();
            ++index;
        }
        return a;
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        int index = 0;
        Iterator<K> iter = this.iterator();
        while (iter.hasNext()) {
            a[index] = iter.next();
            ++index;
        }
        return a;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not supported");
    }

    private static final class Entry<K>
    implements Map.Entry<K, K> {
        final int hash;
        final K key;
        Entry<K> next;

        protected Entry(int hash, K key, Entry<K> next) {
            this.hash = hash;
            this.key = key;
            this.next = next;
        }

        protected final Object clone() {
            return new Entry<K>(this.hash, this.key, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final K getValue() {
            return this.key;
        }

        @Override
        public final K setValue(K value) {
            return null;
        }

        @Override
        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == null ? e.getKey() == null : this.key.equals(e.getKey());
        }

        @Override
        public final int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.key.toString();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, K>> {
        private EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, K>> iterator() {
            return DVTHashSet.this.getIterator(1);
        }

        @Override
        public final boolean add(Map.Entry<K, K> o) {
            return super.add(o);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?>[] tab = DVTHashSet.this.table;
            int hash = DVTHashSet.this.hash(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object> e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public final boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry<?>[] tab = DVTHashSet.this.table;
            int hash = DVTHashSet.this.hash(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object> e = tab[index];
            Entry<?> prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    ++DVTHashSet.this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --DVTHashSet.this.count;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public final int size() {
            return DVTHashSet.this.count;
        }

        @Override
        public final void clear() {
            DVTHashSet.this.clear();
        }
    }

    private final class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        final Entry<?>[] table;
        int index;
        Entry<?> entry;
        Entry<?> lastReturned;
        final int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = DVTHashSet.this.table;
            this.index = this.table.length;
            this.expectedModCount = DVTHashSet.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public final boolean hasMoreElements() {
            Entry<?> e = this.entry;
            int i = this.index;
            Entry<?>[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public final T nextElement() {
            Entry<?> et = this.entry;
            int i = this.index;
            Entry<?>[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry<?> e = this.lastReturned;
                this.entry = e.next;
                return (T)(this.type == 0 ? e.key : e);
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public final boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public final T next() {
            if (DVTHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public final void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (DVTHashSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry<?>[] tab = DVTHashSet.this.table;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
            Entry<Object> e = tab[index];
            Entry<?> prev = null;
            while (e != null) {
                if (e == this.lastReturned) {
                    ++DVTHashSet.this.modCount;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    --DVTHashSet.this.count;
                    this.lastReturned = null;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }
}

