/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class DVTImageColorUtil {
    private static final DVTImageColorUtil instance = new DVTImageColorUtil();
    protected final Map<ProjectColorKey, Image> imageCache = new HashMap<ProjectColorKey, Image>();

    public static DVTImageColorUtil getInstance() {
        return instance;
    }

    protected DVTImageColorUtil() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().disposeExec(() -> DVTImageColorUtil.this.imageCache.values().stream().forEach(color -> color.dispose()));
            }
        });
    }

    public Image getImage(ImageDescriptor imageDescriptor, RGB rgb) {
        ProjectColorKey imageKey = new ProjectColorKey(imageDescriptor, rgb);
        Image result = this.imageCache.get(imageKey);
        if (result != null) {
            return result;
        }
        ImageData imageData = imageDescriptor.getImageData();
        result = new Image(null, imageData);
        this.imageCache.put(imageKey, result);
        return result;
    }

    private static class ProjectColorKey {
        private ImageDescriptor fImageDescriptor;
        private RGB fRGB;

        public ProjectColorKey(ImageDescriptor imageDescriptor, RGB rgb) {
            this.fImageDescriptor = imageDescriptor;
            this.fRGB = rgb;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fImageDescriptor == null ? 0 : this.fImageDescriptor.hashCode());
            result = 31 * result + (this.fRGB == null ? 0 : this.fRGB.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectColorKey other = (ProjectColorKey)obj;
            if (this.fImageDescriptor == null ? other.fImageDescriptor != null : !this.fImageDescriptor.equals(other.fImageDescriptor)) {
                return false;
            }
            return !(this.fRGB == null ? other.fRGB != null : !this.fRGB.equals((Object)other.fRGB));
        }
    }
}

