/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTJobsUtils {
    private static void setUserInterfaceActive(Display display, boolean active) {
        Shell[] shells = display.getShells();
        if (active) {
            int i = 0;
            while (i < shells.length) {
                shells[i].setEnabled(active);
                ++i;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                shells[i].setEnabled(active);
                --i;
            }
        }
    }

    public static void runWithBusyIndicator(Runnable runnable) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        DVTJobsUtils.setUserInterfaceActive(display, false);
        try {
            BusyIndicator.showWhile((Display)display, (Runnable)runnable);
        }
        finally {
            DVTJobsUtils.setUserInterfaceActive(display, true);
        }
    }

    public static void scheduleAndJoin(Job job, long delay, long poolingTime) {
        try {
            job.schedule(delay);
            while (Job.getJobManager().isSuspended()) {
                Thread.sleep(poolingTime);
            }
            job.join();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void scheduleAndJoin(Job job, long delay) {
        DVTJobsUtils.scheduleAndJoin(job, delay, 50L);
    }

    public static void scheduleAndJoin(Job job) {
        DVTJobsUtils.scheduleAndJoin(job, 0L, 50L);
    }

    public static void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static IConsole waitForConsole(IProcess process, IProgressMonitor monitor) {
        long consoleTimeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        IConsole console = null;
        try {
            while ((console = DebugUITools.getConsole((IProcess)process)) == null && !monitor.isCanceled() && System.currentTimeMillis() <= consoleTimeout) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {}
        return console;
    }

    public static boolean isBlockingJobInProgress(IResource resource) {
        Job[] jobs = Job.getJobManager().find(null);
        int i = 0;
        while (i < jobs.length) {
            if (DVTJobsUtils.isOverlappingJob(jobs[i], resource)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isOverlappingJob(Job job, IResource resource) {
        if (job.getState() == 1) {
            return false;
        }
        ISchedulingRule rule = job.getRule();
        if (rule == null) {
            return false;
        }
        return rule.isConflicting((ISchedulingRule)resource);
    }

    public static void waitForJobFinish(String jobName) {
        if (jobName == null) {
            return;
        }
        Job[] jobs = Job.getJobManager().find(null);
        int i = 0;
        while (i < jobs.length) {
            if (jobName.equals(jobs[i].getName())) {
                DVTJobsUtils.waitForJobFinish(jobs[i]);
                break;
            }
            ++i;
        }
    }

    private static void waitForJobFinish(Job job) {
        while (job.getState() == 4) {
        }
    }
}

