/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import ro.amiq.dvt.optimized.collections.fast.LinkedKHMap;
import ro.amiq.dvt.utils.IDVTMapElement;

public class DVTLinkedHashMap<K, V extends IDVTMapElement<K>>
implements Serializable,
Iterable<V> {
    private static final long serialVersionUID = 2L;
    private Object vals;
    private static final short MAX_TABLE_SIZE = 4;

    public DVTLinkedHashMap() {
    }

    public DVTLinkedHashMap(int size) {
        if (size >= 4) {
            this.vals = new LinkedKHMap(size * 4 / 3);
        }
    }

    public DVTLinkedHashMap(DVTLinkedHashMap<K, V> init) {
        if (init != null) {
            if (init.vals instanceof Map) {
                this.vals = new LinkedKHMap((Map)init.vals);
            } else if (init.vals instanceof Object[]) {
                this.vals = new Object[init.size()];
                System.arraycopy(init.vals, 0, this.vals, 0, init.size());
            } else {
                this.vals = init.vals;
            }
        }
    }

    public final void put(K unused, V value) {
        if (this.vals == null) {
            this.vals = value;
            return;
        }
        if (this.vals instanceof Map) {
            ((Map)this.vals).put(value.getKey(), value);
            return;
        }
        int size = this.size();
        int keyIndex = this.keyIndex(value.getKey(), size);
        if (keyIndex < size) {
            if (this.vals instanceof Object[]) {
                ((Object[])this.vals)[keyIndex] = value;
            } else {
                this.vals = value;
            }
        } else if (size + 1 == 4) {
            LinkedKHMap map = new LinkedKHMap(3);
            int i = 0;
            while (i < size) {
                IDVTMapElement temp = (IDVTMapElement)((Object[])this.vals)[i];
                map.put(temp.getKey(), temp);
                ++i;
            }
            map.put(value.getKey(), (IDVTMapElement<Object>)value);
            this.vals = map;
        } else {
            Object[] objectArray;
            Object[] newVals = new Object[size + 1];
            if (this.vals instanceof Object[]) {
                objectArray = (Object[])this.vals;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.vals;
            }
            Object[] src = objectArray;
            System.arraycopy(src, 0, newVals, 0, size);
            newVals[size] = value;
            this.vals = newVals;
        }
    }

    public void swap(K key) {
        int size;
        int keyIndex;
        if (this.vals instanceof Map) {
            IDVTMapElement value = (IDVTMapElement)((Map)this.vals).remove(key);
            ((Map)this.vals).put(key, value);
        } else if (this.vals instanceof Object[] && (keyIndex = this.keyIndex(key, size = ((Object[])this.vals).length)) < size) {
            Object value = ((Object[])this.vals)[keyIndex];
            int i = keyIndex;
            while (i < size - 1) {
                ((Object[])this.vals)[i] = ((Object[])this.vals)[i + 1];
                ++i;
            }
            ((Object[])this.vals)[size - 1] = value;
        }
    }

    public final Collection<V> values() {
        if (this.vals instanceof Map) {
            return ((Map)this.vals).values();
        }
        return new Values();
    }

    public V get(K key) {
        if (this.vals instanceof Map) {
            return (V)((IDVTMapElement)((Map)this.vals).get(key));
        }
        int size = this.size();
        int keyIndex = this.keyIndex(key, size);
        if (keyIndex < size) {
            if (this.vals instanceof Object[]) {
                return (V)((IDVTMapElement)((Object[])this.vals)[keyIndex]);
            }
            return (V)((IDVTMapElement)this.vals);
        }
        return null;
    }

    public final void clear() {
        if (this.vals instanceof Map) {
            ((Map)this.vals).clear();
        }
        this.vals = null;
    }

    public final void deepClean() {
        Collection<V> values = this.values();
        if (values == null) {
            this.clear();
            return;
        }
        ArrayList<V> valuesCopy = new ArrayList<V>(values);
        this.clear();
        for (IDVTMapElement value : valuesCopy) {
            try {
                value.deepClean();
            }
            catch (Exception exception) {}
        }
    }

    public final boolean isEmpty() {
        if (this.vals == null) {
            return true;
        }
        if (this.vals instanceof Map) {
            return ((Map)this.vals).isEmpty();
        }
        if (this.vals instanceof Object[]) {
            return ((Object[])this.vals).length == 0;
        }
        return false;
    }

    public void remove(K key) {
        if (this.vals instanceof Map) {
            Map map = (Map)this.vals;
            map.remove(key);
            if (map.size() == 4) {
                this.vals = new Object[4];
                map.values().toArray((Object[])this.vals);
            }
        } else {
            int size = this.size();
            if (size == 0) {
                return;
            }
            int keyIndex = this.keyIndex(key, size);
            if (keyIndex < size) {
                if (size <= 1) {
                    this.vals = null;
                } else if (size - 1 == 1) {
                    this.vals = ((Object[])this.vals)[1 - keyIndex];
                } else {
                    Object[] newVals = new Object[size - 1];
                    System.arraycopy(this.vals, 0, newVals, 0, keyIndex);
                    System.arraycopy(this.vals, keyIndex + 1, newVals, keyIndex, size - 1 - keyIndex);
                    this.vals = newVals;
                }
            }
        }
    }

    public boolean containsKey(K key) {
        if (this.vals instanceof Map) {
            return ((Map)this.vals).containsKey(key);
        }
        int size = this.size();
        return this.keyIndex(key, size) < size;
    }

    private final int keyIndex(K key, int size) {
        if (this.vals == null) {
            return size;
        }
        int keyHash = key.hashCode();
        int i = 0;
        while (i < size) {
            Object candidateKey;
            Object k = candidateKey = this.vals instanceof Object[] ? ((IDVTMapElement)((Object[])this.vals)[i]).getKey() : ((IDVTMapElement)this.vals).getKey();
            if (candidateKey == key) {
                return i;
            }
            int candidateHash = candidateKey.hashCode();
            if (keyHash == candidateHash && candidateKey.equals(key)) {
                return i;
            }
            i = (short)(i + 1);
        }
        return size;
    }

    public final int size() {
        if (this.vals == null) {
            return 0;
        }
        if (this.vals instanceof Map) {
            return ((Map)this.vals).size();
        }
        if (this.vals instanceof Object[]) {
            return ((Object[])this.vals).length;
        }
        return 1;
    }

    @Override
    public Iterator<V> iterator() {
        if (this.vals instanceof Map) {
            return ((Map)this.vals).values().iterator();
        }
        return new ValueIterator();
    }

    private final class ValueIterator
    implements Iterator<V> {
        int index = 0;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DVTLinkedHashMap.this.size();
        }

        @Override
        public void remove() {
            int size = DVTLinkedHashMap.this.size();
            if (size <= 1) {
                DVTLinkedHashMap.this.vals = null;
            } else if (size == 2) {
                DVTLinkedHashMap.this.vals = ((Object[])DVTLinkedHashMap.this.vals)[2 - this.index];
            } else {
                Object[] newVals = new Object[size - 1];
                System.arraycopy(DVTLinkedHashMap.this.vals, 0, newVals, 0, this.index - 1);
                System.arraycopy(DVTLinkedHashMap.this.vals, this.index, newVals, this.index - 1, size - this.index);
                DVTLinkedHashMap.this.vals = newVals;
            }
            --this.index;
        }

        @Override
        public V next() {
            if (DVTLinkedHashMap.this.vals instanceof Object[]) {
                return (IDVTMapElement)((Object[])DVTLinkedHashMap.this.vals)[this.index++];
            }
            if (this.index == 0) {
                ++this.index;
                return (IDVTMapElement)DVTLinkedHashMap.this.vals;
            }
            return null;
        }
    }

    private final class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final int size() {
            if (DVTLinkedHashMap.this.vals == null) {
                return 0;
            }
            if (DVTLinkedHashMap.this.vals instanceof Object[]) {
                return ((Object[])DVTLinkedHashMap.this.vals).length;
            }
            return 1;
        }

        @Override
        public final boolean contains(Object value) {
            if (value == null || DVTLinkedHashMap.this.vals == null) {
                return false;
            }
            int valueHash = value.hashCode();
            int i = 0;
            while (i < this.size()) {
                Object candidate;
                Object object = candidate = DVTLinkedHashMap.this.vals instanceof Object[] ? ((Object[])DVTLinkedHashMap.this.vals)[i] : DVTLinkedHashMap.this.vals;
                if (candidate == value) {
                    return true;
                }
                int candidateHash = candidate.hashCode();
                if (valueHash == candidateHash && candidate.equals(value)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        @Override
        public final void clear() {
            DVTLinkedHashMap.this.clear();
        }
    }
}

