/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogIntegerNumberFactory;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;

public abstract class DVTNumber {
    public static final DVTNumber UNDEFINED = new UndefinedDVTNumber();
    public static final BigInteger BIG_INTEGER_TWO = BigInteger.valueOf(2L);
    protected static final String MINUS_SIGN = "-";
    public static final String BASE2_LABEL = "Base 2";
    public static final String BASE10_LABEL = "Base 10";
    public static final String BASE16_LABEL = "Base 16";
    public static final int BASE_10_NO_PREFIX = -1;
    public static final int BASE_ENUM = -2;
    public static final int DEBUG_STRING_BASE2_VALUE = -1;
    public static final int BASE2_VALUE = 2;
    public static final int BASE8_VALUE = 8;
    public static final int BASE10_VALUE = 10;
    public static final int BASE16_VALUE = 16;
    public static final String BASE2_PREFIX = "b";
    public static final String BASE8_PREFIX = "o";
    public static final String BASE10_PREFIX = "d";
    public static final String BASE16_PREFIX = "h";
    public static final DVTNumber[] DVTNUMBER_ARRAY_CAST = new DVTNumber[0];
    public static final int MAX_ARRAY_SIZE = 0x7FFFFF;
    public static final int LIMIT_MAX_ARRAY_SIZE = 32;
    public static final int UNDEFINED_SIZE = -1;
    protected int uniqueId = -1;

    public abstract DVTNumber getDefaultValue(boolean var1);

    public abstract double doubleValue();

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public abstract BigInteger bigIntegerValue();

    public int intValue() {
        return this.bigIntegerValue().intValue();
    }

    public DVTNumber getBitSelect(int startPos, int size) {
        return null;
    }

    public boolean isAmbiguous() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public boolean is4State() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean hasSign() {
        return false;
    }

    public boolean hasUnknownSize() {
        return false;
    }

    public abstract int getSize();

    public abstract DVTNumber from(DVTNumber var1, boolean var2);

    protected static DVTNumber pack(DVTNumber number) {
        DVTNumber[] result = new DVTNumber[]{VlogBitVector.BIT_ZERO};
        number.pack(result, 0);
        return result[0];
    }

    protected static DVTNumber unpack(DVTNumber context, DVTNumber number) {
        if (!(number instanceof VlogBitVector)) {
            return UNDEFINED;
        }
        DVTNumber result = context.getDefaultValue(false);
        int resultSize = result.unpack((VlogBitVector)number, 0);
        return resultSize < 0 ? UNDEFINED : result;
    }

    public static DVTNumber getUnknownNumber(DVTNumber number) {
        if (number instanceof VlogBitVector) {
            return VlogBitVector.copy((VlogBitVector)number, ((VlogBitVector)number).isString(), VlogBitVector.createMaskOfType(MaskType.UNKNOWN, number.getSize()));
        }
        if (number instanceof VlogRealNumber) {
            return VlogRealNumber.UNKNOWN;
        }
        if (number instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.UNKNOWN;
        }
        return UNDEFINED;
    }

    public static DVTNumber getAmbiguousResultBit(DVTNumber left) {
        if (left instanceof VlogAbstractRealNumber) {
            return left.isUnknown() ? VlogBitVector.BIT_UNKNOWN : null;
        }
        if (!(left instanceof VlogBitVector)) {
            return null;
        }
        return ((VlogBitVector)left).getAmbiguousBitResult();
    }

    public static DVTNumber getAmbiguousResultBit(DVTNumber left, DVTNumber right) {
        if (left instanceof VlogAbstractRealNumber || right instanceof VlogAbstractRealNumber) {
            return left.isUnknown() || right.isUnknown() ? VlogBitVector.BIT_UNKNOWN : null;
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            return null;
        }
        return ((VlogBitVector)left).getAmbiguousBitResult((VlogBitVector)right);
    }

    public static DVTNumber not(DVTNumber left) {
        if (left instanceof VlogAbstractRealNumber) {
            return ((VlogAbstractRealNumber)left).toBitVectorNumber(left.hasSign(), left.getSize()).not();
        }
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported Not: " + left);
        }
        return ((VlogBitVector)left).not();
    }

    public static DVTNumber plus(DVTNumber left, DVTNumber right) {
        return DVTNumber.plus(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber plus(DVTNumber left, DVTNumber right, int resultSize) {
        if (left.isUnknown() || right.isUnknown()) {
            if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
                return Double.isNaN(left.doubleValue()) || Double.isNaN(right.doubleValue()) ? VlogRealNumber.NAN : VlogRealNumber.UNKNOWN;
            }
            if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
                return Float.isNaN(left.floatValue()) || Float.isNaN(right.floatValue()) ? VlogShortrealNumber.NAN : VlogShortrealNumber.UNKNOWN;
            }
            if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
                throw new UnsupportedOperationException("Unsupported plus: " + left + ", " + right);
            }
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
            return VlogRealNumber.create(left.doubleValue() + right.doubleValue());
        }
        if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.create(left.floatValue() + right.floatValue());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported plus: " + left + ", " + right);
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).plus((VlogBitVector)right, resultSize);
    }

    public static DVTNumber minus(DVTNumber left, DVTNumber right) {
        return DVTNumber.minus(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber minus(DVTNumber left, DVTNumber right, int resultSize) {
        if (left.isUnknown() || right.isUnknown()) {
            if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
                return Double.isNaN(left.doubleValue()) || Double.isNaN(right.doubleValue()) ? VlogRealNumber.NAN : VlogRealNumber.UNKNOWN;
            }
            if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
                return Float.isNaN(left.floatValue()) || Float.isNaN(right.floatValue()) ? VlogShortrealNumber.NAN : VlogShortrealNumber.UNKNOWN;
            }
            if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
                throw new UnsupportedOperationException("Unsupported minus: " + left + ", " + right);
            }
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
            return VlogRealNumber.create(left.doubleValue() - right.doubleValue());
        }
        if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.create(left.floatValue() - right.floatValue());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported minus: " + left + ", " + right);
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).minus((VlogBitVector)right, resultSize);
    }

    public static DVTNumber multiply(DVTNumber left, DVTNumber right) {
        return DVTNumber.multiply(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber multiply(DVTNumber left, DVTNumber right, int resultSize) {
        if (left.isUnknown() || right.isUnknown()) {
            if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
                return Double.isNaN(left.doubleValue()) || Double.isNaN(right.doubleValue()) ? VlogRealNumber.NAN : VlogRealNumber.UNKNOWN;
            }
            if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
                return Float.isNaN(left.floatValue()) || Float.isNaN(right.floatValue()) ? VlogShortrealNumber.NAN : VlogShortrealNumber.UNKNOWN;
            }
            if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
                throw new UnsupportedOperationException("Unsupported multiply: " + left + ", " + right);
            }
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
            return VlogRealNumber.create(left.doubleValue() * right.doubleValue());
        }
        if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.create(left.floatValue() * right.floatValue());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported multiply: " + left + ", " + right);
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).multiply((VlogBitVector)right, resultSize);
    }

    public static DVTNumber divide(DVTNumber left, DVTNumber right) {
        return DVTNumber.divide(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber divide(DVTNumber left, DVTNumber right, int resultSize) {
        if (left.isUnknown() || right.isUnknown()) {
            if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
                return Double.isNaN(left.doubleValue()) || Double.isNaN(right.doubleValue()) ? VlogRealNumber.NAN : VlogRealNumber.UNKNOWN;
            }
            if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
                return Float.isNaN(left.floatValue()) || Float.isNaN(right.floatValue()) ? VlogShortrealNumber.NAN : VlogShortrealNumber.UNKNOWN;
            }
            if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
                throw new UnsupportedOperationException("Unsupported divide: " + left + ", " + right);
            }
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (!(left instanceof VlogBitVector) && !(left instanceof VlogAbstractRealNumber) || !(right instanceof VlogBitVector) && !(right instanceof VlogAbstractRealNumber)) {
            throw new UnsupportedOperationException("Unsupported divide: " + left + ", " + right);
        }
        if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
            return VlogRealNumber.create(left.doubleValue() / right.doubleValue());
        }
        if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
            return VlogShortrealNumber.create(left.floatValue() / right.floatValue());
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).divide((VlogBitVector)right, resultSize);
    }

    public static DVTNumber mod(DVTNumber left, DVTNumber right) {
        return DVTNumber.mod(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber mod(DVTNumber left, DVTNumber right, int resultSize) {
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported mod: " + left + ", " + right);
        }
        if (left.isUnknown() || right.isUnknown()) {
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).mod((VlogBitVector)right, resultSize);
    }

    public static DVTNumber pow(DVTNumber left, DVTNumber right, int resultSize, boolean forceIntegerExp) {
        double exponentValue;
        if (left instanceof DVTUnpackedArray) {
            throw new UnsupportedOperationException("Operands: " + left);
        }
        double d = exponentValue = forceIntegerExp ? (double)right.intValue() : right.doubleValue();
        if (forceIntegerExp && (!(right instanceof VlogBitVector) || exponentValue < 0.0 && !(left instanceof VlogRealNumber))) {
            throw new UnsupportedOperationException("Operands: " + left);
        }
        if (left instanceof VlogRealNumber || right instanceof VlogRealNumber) {
            boolean isZero;
            if (left.isUnknown() && right.isUnknown()) {
                return VlogRealNumber.UNKNOWN;
            }
            if (left.isUnknown()) {
                if (VlogAbstractRealNumber.isNaN(right)) {
                    return VlogRealNumber.NAN;
                }
                if (right.doubleValue() == 0.0) {
                    return VlogRealNumber.ONE;
                }
                return VlogRealNumber.UNKNOWN;
            }
            if (right.isUnknown()) {
                return VlogRealNumber.UNKNOWN;
            }
            boolean bl = isZero = left.doubleValue() == 0.0;
            if (isZero && exponentValue > 0.0) {
                return VlogRealNumber.ZERO;
            }
            if (isZero && exponentValue < 0.0) {
                return VlogRealNumber.INFINITY;
            }
            if (isZero && exponentValue == 0.0 || left.doubleValue() == 1.0) {
                return VlogRealNumber.ONE;
            }
            return VlogRealNumber.create(StrictMath.pow(left.doubleValue(), right.doubleValue()));
        }
        if (left instanceof VlogShortrealNumber || right instanceof VlogShortrealNumber) {
            boolean isZero;
            if (left.isUnknown() && right.isUnknown()) {
                return VlogShortrealNumber.UNKNOWN;
            }
            if (left.isUnknown()) {
                if (VlogShortrealNumber.isNaN(right)) {
                    return VlogShortrealNumber.NAN;
                }
                if (right.floatValue() == 0.0f) {
                    return VlogShortrealNumber.ONE;
                }
                return VlogShortrealNumber.UNKNOWN;
            }
            if (right.isUnknown()) {
                return VlogShortrealNumber.UNKNOWN;
            }
            boolean bl = isZero = left.floatValue() == 0.0f;
            if (isZero && exponentValue > 0.0) {
                return VlogShortrealNumber.ZERO;
            }
            if (isZero && exponentValue < 0.0) {
                return VlogShortrealNumber.INFINITY;
            }
            if (isZero && exponentValue == 0.0 || left.floatValue() == 1.0f) {
                return VlogShortrealNumber.ONE;
            }
            return VlogShortrealNumber.create((float)StrictMath.pow(left.floatValue(), right.floatValue()));
        }
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported pow: " + left + ", " + right);
        }
        VlogBitVector leftVector = (VlogBitVector)left;
        if (left.isUnknown() && right.intValue() == 0) {
            return VlogBitVector.create(leftVector.hasSign(), resultSize - 1, 0, leftVector.getArrayDimensions(), leftVector.is4State(), false, false, false, leftVector.getMemberInfoByName(), VlogBitVector.createMaskOfType(MaskType.UNKNOWN, resultSize), leftVector.getNumber());
        }
        if (left.isUnknown() || right.isUnknown()) {
            return VlogBitVector.all(MaskType.UNKNOWN, resultSize);
        }
        if (left.isAmbiguous() || right.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, resultSize);
        }
        return ((VlogBitVector)left).pow(right.intValue(), resultSize);
    }

    public static DVTNumber and(DVTNumber left, DVTNumber right) {
        return DVTNumber.and(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber and(DVTNumber left, DVTNumber right, int resultSize) {
        if (left instanceof VlogAbstractRealNumber) {
            left = ((VlogAbstractRealNumber)left).toBitVectorNumber(left.hasSign(), left.getSize());
        }
        if (right instanceof VlogAbstractRealNumber) {
            right = ((VlogAbstractRealNumber)right).toBitVectorNumber(right.hasSign(), right.getSize());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported and: " + left + ", " + right);
        }
        return ((VlogBitVector)left).and((VlogBitVector)right, resultSize);
    }

    public static DVTNumber or(DVTNumber left, DVTNumber right) {
        return DVTNumber.or(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber or(DVTNumber left, DVTNumber right, int resultSize) {
        if (left instanceof VlogAbstractRealNumber) {
            left = ((VlogAbstractRealNumber)left).toBitVectorNumber(left.hasSign(), left.getSize());
        }
        if (right instanceof VlogAbstractRealNumber) {
            right = ((VlogAbstractRealNumber)right).toBitVectorNumber(right.hasSign(), right.getSize());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported or: " + left + ", " + right);
        }
        return ((VlogBitVector)left).or((VlogBitVector)right, resultSize);
    }

    public static DVTNumber xor(DVTNumber left, DVTNumber right) {
        return DVTNumber.xor(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber wildEqual(DVTNumber left, DVTNumber right) {
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported wildEqual: " + left + ", " + right);
        }
        return ((VlogBitVector)left).wildEqual((VlogBitVector)right);
    }

    public static DVTNumber xor(DVTNumber left, DVTNumber right, int resultSize) {
        if (left instanceof VlogAbstractRealNumber) {
            left = ((VlogAbstractRealNumber)left).toBitVectorNumber(left.hasSign(), left.getSize());
        }
        if (right instanceof VlogAbstractRealNumber) {
            right = ((VlogAbstractRealNumber)right).toBitVectorNumber(right.hasSign(), right.getSize());
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported xor: " + left + ", " + right);
        }
        return ((VlogBitVector)left).xor((VlogBitVector)right, resultSize);
    }

    public static DVTNumber nxor(DVTNumber left, DVTNumber right) {
        return DVTNumber.nxor(left, right, Integer.max(left.getSize(), right.getSize()));
    }

    public static DVTNumber nxor(DVTNumber left, DVTNumber right, int resultSize) {
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported nxor: " + left + ", " + right);
        }
        return ((VlogBitVector)left).xor((VlogBitVector)right, resultSize).not();
    }

    public static DVTNumber shiftLeft(DVTNumber left, int shl) {
        return DVTNumber.shiftLeft(left, shl, left.getSize());
    }

    public static DVTNumber shiftLeft(DVTNumber left, int shl, int resultSize) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported shiftLeft: " + left + ", " + shl);
        }
        return ((VlogBitVector)left).shiftLeft(shl, resultSize);
    }

    public static DVTNumber shiftRight(DVTNumber left, int shr, boolean keepSign) {
        return DVTNumber.shiftRight(left, shr, keepSign, left.getSize());
    }

    public static DVTNumber shiftRight(DVTNumber left, int shr, boolean keepSign, int resultSize) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported shiftRight: " + left + ", " + shr);
        }
        return ((VlogBitVector)left).shiftRight(shr, keepSign, resultSize);
    }

    public static DVTNumber abs(DVTNumber left) {
        if (left.isUnknown()) {
            if (left instanceof VlogRealNumber) {
                return VlogRealNumber.UNKNOWN;
            }
            if (left instanceof VlogShortrealNumber) {
                return VlogShortrealNumber.UNKNOWN;
            }
            if (!(left instanceof VlogBitVector)) {
                throw new UnsupportedOperationException("Unsupported abs: " + left);
            }
            return VlogBitVector.all(MaskType.UNKNOWN, left.getSize());
        }
        if (left instanceof VlogRealNumber) {
            return new VlogRealNumber(Math.abs(left.doubleValue()));
        }
        if (left instanceof VlogShortrealNumber) {
            return new VlogShortrealNumber(Math.abs(left.floatValue()));
        }
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported abs: " + left);
        }
        if (left.isAmbiguous()) {
            return VlogBitVector.all(MaskType.X, left.getSize());
        }
        return ((VlogBitVector)left).abs();
    }

    public static DVTNumber band(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported band: " + left);
        }
        return ((VlogBitVector)left).band();
    }

    public static DVTNumber nband(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported nband: " + left);
        }
        return ((VlogBitVector)left).nband();
    }

    public static DVTNumber bxor(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported bxor: " + left);
        }
        return ((VlogBitVector)left).bxor();
    }

    public static DVTNumber nbxor(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported nbxor: " + left);
        }
        return ((VlogBitVector)left).nbxor();
    }

    public static DVTNumber bor(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported bor: " + left);
        }
        return ((VlogBitVector)left).bor();
    }

    public static DVTNumber nbor(DVTNumber left) {
        if (!(left instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported nbor: " + left);
        }
        return ((VlogBitVector)left).nbor();
    }

    public static boolean gt(DVTNumber left, DVTNumber right) {
        if (left instanceof VlogAbstractRealNumber || right instanceof VlogAbstractRealNumber) {
            return left.doubleValue() > right.doubleValue();
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported gt: " + left + ", " + right);
        }
        return ((VlogBitVector)left).gt((VlogBitVector)right);
    }

    public static boolean lt(DVTNumber left, DVTNumber right) {
        if (left instanceof VlogAbstractRealNumber || right instanceof VlogAbstractRealNumber) {
            return left.doubleValue() < right.doubleValue();
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported lt: " + left + ", " + right);
        }
        return ((VlogBitVector)left).lt((VlogBitVector)right);
    }

    public static boolean gte(DVTNumber left, DVTNumber right) {
        return DVTNumber.eq(left, right) || DVTNumber.gt(left, right);
    }

    public static boolean lte(DVTNumber left, DVTNumber right) {
        return DVTNumber.eq(left, right) || DVTNumber.lt(left, right);
    }

    public static VlogBitVector vlogEq(DVTNumber left, DVTNumber right) {
        if (left.isUnknown() || right.isUnknown()) {
            if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
                return VlogBitVector.BIT_UNKNOWN;
            }
            return ((VlogBitVector)left).vlogEq((VlogBitVector)right);
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            return DVTNumber.eq(left, right) ? VlogBitVector.BIT_ONE : VlogBitVector.BIT_ZERO;
        }
        return ((VlogBitVector)left).vlogEq((VlogBitVector)right);
    }

    public static boolean eq(DVTNumber left, DVTNumber right) {
        if (left instanceof UndefinedDVTNumber || right instanceof UndefinedDVTNumber) {
            return false;
        }
        if (left instanceof VlogAbstractRealNumber || right instanceof VlogAbstractRealNumber) {
            return left.doubleValue() == right.doubleValue();
        }
        if (left instanceof DVTUnpackedArray || right instanceof DVTUnpackedArray) {
            return left instanceof DVTUnpackedArray && right instanceof DVTUnpackedArray && ((DVTUnpackedArray)left).equals(right);
        }
        if (left instanceof DVTUnpackedStruct || right instanceof DVTUnpackedStruct) {
            return left instanceof DVTUnpackedStruct && right instanceof DVTUnpackedStruct && ((DVTUnpackedStruct)left).equals(right);
        }
        if (!(left instanceof VlogBitVector) || !(right instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Unsupported eq: " + left + ", " + right);
        }
        return ((VlogBitVector)left).equals((VlogBitVector)right);
    }

    public static boolean isUndefined(DVTNumber candidate) {
        return candidate == null || candidate == UNDEFINED;
    }

    public static boolean isUnknownSize(int size) {
        return size < 0;
    }

    public VlogBitVector toBitVector() {
        return null;
    }

    public abstract String toString(int var1, boolean var2, boolean var3);

    public abstract String print(int var1, boolean var2, int var3, boolean var4, boolean var5);

    public abstract String toNiceString(BitVectorContext var1, int var2, boolean var3, boolean var4);

    public int hashCode() {
        return this.toNiceString(null, -1, false, false).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DVTNumber)) {
            return false;
        }
        return DVTNumber.eq(this, (DVTNumber)obj);
    }

    public boolean internalEquals(Object obj) {
        return this.equals(obj);
    }

    public static DVTNumber $clog2(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogBitVector.copy((VlogBitVector)expression, VlogBitVector.createMaskOfType(MaskType.UNKNOWN, expression.getSize()));
        }
        return ((VlogBitVector)expression).clog2();
    }

    public static DVTNumber $abs(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = expression.doubleValue();
        double result = Math.abs(first);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $min(DVTNumber number1, DVTNumber number2) {
        if (number1 == null || number2 == null) {
            throw new UnsupportedOperationException("Operands: " + number1 + ", " + number2);
        }
        if (number1.isUnknown() || number2.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = number1.doubleValue();
        double second = number2.doubleValue();
        return VlogRealNumber.create(Math.min(first, second));
    }

    public static DVTNumber $max(DVTNumber number1, DVTNumber number2) {
        if (number1 == null || number2 == null) {
            throw new UnsupportedOperationException("Operands: " + number1 + ", " + number2);
        }
        if (number1.isUnknown() || number2.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = number1.doubleValue();
        double second = number2.doubleValue();
        return VlogRealNumber.create(Math.max(first, second));
    }

    public static DVTNumber $ln(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.log(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $log10(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.log10(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $exp(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.exp(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $sqrt(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.sqrt(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $pow(DVTNumber number1, DVTNumber number2) {
        if (number1 == null || number2 == null) {
            throw new UnsupportedOperationException("Operands: " + number1 + ", " + number2);
        }
        if (number1.isUnknown() || number2.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = number1.doubleValue();
        double second = number2.doubleValue();
        if (first == 1.0 && (Double.isInfinite(second) || Double.isNaN(second))) {
            return VlogRealNumber.ONE;
        }
        if (first == Double.POSITIVE_INFINITY && second > 0.0) {
            return VlogRealNumber.INFINITY;
        }
        if (first == Double.POSITIVE_INFINITY && second < 0.0) {
            return VlogRealNumber.ZERO;
        }
        if (first == Double.NEGATIVE_INFINITY && second != 0.0) {
            return second % 2.0 == 0.0 ? VlogRealNumber.INFINITY : VlogRealNumber.NEGATIVE_INFINITY;
        }
        if (first > 1.0 && second == Double.POSITIVE_INFINITY) {
            return VlogRealNumber.INFINITY;
        }
        if (first > -1.0 && first < 1.0 && second == Double.POSITIVE_INFINITY) {
            return VlogRealNumber.ZERO;
        }
        if (first > 1.0 && second == Double.NEGATIVE_INFINITY) {
            return VlogRealNumber.ZERO;
        }
        if (first > -1.0 && first < 1.0 && second == Double.NEGATIVE_INFINITY) {
            return VlogRealNumber.INFINITY;
        }
        double result = StrictMath.pow(first, second);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $ceil(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.ceil(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $floor(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.floor(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $sin(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.sin(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $cos(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.cos(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $tan(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.tan(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $asin(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.asin(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $acos(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.acos(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $atan(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.atan(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $rtoi(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        if (Double.isInfinite(value)) {
            value = 0.0;
        }
        return VlogIntegerNumberFactory.createInteger(BigInteger.valueOf((long)value));
    }

    public static DVTNumber $itor(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        return VlogRealNumber.create(value);
    }

    public static DVTNumber $realtobits(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        long ieee754doubleFormat = Double.doubleToLongBits(value);
        return VlogBitVector.create(false, 63, 0, BigInteger.valueOf(ieee754doubleFormat));
    }

    public static DVTNumber $bitstoreal(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        long value = expression.bigIntegerValue().longValue();
        double ieee754doubleFormat = Double.longBitsToDouble(value);
        return VlogRealNumber.create(ieee754doubleFormat);
    }

    public static DVTNumber $shortrealtobits(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        float value = expression.floatValue();
        int ieee754floatFormat = Float.floatToIntBits(value);
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(ieee754floatFormat));
    }

    public static DVTNumber $bitstoshortreal(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        int value = expression.bigIntegerValue().intValue();
        float ieee754floatFormat = Float.intBitsToFloat(value);
        return VlogShortrealNumber.create(ieee754floatFormat);
    }

    public static DVTNumber $atan2(DVTNumber number1, DVTNumber number2) {
        if (number1 == null || number2 == null) {
            throw new UnsupportedOperationException("Operands: " + number1 + ", " + number2);
        }
        if (number1.isUnknown() || number2.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = number1.doubleValue();
        double second = number2.doubleValue();
        double result = StrictMath.atan2(first, second);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $hypot(DVTNumber number1, DVTNumber number2) {
        if (number1 == null || number2 == null) {
            throw new UnsupportedOperationException("Operands: " + number1 + ", " + number2);
        }
        if (number1.isUnknown() || number2.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double first = number1.doubleValue();
        double second = number2.doubleValue();
        double result = StrictMath.hypot(first, second);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $sinh(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.sinh(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $cosh(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.cosh(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $tanh(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.tanh(value);
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $asinh(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        if (value == Double.POSITIVE_INFINITY) {
            return VlogRealNumber.INFINITY;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return VlogRealNumber.NEGATIVE_INFINITY;
        }
        if (value == Double.NaN) {
            return VlogRealNumber.NAN;
        }
        if (Double.compare(value, 0.0) == 0) {
            return VlogRealNumber.ZERO;
        }
        if (Double.compare(value, -0.0) == 0) {
            return VlogRealNumber.MINUS_ZERO;
        }
        double result = StrictMath.log(value + StrictMath.sqrt(value * value + 1.0));
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $acosh(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        double result = StrictMath.log(value + StrictMath.sqrt(value * value - 1.0));
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $atanh(DVTNumber expression) {
        double mult;
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.isUnknown()) {
            return VlogRealNumber.UNKNOWN;
        }
        double value = expression.doubleValue();
        if (Double.compare(value, 0.0) == 0) {
            return VlogRealNumber.ZERO;
        }
        if (Double.compare(value, -0.0) == 0) {
            return VlogRealNumber.MINUS_ZERO;
        }
        if (Double.doubleToRawLongBits(value) < 0L) {
            value = Math.abs(value);
            mult = -0.5;
        } else {
            mult = 0.5;
        }
        double result = mult * StrictMath.log((1.0 + value) / (1.0 - value));
        return VlogRealNumber.create(result);
    }

    public static DVTNumber $bits(DVTNumber expression) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(expression.getSize()));
    }

    public static DVTNumber $size(DVTNumber expression, DVTNumber dimensionNo) {
        if (expression == null) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        int arraySize = -1;
        if (expression instanceof DVTUnpackedArray && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            arraySize = ((DVTUnpackedArray)expression).getArraySize();
        }
        if (expression instanceof VlogBitVector) {
            int[] dimensions = ((VlogBitVector)expression).getArrayDimensions();
            int index = 2 * dimensionIndex[0];
            if (dimensions != null && index < dimensions.length) {
                int n = arraySize = dimensions[index] > dimensions[index + 1] ? dimensions[index] - dimensions[index + 1] + 1 : dimensions[index + 1] - dimensions[index] + 1;
            }
        }
        if (arraySize < 0) {
            return VlogBitVector.all(MaskType.X, 32);
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(arraySize));
    }

    public static DVTNumber $onehot(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        int countBits = ((VlogBitVector)expression).countBits(VlogBitVector.CONTROL_BIT.ONE);
        if (countBits == 1) {
            return VlogBitVector.BIT_ONE;
        }
        return VlogBitVector.BIT_ZERO;
    }

    public static DVTNumber $onehot0(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        int countBits = ((VlogBitVector)expression).countBits(VlogBitVector.CONTROL_BIT.ONE);
        if (countBits <= 1) {
            return VlogBitVector.BIT_ONE;
        }
        return VlogBitVector.BIT_ZERO;
    }

    public static DVTNumber $countones(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        int countBits = ((VlogBitVector)expression).countBits(VlogBitVector.CONTROL_BIT.ONE);
        return VlogBitVector.create(true, 31, 0, BigInteger.valueOf(countBits));
    }

    public static DVTNumber $isunknown(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        boolean hasX = ((VlogBitVector)expression).countBits(VlogBitVector.CONTROL_BIT.X) > 0;
        boolean hasZ = ((VlogBitVector)expression).countBits(VlogBitVector.CONTROL_BIT.Z) > 0;
        return hasX || hasZ ? VlogBitVector.BIT_ONE : VlogBitVector.BIT_ZERO;
    }

    public static DVTNumber $countbits(DVTNumber expression, DVTNumber bit) {
        VlogBitVector.CONTROL_BIT control;
        if (!(expression instanceof VlogBitVector) || !(bit instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        VlogBitVector controlBit = (VlogBitVector)bit;
        int bitValue = controlBit.intValue();
        if (controlBit.getSize() > 1) {
            bitValue &= 1;
        }
        if (bitValue != 0 && bitValue != 1) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        int[] firstDimension = controlBit.getFirstDimension();
        if (firstDimension == null) {
            return UNDEFINED;
        }
        VlogBitVector.CONTROL_BIT cONTROL_BIT = control = bitValue == 0 ? VlogBitVector.CONTROL_BIT.ZERO : VlogBitVector.CONTROL_BIT.ONE;
        if (controlBit.hasMask(MaskType.X, firstDimension[0])) {
            control = VlogBitVector.CONTROL_BIT.X;
        } else if (controlBit.hasMask(MaskType.Z, firstDimension[0])) {
            control = VlogBitVector.CONTROL_BIT.Z;
        }
        int countBits = ((VlogBitVector)expression).countBits(control);
        return VlogBitVector.create(true, 31, 0, BigInteger.valueOf(countBits));
    }

    public static DVTNumber $unsigned(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        return ((VlogBitVector)expression).signedToUnsigned();
    }

    public static DVTNumber $signed(DVTNumber expression) {
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (expression.hasSign()) {
            return expression;
        }
        VlogBitVector bitVector = (VlogBitVector)expression;
        VlogBitVector result = VlogBitVector.create(true, bitVector.getLeft(), bitVector.getRight(), bitVector.getArrayDimensions(), false);
        return result.from(bitVector);
    }

    public static DVTNumber $left(DVTNumber expression, DVTNumber dimensionNo) {
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        if (!(expression instanceof VlogBitVector) && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            return VlogBitVector.create(false, 0, 31, BigInteger.valueOf(((DVTUnpackedArray)expression).getLeft()));
        }
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (dimensionIndex[0] == 0) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(((VlogBitVector)expression).getFirstDimension()[0]));
        }
        int[] arrayDimensions = ((VlogBitVector)expression).getArrayDimensions();
        int index = 2 * dimensionIndex[0];
        if (arrayDimensions != null && index < arrayDimensions.length) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(arrayDimensions[index]));
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(0L));
    }

    public static DVTNumber $right(DVTNumber expression, DVTNumber dimensionNo) {
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        if (!(expression instanceof VlogBitVector) && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            return VlogBitVector.create(false, 0, 31, BigInteger.valueOf(((DVTUnpackedArray)expression).getRight()));
        }
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (dimensionIndex[0] == 0) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(((VlogBitVector)expression).getFirstDimension()[1]));
        }
        int[] dimensions = ((VlogBitVector)expression).getArrayDimensions();
        int index = 2 * dimensionIndex[0] + 1;
        if (dimensions != null && index < dimensions.length) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(dimensions[index]));
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(-1L));
    }

    public static DVTNumber $high(DVTNumber expression, DVTNumber dimensionNo) {
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        if (!(expression instanceof VlogBitVector) && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            return VlogBitVector.create(false, 0, 31, BigInteger.valueOf(Math.max(((DVTUnpackedArray)expression).getLeft(), ((DVTUnpackedArray)expression).getRight())));
        }
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (dimensionIndex[0] == 0) {
            int[] firstDimension = ((VlogBitVector)expression).getFirstDimension();
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(Math.max(firstDimension[0], firstDimension[1])));
        }
        int[] dimensions = ((VlogBitVector)expression).getArrayDimensions();
        int index = 2 * dimensionIndex[0];
        if (dimensions != null && index < dimensions.length - 1) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(Math.max(dimensions[index], dimensions[index + 1])));
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(-1L));
    }

    public static DVTNumber $low(DVTNumber expression, DVTNumber dimensionNo) {
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        if (!(expression instanceof VlogBitVector) && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            return VlogBitVector.create(false, 0, 31, BigInteger.valueOf(Math.min(((DVTUnpackedArray)expression).getLeft(), ((DVTUnpackedArray)expression).getRight())));
        }
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (dimensionIndex[0] == 0) {
            int[] firstDimension = ((VlogBitVector)expression).getFirstDimension();
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(Math.min(firstDimension[0], firstDimension[1])));
        }
        int[] dimensions = ((VlogBitVector)expression).getArrayDimensions();
        int index = 2 * dimensionIndex[0];
        if (dimensions != null && index < dimensions.length - 1) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(Math.min(dimensions[index], dimensions[index + 1])));
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(-1L));
    }

    public static DVTNumber $increment(DVTNumber expression, DVTNumber dimensionNo) {
        int[] dimensionIndex = new int[]{dimensionNo.intValue()};
        if (!(expression instanceof VlogBitVector) && (expression = DVTNumber.goToDimensionNo(expression, dimensionIndex)) instanceof DVTUnpackedArray) {
            return VlogBitVector.create(false, 0, 31, BigInteger.valueOf(((DVTUnpackedArray)expression).getLeft() > ((DVTUnpackedArray)expression).getRight() ? 1 : -1));
        }
        if (!(expression instanceof VlogBitVector)) {
            throw new UnsupportedOperationException("Operands: " + expression);
        }
        if (dimensionIndex[0] == 0) {
            int[] firstDimension = ((VlogBitVector)expression).getFirstDimension();
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(firstDimension[0] > firstDimension[1] ? 1 : -1));
        }
        int[] dimensions = ((VlogBitVector)expression).getArrayDimensions();
        int index = 2 * dimensionIndex[0];
        if (dimensions != null && index < dimensions.length - 1) {
            return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(dimensions[index] >= dimensions[index + 1] ? 1 : -1));
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(-1L));
    }

    /*
     * Unable to fully structure code
     */
    private static DVTNumber goToDimensionNo(DVTNumber expression, int[] dimension) {
        if (expression instanceof DVTUnpackedArray) ** GOTO lbl5
        throw new UnsupportedOperationException("Operands: " + expression);
lbl-1000:
        // 1 sources

        {
            expression = ((DVTUnpackedArray)expression).getElementType();
            dimension[0] = dimension[0] - 1;
lbl5:
            // 2 sources

            ** while (dimension[0] > 0 && expression instanceof DVTUnpackedArray)
        }
lbl6:
        // 1 sources

        return expression;
    }

    public static DVTNumber $dimensions(DVTNumber expression) {
        int nofDimensions = 0;
        while (expression instanceof DVTUnpackedArray) {
            ++nofDimensions;
            expression = ((DVTUnpackedArray)expression).getElementType();
        }
        if (expression instanceof VlogBitVector && !((VlogBitVector)expression).isStruct(true)) {
            int[] dims = ((VlogBitVector)expression).getArrayDimensions();
            nofDimensions += dims.length / 2;
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(nofDimensions));
    }

    public static DVTNumber $unpackedDimensions(DVTNumber expression) {
        int nofDimensions = 0;
        while (expression instanceof DVTUnpackedArray) {
            ++nofDimensions;
            expression = ((DVTUnpackedArray)expression).getElementType();
        }
        return VlogBitVector.create(false, 31, 0, BigInteger.valueOf(nofDimensions));
    }

    public static DVTNumber $test$plusargs(DVTNumber expression) {
        return VlogBitVector.create(false, 31, 0, BigInteger.ZERO);
    }

    public static DVTNumber concatenate(DVTNumber left, DVTNumber right, BitVectorContext context) {
        DVTNumber result = null;
        if (left instanceof VlogBitVector && right instanceof VlogBitVector) {
            result = left;
            int resultSize = left.getSize() < right.getSize() && left.intValue() == 0 ? right.getSize() : result.getSize() + right.getSize();
            result = DVTNumber.shiftLeft(result, right.getSize(), resultSize);
            result = ((VlogBitVector)result).concatenate((VlogBitVector)right, Integer.max(result.getSize(), right.getSize()));
        } else if (left instanceof DVTUnpackedArray) {
            DVTNumber[] newArray;
            DVTNumber elementType;
            int newRight;
            int newLeft;
            if (((DVTUnpackedArray)left).isEmpty() && right instanceof DVTUnpackedArray) {
                return right;
            }
            if (context != null && context.getContextNumber() instanceof DVTUnpackedArray) {
                DVTUnpackedArray contextArray = (DVTUnpackedArray)context.getContextNumber();
                newLeft = contextArray.getLeft();
                newRight = contextArray.getRight();
                elementType = contextArray.getElementType();
            } else {
                DVTUnpackedArray leftArr = (DVTUnpackedArray)left;
                int rightSize = right instanceof DVTUnpackedArray ? ((DVTUnpackedArray)right).getArraySize() : 1;
                elementType = leftArr.getElementType();
                int step = leftArr.getValues().length == 0 ? -1 : 0;
                boolean isDecreasing = leftArr.getLeft() >= leftArr.getRight();
                newLeft = isDecreasing ? leftArr.getLeft() + rightSize + step : leftArr.getLeft();
                newRight = isDecreasing ? leftArr.getRight() : leftArr.getRight() + rightSize + step;
            }
            DVTNumber[] leftValues = ((DVTUnpackedArray)left).getValues();
            if (right instanceof DVTUnpackedArray) {
                DVTNumber[] rightValues = ((DVTUnpackedArray)right).getValues();
                newArray = new DVTNumber[leftValues.length + rightValues.length];
                System.arraycopy(leftValues, 0, newArray, 0, leftValues.length);
                System.arraycopy(rightValues, 0, newArray, leftValues.length, rightValues.length);
            } else {
                newArray = new DVTNumber[leftValues.length + 1];
                System.arraycopy(leftValues, 0, newArray, 0, leftValues.length);
                newArray[newArray.length - 1] = right;
            }
            result = new DVTUnpackedArray(newLeft, newRight, elementType, newArray);
        } else if (right instanceof DVTUnpackedArray) {
            DVTNumber elementType;
            int newRight;
            int newLeft;
            if (context != null && context.getContextNumber() instanceof DVTUnpackedArray) {
                DVTUnpackedArray contextArray = (DVTUnpackedArray)context.getContextNumber();
                newLeft = contextArray.getLeft();
                newRight = contextArray.getRight();
                elementType = contextArray.getElementType();
            } else {
                DVTUnpackedArray rightArr = (DVTUnpackedArray)right;
                newLeft = rightArr.getLeft();
                newRight = rightArr.getLeft() < rightArr.getRight() ? rightArr.getRight() + 1 : rightArr.getRight() - 1;
                elementType = rightArr.getElementType();
            }
            DVTNumber[] rightValues = ((DVTUnpackedArray)right).getValues();
            DVTNumber[] newArray = new DVTNumber[rightValues.length + 1];
            newArray[0] = left;
            System.arraycopy(rightValues, 0, newArray, 1, rightValues.length);
            result = new DVTUnpackedArray(newLeft, newRight, elementType, newArray);
        }
        return result;
    }

    public String toStringDimensions(int[] firstDimension, boolean isVhdl) {
        if (isVhdl) {
            return firstDimension[0] > firstDimension[1] ? firstDimension[0] + " downto " + firstDimension[1] : firstDimension[0] + " to " + firstDimension[1];
        }
        return Arrays.toString(firstDimension);
    }

    public String xGetRawString() {
        return "";
    }

    public static boolean isString(DVTNumber number) {
        return number instanceof VlogBitVector && ((VlogBitVector)number).isString();
    }

    public abstract DVTNumber copy();

    public BitSet getMask(MaskType type) {
        return null;
    }

    public BitSet removeMask(MaskType type) {
        return null;
    }

    public EnumMap<MaskType, BitSet> getMasks() {
        return null;
    }

    public boolean isStruct(boolean isStructOrUnion) {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public boolean hasMask(MaskType ... types) {
        return false;
    }

    protected int pack(DVTNumber[] result, int resultSize) {
        result[0] = UNDEFINED;
        return -1;
    }

    protected int unpack(VlogBitVector source, int resultSize) {
        return -1;
    }

    public ElementPath getInstancePath() {
        return ElementPath.EMPTY_PATH;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public DVTNumber setUniqueId(int uniqueId, boolean doCopy) {
        DVTNumber copy = doCopy ? this.copy() : this;
        copy.uniqueId = uniqueId;
        return copy;
    }

    public int[] getPacked() {
        return null;
    }

    private static class UndefinedDVTNumber
    extends DVTNumber {
        @Override
        public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[undefined number]";
        }

        @Override
        public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
            return "[undefined number]";
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[undefined number]";
        }

        public String toString() {
            return this.toString(10, false, true);
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public BigInteger bigIntegerValue() {
            return BigInteger.ZERO;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public DVTNumber from(DVTNumber number, boolean isCast) {
            return UNDEFINED;
        }

        @Override
        public DVTNumber copy() {
            return this;
        }

        @Override
        public DVTNumber getDefaultValue(boolean force4State) {
            return this;
        }
    }

    public static class XAssocArrayKeyNumberWrapper
    extends DVTNumber {
        private XValueHolder value;

        public XAssocArrayKeyNumberWrapper(XValueHolder value) {
            this.value = value;
        }

        public XValueHolder getValue() {
            return this.value;
        }

        @Override
        public DVTNumber getDefaultValue(boolean force4State) {
            return null;
        }

        @Override
        public double doubleValue() {
            return 0.0;
        }

        @Override
        public BigInteger bigIntegerValue() {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public DVTNumber from(DVTNumber number, boolean isCast) {
            return null;
        }

        @Override
        public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return null;
        }

        @Override
        public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
            return null;
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return null;
        }

        @Override
        public DVTNumber copy() {
            return null;
        }
    }
}

