/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.utils.DVTBatchUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTProcessRunner {
    private String fCommandLine;
    private String[] fCommandLineArray;
    private StringBuilder fErrorOutput;
    private StringBuilder fStandardOutput;
    private int fExitValue;
    private boolean isCancelled;
    private int fPid;
    private OutputStream fStdErrPipe;
    private OutputStream fStdOutPipe;
    private File fWorkingDir;

    public DVTProcessRunner(String commandLine) {
        this.fCommandLine = commandLine;
    }

    public DVTProcessRunner(String ... args) {
        this.fCommandLineArray = args;
    }

    public DVTProcessRunner(List<String> args) {
        this.fCommandLineArray = args.toArray(new String[args.size()]);
    }

    public void setWorkingDir(File workingDir) {
        this.fWorkingDir = workingDir;
    }

    public DVTProcessRunner(String commandLine, File workingDir) {
        this(commandLine);
        this.checkAndSetWorkingDir(commandLine, workingDir);
    }

    public DVTProcessRunner(File workingDir, String ... commandLine) {
        this(commandLine);
        this.checkAndSetWorkingDir(commandLine, workingDir);
    }

    private void checkAndSetWorkingDir(Object commandLine, File workingDir) {
        if (workingDir == null) {
            return;
        }
        Assert.isTrue((boolean)workingDir.exists(), (String)("Working directory '" + workingDir.getAbsolutePath() + "' for command " + this.makeString(commandLine) + " does not exist"));
        Assert.isTrue((boolean)workingDir.exists(), (String)("Working directory '" + workingDir.getAbsolutePath() + "' for command " + this.makeString(commandLine) + " is not a directory"));
        this.fWorkingDir = workingDir;
    }

    private String makeString(Object commandLine) {
        if (commandLine instanceof String) {
            return (String)commandLine;
        }
        if (commandLine instanceof String[]) {
            return DVTStringUtil.join((String[])commandLine, " ");
        }
        return commandLine.toString();
    }

    public void run(IProgressMonitor progressMonitor) throws IOException {
        this.run(progressMonitor, null);
    }

    public void run(IProgressMonitor progressMonitor, long timeout) throws IOException {
        this.run(progressMonitor, null, timeout);
    }

    public void run(IProgressMonitor progressMonitor, Map env) throws IOException {
        this.run(progressMonitor, env, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor progressMonitor, Map env, long timeout) throws IOException {
        this.fErrorOutput = new StringBuilder();
        this.fStandardOutput = new StringBuilder();
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        timeoutStamp = timeout <= 0L ? 0x7FFFFFFFFFFFFFFFL : System.currentTimeMillis() + timeout;
        progressMonitor.beginTask("Running: " + this.getCommandLine(), -1);
        process = null;
        if (this.fCommandLine != null) {
            process = Runtime.getRuntime().exec(this.fCommandLine, DVTProcessRunner.getEnvp(env), this.fWorkingDir);
        } else if (this.fCommandLineArray != null) {
            process = Runtime.getRuntime().exec(this.fCommandLineArray, DVTProcessRunner.getEnvp(env), this.fWorkingDir);
        } else {
            throw new IllegalStateException("Command Line argument should be an instance of String or String[]");
        }
        errorStream = process.getErrorStream();
        stdoutStream = process.getInputStream();
        this.fPid = DVTUtilsCommon.INSTANCE.getPid(process);
        nextDelta = 0L;
        while (true) {
            this.storeAndPipe(stdoutStream, this.fStdOutPipe, this.fStandardOutput);
            this.storeAndPipe(errorStream, this.fStdErrPipe, this.fErrorOutput);
            if (System.currentTimeMillis() <= nextDelta) continue;
            nextDelta = System.currentTimeMillis() + 50L;
            if (progressMonitor.isCanceled()) {
                this.isCancelled = true;
                process.destroy();
                this.closeStreams(errorStream, stdoutStream);
                return;
            }
            try {
                this.fExitValue = process.exitValue();
            }
            catch (IllegalThreadStateException v0) {
                if (System.currentTimeMillis() > timeoutStamp) ** break;
                continue;
                this.isCancelled = true;
                process.destroy();
                this.closeStreams(errorStream, stdoutStream);
                throw new TimeoutException();
            }
            break;
        }
        this.fErrorOutput.append(this.readStream(errorStream));
        this.fStandardOutput.append(this.readStream(stdoutStream));
        this.closeStreams(errorStream, stdoutStream);
    }

    private void closeStreams(InputStream errorStream, InputStream stdoutStream) throws IOException {
        errorStream.close();
        stdoutStream.close();
    }

    private void storeAndPipe(InputStream i, OutputStream o, StringBuilder sb) throws IOException {
        String err = this.readStream(i);
        if (sb != null) {
            sb.append(err);
        }
        if (o != null) {
            o.write(err.getBytes());
        }
    }

    public void pipeStdOutTo(OutputStream stdOutPipe) {
        this.fStdOutPipe = stdOutPipe;
    }

    public void pipeStdErrTo(OutputStream stdErrPipe) {
        this.fStdErrPipe = stdErrPipe;
    }

    public static String[] getEnvp(Map env) {
        Map<?, ?> nativeEnv = DVTBatchUtils.getNativeEnv();
        LinkedHashMap mergedEnv = new LinkedHashMap();
        mergedEnv.putAll(nativeEnv);
        if (env != null) {
            mergedEnv.putAll(env);
        }
        ArrayList<String> strings = new ArrayList<String>(mergedEnv.size());
        StringBuilder buffer = null;
        for (Map.Entry entry : mergedEnv.entrySet()) {
            buffer = new StringBuilder((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public String getErrorOutput() {
        return this.fErrorOutput.toString();
    }

    public String getStandardOutput() {
        return this.fStandardOutput.toString();
    }

    public int getExitValue() {
        return this.fExitValue;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public int getPid() {
        return this.fPid;
    }

    public String getCommandLine() {
        if (this.fCommandLine != null) {
            return this.fCommandLine;
        }
        if (this.fCommandLineArray != null) {
            if (this.fCommandLineArray.length == 0) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            result.append(this.fCommandLineArray[0]);
            int i = 1;
            while (i < this.fCommandLineArray.length) {
                result.append(' ').append(this.fCommandLineArray[i]);
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    private String readStream(InputStream s) throws IOException {
        int available = s.available();
        if (available == 0) {
            return "";
        }
        byte[] result = new byte[available];
        int bytesRead = s.read(result);
        if (bytesRead != available) {
            result = Arrays.copyOfRange(result, 0, bytesRead > 0 ? bytesRead : 0);
        }
        return new String(result);
    }

    public static class TimeoutException
    extends IOException {
        private static final long serialVersionUID = 1L;
    }
}

