/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;

public class DVTProfilingUtils {
    private static final String SYS_INFO_COMMAND = "uname -a";
    private static final String CPU_INFO_COMMAND = "cat /proc/cpuinfo";
    private static final String MEM_INFO_COMMAND = "cat /proc/meminfo";
    private static final String LOAD_INFO_COMMAND = "cat /proc/loadavg";
    private static final String X_VERSION_COMMAND = "X -version";
    private static final int MAX_READ_ATTEMPTS = 200;
    private static final int READ_ATTEMPT_INTERVAL = 100;

    public static long getCpuTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() : 0L;
    }

    public static long getUserTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadUserTime() : 0L;
    }

    public static long getSystemTime() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        return bean.isCurrentThreadCpuTimeSupported() ? bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime() : 0L;
    }

    public static long printGCStats() {
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                // empty if block
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        return garbageCollectionTime;
    }

    public static boolean isUnixOS() {
        String osName = System.getProperty("os.name");
        return osName != null && (osName.toLowerCase().contains("nix") || osName.toLowerCase().contains("nux"));
    }

    public static boolean isWinOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("win");
    }

    public static String cpuInfo() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "CPU Info not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(CPU_INFO_COMMAND);
    }

    public static String memInfo() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "Memory Info not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(MEM_INFO_COMMAND);
    }

    public static String sysInfo() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "System Info not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(SYS_INFO_COMMAND);
    }

    public static String loadInfo() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "Load Info not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(LOAD_INFO_COMMAND);
    }

    public static String XVersion() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "X version not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(X_VERSION_COMMAND);
    }

    public static String dvtOsInformation() {
        if (!DVTProfilingUtils.isUnixOS()) {
            return "dvt_os_information.sh is not available on this OS.";
        }
        return DVTProfilingUtils.getOutputOf(String.valueOf(System.getenv("DVT_HOME")) + "/bin/dvt_os_information.sh");
    }

    private static String getOutputOf(String command) {
        StringBuilder result = new StringBuilder();
        result.append("Output of '" + command + "'\n");
        try {
            Process process = Runtime.getRuntime().exec(command);
            int i = 0;
            while (i < 200) {
                Thread.sleep(100L);
                int avail = process.getInputStream().available();
                byte[] bytes = null;
                int readBytes = 0;
                if (avail != 0) {
                    bytes = new byte[avail];
                    readBytes = process.getInputStream().read(bytes);
                } else {
                    avail = process.getErrorStream().available();
                    bytes = new byte[avail];
                    readBytes = process.getErrorStream().read(bytes);
                }
                if (readBytes != avail) {
                    bytes = Arrays.copyOfRange(bytes, 0, readBytes > 0 ? readBytes : 0);
                }
                result.append(new String(bytes));
                try {
                    if (process.exitValue() != 0) {
                        result.append("\n!!! PROCESS '" + command + "' EXITED WITH RETURN STATUS " + process.exitValue() + " !!!");
                    }
                    break;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (i == 199) {
                        result.append("\n!!! PROCESS '" + command + "' DID NOT TERMINATE IN " + 20000 + "ms !!!");
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            result.append("\n!!! FAILED TO EXECUTE '" + command + "' !!!\n");
        }
        return result.toString();
    }
}

