/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.LinkedList;

public class DVTStringBuilder {
    private LinkedList<String> array = new LinkedList();
    private int size;

    public DVTStringBuilder() {
    }

    public DVTStringBuilder(String str) {
        this();
        this.append(str);
    }

    public DVTStringBuilder(CharSequence seq) {
        this();
        this.append(seq);
    }

    public DVTStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public DVTStringBuilder append(String str) {
        if (str == null || str.isEmpty()) {
            return this;
        }
        this.array.addLast(str);
        this.size += str.length();
        return this;
    }

    public DVTStringBuilder append(StringBuffer sb) {
        this.append(String.valueOf(sb));
        return this;
    }

    public DVTStringBuilder append(CharSequence s) {
        this.append(String.valueOf(s));
        return this;
    }

    public DVTStringBuilder append(CharSequence s, int start, int end) {
        if (s == null) {
            return this;
        }
        if (start < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        StringBuilder sContent = new StringBuilder(len);
        int i = start;
        while (i < end) {
            sContent.append(s.charAt(i));
            ++i;
        }
        this.append(sContent.toString());
        return this;
    }

    public DVTStringBuilder append(char[] str) {
        this.append(String.valueOf(str));
        return this;
    }

    public DVTStringBuilder append(char[] str, int offset, int len) {
        this.append(String.valueOf(str, offset, len));
        return this;
    }

    public DVTStringBuilder append(boolean b) {
        this.append(String.valueOf(b));
        return this;
    }

    public DVTStringBuilder append(char c) {
        this.append(String.valueOf(c));
        return this;
    }

    public DVTStringBuilder append(int i) {
        this.append(String.valueOf(i));
        return this;
    }

    public DVTStringBuilder append(long lng) {
        this.append(String.valueOf(lng));
        return this;
    }

    public DVTStringBuilder append(float f2) {
        this.append(String.valueOf(f2));
        return this;
    }

    public DVTStringBuilder append(double d) {
        this.append(String.valueOf(d));
        return this;
    }

    public DVTStringBuilder prepend(Object obj) {
        this.prepend(String.valueOf(obj));
        return this;
    }

    public DVTStringBuilder prepend(String str) {
        if (str == null || str.isEmpty()) {
            return this;
        }
        this.array.addFirst(str);
        this.size += str.length();
        return this;
    }

    public DVTStringBuilder prepend(char[] str) {
        this.prepend(String.valueOf(str));
        return this;
    }

    public DVTStringBuilder prepend(CharSequence s) {
        this.prepend(String.valueOf(s));
        return this;
    }

    public DVTStringBuilder prepend(CharSequence s, int start, int end) {
        if (s == null) {
            return this;
        }
        if (start < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        StringBuilder sContent = new StringBuilder(len);
        int i = start;
        while (i < end) {
            sContent.append(s.charAt(i));
            ++i;
        }
        this.prepend(sContent.toString());
        return this;
    }

    public DVTStringBuilder prepend(boolean b) {
        this.prepend(String.valueOf(b));
        return this;
    }

    public DVTStringBuilder prepend(char c) {
        this.prepend(String.valueOf(c));
        return this;
    }

    public DVTStringBuilder prepend(int i) {
        this.prepend(String.valueOf(i));
        return this;
    }

    public DVTStringBuilder prepend(long l) {
        this.prepend(String.valueOf(l));
        return this;
    }

    public DVTStringBuilder prepend(float f2) {
        this.prepend(String.valueOf(f2));
        return this;
    }

    public DVTStringBuilder prepend(double d) {
        this.prepend(String.valueOf(d));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.array) {
            sb.append(str);
        }
        return sb.toString();
    }

    public int length() {
        return this.size;
    }

    public char getFirstChar() {
        return this.array.getFirst().charAt(0);
    }

    public char getLastChar() {
        return this.array.getLast().charAt(0);
    }

    public DVTStringBuilder deleteFirstChar() {
        String firstWord = this.array.removeFirst();
        String currentWord = firstWord.substring(1);
        --this.size;
        if (currentWord.isEmpty()) {
            return this;
        }
        this.array.addFirst(currentWord);
        return this;
    }

    public DVTStringBuilder deleteLastChar() {
        String lastWord = this.array.removeLast();
        String currentWord = lastWord.substring(0, lastWord.length() - 1);
        --this.size;
        if (currentWord.isEmpty()) {
            return this;
        }
        this.array.addLast(currentWord);
        return this;
    }

    public void clear() {
        this.array = new LinkedList();
        this.size = 0;
    }
}

