/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.utils.DefaultPhoneticDistanceAlgorithm;
import ro.amiq.dvt.utils.IPhoneticDistanceAlgorithm;
import ro.amiq.dvt.utils.Inflector;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.Utils;

public final class DVTStringUtil {
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String EMPTY_STRING = "";
    public static final String SPACE = " ";
    public static final String FOUR_SPACES = "    ";
    public static final String EQUALS = "=";
    public static final String COLON = ":";
    public static final String LT = "<";
    public static final String GT = ">";
    public static final String HASHTAG = "#";
    public static final Pattern NEW_LINE = Pattern.compile("\r\n|\r|\n");
    public static final Pattern UNICODE_NEW_LINE = Pattern.compile("\\R");
    public static final Pattern TRAILING_NEW_LINE = Pattern.compile("\\R$");
    public static final Pattern LEADING_NEW_LINE = Pattern.compile("^\\R");
    public static final Pattern MULTIPLE_WS = Pattern.compile("\\s+");
    public static final Pattern TRAILING_WS = Pattern.compile("[\\s]+$");
    public static final Pattern WS_LINES = Pattern.compile("^[\\s]+$");
    public static final Pattern COLON_COLON = Pattern.compile("::");
    public static final Pattern APOSTROPHE = Pattern.compile("'");
    public static final Pattern BACKSLASH_DOT = Pattern.compile("\\\\\\.");
    public static final Pattern E_TYPE_LIST_OF = Pattern.compile("list\\s+of\\s+");
    public static final Pattern LINKED_POSITION_PATTERN = Pattern.compile("(\\$\\{)|\\}");
    public static final Pattern TAB = Pattern.compile("\t");
    public static final Pattern COMMA = Pattern.compile(",");
    public static final Pattern BUILD_CONFIG_ARGS_SPLIT_PATTERN = Pattern.compile("\\+");
    public static final Pattern INTEGER_PATTERN = Pattern.compile("[1-9]\\d*");
    public static final Pattern METHOD_ARGS_SEPARATOR = Pattern.compile(", ");
    public static final Pattern SPECIAL_CHARS_PATTERN = Pattern.compile("\\\\([0-7]{3}|x[0-9a-fA-F]{2})");
    public static final Pattern JAVADOC = Pattern.compile("/\\*.*?\\*/", 40);
    public static final Pattern PLUS = Pattern.compile("\\+");
    public static final Pattern TICK_FOLLOWED_BY_WORD = Pattern.compile("`\\w+");
    public static final Pattern STARTING_WS = Pattern.compile("^[\\s]+");
    public static final Pattern SLASHES = Pattern.compile("/+");
    public static final Pattern SINGLE_QUOTE = Pattern.compile("'");
    private static final IPhoneticDistanceAlgorithm distanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    public static final int MATCH_EQUALS = 1;
    public static final int MATCH_PREFIX = 2;
    public static final int MATCH_CAMEL_CASE = 4;
    public static final int MATCH_IGNORE_CASE = 8;
    public static final int MATCH_MIN_DISTANCE = 16;
    public static final int MATCH_LIMIT_100 = 32;
    public static final int MATCH_GETTER_SETTER = 64;
    public static final int MATCH_CHILD_ONLY = 256;
    public static final int MATCH_PARENT_ONLY = 512;
    private static final int START = 0;
    private static final int LOWERCASE_CHAR = 1;
    private static final int UPPERCASE_CHAR = 2;
    private static final int UNDERSORE_CHAR = 3;
    private static final Map<String, Pattern> fPrefixPatternCacheIC = Collections.synchronizedMap(new LRUCache(4));
    private static final Map<String, Pattern> fPrefixPatternCacheCS = Collections.synchronizedMap(new LRUCache(4));
    private static final Pattern fDolarSign = Pattern.compile("\\$");
    private static final Pattern fPrefixSoft = Pattern.compile("(?<=[^_])(?=[A-Z])");
    private static final Pattern fPrefixHard = Pattern.compile("(?<=[^_])_+");
    private static final Map<String, String> fLowercaseStringCache = new LRUCache<String, String>(32);
    private static final Interner<String> fInterner = new Interner(32707);
    private static final Pattern ESCAPE_HTML_1 = Pattern.compile("<(?!b>|/b>|i>|/i>|br>|/br>)");
    private static final Pattern ESCAPE_HTML_2 = Pattern.compile("(?<!<b|</b|<i|</i|<br|</br)>");

    public static final String appendString(Object ... s) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == null) {
                sb.append("null");
            } else {
                sb.append(object.toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    public static final String join(int[] list, String separator) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        int i = 0;
        while (i < list.length) {
            temp.add(list[i]);
            ++i;
        }
        return DVTStringUtil.join(temp, separator);
    }

    public static final String join(byte[] list, String separator) {
        ArrayList<Byte> temp = new ArrayList<Byte>();
        int i = 0;
        while (i < list.length) {
            temp.add(list[i]);
            ++i;
        }
        return DVTStringUtil.join(temp, separator);
    }

    public static final String join(boolean[] list, String separator) {
        ArrayList<Boolean> temp = new ArrayList<Boolean>();
        int i = 0;
        while (i < list.length) {
            temp.add(list[i]);
            ++i;
        }
        return DVTStringUtil.join(temp, separator);
    }

    public static final <T> String join(T[] list, String separator) {
        return DVTStringUtil.join(Arrays.asList(list), separator);
    }

    public static final String join(Iterable<? extends Object> list, String separator) {
        Iterator<? extends Object> iterator;
        if (list == null || !(iterator = list.iterator()).hasNext()) {
            return EMPTY_STRING;
        }
        Object next = iterator.next();
        StringBuilder result = new StringBuilder(next == null ? EMPTY_STRING : next.toString());
        while (iterator.hasNext()) {
            result.append(separator).append(iterator.next());
        }
        return result.toString();
    }

    public static final String join(Stream<? extends Object> list, String separator) {
        Iterator iterator;
        if (list == null || !(iterator = list.iterator()).hasNext()) {
            return EMPTY_STRING;
        }
        StringBuilder result = new StringBuilder(iterator.next().toString());
        while (iterator.hasNext()) {
            result.append(separator).append(iterator.next());
        }
        return result.toString();
    }

    public static final String[] split(String pattern, String input) {
        ArrayList<String> result = new ArrayList<String>();
        int currIndex = input.indexOf(pattern);
        int prevIndex = 0;
        while (currIndex >= 0) {
            result.add(input.substring(prevIndex, currIndex));
            prevIndex = currIndex + pattern.length();
            currIndex = input.indexOf(pattern, prevIndex);
        }
        if (prevIndex >= 0 && prevIndex < input.length()) {
            result.add(input.substring(prevIndex));
        }
        return result.toArray(new String[result.size()]);
    }

    public static final String[] splitHierarhicalString(String input) {
        ArrayList<String> result = new ArrayList<String>();
        int oppenBracketIndex = input.indexOf("[");
        if (oppenBracketIndex == -1) {
            return DVTStringUtil.split(".", input);
        }
        int nested = 0;
        StringBuilder currentStr = new StringBuilder(EMPTY_STRING);
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch == '[') {
                ++nested;
            }
            if (ch == ']') {
                --nested;
            }
            if (ch == '.' && nested == 0) {
                result.add(currentStr.toString().trim());
                currentStr = new StringBuilder(EMPTY_STRING);
            } else {
                currentStr.append(ch);
            }
            ++i;
        }
        result.add(currentStr.toString().trim());
        return result.toArray(new String[result.size()]);
    }

    public static final StringBuilder textWrap(int lineLength, String text) {
        StringBuilder wrapped = new StringBuilder();
        if (text != null) {
            String[] chunks = MULTIPLE_WS.split(text);
            int threshold = 0;
            int i = 0;
            while (i < chunks.length) {
                if ((threshold += chunks[i].length()) > lineLength) {
                    if (i != 0) {
                        wrapped.append('\n');
                    }
                    threshold = chunks[i].length();
                }
                wrapped.append(chunks[i]).append(' ');
                ++i;
            }
        }
        return wrapped;
    }

    public static final List<String> extractArrayIndices(String input) {
        int startIndex = input.indexOf(91);
        if (startIndex == -1) {
            return null;
        }
        ArrayList<String> indices = new ArrayList<String>();
        int nested = 1;
        StringBuilder currentIndex = new StringBuilder(EMPTY_STRING);
        int i = startIndex + 1;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch == ']' && nested == 1) {
                indices.add(currentIndex.toString().trim());
                --nested;
            } else if (ch == '[' && nested == 0) {
                ++nested;
                currentIndex = new StringBuilder(EMPTY_STRING);
            } else {
                if (ch == '[') {
                    ++nested;
                }
                if (ch == ']') {
                    --nested;
                }
                currentIndex.append(ch);
            }
            ++i;
        }
        return indices;
    }

    /*
     * Unable to fully structure code
     */
    public static final StringBuilder textWrap2(int lineLength, String text) {
        block3: {
            wrapped = new StringBuilder();
            if (text == null) break block3;
            chunks = DVTStringUtil.MULTIPLE_WS.split(text);
            threshold = 0;
            i = 0;
            while (i < chunks.length) {
                block4: {
                    chunk = chunks[i];
                    if (threshold + chunk.length() <= lineLength) ** GOTO lbl27
                    wrapped.append('\n');
                    while (chunk.length() > lineLength) {
                        wrapped.append(chunk.substring(0, lineLength));
                        wrapped.append('\n');
                        chunk = chunk.substring(lineLength);
                    }
                    wrapped.append(chunk).append(' ');
                    threshold = chunk.length();
                    break block4;
lbl-1000:
                    // 1 sources

                    {
                        wrapped.append(chunk.substring(0, lineLength));
                        wrapped.append('\n');
                        chunk = chunk.substring(lineLength);
lbl27:
                        // 2 sources

                        ** while (chunk.length() > lineLength)
                    }
lbl28:
                    // 1 sources

                    wrapped.append(chunk).append(' ');
                    threshold += chunk.length();
                }
                ++i;
            }
        }
        return wrapped;
    }

    public static final StringBuilder textWrapOnWhitespace(int breakAfter, String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int i = 0;
        while (i < text.length()) {
            ++counter;
            if (text.charAt(i) == '\n' || text.charAt(i) == '\r') {
                counter = 0;
            }
            if (counter >= breakAfter && Character.isWhitespace(text.charAt(i))) {
                sb.append('\n');
                counter = 0;
            }
            sb.append(text.charAt(i));
            ++i;
        }
        return sb;
    }

    public static final String breakLongNonWhitespaceSequences(String text, int breakAfter, char breakWith) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int counter = 0;
        int i = 0;
        while (i < text.length()) {
            ++counter;
            if (Character.isWhitespace(text.charAt(i))) {
                counter = 0;
            }
            if (i >= 4 && "<br>".equals(text.substring(i - 4, i))) {
                counter = 0;
            }
            if (counter >= breakAfter) {
                sb.append(breakWith);
                counter = 0;
            }
            sb.append(text.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static final int getCamelCaseIndex(String proposal, String prefix, boolean caseSensitive) {
        String workingPrefix = prefix;
        String workingProposal = proposal;
        int initialProposalIndex = 0;
        int prefixMatchingScore = -1;
        int tokensCountBeforePrefixMatching = 0;
        if (!caseSensitive) {
            workingProposal = workingProposal.toLowerCase();
            workingPrefix = workingPrefix.toLowerCase();
        }
        if (!Character.isUpperCase(workingProposal.charAt(0)) && proposal.charAt(0) != '_') {
            prefixMatchingScore = DVTStringUtil.getScoreForCurrentIndex(workingProposal, workingPrefix);
            if (prefixMatchingScore > -1) {
                return prefixMatchingScore;
            }
            ++tokensCountBeforePrefixMatching;
            initialProposalIndex = 1;
        }
        int matchStartingIndex = initialProposalIndex;
        while (matchStartingIndex < workingProposal.length()) {
            if (DVTStringUtil.isBeginningOfToken(matchStartingIndex, proposal)) {
                int proposalPadding = workingProposal.charAt(matchStartingIndex) == '_' ? 1 : 0;
                prefixMatchingScore = DVTStringUtil.getScoreForCurrentIndex(workingProposal.substring(matchStartingIndex + proposalPadding), workingPrefix);
                if (prefixMatchingScore > -1) {
                    return prefixMatchingScore + tokensCountBeforePrefixMatching;
                }
                ++tokensCountBeforePrefixMatching;
            }
            ++matchStartingIndex;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static final int getScoreForCurrentIndex(String proposal, String prefix) {
        lowercaseProposal = proposal.toLowerCase();
        lowercasePrefix = prefix.toLowerCase();
        if (lowercaseProposal.charAt(0) != lowercasePrefix.charAt(0)) {
            return -1;
        }
        score = 0;
        prefixIndex = 0;
        initialProposalIndex = 0;
        if (!Character.isUpperCase(proposal.charAt(0)) && proposal.charAt(0) != '_') {
            score += DVTStringUtil.calculateScoreFor(proposal.charAt(0), prefix.charAt(0));
            prefixIndex = 1;
            initialProposalIndex = 1;
        }
        proposalIndex = initialProposalIndex;
        while (proposalIndex < proposal.length()) {
            if (prefixIndex == prefix.length()) {
                return score;
            }
            if (proposal.charAt(proposalIndex) == '_') {
                if (proposalIndex + 1 >= proposal.length() || proposal.charAt(proposalIndex + 1) != '_') {
                    if (prefix.charAt(prefixIndex) != '_') {
                        ++score;
                    }
                    if (proposalIndex + 1 == proposal.length()) {
                        prefixIndex = DVTStringUtil.consumeUnderline(prefix, prefixIndex);
                        break;
                    } else {
                        ** GOTO lbl-1000
                    }
                }
            } else if (DVTStringUtil.isBeginningOfToken(proposalIndex, proposal)) {
                proposalPadding = proposal.charAt(proposalIndex) == '_' ? 1 : 0;
                prefixPadding = DVTStringUtil.consumeUnderline(prefix, prefixIndex) - prefixIndex;
                if (prefixPadding > 0 && proposalPadding == 0 && !DVTStringUtil.lastCharIsSkippedUnderline(proposal, proposalIndex)) {
                    ++score;
                }
                if (prefixIndex + prefixPadding == prefix.length()) {
                    return score;
                }
                if (lowercaseProposal.charAt(proposalIndex += proposalPadding) != lowercasePrefix.charAt(prefixIndex += prefixPadding)) {
                    return -1;
                }
                score += DVTStringUtil.calculateScoreFor(proposal.charAt(proposalIndex), prefix.charAt(prefixIndex));
                ++prefixIndex;
            } else if (proposal.charAt(proposalIndex) == prefix.charAt(prefixIndex)) {
                ++prefixIndex;
            } else if (Character.isLowerCase(prefix.charAt(prefixIndex))) {
                return -1;
            }
            ++proposalIndex;
        }
        if (prefixIndex < prefix.length()) {
            return -1;
        }
        return score;
    }

    private static final boolean lastCharIsSkippedUnderline(String proposal, int proposalIndex) {
        return Character.isUpperCase(proposal.charAt(proposalIndex)) && proposalIndex > 0 && proposal.charAt(proposalIndex - 1) == '_';
    }

    private static final int consumeUnderline(String prefix, int index) {
        int i = index;
        while (i < prefix.length()) {
            if (prefix.charAt(i) != '_') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static final int calculateScoreFor(char proposalCharacter, char prefixCharacter) {
        return proposalCharacter == prefixCharacter ? 0 : 1;
    }

    private static final boolean isBeginningOfToken(int proposalIndex, String workingProposal) {
        return Character.isUpperCase(workingProposal.charAt(proposalIndex)) || proposalIndex + 1 < workingProposal.length() && workingProposal.charAt(proposalIndex) == '_' && !Character.isUpperCase(workingProposal.charAt(proposalIndex + 1)) && workingProposal.charAt(proposalIndex + 1) != '_';
    }

    public static final boolean regionMatches(String name, String prefix, int matchType) {
        boolean result;
        boolean ignoreCase = (matchType & 8) != 0;
        int prefixLength = prefix.length();
        int DISTANCE_THRESHOLD = DVTStringUtil.getWordDistanceThreshold(prefix);
        if ((matchType & 0x10) != 0) {
            int dist = distanceAlgorithm.getDistance(prefix, name);
            if (dist < DISTANCE_THRESHOLD) {
                return true;
            }
            if ((matchType & 0x40) != 0) {
                dist = distanceAlgorithm.getDistance("get" + prefix, name);
                if (dist < DISTANCE_THRESHOLD) {
                    return true;
                }
                dist = distanceAlgorithm.getDistance("get_" + prefix, name);
                if (dist < DISTANCE_THRESHOLD) {
                    return true;
                }
            }
            return false;
        }
        if ((matchType & 1) != 0) {
            int length = Math.max(name.length(), prefixLength);
            return name.regionMatches(ignoreCase, 0, prefix, 0, length);
        }
        if (prefixLength == 0) {
            return true;
        }
        if ((matchType & 2) != 0 && (result = name.regionMatches(ignoreCase, 0, prefix, 0, prefixLength))) {
            return result;
        }
        if ((matchType & 4) != 0) {
            if (name.isEmpty()) {
                return false;
            }
            CharSequence name2 = DVTStringUtil.transformFast(name, ignoreCase);
            Matcher m = DVTStringUtil.getCachedPrefixPattern(prefix, ignoreCase).matcher(name2);
            if (m.find()) {
                return true;
            }
        }
        return false;
    }

    private static final CharSequence transformFast(String name, boolean toLowerCase) {
        StringBuilder result = new StringBuilder("@");
        int length = name.length();
        int state = 0;
        int pstate = 0;
        boolean plowerCase = false;
        int i = 0;
        while (i < length) {
            char ch = name.charAt(i);
            char resultCh = toLowerCase ? Character.toLowerCase(ch) : ch;
            boolean lowerCase = Character.isLowerCase(ch);
            boolean isDigit = Character.isDigit(ch);
            switch (state) {
                case 0: {
                    if (ch == '_') {
                        result.append(resultCh);
                        break;
                    }
                    if (lowerCase || isDigit) {
                        result.append(resultCh);
                        pstate = state;
                        state = 1;
                        break;
                    }
                    result.append(resultCh);
                    pstate = state;
                    state = 2;
                    break;
                }
                case 1: {
                    if (ch == '_') {
                        result.append('@');
                        pstate = state;
                        state = 3;
                        break;
                    }
                    if (lowerCase || isDigit) {
                        result.append(resultCh);
                        pstate = state;
                        state = 1;
                        break;
                    }
                    result.append('@');
                    result.append(resultCh);
                    pstate = state;
                    state = 2;
                    break;
                }
                case 2: {
                    if (pstate == 2 && !plowerCase && lowerCase) {
                        result.insert(result.length() - 1, '@');
                        result.append(ch);
                        pstate = state;
                        state = 1;
                        break;
                    }
                    if (ch == '_') {
                        result.append('@');
                        pstate = state;
                        state = 3;
                        break;
                    }
                    if (lowerCase || isDigit) {
                        result.append(resultCh);
                        pstate = state;
                        state = 1;
                        break;
                    }
                    result.append(resultCh);
                    pstate = state;
                    state = 2;
                    break;
                }
                case 3: {
                    if (ch == '_') {
                        pstate = state;
                        state = 3;
                        break;
                    }
                    if (lowerCase || isDigit) {
                        result.append(resultCh);
                        pstate = state;
                        state = 1;
                        break;
                    }
                    result.append(resultCh);
                    pstate = state;
                    state = 2;
                    break;
                }
            }
            plowerCase = lowerCase;
            ++i;
        }
        return result;
    }

    private static final Pattern getCachedPrefixPattern(String prefix, boolean ignoreCase) {
        Map<String, Pattern> cache = ignoreCase ? fPrefixPatternCacheIC : fPrefixPatternCacheCS;
        Pattern temp = cache.get(prefix);
        if (temp == null) {
            String prefixFilling = ignoreCase ? "[a-z0-9]*" : "[A-Za-z0-9]*";
            String prefix2 = fDolarSign.matcher(prefix).replaceAll("\\\\\\$");
            prefix2 = fPrefixSoft.matcher(prefix2).replaceAll(String.valueOf(prefixFilling) + "@?");
            prefix2 = fPrefixHard.matcher(prefix2).replaceAll(String.valueOf(prefixFilling) + "@");
            prefix2 = "@" + prefix2;
            if (ignoreCase) {
                prefix2 = prefix2.toLowerCase();
            }
            temp = Pattern.compile(prefix2);
            cache.put(prefix, temp);
        }
        return temp;
    }

    public static final String makeIndent(String zeroIndent, String indent, int level) {
        int i = 0;
        while (i < level) {
            zeroIndent = zeroIndent.concat(indent);
            ++i;
        }
        return zeroIndent;
    }

    public static final String streamToString(InputStream is) {
        if (is == null) {
            return null;
        }
        char[] buf = new char[4096];
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int rsz;
            while ((rsz = ((Reader)in).read(buf, 0, buf.length)) >= 0) {
                sb.append(buf, 0, rsz);
            }
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public static final byte[] md5sum(String string) {
        if (string == null) {
            return null;
        }
        byte[] md5 = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md5 = md.digest(string.getBytes(StandardCharsets.UTF_8));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        return md5;
    }

    public static final String bytes2hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return sb.toString();
    }

    public static final boolean isNumber(String value) {
        if (value.isEmpty()) {
            return false;
        }
        boolean hasDigits = false;
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if ((i != 0 || ch != '-') && ch != '_') {
                if (!Character.isDigit(ch)) {
                    return false;
                }
                hasDigits = true;
            }
            ++i;
        }
        return hasDigits;
    }

    public static final String quote(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                sb.append('\\');
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public static final String toTitleCase(String text) {
        if (text == null) {
            return text;
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean capitalizeNext = true;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(Character.toLowerCase(ch));
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String toNiceTitleCase(String text) {
        if (text == null) {
            return text;
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        boolean capitalizeNext = true;
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (Character.isWhitespace(ch) || ch == '_') {
                buffer.append(' ');
                capitalizeNext = true;
            } else if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
            } else {
                buffer.append(Character.toLowerCase(ch));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static final String unescapeIdentifier(String name, boolean intern) {
        if (name == null) {
            return null;
        }
        String result = name;
        if (name.length() > 0 && name.charAt(name.length() - 1) == '\ufff0') {
            result = name.substring(1, name.length() - 1);
        }
        return intern ? DVTStringUtil.intern(result) : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String toLowerCase(String mixedCaseName) {
        if (mixedCaseName == null || mixedCaseName.isEmpty()) {
            return mixedCaseName;
        }
        Map<String, String> map = fLowercaseStringCache;
        synchronized (map) {
            String lowerCaseName = fLowercaseStringCache.get(mixedCaseName);
            if (lowerCaseName != null) {
                return lowerCaseName;
            }
            lowerCaseName = mixedCaseName.toLowerCase();
            fLowercaseStringCache.put(mixedCaseName, lowerCaseName);
            fLowercaseStringCache.put(lowerCaseName, lowerCaseName);
            return lowerCaseName;
        }
    }

    public static final String intern(String name) {
        if (name == null) {
            return null;
        }
        return fInterner.intern(name);
    }

    public static int parseInt(String text, int defaultValue) {
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        int result = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            if (ch != '.' && ch != ',' && ch != '_') {
                if (ch < '0' || ch > '9') {
                    return defaultValue;
                }
                result = result * 10 + (ch - 48);
            }
            ++i;
        }
        return result;
    }

    public static final Number parseNumberVLOG(String text, Number defaultValue, boolean replaceWildcardValues) {
        if (text == null) {
            return defaultValue;
        }
        int length = text.length();
        StringBuilder number = new StringBuilder(length);
        boolean tickAlreadyFound = false;
        int numberBase = 10;
        try {
            int i = 0;
            while (i < length) {
                char currChar = text.charAt(i);
                if (currChar == '.') {
                    return Float.valueOf(Float.MAX_VALUE);
                }
                if (currChar != '_') {
                    if (currChar == '\'') {
                        tickAlreadyFound = true;
                        number.setLength(0);
                        if (i + 1 >= length) {
                            return defaultValue;
                        }
                        char first = text.charAt(i + 1);
                        if (Character.isAlphabetic(first)) {
                            char baseChar = first;
                            ++i;
                            if (first == 's' || first == 'S') {
                                if (i + 1 >= length) {
                                    return defaultValue;
                                }
                                baseChar = text.charAt(i + 1);
                                ++i;
                            }
                            if ((numberBase = DVTStringUtil.numberBaseVLOG(baseChar)) <= 0) {
                                return defaultValue;
                            }
                        }
                        first = text.charAt(i + 1);
                        while (Character.isWhitespace(first)) {
                            if (++i + 1 >= length) {
                                return defaultValue;
                            }
                            first = text.charAt(i + 1);
                        }
                    } else if (Character.isDigit(currChar)) {
                        number.append(currChar);
                    } else if (currChar == 'X' || currChar == 'x' || currChar == 'z' || currChar == 'Z' || currChar == '?') {
                        if (!replaceWildcardValues) {
                            return defaultValue;
                        }
                        if (numberBase == 10) {
                            return defaultValue;
                        }
                        number.append(DVTStringUtil.getMaxDigitOfNumberBase(numberBase));
                    } else {
                        if (!tickAlreadyFound || numberBase != 16) {
                            if (Character.toLowerCase(currChar) == 'e') {
                                return Float.valueOf(Float.MAX_VALUE);
                            }
                            return defaultValue;
                        }
                        number.append(currChar);
                    }
                }
                ++i;
            }
            if (number.length() == 0) {
                return defaultValue;
            }
            switch (numberBase) {
                case 2: 
                case 8: 
                case 10: 
                case 16: {
                    return new BigInteger(number.toString(), numberBase);
                }
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static final Number parseNumberVHDL(String text, Number defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        return text.endsWith("\"") ? (Number)DVTStringUtil.parseNumberBitLiteralVHDL(text, defaultValue) : (Number)DVTStringUtil.parseNumberDecimalLiteralVHDL(text, defaultValue);
    }

    private static final Number parseNumberDecimalLiteralVHDL(String text, Number defaultValue) {
        StringBuilder number = new StringBuilder();
        StringBuilder exponent = new StringBuilder();
        int nofTags = 0;
        int numberBase = 10;
        try {
            int exponentNumber;
            int length = text.length();
            int i = 0;
            while (i < length) {
                char currChar = text.charAt(i);
                if (currChar == '.') {
                    return Float.valueOf(Float.MAX_VALUE);
                }
                if (currChar != '_') {
                    if (currChar == '#') {
                        if (++nofTags == 1) {
                            String base = number.toString();
                            number.setLength(0);
                            numberBase = Integer.parseInt(base);
                            if (2 > numberBase || numberBase > 16) {
                                return defaultValue;
                            }
                        }
                        if (nofTags == 2 && i + 1 < length) {
                            char first = text.charAt(i + 1);
                            if (first != 'e' && first != 'E') {
                                return defaultValue;
                            }
                            if (++i + 1 >= length) {
                                return defaultValue;
                            }
                            char second = text.charAt(i + 1);
                            if (second == '-') {
                                return Float.valueOf(Float.MAX_VALUE);
                            }
                            if (second == '+') {
                                ++i;
                            }
                        }
                    } else if (Character.isDigit(currChar)) {
                        if (nofTags == 2) {
                            exponent.append(currChar);
                        } else {
                            number.append(currChar);
                        }
                    } else {
                        if (nofTags == 2) {
                            return defaultValue;
                        }
                        if (!DVTStringUtil.isValidNumberBaseChar(Character.valueOf(currChar), numberBase)) {
                            return defaultValue;
                        }
                        number.append(currChar);
                    }
                }
                ++i;
            }
            BigInteger exponentCorrection = null;
            if (exponent.length() > 0 && (exponentNumber = Integer.parseInt(exponent.toString())) > 0) {
                exponentCorrection = BigDecimal.valueOf(Math.pow(numberBase, exponentNumber)).toBigInteger();
            }
            if (number.length() == 0) {
                return defaultValue;
            }
            BigInteger numberObject = new BigInteger(number.toString(), numberBase);
            return exponentCorrection != null ? numberObject.multiply(exponentCorrection) : numberObject;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    private static final Number parseNumberBitLiteralVHDL(String text, Number defaultValue) {
        if (text == null || !text.endsWith("\"")) {
            return defaultValue;
        }
        int length = text.length();
        StringBuilder number = new StringBuilder(length);
        int nofQuotes = 0;
        int numberBase = 10;
        try {
            int i = 0;
            while (i < length) {
                char currChar = text.charAt(i);
                if (currChar != '_') {
                    if (currChar == '\"') {
                        if (++nofQuotes == 2) {
                            break;
                        }
                    } else if (Character.isDigit(currChar)) {
                        if (nofQuotes >= 1) {
                            number.append(currChar);
                        }
                    } else if (nofQuotes == 0) {
                        if (!Character.isAlphabetic(currChar)) {
                            return defaultValue;
                        }
                        char baseChar = currChar;
                        if (currChar == 'U' || currChar == 'u' || currChar == 's' || currChar == 'S') {
                            if (i + 1 > length) {
                                return defaultValue;
                            }
                            char first = text.charAt(i + 1);
                            if (Character.isAlphabetic(first)) {
                                baseChar = first;
                                ++i;
                            }
                        }
                        if ((numberBase = DVTStringUtil.numberBaseVHDL(baseChar)) < 0) {
                            return defaultValue;
                        }
                    } else {
                        if (!DVTStringUtil.isValidNumberBaseChar(Character.valueOf(currChar), numberBase)) {
                            return defaultValue;
                        }
                        number.append(currChar);
                    }
                }
                ++i;
            }
            if (number.length() == 0) {
                return defaultValue;
            }
            return new BigInteger(number.toString(), numberBase);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static final int numberBaseVLOG(char baseChar) {
        switch (baseChar) {
            case 'B': 
            case 'b': {
                return 2;
            }
            case 'O': 
            case 'o': {
                return 8;
            }
            case 'D': 
            case 'd': {
                return 10;
            }
            case 'H': 
            case 'h': {
                return 16;
            }
        }
        return -1;
    }

    public static final int numberBaseVHDL(char baseChar) {
        switch (baseChar) {
            case 'B': 
            case 'b': {
                return 2;
            }
            case 'O': 
            case 'o': {
                return 8;
            }
            case 'D': 
            case 'd': {
                return 10;
            }
            case 'X': 
            case 'x': {
                return 16;
            }
        }
        return -1;
    }

    public static final boolean isValidNumberBaseChar(Character c, int numberBase) {
        boolean isValid = false;
        switch (numberBase) {
            case 16: {
                isValid |= c.charValue() == 'F' || c.charValue() == 'f';
            }
            case 15: {
                isValid |= c.charValue() == 'E' || c.charValue() == 'e';
            }
            case 14: {
                isValid |= c.charValue() == 'D' || c.charValue() == 'd';
            }
            case 13: {
                isValid |= c.charValue() == 'C' || c.charValue() == 'c';
            }
            case 12: {
                isValid |= c.charValue() == 'B' || c.charValue() == 'b';
            }
            case 11: {
                isValid |= c.charValue() == 'A' || c.charValue() == 'a';
            }
        }
        return isValid;
    }

    public static final String getMaxDigitOfNumberBase(int numberBase) {
        switch (numberBase) {
            case 2: {
                return "1";
            }
            case 8: {
                return "7";
            }
            case 16: {
                return "F";
            }
        }
        return EMPTY_STRING;
    }

    public static boolean isIdentifier(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < text.length()) {
            if (!Character.isJavaIdentifierPart(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String escapeRegex(String str) {
        if (str == null || str.isEmpty()) {
            return EMPTY_STRING;
        }
        return str.replace("\\", "\\\\").replace(".", "\\.");
    }

    public static final String escapeXMLString(String str, boolean includingWS) {
        if (str == null) {
            return EMPTY_STRING;
        }
        str = StringUtils.replace((String)str, (String)"&", (String)"&amp;");
        str = StringUtils.replace((String)str, (String)"\"", (String)"&quot;");
        str = StringUtils.replace((String)str, (String)LT, (String)"&lt;");
        str = StringUtils.replace((String)str, (String)GT, (String)"&gt;");
        if (includingWS) {
            str = StringUtils.replace((String)str, (String)"\t", (String)"&#9;");
            str = StringUtils.replace((String)str, (String)"\n", (String)"&#10;");
            str = StringUtils.replace((String)str, (String)"\r", (String)"&#13;");
        }
        return str;
    }

    public static final String unescapeXMLString(String str, boolean includingWS) {
        if (str == null) {
            return null;
        }
        if (includingWS) {
            str = StringUtils.replace((String)str, (String)"&#13;", (String)"\r");
            str = StringUtils.replace((String)str, (String)"&#10;", (String)"\n");
            str = StringUtils.replace((String)str, (String)"&#9;", (String)"\t");
        }
        str = StringUtils.replace((String)str, (String)"&gt;", (String)GT);
        str = StringUtils.replace((String)str, (String)"&lt;", (String)LT);
        str = StringUtils.replace((String)str, (String)"&quot;", (String)"\"");
        str = StringUtils.replace((String)str, (String)"&amp;", (String)"&");
        return str;
    }

    public static final String translatePathPatternToLinuxPattern(String pathPattern) {
        if (pathPattern == null || pathPattern.isEmpty()) {
            return pathPattern;
        }
        pathPattern = Utils.canonicPath(pathPattern);
        pathPattern = pathPattern.replace('\\', '/');
        return pathPattern;
    }

    public static final String translatePathPatternToOSPattern(String pathPattern) {
        if (pathPattern == null || pathPattern.isEmpty()) {
            return pathPattern;
        }
        pathPattern = pathPattern.replace('\\', File.separatorChar);
        pathPattern = pathPattern.replace('/', File.separatorChar);
        return pathPattern;
    }

    public static final String removeTicks(String description) {
        if (description == null || description.length() < 2) {
            return null;
        }
        if (description.charAt(0) == '\'' && description.charAt(description.length() - 1) == '\'') {
            return description.substring(1, description.length() - 1);
        }
        return description;
    }

    public static final int getRelevantDistance(String distanceTo, String word) {
        int threshold;
        int distance = distanceAlgorithm.getDistance(word, distanceTo);
        if (distance > (threshold = DVTStringUtil.getWordDistanceThreshold(distanceTo))) {
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    public static final int getWordDistanceThreshold(String word) {
        return word.length() == 1 ? 100 : word.length() * 100 / 2;
    }

    public static final String trimNumberOfWhitespacesFromBeginningOfString(String string, int trimLength) {
        if (trimLength == 0) {
            return string;
        }
        if (string.isEmpty()) {
            return string;
        }
        char[] text = string.toCharArray();
        int i = 0;
        while (i < text.length) {
            char chr = text[i];
            if (Character.isWhitespace(chr) && i < trimLength) {
                ++i;
                continue;
            }
            if (!Character.isWhitespace(chr) || i >= trimLength) break;
            ++i;
        }
        return string.substring(i, string.length());
    }

    public static final String concatMethodsSignatures(List<String> methodSignatures, String enclosingContainerIndent, String indent, String lineDelimiter, boolean addLineDelimitatorOnFirstLine, boolean indentFirstLine) {
        String result = EMPTY_STRING;
        int i = 0;
        while (i < methodSignatures.size()) {
            String signature = methodSignatures.get(i);
            String[] lines = signature.split(lineDelimiter);
            int j = 0;
            while (j < lines.length) {
                if (i == 0 && j == 0) {
                    if (indentFirstLine) {
                        result = DVTStringUtil.appendString(indent, result);
                    }
                    if (addLineDelimitatorOnFirstLine) {
                        result = DVTStringUtil.appendString(lineDelimiter, result);
                    }
                    result = DVTStringUtil.appendString(result, lines[j], lineDelimiter);
                } else {
                    result = DVTStringUtil.appendString(result, indent, lines[j], lineDelimiter);
                }
                ++j;
            }
            result = DVTStringUtil.appendString(result, lineDelimiter);
            ++i;
        }
        return DVTStringUtil.appendString(result, enclosingContainerIndent);
    }

    public static final String padMessage(String message, int totalLength) {
        int length = message.length();
        if (length > totalLength) {
            return message;
        }
        StringBuilder result = new StringBuilder(message);
        int i = 0;
        while (i < totalLength - length) {
            result.append(' ');
            ++i;
        }
        return result.toString();
    }

    public static final String partiallyEscapeHTML(String input) {
        if (input == null) {
            return EMPTY_STRING;
        }
        String result = input.replace("\r\n", "<br>").replace("\n", "<br>").replace("\r", "<br>");
        result = DVTStringUtil.replaceAll(ESCAPE_HTML_1, result, "&lt;");
        result = DVTStringUtil.replaceAll(ESCAPE_HTML_2, result, "&gt;");
        return result;
    }

    public static final String replace(String input, String sequence, String replacement, boolean checkWordBoundaries) {
        StringBuilder result = new StringBuilder();
        int start = 0;
        int end = input.length();
        int index = 0;
        int sequenceLength = sequence.length();
        while ((index = input.indexOf(sequence, start)) >= 0) {
            end = index;
            if (!(!checkWordBoundaries || start != 0 && Character.isJavaIdentifierPart(input.charAt(start - 1)) || index + sequenceLength != input.length() && Character.isJavaIdentifierPart(input.charAt(index + sequenceLength)))) {
                result.append(input.substring(start, end)).append(replacement);
            }
            start = index + sequenceLength;
        }
        if (start == 0) {
            return input;
        }
        result.append(input.substring(start));
        return result.toString();
    }

    public static final String collapseWhitespaces(String input) {
        StringBuilder result = new StringBuilder();
        boolean previousWhitespace = false;
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (!Character.isWhitespace(ch)) {
                previousWhitespace = false;
                result.append(ch);
            } else if (result.length() > 0 && !previousWhitespace) {
                result.append(' ');
                previousWhitespace = true;
            }
            ++i;
        }
        if (previousWhitespace) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public static final String getFirstIdentifier(String input) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (result.length() != 0) {
                    return result.toString();
                }
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static final String removeNewLines(String input, String tail) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        int lastWsIndex = 0;
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (result.length() != 0 || !Character.isWhitespace(ch)) {
                if (Character.isWhitespace(ch)) {
                    lastWsIndex = result.length();
                    result.append(' ');
                } else {
                    result.append(ch);
                    lastWsIndex = result.length();
                }
            }
            ++i;
        }
        if (lastWsIndex > 0 && lastWsIndex < result.length()) {
            result.delete(lastWsIndex, result.length());
        }
        if (tail != null) {
            result.append(tail);
        }
        return result.toString();
    }

    public static String replace(String input, String[] sequences, String replacement, boolean[] hasReplacement) {
        StringBuilder result = new StringBuilder();
        int argsLength = input.length();
        int seqsLength = sequences.length;
        int i = 0;
        while (i < argsLength) {
            char ch = input.charAt(i);
            int resultLength = result.length();
            if (Character.isWhitespace(ch)) {
                if (result.charAt(resultLength - 1) != ' ') {
                    result.append(' ');
                }
            } else {
                result.append(ch);
                resultLength = result.length();
                int j = 0;
                while (j < seqsLength) {
                    String sequence = sequences[j];
                    int seqLength = sequence.length();
                    if (resultLength >= seqLength && DVTStringUtil.regionMatches(sequence, result, resultLength - seqLength, resultLength)) {
                        result.delete(resultLength - seqLength, resultLength);
                        result.append(replacement);
                        hasReplacement[0] = hasReplacement[0] | true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toString();
    }

    private static boolean regionMatches(String sequence, StringBuilder input, int start, int end) {
        if (sequence.length() != end - start) {
            return false;
        }
        int i = start;
        while (i < end) {
            char ch2;
            char ch1 = input.charAt(i);
            if (ch1 != (ch2 = sequence.charAt(i - start))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String capitalizeFirstLetter(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static int matchFirstKMP(String substringToSearch, String string, int startIndex) {
        List<Integer> result = DVTStringUtil.matchKMP(substringToSearch, string, startIndex, true);
        if (result == null || result.isEmpty()) {
            return -1;
        }
        return result.get(0);
    }

    private static List<Integer> matchKMP(String substringToSearch, String string, int startIndex, boolean stopOnFirst) {
        int stringLength;
        if (substringToSearch == null || string == null) {
            return null;
        }
        int substringLength = substringToSearch.length();
        if (substringLength > (stringLength = string.length()) || substringLength == 0) {
            return null;
        }
        int[] lps = DVTStringUtil.buildLPSArray(substringToSearch);
        if (lps == null) {
            return null;
        }
        int stringIndex = startIndex;
        int substringIndex = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        while (stringIndex < stringLength) {
            if (substringToSearch.charAt(substringIndex) == string.charAt(stringIndex)) {
                ++stringIndex;
                if (++substringIndex != substringLength) continue;
                indexes.add(stringIndex - substringIndex);
                if (stopOnFirst) break;
                substringIndex = lps[substringIndex - 1];
                continue;
            }
            if (substringIndex == 0) {
                ++stringIndex;
                continue;
            }
            substringIndex = lps[substringIndex - 1];
        }
        return indexes;
    }

    private static int[] buildLPSArray(String substringToSearch) {
        if (substringToSearch == null) {
            return null;
        }
        int sequenceLength = substringToSearch.length();
        if (sequenceLength == 0) {
            return null;
        }
        int[] lps = new int[sequenceLength];
        lps[0] = 0;
        int previousLPSLength = 0;
        int currIndex = 1;
        while (currIndex < sequenceLength) {
            if (substringToSearch.charAt(currIndex) == substringToSearch.charAt(previousLPSLength)) {
                lps[currIndex++] = ++previousLPSLength;
                continue;
            }
            if (previousLPSLength == 0) {
                lps[currIndex++] = 0;
                continue;
            }
            previousLPSLength = lps[previousLPSLength - 1];
        }
        return lps;
    }

    public static String unindentLinesToLevel(String input, String separator) {
        String[] lines;
        if (input == null) {
            return null;
        }
        int minIndent = Integer.MAX_VALUE;
        String[] stringArray = lines = input.split(separator);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!line.trim().isEmpty()) {
                minIndent = Math.min(minIndent, DVTStringUtil.countLeadingWhitespaces(line));
            }
            ++n2;
        }
        ArrayList<String> newLines = new ArrayList<String>();
        String[] stringArray2 = lines;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            String line = stringArray2[n];
            newLines.add(DVTStringUtil.trimLeadingWhitespaces(line, minIndent));
            ++n;
        }
        return StringUtils.join(newLines, (String)separator);
    }

    public static int countLeadingWhitespaces(String input) {
        if (input == null) {
            return 0;
        }
        int i = 0;
        while (i < input.length()) {
            if (!Character.isWhitespace(input.charAt(i))) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static String trimLeadingWhitespaces(String input, int limit) {
        if (input == null) {
            return null;
        }
        return input.substring(Math.min(limit, DVTStringUtil.countLeadingWhitespaces(input)));
    }

    public static int countLeadingTabs(String input) {
        if (input == null) {
            return 0;
        }
        int nofTabs = 0;
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) == '\t') {
                ++nofTabs;
            }
            if (!Character.isWhitespace(input.charAt(i))) {
                return nofTabs;
            }
            ++i;
        }
        return 0;
    }

    public static int countEndingWhitespaces(String input) {
        if (input == null) {
            return 0;
        }
        int i = input.length() - 1;
        while (i >= 0) {
            if (!Character.isWhitespace(input.charAt(i))) {
                return input.length() - i - 1;
            }
            --i;
        }
        return 0;
    }

    public static String getParamRadixPrefix(int radix) {
        if (2 == radix) {
            return "b";
        }
        if (8 == radix) {
            return "o";
        }
        if (10 == radix) {
            return "d";
        }
        if (16 == radix) {
            return "h";
        }
        return "h";
    }

    public static final String getGrammarFormOf(String word, int occurences) {
        return occurences == 1 ? Inflector.singularize(word) : Inflector.pluralize(word);
    }

    public static final String replaceAll(Pattern pattern, CharSequence input, String replacement) {
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceAll(replacement);
    }

    public static final String replaceDynamicAll(Pattern pattern, CharSequence input, Function<Matcher, String> replacer) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacer.apply(matcher));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static final String replaceFirst(Pattern pattern, CharSequence input, String replacement) {
        Matcher matcher = pattern.matcher(input);
        return matcher.replaceFirst(replacement);
    }

    public static final String[] split(Pattern pattern, String input) {
        return pattern.split(input, 0);
    }

    public static final String[] split(Pattern pattern, String input, int limit) {
        return pattern.split(input, limit);
    }

    public static final boolean matches(Pattern pattern, CharSequence input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }

    public static final String mapSplitLines(String input, String lineDelimiter, BiFunction<String, Integer, String> mapper) {
        AtomicInteger index = new AtomicInteger(-1);
        Matcher matcher = TRAILING_NEW_LINE.matcher(input);
        input = input.concat(matcher.find() ? lineDelimiter : EMPTY_STRING);
        return input.lines().map(line -> (String)mapper.apply((String)line, index.incrementAndGet())).collect(Collectors.joining(lineDelimiter));
    }

    public static final String unquote(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length >= 2 && text.charAt(0) == '\"' && text.charAt(length - 1) == '\"') {
            return text.substring(1, length - 1);
        }
        return text;
    }

    public static final String truncateLongText(Object object, int nofChars, int threshold) {
        if (object == null) {
            return "null";
        }
        String text = object.toString();
        if (text.length() < threshold) {
            return text;
        }
        return String.valueOf(text.substring(0, nofChars)) + "...";
    }

    public static final String unquoteStringContent(String input) {
        input = input.replace("\\\"", "\"");
        input = input.replace("\\n", "\n");
        input = input.replace("\\r", "\r");
        input = input.replace("\\t", "\t");
        input = input.replace("\\f", "\f");
        input = input.replace("\\\\", "\\");
        input = input.replace("\u0000", EMPTY_STRING);
        return input;
    }

    public static int getNextWS(String input, int index) {
        int i = index;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (Character.isWhitespace(ch)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getFirstNWSDifferentFromCharIndex(String input, char excludedChar) {
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (!Character.isWhitespace(ch) && ch != excludedChar) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static int getLastNWSDifferentFromCharReverseIndex(String input, char excludedChar) {
        int i = input.length() - 1;
        while (i >= 0) {
            char ch = input.charAt(i);
            if (!Character.isWhitespace(ch) && ch != excludedChar) {
                return input.length() - i - 1;
            }
            --i;
        }
        return 0;
    }

    public static boolean containsAny(String toBeChecked, String[] toBeContained) {
        String[] stringArray = toBeContained;
        int n = toBeContained.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (toBeChecked.contains(str)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isNotTextFileCharacter(char ch) {
        if (Character.isISOControl(ch)) {
            return !Character.isWhitespace(ch);
        }
        int charType = Character.getType(ch);
        switch (charType) {
            case 0: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public static String capBytesLength(String string) {
        if (string.length() > 21000 && string.getBytes().length > 65535) {
            String suffix = "...";
            int suffixBytes = suffix.getBytes().length;
            int maxBytes = 65535 - suffixBytes;
            CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
            ByteBuffer buffer = ByteBuffer.allocate(maxBytes);
            CharBuffer charBuffer = CharBuffer.wrap(string);
            encoder.encode(charBuffer, buffer, true);
            string = String.valueOf(string.substring(0, charBuffer.position())) + suffix;
        }
        return string;
    }

    private static class Interner<T> {
        private final T[] cache;

        public Interner(int primeSize) {
            this.cache = new Object[primeSize];
        }

        public final T intern(T t) {
            if (t == null) {
                return null;
            }
            T[] c = this.cache;
            int hashCode = t.hashCode();
            int hash = (hashCode & Integer.MAX_VALUE) % c.length;
            T t2 = c[hash];
            if (t2 != null && t.equals(t2)) {
                return t2;
            }
            c[hash] = t;
            return t;
        }
    }
}

