/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.Arrays;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.semantic.extension.IllegalPartSelectIndexException;
import ro.amiq.dvt.model.reflection.semantic.extension.OutOfBoundsSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.ReversedPartSelectException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;

public class DVTUnpackedArray
extends DVTNumber
implements IDVTRangeSelectable {
    private DVTNumber elementType;
    private DVTNumber[] values;
    private int right;
    private int left;
    public String elementTypeName;

    public DVTUnpackedArray(int left, int right, DVTNumber elementType) {
        this(left, right, elementType, new DVTNumber[0]);
    }

    public DVTUnpackedArray(int left, int right, DVTNumber elementType, String elementTypeName) {
        this(left, right, elementType, new DVTNumber[0]);
        this.elementTypeName = elementTypeName;
    }

    public DVTUnpackedArray(int left, int right, DVTNumber elementType, DVTNumber[] array) {
        this.left = left;
        this.right = right;
        this.values = new DVTNumber[array.length];
        System.arraycopy(array, 0, this.values, 0, this.values.length);
        this.elementType = elementType;
    }

    public static DVTNumber of(int[][] unpacked, DVTNumber elementType) {
        if (unpacked == null || unpacked.length == 0) {
            return elementType;
        }
        return new DVTUnpackedArray(unpacked[0][0], unpacked[0][1], DVTUnpackedArray.of((int[][])Arrays.copyOfRange(unpacked, 1, unpacked.length), elementType));
    }

    public static DVTNumber defaultFrom(BitVectorContext handler, DVTNumber value) {
        if (value == null) {
            return null;
        }
        if (!(handler.getContextNumber() instanceof DVTUnpackedArray)) {
            return null;
        }
        DVTUnpackedArray contextNumber = (DVTUnpackedArray)handler.getContextNumber();
        int[] firstDimension = contextNumber.getFirstDimension();
        if (firstDimension == null) {
            return null;
        }
        DVTUnpackedArray result = new DVTUnpackedArray(firstDimension[0], firstDimension[1], contextNumber.elementType);
        DVTNumber newContextNumber = contextNumber.decreaseDimension();
        BitVectorContext newContext = BitVectorContext.of(newContextNumber, handler.getOrigin());
        if (newContextNumber instanceof DVTUnpackedArray) {
            if (!(value instanceof DVTUnpackedArray)) {
                DVTNumber defaultFrom = DVTUnpackedArray.defaultFrom(newContext, value);
                result.fillValues(defaultFrom);
            } else {
                DVTNumber sameArrayValue = ((DVTUnpackedArray)newContextNumber).getSameElementContext((DVTUnpackedArray)value);
                if (sameArrayValue != null) {
                    result.fillValues(sameArrayValue);
                } else {
                    DVTNumber defaultFrom = DVTUnpackedArray.defaultFrom(newContext, value);
                    result.fillValues(defaultFrom);
                }
            }
        } else {
            if (value instanceof DVTUnpackedArray) {
                return null;
            }
            DVTNumber transformed = newContext.transform(value);
            result.fillValues(transformed);
        }
        return result;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    private void fillValues(DVTNumber value) {
        if (this.values.length == 0) {
            this.values = new DVTNumber[this.getArraySize()];
        }
        Arrays.fill(this.values, value);
    }

    public DVTNumber getSameElementContext(DVTUnpackedArray other) {
        DVTNumber thisU = this;
        DVTNumber otherU = other;
        DVTUnpackedArray prevOtherU = other;
        while (thisU instanceof DVTUnpackedArray && otherU instanceof DVTUnpackedArray) {
            if (thisU.getArraySize() != otherU.getArraySize()) {
                return null;
            }
            thisU = thisU.getElementType();
            if (!((otherU = otherU.getElementType()) instanceof DVTUnpackedArray)) continue;
            prevOtherU = otherU;
        }
        if (!((DVTNumber)thisU).equals(otherU) || prevOtherU.getValues() == null) {
            return null;
        }
        BitVectorContext context = BitVectorContext.of(thisU, null);
        DVTNumber[] values2 = prevOtherU.getValues();
        int i = 0;
        while (i < values2.length) {
            values2[i] = context.transform(values2[i]);
            ++i;
        }
        return other;
    }

    @Override
    public int getArraySize() {
        return Math.abs(this.left - this.right) + 1;
    }

    @Override
    public int[] getFirstDimension() {
        return new int[]{this.left, this.right};
    }

    @Override
    public int getElementSize() {
        return this.elementType != null ? this.elementType.getSize() : -1;
    }

    public int getBaseElementSize() {
        if (this.elementType instanceof DVTUnpackedArray) {
            return ((DVTUnpackedArray)this.elementType).getBaseElementSize();
        }
        return this.getElementSize();
    }

    @Override
    public int getSize() {
        if (this.left == -1 && this.right == -1) {
            return -1;
        }
        int elementSize = this.getElementSize();
        if (elementSize <= 0) {
            return elementSize;
        }
        return this.getArraySize() * elementSize;
    }

    public DVTNumber decreaseDimension() {
        return this.elementType;
    }

    public DVTNumber[] getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.values == null || this.values.length == 0;
    }

    @Override
    public DVTNumber updateSelects(DVTNumber updateValue, ListContainer<XComputedSelect> computedSelects) {
        if (this.values.length == 0) {
            this.values = new DVTNumber[this.getArraySize()];
        }
        if (computedSelects == null || computedSelects.isEmpty()) {
            return updateValue;
        }
        XComputedSelect firstSelect = computedSelects.get(0);
        if (computedSelects.size() > 1) {
            DVTNumber rangeSelect = this.getRangeSelect(firstSelect, false, LanguageKind.VLOG);
            if (!(rangeSelect instanceof IDVTRangeSelectable)) {
                return this;
            }
            DVTNumber updated = ((IDVTRangeSelectable)((Object)rangeSelect)).updateSelects(updateValue, OptimizedUtils.listContainerCreate(OptimizedUtils.asList(computedSelects, false).subList(1, computedSelects.size()), true));
            this.updateRangeSelect(firstSelect, updated, firstSelect.computedValues);
        } else {
            this.updateRangeSelect(firstSelect, updateValue, firstSelect.computedValues);
        }
        return this;
    }

    private void updateRangeSelect(XComputedSelect computedSelect, DVTNumber value, IELParamValue ... selectValues) {
        if (selectValues.length <= 0 || selectValues.length > 2) {
            return;
        }
        if (this.values.length == 0) {
            return;
        }
        int[] selects = new int[selectValues.length];
        int i = 0;
        while (i < selectValues.length) {
            selects[i] = selectValues[i].intValue();
            ++i;
        }
        if (computedSelect.isPlusIndexPartSelect || computedSelect.isMinusIndexPartSelect) {
            if (selects[1] <= 0) {
                return;
            }
            int maxSelect = 0;
            int minSelect = 0;
            if (computedSelect.isPlusIndexPartSelect) {
                maxSelect = selects[0] + selects[1] - 1;
                minSelect = selects[0];
            } else if (computedSelect.isMinusIndexPartSelect) {
                maxSelect = selects[0];
                minSelect = selects[0] - selects[1] + 1;
            }
            selects = this.left > this.right ? new int[]{maxSelect, minSelect} : new int[]{minSelect, maxSelect};
        }
        int arraySize = this.getArraySize();
        if (selects.length == 1 || selects[0] == selects[1]) {
            int selectIndex = selects[0];
            if (!this.inAbsoluteRange(selectIndex, this.left, this.right)) {
                return;
            }
            if (this.inRange(selectIndex, this.left, this.right)) {
                this.values[selectIndex - this.left] = value;
                return;
            }
            this.values[arraySize - 1 - (selectIndex - this.right)] = value;
            return;
        }
        int lhValue = selects[0];
        int rhValue = selects[1];
        if (!(value instanceof DVTUnpackedArray)) {
            return;
        }
        try {
            DVTUnpackedArray updateArray = (DVTUnpackedArray)value;
            if (lhValue < rhValue) {
                if (!this.inRange(lhValue, this.left, this.right) || !this.inRange(rhValue, this.left, this.right)) {
                    return;
                }
                System.arraycopy(updateArray.values, 0, this.values, lhValue - this.left, updateArray.getArraySize());
            } else if (lhValue > rhValue) {
                if (!this.inRange(lhValue, this.right, this.left) || !this.inRange(rhValue, this.right, this.left)) {
                    return;
                }
                System.arraycopy(updateArray.values, 0, this.values, arraySize - Math.abs(lhValue - this.right + 1), updateArray.getArraySize());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    @Override
    public DVTNumber getBitSelect(int startPos, int size) {
        int myBitSize = this.getSize();
        if (startPos < 0 || startPos + size - 1 >= myBitSize || size > this.getElementSize()) {
            return null;
        }
        int counter = 0;
        DVTNumber[] dVTNumberArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            DVTNumber number = dVTNumberArray[n2];
            if (counter == startPos) {
                if (size == number.getSize()) {
                    return number;
                }
                return number.getBitSelect(0, size);
            }
            if (counter > startPos) {
                return null;
            }
            int numberSize = number.getSize();
            if (counter + numberSize > startPos) {
                return number.getBitSelect(startPos - counter, size);
            }
            counter += numberSize;
            ++n2;
        }
        return null;
    }

    @Override
    public DVTNumber getRangeSelect(XComputedSelect computedSelect, boolean evaluateForSize, LanguageKind languageKind) {
        boolean isOutOfRangeRH;
        boolean increasing;
        IELParamValue[] numberSelects = computedSelect.computedValues;
        if (numberSelects.length == 1) {
            if (ELUtils.isUnsuccessfulEval(numberSelects[0])) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
        } else if (numberSelects.length == 2) {
            if (ELUtils.isUnsuccessfulEval(numberSelects[0]) || ELUtils.isUnsuccessfulEval(numberSelects[1])) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
        } else {
            throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
        }
        int[] selects = new int[numberSelects.length];
        boolean isIndexPartSelect = computedSelect.isPlusIndexPartSelect || computedSelect.isMinusIndexPartSelect;
        boolean isVhdl = languageKind == LanguageKind.VHDL;
        int i = 0;
        while (i < numberSelects.length) {
            if (!isVhdl && numberSelects[i].isAmbiguous()) {
                if (numberSelects.length == 1) {
                    return this.getAmbiguousSingleSelectDefaultValue();
                }
                if (isIndexPartSelect && i == 0) {
                    if (numberSelects[1].isAmbiguous() || numberSelects[1].intValue() <= 0) {
                        throw new IllegalPartSelectIndexException(computedSelect.getSelectObject());
                    }
                    int width = numberSelects[1].intValue();
                    return this.getDefaultValueSubArray(this.left, this.left > this.right ? this.left - width + 1 : this.left + width - 1);
                }
                throw new IllegalPartSelectIndexException(computedSelect.getSelectObject());
            }
            selects[i] = numberSelects[i].intValue();
            ++i;
        }
        boolean bl = increasing = this.right > this.left;
        if (isIndexPartSelect) {
            if (selects[1] <= 0) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject());
            }
            if (computedSelect.isPlusIndexPartSelect) {
                if (!increasing) {
                    firstSelectValue = evaluateForSize ? this.right : selects[0];
                    selects = new int[]{firstSelectValue + selects[1] - 1, firstSelectValue};
                } else {
                    firstSelectValue = evaluateForSize ? this.left : selects[0];
                    selects = new int[]{firstSelectValue, firstSelectValue + selects[1] - 1};
                }
            } else if (computedSelect.isMinusIndexPartSelect) {
                if (!increasing) {
                    firstSelectValue = evaluateForSize ? this.left : selects[0];
                    selects = new int[]{firstSelectValue, firstSelectValue - selects[1] + 1};
                } else {
                    firstSelectValue = evaluateForSize ? this.right : selects[0];
                    selects = new int[]{firstSelectValue - selects[1] + 1, firstSelectValue};
                }
            }
        }
        int arraySize = this.getArraySize();
        if (selects.length == 1 || selects[0] == selects[1]) {
            int finalSelectIndex;
            if (evaluateForSize) {
                return this.elementType;
            }
            int selectIndex = selects[0];
            if (!this.inAbsoluteRange(selectIndex, this.left, this.right)) {
                if (isVhdl) {
                    throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(new int[]{this.left, this.right}, isVhdl), String.valueOf(selectIndex));
                }
                return this.getAmbiguousSingleSelectDefaultValue();
            }
            int n = finalSelectIndex = this.left < this.right ? selectIndex - this.left : arraySize - 1 - (selectIndex - this.right);
            if (finalSelectIndex < 0 || finalSelectIndex >= this.values.length) {
                throw new UnknownHidObjectEvaluationException(computedSelect.getSelectObject(), "Unpacked array size mismatch!");
            }
            return this.getElementAtIndex(finalSelectIndex, !evaluateForSize);
        }
        if (increasing && selects[0] > selects[1] || !increasing && selects[0] < selects[1]) {
            throw new ReversedPartSelectException(computedSelect.getSelectObject());
        }
        int lhValue = selects[0];
        int rhValue = selects[1];
        if (increasing && (lhValue > this.right || rhValue < this.left) || !increasing && (lhValue < this.right || rhValue > this.left)) {
            if (isVhdl) {
                throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(new int[]{this.left, this.right}, isVhdl), String.valueOf(lhValue), String.valueOf(rhValue));
            }
            return this.getDefaultValueSubArray(lhValue, rhValue);
        }
        int newLH = increasing ? Math.max(lhValue, this.left) : Math.min(lhValue, this.left);
        int newRH = increasing ? Math.min(rhValue, this.right) : Math.max(rhValue, this.right);
        DVTUnpackedArray rangeSelect = newLH < newRH ? this.subArray(newLH - this.left, newRH - this.left, evaluateForSize) : this.subArray(arraySize - 1 - (newLH - this.right), arraySize - 1 - (newRH - this.right), evaluateForSize);
        boolean isOutOfRangeLH = lhValue < rhValue && !this.inRange(lhValue, this.left, this.right) || lhValue > rhValue && !this.inRange(lhValue, this.right, this.left);
        boolean bl2 = isOutOfRangeRH = lhValue < rhValue && !this.inRange(rhValue, this.left, this.right) || lhValue > rhValue && !this.inRange(rhValue, this.right, this.left);
        if (!isOutOfRangeLH && !isOutOfRangeRH) {
            return rangeSelect;
        }
        if (isVhdl) {
            String[] stringArray;
            if (isOutOfRangeLH && isOutOfRangeRH) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = String.valueOf(lhValue);
                stringArray = stringArray2;
                stringArray2[1] = String.valueOf(rhValue);
            } else if (isOutOfRangeLH) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = String.valueOf(lhValue);
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = String.valueOf(rhValue);
            }
            String[] outsideValues = stringArray;
            throw new OutOfBoundsSelectException(computedSelect.getSelectObject(), this.toStringDimensions(new int[]{this.left, this.right}, isVhdl), outsideValues);
        }
        DVTUnpackedArray result = (DVTUnpackedArray)this.getDefaultValueSubArray(lhValue, rhValue);
        if (DVTUnpackedArray.isUndefined(result)) {
            return DVTNumber.UNDEFINED;
        }
        result.updateRangeSelect(computedSelect, rangeSelect, ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(newLH)), ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(newRH)));
        return result;
    }

    public DVTNumber getElementAtIndex(int index, boolean update) {
        DVTNumber result = this.values[index];
        if (result != null) {
            return result;
        }
        result = this.getAmbiguousSingleSelectDefaultValue();
        if (update) {
            this.values[index] = result;
        }
        return result;
    }

    private DVTNumber getDefaultValueSubArray(int overrideLeft, int overrideRight) {
        int size = Math.abs(overrideLeft - overrideRight) + 1;
        if (size > 0x7FFFFF) {
            size = 0x7FFFFF;
        }
        DVTNumber[] newValues = new DVTNumber[size];
        return new DVTUnpackedArray(overrideLeft, overrideRight, this.elementType, newValues);
    }

    private DVTNumber getAmbiguousSingleSelectDefaultValue() {
        return this.elementType != null ? this.elementType.getDefaultValue(false) : DVTNumber.UNDEFINED;
    }

    private DVTUnpackedArray subArray(int i, int j, boolean evaluateForSize) {
        try {
            DVTNumber[] array = !evaluateForSize && this.values.length > 0 ? Arrays.copyOfRange(this.values, i, j + 1) : this.values;
            return new DVTUnpackedArray(i, j, this.elementType, array);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return new DVTUnpackedArray(i, j, this.elementType, this.values);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DVTUnpackedArray)) {
            return false;
        }
        DVTUnpackedArray otherArray = (DVTUnpackedArray)obj;
        if (this.values == otherArray.values) {
            return true;
        }
        int length = this.values.length;
        if (otherArray.values.length != length) {
            return false;
        }
        DVTNumber singleSelectValue = null;
        int i = 0;
        while (i < length) {
            DVTNumber o1 = this.values[i];
            DVTNumber o2 = otherArray.values[i];
            if (o1 != null || o2 != null) {
                if (o1 == null) {
                    if (singleSelectValue == null) {
                        singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                    }
                    o1 = singleSelectValue;
                }
                if (o2 == null) {
                    if (singleSelectValue == null) {
                        singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                    }
                    o2 = singleSelectValue;
                }
                if (!((Object)o1).equals(o2)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean internalEquals(Object obj) {
        if (!(obj instanceof DVTUnpackedArray)) {
            return false;
        }
        DVTUnpackedArray otherArray = (DVTUnpackedArray)obj;
        if (this.values == otherArray.values) {
            return true;
        }
        int length = this.values.length;
        if (otherArray.values.length != length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            DVTNumber o1 = this.values[i];
            DVTNumber o2 = otherArray.values[i];
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!o1.internalEquals(o2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        DVTNumber singleSelectValue = null;
        DVTNumber[] dVTNumberArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            DVTNumber element = dVTNumberArray[n2];
            if (element == null) {
                if (singleSelectValue == null) {
                    singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                }
                element = singleSelectValue;
            }
            result = 31 * result + (element == null ? 0 : ((Object)element).hashCode());
            ++n2;
        }
        return result;
    }

    public String toString() {
        return this.toString(10, false, false);
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.ZERO;
    }

    @Override
    public DVTNumber from(DVTNumber number, boolean isCast) {
        if (isCast && number instanceof VlogBitVector) {
            return DVTUnpackedArray.unpack(this, number);
        }
        if (isCast && number instanceof DVTUnpackedStruct) {
            return DVTUnpackedArray.unpack(this, DVTUnpackedArray.pack(number));
        }
        if (number instanceof DVTUnpackedArray) {
            if (isCast) {
                return DVTUnpackedArray.unpack(this, DVTUnpackedArray.pack(number));
            }
            if (number instanceof DVTUnpackedArray && ((DVTUnpackedArray)number).getArraySize() == this.getArraySize()) {
                return new DVTUnpackedArray(this.getLeft(), this.getRight(), ((DVTUnpackedArray)number).getElementType(), ((DVTUnpackedArray)number).getValues());
            }
        }
        return DVTNumber.UNDEFINED;
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        StringBuilder sb = new StringBuilder("[");
        String singleSelectValueText = null;
        int i = 0;
        while (i < this.values.length) {
            DVTNumber dvtNumber = this.values[i];
            if (dvtNumber == null) {
                if (singleSelectValueText == null) {
                    DVTNumber singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                    singleSelectValueText = singleSelectValue.toString(radix, useCharLimit, useLowerCaseMaskType);
                }
                sb.append(singleSelectValueText).append(i == this.values.length - 1 ? "" : ",");
            } else {
                String string = dvtNumber.toString(radix, useCharLimit, useLowerCaseMaskType);
                sb.append(string).append(i == this.values.length - 1 ? "" : ",");
            }
            ++i;
        }
        return sb.append("]").toString();
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        StringBuilder sb = new StringBuilder("[");
        String singleSelectValueText = null;
        int i = 0;
        while (i < this.values.length) {
            DVTNumber dvtNumber = this.values[i];
            if (dvtNumber == null) {
                if (singleSelectValueText == null) {
                    DVTNumber singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                    singleSelectValueText = singleSelectValue.print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern);
                }
                sb.append(singleSelectValueText).append(i == this.values.length - 1 ? "" : ",");
            } else {
                String string = dvtNumber.print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern);
                sb.append(string).append(i == this.values.length - 1 ? "" : ",");
            }
            ++i;
        }
        return sb.append("]").toString();
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        StringBuilder sb = new StringBuilder("(");
        String singleSelectValueText = null;
        DVTNumber elementContext = context != null && context.getContextNumber() instanceof DVTUnpackedArray ? ((DVTUnpackedArray)context.getContextNumber()).getElementType() : this.elementType;
        BitVectorContext newContext = elementContext == null ? null : BitVectorContext.of(elementContext, null);
        int i = 0;
        while (i < this.values.length) {
            DVTNumber dvtNumber = this.values[i];
            if (dvtNumber == null) {
                if (singleSelectValueText == null) {
                    DVTNumber singleSelectValue = this.getAmbiguousSingleSelectDefaultValue();
                    singleSelectValueText = singleSelectValue.toNiceString(newContext, radix, useCharLimit, useLowerCaseMaskType);
                }
                sb.append(singleSelectValueText).append(i == this.values.length - 1 ? "" : ",");
                if (useCharLimit && sb.length() > 8100) {
                    sb.append("...)");
                    return sb.toString();
                }
            } else {
                sb.append(dvtNumber.toNiceString(newContext, radix, useCharLimit, useLowerCaseMaskType)).append(i == this.values.length - 1 ? "" : ",");
                if (useCharLimit && sb.length() > 8100) {
                    sb.append("...)");
                    return sb.toString();
                }
            }
            ++i;
        }
        return sb.append(")").toString();
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        return new DVTUnpackedArray(this.left, this.right, this.elementType, new DVTNumber[this.getArraySize()]);
    }

    @Override
    public DVTNumber getElementType() {
        return this.elementType;
    }

    public int getNofDimensions() {
        int rank = 1;
        DVTNumber elementType = this.elementType;
        while (elementType instanceof DVTUnpackedArray) {
            ++rank;
            elementType = ((DVTUnpackedArray)elementType).elementType;
        }
        return rank;
    }

    public void setElementType(DVTNumber elementType) {
        this.elementType = elementType;
    }

    @Override
    public DVTNumber copy() {
        DVTUnpackedArray result = new DVTUnpackedArray(this.left, this.right, this.elementType, this.values);
        result.uniqueId = this.uniqueId;
        return result;
    }

    @Override
    protected int pack(DVTNumber[] result, int resultSize) {
        DVTNumber[] dVTNumberArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            DVTNumber value = dVTNumberArray[n2];
            if (value == null) {
                value = this.getAmbiguousSingleSelectDefaultValue();
            }
            if (!(value instanceof VlogBitVector)) {
                if ((resultSize = value.pack(result, resultSize)) == -1) {
                    break;
                }
            } else {
                DVTNumber tempResult = result[0];
                int valueSize = value.getSize();
                if (valueSize < 0) {
                    result[0] = DVTNumber.UNDEFINED;
                    return -1;
                }
                result[0] = DVTNumber.concatenate(tempResult, value, null);
                resultSize += valueSize;
            }
            ++n2;
        }
        return resultSize;
    }

    @Override
    protected int unpack(VlogBitVector source, int resultSize) {
        if (this.left == -1 && this.right == -1 || this.elementType == null) {
            return -1;
        }
        if (this.values.length == 0) {
            this.values = new DVTNumber[this.getArraySize()];
        }
        if (this.elementType instanceof VlogBitVector) {
            int valueSize = this.elementType.getSize();
            if (valueSize < 0) {
                return -1;
            }
            int i = 0;
            while (i < this.values.length) {
                if ((resultSize += valueSize) > source.getSize()) {
                    return -1;
                }
                this.values[i] = this.elementType.from(source.getRangeAbsolute(resultSize - valueSize, valueSize), false);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.values.length && resultSize != -1) {
                this.values[i] = this.elementType.getDefaultValue(false);
                resultSize = this.values[i].unpack(source, resultSize);
                ++i;
            }
        }
        return resultSize;
    }

    @Override
    public VlogBitVector toBitVector() {
        DVTNumber result = VlogBitVector.BIT_ZERO;
        int nofBits = 0;
        DVTNumber[] dVTNumberArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            DVTNumber value = dVTNumberArray[n2];
            VlogBitVector memberBitVector = value.toBitVector();
            if (memberBitVector != null) {
                result = DVTNumber.shiftLeft(result, memberBitVector.getSize(), nofBits + memberBitVector.getSize());
                result = DVTNumber.or(result, memberBitVector);
                nofBits += memberBitVector.getSize();
            }
            ++n2;
        }
        return result;
    }
}

