/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.InsensitiveLinkedMap;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector;

public class DVTUnpackedStruct
extends DVTNumber
implements IDVTMemberSelectable {
    private Map<String, StructMemberContextInfo> contextInfoByName;
    private Map<String, DVTNumber> membersByName;
    private boolean isUnion;
    private int size = Integer.MIN_VALUE;

    public static DVTUnpackedStruct ofInfo(Map<String, StructMemberContextInfo> membersInfo, boolean isUnion) {
        return new DVTUnpackedStruct(membersInfo, Collections.emptyMap(), isUnion);
    }

    public DVTUnpackedStruct(Map<String, StructMemberContextInfo> membersInfo, Map<String, DVTNumber> membersByName, boolean isUnion) {
        this.contextInfoByName = membersInfo;
        this.membersByName = membersByName;
        this.isUnion = isUnion;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.ZERO;
    }

    @Override
    public DVTNumber from(DVTNumber number, boolean isCast) {
        if (isCast && number instanceof VlogBitVector) {
            return DVTUnpackedStruct.unpack(this, number);
        }
        if (isCast && number instanceof DVTUnpackedArray) {
            return DVTUnpackedStruct.unpack(this, DVTUnpackedStruct.pack(number));
        }
        if (number instanceof DVTUnpackedStruct) {
            if (isCast) {
                return DVTUnpackedStruct.unpack(this, DVTUnpackedStruct.pack(number));
            }
            return number;
        }
        return DVTNumber.UNDEFINED;
    }

    @Override
    public boolean isUnion() {
        return this.isUnion;
    }

    public boolean isVhdl() {
        return this.contextInfoByName instanceof InsensitiveLinkedMap;
    }

    @Override
    public int getSize() {
        if (this.size == Integer.MIN_VALUE) {
            this.size = 0;
            for (StructMemberContextInfo contextInfo : this.contextInfoByName.values()) {
                if (contextInfo.context == null) {
                    return -1;
                }
                DVTNumber contextNumber = contextInfo.context.getContextNumber();
                if (contextNumber == null) {
                    return -1;
                }
                int memberSize = contextNumber.getSize();
                if (memberSize < 0) {
                    this.size = memberSize;
                    break;
                }
                if (this.isUnion) {
                    this.size = Math.max(this.size, memberSize);
                    continue;
                }
                this.size += memberSize;
            }
        }
        return this.size;
    }

    @Override
    public String toString(int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        if (this.membersByName == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<String, StructMemberContextInfo> entry : this.contextInfoByName.entrySet()) {
            sb.append(entry.getKey()).append(':').append(this.getMemberByName(entry.getKey(), false).toString(radix, useCharLimit, useLowerCaseMaskType)).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("]").toString();
    }

    @Override
    public VlogBitVector toBitVector() {
        DVTNumber result = VlogBitVector.BIT_ZERO;
        int nofBits = 0;
        for (Map.Entry<String, StructMemberContextInfo> entry : this.contextInfoByName.entrySet()) {
            DVTNumber memberByName = this.getMemberByName(entry.getKey(), false);
            VlogBitVector memberBitVector = memberByName.toBitVector();
            if (memberBitVector == null) continue;
            result = DVTNumber.shiftLeft(result, memberBitVector.getSize(), nofBits + memberBitVector.getSize());
            result = DVTNumber.or(result, memberBitVector);
            nofBits += memberBitVector.getSize();
        }
        return result;
    }

    @Override
    public String print(int radix, boolean stripLeadingZeroes, int width, boolean useLowerCaseMaskType, boolean structAssignPattern) {
        if (this.membersByName == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<String, StructMemberContextInfo> entry : this.contextInfoByName.entrySet()) {
            sb.append(entry.getKey()).append(':').append(this.getMemberByName(entry.getKey(), false).print(radix, stripLeadingZeroes, width, useLowerCaseMaskType, structAssignPattern)).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("]").toString();
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        Map<String, StructMemberContextInfo> contextByName;
        if (this.membersByName == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        Map<String, StructMemberContextInfo> map = contextByName = context != null && context.getContextNumber() instanceof DVTUnpackedStruct ? ((DVTUnpackedStruct)context.getContextNumber()).getMembersInfoByName() : this.contextInfoByName;
        if (contextByName == null || contextByName.isEmpty()) {
            return "N/A";
        }
        for (Map.Entry<String, StructMemberContextInfo> entry : contextByName.entrySet()) {
            if (useCharLimit && sb.length() > 8100) {
                sb.append("...]");
                return sb.toString();
            }
            StructMemberContextInfo structMemberContextInfo = entry.getValue();
            if (structMemberContextInfo == null) {
                return "";
            }
            sb.append(entry.getKey()).append(":").append(this.getMemberByName(entry.getKey(), false).toNiceString(structMemberContextInfo.context, radix, useCharLimit, useLowerCaseMaskType)).append(",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.append("]").toString();
    }

    @Override
    public DVTNumber getBitSelect(int startPos, int size) {
        int myBitSize = this.getSize();
        if (startPos < 0 || startPos + size - 1 >= myBitSize) {
            return null;
        }
        if (this.membersByName == null || this.membersByName.isEmpty()) {
            return null;
        }
        int counter = 0;
        for (DVTNumber number : this.membersByName.values()) {
            if (counter == startPos) {
                if (size > number.getSize()) {
                    return null;
                }
                if (size == number.getSize()) {
                    return number;
                }
                return number.getBitSelect(0, size);
            }
            if (counter > startPos) {
                return null;
            }
            counter += number.getSize();
        }
        return null;
    }

    @Override
    public DVTNumber getMemberSelect(IHid hidSelect, boolean evaluateForSize) {
        if (hidSelect == null) {
            return DVTNumber.UNDEFINED;
        }
        String selectedName = hidSelect.getName();
        return this.getMemberByName(selectedName, !evaluateForSize);
    }

    private DVTNumber getMemberByName(String selectedName, boolean update) {
        StructMemberContextInfo contextInfo = this.contextInfoByName.get(selectedName);
        if (contextInfo == null || contextInfo.context == null) {
            return DVTNumber.UNDEFINED;
        }
        DVTNumber contextNumber = contextInfo.context.getContextNumber();
        if (contextNumber == null) {
            return DVTNumber.UNDEFINED;
        }
        if (this.membersByName == null || this.membersByName.isEmpty()) {
            DVTNumber initializeDefaultValue = contextNumber.getDefaultValue(false);
            if (update) {
                this.updateName(selectedName, initializeDefaultValue);
            }
            return initializeDefaultValue;
        }
        DVTNumber result = this.membersByName.get(selectedName);
        if (result == null) {
            DVTNumber initializeDefaultValue = contextNumber.getDefaultValue(false);
            if (update) {
                this.updateName(selectedName, initializeDefaultValue);
            }
            return initializeDefaultValue;
        }
        return result;
    }

    @Override
    public int getSizeIgnoreDimensions() {
        return this.getSize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DVTUnpackedStruct)) {
            return false;
        }
        DVTUnpackedStruct other = (DVTUnpackedStruct)obj;
        if (this.membersByName == null) {
            if (other.membersByName != null) {
                return false;
            }
        } else {
            int otherEntriesSize;
            Set<Map.Entry<String, StructMemberContextInfo>> thisEntries = this.contextInfoByName.entrySet();
            Set<Map.Entry<String, StructMemberContextInfo>> otherEntries = other.contextInfoByName.entrySet();
            int thisEntriesSize = thisEntries.size();
            if (thisEntriesSize != (otherEntriesSize = otherEntries.size())) {
                return false;
            }
            if (thisEntriesSize == 0 && otherEntriesSize == 0) {
                return true;
            }
            Iterator<Map.Entry<String, StructMemberContextInfo>> thisIterator = thisEntries.iterator();
            Iterator<Map.Entry<String, StructMemberContextInfo>> otherIterator = otherEntries.iterator();
            while (thisIterator.hasNext()) {
                StructMemberContextInfo memberInfo;
                DVTNumber otherNumber;
                Map.Entry<String, StructMemberContextInfo> thisEntry = thisIterator.next();
                Map.Entry<String, StructMemberContextInfo> otherEntry = otherIterator.next();
                if (!thisEntry.getKey().equals(otherEntry.getKey())) {
                    return false;
                }
                DVTNumber thisNumber = this.membersByName.get(thisEntry.getKey());
                DVTNumber dVTNumber = otherNumber = other.membersByName != null ? other.membersByName.get(otherEntry.getKey()) : null;
                if (thisNumber == null && otherNumber == null) continue;
                if (thisNumber == null) {
                    memberInfo = thisEntry.getValue();
                    thisNumber = memberInfo.context != null && memberInfo.context.getContextNumber() != null ? memberInfo.context.getContextNumber().getDefaultValue(false) : DVTNumber.UNDEFINED;
                }
                if (otherNumber == null) {
                    memberInfo = otherEntry.getValue();
                    otherNumber = memberInfo.context != null && memberInfo.context.getContextNumber() != null ? memberInfo.context.getContextNumber().getDefaultValue(false) : DVTNumber.UNDEFINED;
                }
                if (thisNumber.equals(otherNumber)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean internalEquals(Object obj) {
        if (!(obj instanceof DVTUnpackedStruct)) {
            return false;
        }
        DVTUnpackedStruct other = (DVTUnpackedStruct)obj;
        if (this.membersByName == null) {
            if (other.membersByName != null) {
                return false;
            }
        } else {
            int otherEntriesSize;
            Set<Map.Entry<String, StructMemberContextInfo>> thisEntries = this.contextInfoByName.entrySet();
            Set<Map.Entry<String, StructMemberContextInfo>> otherEntries = other.contextInfoByName.entrySet();
            int thisEntriesSize = thisEntries.size();
            if (thisEntriesSize != (otherEntriesSize = otherEntries.size())) {
                return false;
            }
            if (thisEntriesSize == 0 && otherEntriesSize == 0) {
                return true;
            }
            Iterator<Map.Entry<String, StructMemberContextInfo>> thisIterator = thisEntries.iterator();
            Iterator<Map.Entry<String, StructMemberContextInfo>> otherIterator = otherEntries.iterator();
            while (thisIterator.hasNext()) {
                DVTNumber otherNumber;
                Map.Entry<String, StructMemberContextInfo> thisEntry = thisIterator.next();
                Map.Entry<String, StructMemberContextInfo> otherEntry = otherIterator.next();
                if (!thisEntry.getKey().equals(otherEntry.getKey())) {
                    return false;
                }
                DVTNumber thisNumber = this.membersByName.get(thisEntry.getKey());
                DVTNumber dVTNumber = otherNumber = other.membersByName != null ? other.membersByName.get(otherEntry.getKey()) : null;
                if (thisNumber == null || otherNumber == null) {
                    return false;
                }
                if (thisNumber.internalEquals(otherNumber)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        Set<Map.Entry<String, StructMemberContextInfo>> thisEntries = this.contextInfoByName.entrySet();
        if (thisEntries == null || thisEntries.isEmpty()) {
            return 31 * result;
        }
        for (Map.Entry<String, StructMemberContextInfo> entry : thisEntries) {
            DVTNumber value;
            String memberName = entry.getKey();
            DVTNumber dVTNumber = value = this.membersByName != null ? this.membersByName.get(memberName) : null;
            if (value == null) {
                StructMemberContextInfo memberInfo = entry.getValue();
                value = memberInfo.context == null || memberInfo.context.getContextNumber() == null ? DVTNumber.UNDEFINED : memberInfo.context.getContextNumber().getDefaultValue(false);
            }
            result = 31 * result + (memberName.hashCode() ^ value.hashCode());
        }
        return result;
    }

    public String toString() {
        return this.toString(10, false, false);
    }

    public List<StructMemberContextInfo> getMembersInfoOrdered() {
        ArrayList<StructMemberContextInfo> result = new ArrayList<StructMemberContextInfo>();
        result.addAll(this.contextInfoByName.values());
        result.sort((o1, o2) -> o1.startingIndex - o2.startingIndex);
        return result;
    }

    public Map<String, StructMemberContextInfo> getMembersInfoByName() {
        return this.contextInfoByName;
    }

    @Override
    public DVTNumber copy() {
        DVTUnpackedStruct result = new DVTUnpackedStruct(this.contextInfoByName, this.membersByName, this.isUnion);
        result.uniqueId = this.uniqueId;
        return result;
    }

    @Override
    public DVTNumber updateMemberSelects(IHidEvaluator evaluator, DVTNumber updateValue, List<HidNameAndSelects> nameSelects, IHidEvaluationGuardian guardian) {
        if (updateValue == null || this.contextInfoByName == null) {
            return this;
        }
        if (nameSelects.isEmpty()) {
            return this;
        }
        HidNameAndSelects hidNameAndSelects = nameSelects.get(0);
        String name = hidNameAndSelects.name;
        StructMemberContextInfo memberContextInfo = this.contextInfoByName.get(name);
        if (memberContextInfo == null || memberContextInfo.context == null) {
            nameSelects = nameSelects.subList(1, nameSelects.size());
            hidNameAndSelects = nameSelects.get(0);
            name = hidNameAndSelects.name;
            memberContextInfo = this.contextInfoByName.get(name);
        }
        if (memberContextInfo == null || memberContextInfo.context == null) {
            return this;
        }
        DVTNumber member = this.getMemberByName(name, false);
        if (hidNameAndSelects.selects != null && member instanceof IDVTRangeSelectable) {
            ListContainer<XComputedSelect> selectsContainer = hidNameAndSelects.selects;
            if (nameSelects.size() == 1) {
                this.updateName(name, ((IDVTRangeSelectable)((Object)member)).updateSelects(updateValue, selectsContainer));
                return this;
            }
            DVTNumber rangeSelect = member;
            for (XComputedSelect select : selectsContainer) {
                if (select == null || select.computedValues == null) {
                    return this;
                }
                if (!(rangeSelect instanceof IDVTRangeSelectable)) {
                    return UNDEFINED;
                }
                rangeSelect = ((IDVTRangeSelectable)((Object)rangeSelect)).getRangeSelect(select, false, LanguageKind.VLOG);
            }
            if (!(rangeSelect instanceof IDVTMemberSelectable)) {
                return this;
            }
            DVTNumber updatedRangeSelect = ((IDVTMemberSelectable)((Object)rangeSelect)).updateMemberSelects(evaluator, updateValue, nameSelects.subList(1, nameSelects.size()), guardian);
            this.updateName(name, ((IDVTRangeSelectable)((Object)member)).updateSelects(updatedRangeSelect, selectsContainer));
        } else {
            if (nameSelects.size() == 1) {
                this.updateName(name, updateValue);
            }
            if (!(member instanceof IDVTMemberSelectable)) {
                return this;
            }
            this.updateName(name, ((IDVTMemberSelectable)((Object)member)).updateMemberSelects(evaluator, updateValue, nameSelects.subList(1, nameSelects.size()), guardian));
        }
        return this;
    }

    private void updateName(String name, DVTNumber value) {
        if (this.membersByName == null || this.membersByName.isEmpty()) {
            this.membersByName = this.isVhdl() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
        }
        this.membersByName.put(name, value);
    }

    @Override
    public DVTNumber getDefaultValue(boolean force4State) {
        TreeMap<String, StructMemberContextInfo> newContextInfo = this.isVhdl() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
        for (Map.Entry<String, StructMemberContextInfo> entry : this.contextInfoByName.entrySet()) {
            StructMemberContextInfo value = entry.getValue();
            StructMemberContextInfo newValue = new StructMemberContextInfo(value.startingIndex, entry.getKey(), value.context);
            newContextInfo.put(entry.getKey(), newValue);
        }
        return new DVTUnpackedStruct(newContextInfo, this.isVhdl() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap(), this.isUnion);
    }

    @Override
    protected int pack(DVTNumber[] result, int resultSize) {
        for (StructMemberContextInfo memberInfo : this.getMembersInfoOrdered()) {
            DVTNumber value = this.membersByName.get(memberInfo.name);
            if (value == null) {
                resultSize = -1;
                break;
            }
            if (!(value instanceof VlogBitVector)) {
                if ((resultSize = value.pack(result, resultSize)) != -1) continue;
                break;
            }
            DVTNumber tempResult = result[0];
            int valueSize = value.getSize();
            if (valueSize < 0) {
                result[0] = DVTNumber.UNDEFINED;
                return -1;
            }
            result[0] = DVTNumber.concatenate(tempResult, value, null);
            resultSize += valueSize;
        }
        return resultSize;
    }

    @Override
    protected int unpack(VlogBitVector source, int resultSize) {
        if (this.membersByName == null || this.membersByName.isEmpty()) {
            this.membersByName = this.isVhdl() ? new TreeMap(String.CASE_INSENSITIVE_ORDER) : new LinkedHashMap();
        }
        for (StructMemberContextInfo memberInfo : this.getMembersInfoOrdered()) {
            if (memberInfo.context == null) continue;
            DVTNumber member = memberInfo.context.getContextNumber();
            if (member instanceof VlogBitVector) {
                int memberSize = member.getSize();
                if (memberSize < 0) {
                    return -1;
                }
                if ((resultSize += memberSize) > source.getSize()) {
                    return -1;
                }
                this.membersByName.put(memberInfo.name, member.from(source.getRangeAbsolute(resultSize - memberSize, memberSize), false));
                continue;
            }
            if (member == null) continue;
            resultSize = (member = member.getDefaultValue(false)).unpack(source, resultSize);
            if (resultSize < 0) break;
            this.membersByName.put(memberInfo.name, member);
        }
        return resultSize;
    }

    public Map<String, DVTNumber> getMembersByName() {
        return this.membersByName;
    }

    @Override
    public boolean isStruct(boolean isStructOrUnion) {
        return !this.isUnion || isStructOrUnion;
    }
}

