/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.core.IPluginConfig;
import ro.amiq.dvt.model.preproc.PreprocMappingsUtils;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;
import ro.amiq.dvt.utils.Utils;

public enum DVTUtilsCommon {
    INSTANCE;

    private static final long CONVERT_B_TO_MB = 0x100000L;
    private static final long CONVERT_MB_TO_GB = 1024L;
    private Mapping[] fCrossPlatformMapping = this.getDVTCrossPlatformMap();
    private Map<String, String> fVersionsMap;
    private Map<String, String> fCachedFileSubstituteMap;
    private Map<String, String> fCachedDirectorySubstituteMap;
    private IProject fCachedFileSubstituteProject;

    public String getCrossPlatformPath(String input) {
        IPath inputPath;
        if (this.fCrossPlatformMapping == null) {
            return input;
        }
        IPath outputPath = inputPath = Path.fromOSString((String)input);
        int i = this.fCrossPlatformMapping.length - 1;
        while (i >= 0) {
            Mapping mapping = this.fCrossPlatformMapping[i];
            if (mapping.input.isPrefixOf(inputPath)) {
                outputPath = Path.fromOSString((String)mapping.output).append(inputPath.makeRelativeTo(mapping.input));
                break;
            }
            --i;
        }
        return outputPath.toOSString();
    }

    private Mapping[] getDVTCrossPlatformMap() {
        String sysVar;
        block7: {
            sysVar = System.getenv("DVT_CROSSPLATFORM_MAP");
            if (sysVar != null) break block7;
            return null;
        }
        try {
            String[] mappings = sysVar.trim().split(";");
            ArrayList<Mapping> result = new ArrayList<Mapping>();
            String[] stringArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] split = mapping.split("=");
                if (split.length == 2) {
                    Mapping map = new Mapping(split[0], split[1]);
                    result.add(map);
                } else {
                    DVTLogger.INSTANCE.logDebug("ERROR: Invalid mapping: '" + mapping + "'");
                }
                ++n2;
            }
            return result.toArray(new Mapping[result.size()]);
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Map<String, String> getVersionsMap() {
        block22: {
            if (this.fVersionsMap != null) {
                return this.fVersionsMap;
            }
            this.fVersionsMap = new LinkedHashMap<String, String>();
            InputStream versionsFileStream = null;
            BufferedReader reader = null;
            try {
                try {
                    versionsFileStream = JarUtils.getFileStream("/resources/versions.csv", JarUtils.class);
                    reader = new BufferedReader(new InputStreamReader(versionsFileStream, StandardCharsets.UTF_8));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] splits = DVTStringUtil.split(",", line);
                        if (splits.length != 2) continue;
                        String version = splits[0];
                        String date = splits[1];
                        this.fVersionsMap.put(version, date);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (versionsFileStream != null) {
                        try {
                            versionsFileStream.close();
                        }
                        catch (IOException e2) {
                            DVTLogger.INSTANCE.logError((Throwable)e2);
                        }
                    }
                    if (reader == null) break block22;
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        DVTLogger.INSTANCE.logError((Throwable)e3);
                    }
                }
            }
            finally {
                if (versionsFileStream != null) {
                    try {
                        versionsFileStream.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return this.fVersionsMap;
    }

    public String getFileSubstitute(IProject project, String filePath) {
        String canonicPath;
        String result;
        if (filePath == null) {
            return null;
        }
        if (project == null) {
            return filePath;
        }
        if (this.fCachedFileSubstituteProject != project || this.fCachedFileSubstituteMap == null) {
            this.fCachedFileSubstituteProject = project;
            this.fCachedFileSubstituteMap = BuildConfigManager.getFileSubstituteMap(project);
            this.fCachedDirectorySubstituteMap = BuildConfigManager.getDirectorySubstituteMap(project);
        }
        if ((result = this.fCachedFileSubstituteMap.get(canonicPath = Utils.canonicPath(filePath))) != null) {
            return result;
        }
        for (Map.Entry<String, String> directory : this.fCachedDirectorySubstituteMap.entrySet()) {
            result = this.resolveDirectorySubstitute(canonicPath, directory.getKey(), directory.getValue());
            if (result == null) continue;
            return result;
        }
        result = PreprocMappingsUtils.resolvePVlogSubstitute(project, canonicPath);
        if (result == null) {
            return filePath;
        }
        return result;
    }

    public String resolveDirectorySubstitute(String originalPath, String originalPrefix, String substitutePrefix) {
        return this.resolveDirectorySubstitute(originalPath, originalPrefix, substitutePrefix, true);
    }

    public String resolveDirectorySubstitute(String originalPath, String originalPrefix, String substitutePrefix, boolean checkFileExistence) {
        if (!originalPath.startsWith(originalPrefix)) {
            return null;
        }
        String substitute = originalPath.replaceFirst(originalPrefix, substitutePrefix);
        IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(Path.fromOSString((String)substitute));
        if (!(checkFileExistence && !fileInfo.exists() || fileInfo.isDirectory())) {
            return substitute;
        }
        return null;
    }

    public void cleanFileSubstituteCache() {
        this.fCachedFileSubstituteMap = null;
        this.fCachedFileSubstituteProject = null;
        this.fCachedDirectorySubstituteMap = null;
        PreprocMappingsUtils.clearCache();
    }

    public final String replaceAllSystemVariables(CharSequence input) {
        return this.replaceAllSystemVariables(IDVTConstants.SYSTEM_VARIABLE_PATTERN, input, ReplaceSysvarsPolicy.RETURN_NULL, null);
    }

    public final String replaceAllSystemVariables(CharSequence input, ReplaceSysvarsPolicy policy, IEnvironmentProvider environmentProvider) {
        return this.replaceAllSystemVariables(IDVTConstants.SYSTEM_VARIABLE_PATTERN, input, policy, environmentProvider);
    }

    public void closeClosable(Closeable closeable) {
        if (closeable != null) {
            try {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    closeable = null;
                }
            }
            finally {
                closeable = null;
            }
        }
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    zipFile = null;
                }
            }
            finally {
                zipFile = null;
            }
        }
    }

    private final String replaceAllSystemVariables(Pattern pattern, CharSequence input, ReplaceSysvarsPolicy policy, IEnvironmentProvider environmentProvider) {
        if (input == null) {
            return null;
        }
        StringBuffer replaceSB = new StringBuffer();
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String replacement;
            String sysVarName = null;
            int i = 1;
            while (i <= matcher.groupCount()) {
                sysVarName = matcher.group(i);
                if (sysVarName != null) break;
                ++i;
            }
            if (sysVarName == null) {
                return null;
            }
            String string = replacement = environmentProvider == null ? System.getenv(sysVarName) : environmentProvider.getenv(sysVarName);
            if (replacement == null) {
                switch (policy) {
                    case RETURN_NULL: {
                        return null;
                    }
                    case LEAVE_UNREPLACED: {
                        replacement = matcher.group();
                        break;
                    }
                    case REPLACE_WITH_EMPTY: {
                        replacement = "";
                        break;
                    }
                    default: {
                        replacement = "";
                    }
                }
            }
            matcher.appendReplacement(replaceSB, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(replaceSB);
        return replaceSB.toString();
    }

    public Pattern compileSimpleRegex(String pattern) {
        StringBuilder sb = new StringBuilder();
        boolean isEscaped = false;
        sb.append("(?s)");
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    if (!isEscaped) {
                        isEscaped = true;
                        break;
                    }
                    sb.append("\\\\");
                    isEscaped = false;
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (isEscaped) {
                        sb.append("\\\\");
                        isEscaped = false;
                    }
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '?': {
                    if (!isEscaped) {
                        sb.append('.');
                        break;
                    }
                    sb.append('\\');
                    sb.append(c);
                    isEscaped = false;
                    break;
                }
                case '*': {
                    if (!isEscaped) {
                        sb.append(".*");
                        break;
                    }
                    sb.append('\\');
                    sb.append(c);
                    isEscaped = false;
                    break;
                }
                default: {
                    if (isEscaped) {
                        sb.append("\\\\");
                        isEscaped = false;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        if (isEscaped) {
            sb.append("\\\\");
            isEscaped = false;
        }
        return Pattern.compile(sb.toString());
    }

    public final String enc(String message) throws Exception {
        StringBuilder result = new StringBuilder();
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        int i = 0;
        while (i < bytes.length) {
            result.append(String.format("%02X", bytes[i]));
            ++i;
        }
        return result.toString();
    }

    public final String dec(String message) {
        try {
            message = String.valueOf(Integer.toString(6476745)) + message;
            byte[] bytes = new byte[message.length() / 2];
            int i = 0;
            while (i < message.length()) {
                bytes[i / 2] = (byte)Integer.parseInt(message.substring(i, i + 2), 16);
                i += 2;
            }
            StringBuilder result = new StringBuilder();
            int i2 = 0;
            while (i2 < bytes.length) {
                result.append((char)bytes[i2]);
                ++i2;
            }
            return result.toString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    public boolean readClearBooleanSessionProperty(IProject project, QualifiedName qualifiedName) {
        Object result;
        block3: {
            try {
                result = project.getSessionProperty(qualifiedName);
                if (result != null && result instanceof Boolean) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        project.setSessionProperty(qualifiedName, null);
        return (Boolean)result;
    }

    public String readClearStringSessionProperty(IProject project, QualifiedName qualifiedName) {
        Object result;
        block3: {
            try {
                result = project.getSessionProperty(qualifiedName);
                if (result != null && result instanceof String) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        project.setSessionProperty(qualifiedName, null);
        return (String)result;
    }

    public boolean showHyperlinkAction(IRfDefElement defElement, String elementName, int currentOffset, IPath currentFilePath) {
        if (defElement == null) {
            return false;
        }
        if (currentFilePath == null || currentFilePath.isEmpty()) {
            return true;
        }
        IRfFileDef elementFileDef = defElement.getDefFile();
        if (elementFileDef == null) {
            return false;
        }
        ParserPath parserPath = elementFileDef.getParserPath();
        if (parserPath == null || parserPath.path == null) {
            return false;
        }
        if (!Path.fromOSString((String)parserPath.path).equals((Object)currentFilePath)) {
            return true;
        }
        int nameLength = elementName != null ? elementName.length() : 0;
        int defStartOffset = defElement.getStartOffset();
        if (defStartOffset == -1) {
            return true;
        }
        int defEndOffset = defElement.getEndOffset();
        if (defEndOffset <= defStartOffset || defEndOffset <= defStartOffset + 1 || defEndOffset == -1) {
            defEndOffset = defStartOffset + nameLength;
        }
        return defStartOffset > currentOffset || currentOffset > defEndOffset;
    }

    public IRegion getFoldingRegion(IRfDefElement element, IDocument document) throws BadLocationException {
        return this.getFoldingRegion(element, document, false);
    }

    public IRegion getFoldingRegion(IRfDefElement element, IDocument document, boolean includeSingleLineRegions) throws BadLocationException {
        int documentLength = document.getLength();
        int elementStartOffset = element.getStartOffset();
        if (elementStartOffset < 0 || elementStartOffset > documentLength) {
            return null;
        }
        IRegion blockStartInfo = document.getLineInformationOfOffset(elementStartOffset);
        int startOffset = blockStartInfo.getOffset();
        if (startOffset < 0 || startOffset > documentLength) {
            return null;
        }
        int elementEndOffset = element.getEndOffset();
        if (elementEndOffset < 0 || elementEndOffset > documentLength) {
            return null;
        }
        IRegion blockEndInfo = document.getLineInformationOfOffset(elementEndOffset);
        if (!includeSingleLineRegions && blockStartInfo.equals(blockEndInfo)) {
            return null;
        }
        int endOffset = Math.min(blockEndInfo.getOffset() + blockEndInfo.getLength() + 1, documentLength);
        if (endOffset <= startOffset) {
            return null;
        }
        return new Region(startOffset, endOffset - startOffset);
    }

    public void debugWithStackTrace(String message) {
        this.debugWithStackTrace(message, TestHelper.err);
    }

    private void debugWithStackTrace(String message, PrintStream s) {
        if (s == null || !DVTLogger.INSTANCE.isDebugMode()) {
            return;
        }
        s.println();
        s.println("==================================================");
        s.println("On thread: " + Thread.currentThread().getName());
        if (message != null && !message.isEmpty()) {
            s.println(message);
        }
        s.println("==================================================");
        new Exception().printStackTrace(s);
        s.println("==================================================");
        s.println();
    }

    public String getAtParamComment(String paramName, String fromComment) {
        Pattern p;
        Matcher m;
        String result = "";
        if (fromComment != null && fromComment.contains("@param") && paramName != null && (m = (p = Pattern.compile("@param\\s+" + paramName + "\\s+")).matcher(fromComment)).find()) {
            int startIndex = m.end();
            int endIndex = fromComment.indexOf("@", startIndex);
            if (endIndex == -1) {
                endIndex = fromComment.length();
            }
            result = fromComment.substring(startIndex, endIndex);
        }
        return result;
    }

    public boolean isInSLNMode(String natureID) {
        return "ro.amiq.slndt.slnnature".equals(natureID);
    }

    public boolean isInSDLMode(String natureID) {
        return false;
    }

    public boolean isInSLNMode(IPluginConfig pluginConfig) {
        return "ro.amiq.slndt.slnnature".equals(pluginConfig.getNature());
    }

    public boolean isInSDLMode(IPluginConfig pluginConfig) {
        return false;
    }

    public boolean isInSlnLikeMode(IPluginConfig pluginConfig) {
        return "ro.amiq.slndt.slnnature".equals(pluginConfig.getNature());
    }

    public IProject getProject(IRfBaseElement element) {
        IRfSingleLangProject singleLangProject = element != null ? element.getRfProject() : null;
        return singleLangProject != null ? singleLangProject.getProject() : null;
    }

    public String getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public boolean isOpenClonedEditorSharingSameDocument(IDocument document) {
        if (document == null) {
            return false;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        if (editorReferences == null) {
            return false;
        }
        IEditorReference[] iEditorReferenceArray = editorReferences;
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            DVTEditor dvtEditor;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof DVTEditor && document == (dvtEditor = (DVTEditor)editor).getDocument()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public <T> List<T> nCopies(int i, T elementType) {
        ArrayList<T> result = new ArrayList<T>();
        int j = 0;
        while (j < i) {
            result.add(elementType);
            ++j;
        }
        return result;
    }

    public String executeProgram(List<String> command, String workingDirectory, int timeoutMS) {
        StringBuilder processOutput = new StringBuilder();
        try {
            ProcessBuilder pb = new ProcessBuilder(command).redirectErrorStream(true);
            if (workingDirectory != null && !workingDirectory.isEmpty()) {
                pb.directory(new File(workingDirectory));
            }
            Process process = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                processOutput.append(line).append('\n');
            }
            process.waitFor(timeoutMS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return processOutput.toString();
    }

    public Process startProcess(List<String> command, File workingDirectory) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        processBuilder.redirectErrorStream(true);
        processBuilder.environment().putAll(System.getenv());
        return processBuilder.start();
    }

    public Process startProcessAdditionalRedirect(List<String> command, File workingDirectory, Map<String, String> additionalEnvVars, boolean redirectError) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory);
        }
        if (redirectError) {
            processBuilder.redirectErrorStream(true);
        }
        processBuilder.environment().putAll(System.getenv());
        processBuilder.environment().putAll(additionalEnvVars);
        return processBuilder.start();
    }

    public void killProcess(Process process) {
        try {
            if (process != null && !process.waitFor(3000L, TimeUnit.MILLISECONDS)) {
                process.destroyForcibly();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public static IProject[] getProjects() {
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            ArrayList<IProject> result = new ArrayList<IProject>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && (project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.slndt.slnnature") || project.hasNature("ro.amiq.msdldt.msdlnature") || project.hasNature("ro.amiq.pssdt.pssnature") || project.hasNature("ro.amiq.vhdldt.VhdlNature"))) {
                    result.add(project);
                }
                ++n2;
            }
            return result.toArray(new IProject[result.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IProject[0];
        }
    }

    public static boolean isValidUUID(String id) {
        try {
            if (id != null && !id.isEmpty()) {
                UUID.fromString(id);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return false;
    }

    public long convertByteToMb(long size) {
        return size / 0x100000L;
    }

    public double convertMbToGb(double size) {
        return size / 1024.0;
    }

    public static String convertBytesToSuitableUnitString(long bytes) {
        if (bytes < 1024L) {
            return String.valueOf(bytes) + " Bytes";
        }
        int unitIndex = 0;
        double size = bytes;
        String[] units = new String[]{"Bytes", "KB", "MB", "GB", "TB", "PB", "EB"};
        while (size >= 1024.0 && unitIndex < units.length - 1) {
            size /= 1024.0;
            ++unitIndex;
        }
        return String.format("%.1f %s", size, units[unitIndex]);
    }

    public int getPid(Process process) {
        try {
            String processType = process.getClass().getName();
            if (processType.equals("java.lang.UNIXProcess")) {
                Field f2 = process.getClass().getDeclaredField("pid");
                f2.setAccessible(true);
                return f2.getInt(process);
            }
            Method declaredMethod = Process.class.getMethod("pid", new Class[0]);
            return ((Long)declaredMethod.invoke((Object)process, new Object[0])).intValue();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    public static <T> boolean compareDeques(Deque<T> deque1, Deque<T> deque2) {
        if (deque1 == null && deque2 == null) {
            return true;
        }
        if (deque1 == null || deque2 == null) {
            return false;
        }
        if (deque1.size() != deque2.size()) {
            return false;
        }
        Iterator<T> iterator1 = deque1.iterator();
        Iterator<T> iterator2 = deque2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            T elem1 = iterator1.next();
            T elem2 = iterator2.next();
            if ((elem1 != null || elem2 == null) && (elem1 == null || elem1.equals(elem2))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStackTrace(Throwable throwable) {
        String result = "";
        try {
            Throwable throwable2 = null;
            Object var4_5 = null;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    try (PrintStream ps = new PrintStream(os);){
                        throwable.printStackTrace(ps);
                        result = os.toString();
                    }
                    if (os == null) return result;
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    if (os == null) throw throwable2;
                    os.close();
                    throw throwable2;
                }
                os.close();
                return result;
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                } else {
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public int getFirstAvailablePortInRange(int start, int end, InetAddress bindAddress) {
        int result = 0;
        int port = start;
        while (port <= end) {
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (ServerSocket serverSocket = new ServerSocket(port, 0, bindAddress);){
                    if (serverSocket != null && serverSocket.getLocalPort() == port) {
                        result = port;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            ++port;
        }
        return result;
    }

    public static interface IEnvironmentProvider {
        public String getenv(String var1);
    }

    private static class Mapping {
        IPath input;
        String output;

        public Mapping(String input, String output) {
            if (input == null || output == null) {
                return;
            }
            this.input = Path.fromOSString((String)input);
            this.output = output;
            DVTLogger.INSTANCE.logDebug("DEBUG: Mapping path: '" + this.input + "' to '" + this.output + "'");
        }
    }

    public static enum ReplaceSysvarsPolicy {
        RETURN_NULL,
        LEAVE_UNREPLACED,
        REPLACE_WITH_EMPTY;

    }
}

