/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import ro.amiq.dvt.utils.IPhoneticDistanceAlgorithm;

public final class DefaultPhoneticDistanceAlgorithm
implements IPhoneticDistanceAlgorithm {
    public static final int COST_CASE = 10;
    public static final int COST_INSERT = 95;
    public static final int COST_REMOVE = 95;
    public static final int COST_SUBSTITUTE = 100;
    public static final int COST_SWAP = 90;

    @Override
    public final int getDistance(String from, String to) {
        char[] first = (" " + from).toCharArray();
        char[] second = (" " + to).toCharArray();
        int rows = first.length;
        int columns = second.length;
        int[][] metric = new int[rows][columns];
        int column = 1;
        while (column < columns) {
            metric[0][column] = metric[0][column - 1] + 95;
            ++column;
        }
        int row = 1;
        while (row < rows) {
            metric[row][0] = metric[row - 1][0] + 95;
            ++row;
        }
        int swap = Integer.MAX_VALUE;
        int change = Integer.MAX_VALUE;
        int row2 = 1;
        while (row2 < rows) {
            char source = first[row2];
            int column2 = 1;
            while (column2 < columns) {
                char target = second[column2];
                int diagonal = metric[row2 - 1][column2 - 1];
                if (source == target) {
                    metric[row2][column2] = diagonal;
                } else {
                    int insert;
                    int remove;
                    int minimum;
                    change = Integer.MAX_VALUE;
                    if (Character.toLowerCase(source) == Character.toLowerCase(target)) {
                        change = 10 + diagonal;
                    }
                    swap = Integer.MAX_VALUE;
                    if (row2 != 1 && column2 != 1 && source == second[column2 - 1] && first[row2 - 1] == target) {
                        swap = 90 + metric[row2 - 2][column2 - 2];
                    }
                    if (swap < (minimum = 100 + diagonal)) {
                        minimum = swap;
                    }
                    if (95 + (remove = metric[row2][column2 - 1]) < minimum) {
                        minimum = 95 + remove;
                    }
                    if (95 + (insert = metric[row2 - 1][column2]) < minimum) {
                        minimum = 95 + insert;
                    }
                    if (change < minimum) {
                        minimum = change;
                    }
                    metric[row2][column2] = minimum;
                }
                ++column2;
            }
            ++row2;
        }
        return metric[rows - 1][columns - 1];
    }
}

