/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.concurrent.atomic.AtomicLong;
import ro.amiq.dvt.interpreter.XValueHolderFactory;

public enum DistributionFunctions {
    INSTANCE;


    public long rtl_dist_chi_square(XValueHolderFactory factory, AtomicLong seed, long df) {
        long i;
        if (df > 0L) {
            double r = this.chi_square(seed, df);
            if (r >= 0.0) {
                i = (long)(r + 0.5);
            } else {
                r = -r;
                i = (long)(r + 0.5);
                i = -i;
            }
        } else {
            factory.logWarning("Chi_square distribution must have positive degree of freedom");
            i = 0L;
        }
        return i;
    }

    public long rtl_dist_erlang(XValueHolderFactory factory, AtomicLong seed, long k, long mean) {
        long i;
        if (k > 0L) {
            double r = this.erlangian(seed, k, mean);
            if (r >= 0.0) {
                i = (long)(r + 0.5);
            } else {
                r = -r;
                i = (long)(r + 0.5);
                i = -i;
            }
        } else {
            factory.logWarning("k-stage erlangian distribution must have positive k");
            i = 0L;
        }
        return i;
    }

    public long rtl_dist_exponential(XValueHolderFactory factory, AtomicLong seed, long mean) {
        long i;
        if (mean > 0L) {
            double r = this.exponential(seed, mean);
            if (r >= 0.0) {
                i = (long)(r + 0.5);
            } else {
                r = -r;
                i = (long)(r + 0.5);
                i = -i;
            }
        } else {
            factory.logWarning("Exponential distribution must have a positive mean");
            i = 0L;
        }
        return i;
    }

    public long rtl_dist_normal(XValueHolderFactory factory, AtomicLong seed, long mean, long sd) {
        long i;
        double r = this.normal(seed, mean, sd);
        if (r >= 0.0) {
            i = (long)(r + 0.5);
        } else {
            r = -r;
            i = (long)(r + 0.5);
            i = -i;
        }
        return i;
    }

    public long rtl_dist_poisson(XValueHolderFactory factory, AtomicLong seed, long mean) {
        long i;
        if (mean > 0L) {
            i = this.poisson(seed, mean);
        } else {
            factory.logWarning("Poisson distribution must have a positive mean");
            i = 0L;
        }
        return i;
    }

    public long rtl_dist_t(XValueHolderFactory factory, AtomicLong seed, long df) {
        long i;
        if (df > 0L) {
            double r = this.t(seed, df);
            if (r >= 0.0) {
                i = (long)(r + 0.5);
            } else {
                r = -r;
                i = (long)(r + 0.5);
                i = -i;
            }
        } else {
            factory.logWarning("t distribution must have positive degree of freedom");
            i = 0L;
        }
        return i;
    }

    public long rtl_dist_uniform(XValueHolderFactory factory, AtomicLong seed, long start, long end) {
        long i;
        if (start >= end) {
            return start;
        }
        if (end != Long.MAX_VALUE) {
            double r;
            if ((i = (r = this.uniform(seed, start, ++end)) >= 0.0 ? (long)r : (long)(r - 1.0)) < start) {
                i = start;
            }
            if (i >= end) {
                i = end - 1L;
            }
        } else if (start != Long.MIN_VALUE) {
            double r;
            if ((i = (r = this.uniform(seed, --start, end) + 1.0) >= 0.0 ? (long)r : (long)(r - 1.0)) <= start) {
                i = start + 1L;
            }
            if (i > end) {
                i = end;
            }
        } else {
            double r = (this.uniform(seed, start, end) + 2.147483648E9) / 4.294967295E9;
            i = (r = r * 4.294967296E9 - 2.147483648E9) >= 0.0 ? (long)r : (long)(r - 1.0);
        }
        return i;
    }

    private double uniform(AtomicLong seed, long start, long end) {
        if (seed.get() == 0L) {
            seed.set(259341593L);
        }
        seed.set(69069L * seed.get() + 1L & 0xFFFFFFFFL);
        if (seed.get() > Integer.MAX_VALUE) {
            seed.set(seed.get() - 0x100000000L);
        }
        long u_stemp = seed.get() & 0xFFFFFFFFL;
        u_stemp = u_stemp >> 9 | 0x3F800000L;
        float c = Float.intBitsToFloat((int)u_stemp);
        double d = 1.1920928955078125E-7;
        c = (float)((double)c + (double)c * d);
        return (double)(end - start) * ((double)c - 1.0) + (double)start;
    }

    private double normal(AtomicLong seed, long mean, long deviation) {
        double s = 1.0;
        double v1 = 0.0;
        while (s >= 1.0 || s == 0.0) {
            v1 = this.uniform(seed, -1L, 1L);
            double v2 = this.uniform(seed, -1L, 1L);
            s = v1 * v1 + v2 * v2;
        }
        s = v1 * StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        return s * (double)deviation + (double)mean;
    }

    private double exponential(AtomicLong seed, long mean) {
        double n = this.uniform(seed, 0L, 1L);
        if (n != 0.0) {
            n = -StrictMath.log(n) * (double)mean;
        }
        return n;
    }

    private long poisson(AtomicLong seed, long mean) {
        long n = 0L;
        double p = StrictMath.exp(-mean);
        double q = this.uniform(seed, 0L, 1L);
        while (p < q) {
            ++n;
            q = this.uniform(seed, 0L, 1L) * q;
        }
        return n;
    }

    private double chi_square(AtomicLong seed, long degOfFree) {
        double x;
        if (degOfFree % 2L == 1L) {
            x = this.normal(seed, 0L, 1L);
            x *= x;
        } else {
            x = 0.0;
        }
        int k = 2;
        while ((long)k <= degOfFree) {
            x += 2.0 * this.exponential(seed, 1L);
            k += 2;
        }
        return x;
    }

    private double t(AtomicLong seed, long degOfFree) {
        double chi2 = this.chi_square(seed, degOfFree);
        double root = StrictMath.sqrt(chi2 / (double)degOfFree);
        return this.normal(seed, 0L, 1L) / root;
    }

    private double erlangian(AtomicLong seed, long k, long mean) {
        double x = 1.0;
        int i = 1;
        while ((long)i <= k) {
            x *= this.uniform(seed, 0L, 1L);
            ++i;
        }
        return (double)(-mean) * StrictMath.log(x) / (double)k;
    }
}

