/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.math.BigInteger;

public class EBitVector {
    public static final BigInteger BIG_INTEGER_TWO = BigInteger.valueOf(2L);
    public static final EBitVector ZERO = new EBitVector(true, 31, 0, BigInteger.ZERO);
    public static final EBitVector ONE = new EBitVector(true, 31, 0, BigInteger.ONE);
    public static final EBitVector NEGATIVE_ONE = new EBitVector(true, 31, 0, BigInteger.valueOf(-1L));
    public static final EBitVector UNDEFINED = new UNDEFINED();
    public static final EBitVector FALSE = new EBitVector(false, 0, 0, BigInteger.ZERO);
    public static final EBitVector TRUE = new EBitVector(false, 0, 0, BigInteger.ONE);
    protected boolean sign;
    protected int left;
    protected int right;
    private BigInteger number;

    public EBitVector(boolean signed, int left, int right) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.number = BigInteger.ZERO;
    }

    private EBitVector(boolean signed, int left, int right, BigInteger number) {
        this.sign = signed;
        this.left = left;
        this.right = right;
        this.number = number;
        this.from(this);
    }

    private EBitVector(EBitVector bs) {
        this.sign = bs.sign;
        this.left = bs.left;
        this.right = bs.right;
        this.number = new BigInteger(bs.number.toByteArray());
    }

    public int getSize() {
        return Math.abs(this.left - this.right) + 1;
    }

    public boolean hasSign() {
        return this.sign;
    }

    public Number numberValue() {
        return this.bigIntegerValue();
    }

    public BigInteger bigIntegerValue() {
        return this.number;
    }

    public int intValue() {
        return this.number.intValue();
    }

    public EBitVector setValue(String number, int radix) {
        this.number = new BigInteger(number, radix);
        EBitVector result = this.from(this);
        this.number = result.number;
        return this;
    }

    public EBitVector setValue(BigInteger number) {
        this.number = number;
        EBitVector result = this.from(this);
        this.number = result.number;
        return this;
    }

    public static EBitVector from(boolean signed, int number) {
        EBitVector result = new EBitVector(signed, 31, 0);
        result.setValue(BigInteger.valueOf(number));
        return result;
    }

    public EBitVector from(EBitVector bs) {
        int end;
        int start;
        int resultSize = this.getSize() - 1;
        if (bs.left > bs.right) {
            start = resultSize;
            end = 0;
        } else {
            start = 0;
            end = resultSize;
        }
        EBitVector result = bs.getRange(start, end, this.hasSign());
        result.convertInRange();
        return result;
    }

    public EBitVector not() {
        EBitVector result = new EBitVector(this);
        result.number = result.number.not();
        return result;
    }

    public EBitVector plus(EBitVector bs) {
        return this.plus(bs, this.getResultSize(bs), false);
    }

    public EBitVector plus(EBitVector bs, boolean forceUnsigned) {
        return this.plus(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector plus(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.add(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector minus(EBitVector bs) {
        return this.minus(bs, this.getResultSize(bs), false);
    }

    public EBitVector minus(EBitVector bs, boolean forceUnsigned) {
        return this.minus(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector minus(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.subtract(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector multiply(EBitVector bs) {
        return this.multiply(bs, this.getResultSize(bs), false);
    }

    public EBitVector multiply(EBitVector bs, boolean forceUnsigned) {
        return this.multiply(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector multiply(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.multiply(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector divide(EBitVector bs) {
        return this.divide(bs, this.getResultSize(bs), false);
    }

    public EBitVector divide(EBitVector bs, boolean forceUnsigned) {
        return this.divide(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector divide(EBitVector bs, int resultSize, boolean forceUnsigned) {
        if (bs.equals(ZERO)) {
            throw new ArithmeticException("Cannot divide by ZERO");
        }
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.divide(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector mod(EBitVector bs) {
        return this.mod(bs, this.getResultSize(bs), false);
    }

    public EBitVector mod(EBitVector bs, boolean forceUnsigned) {
        return this.mod(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector mod(EBitVector bs, int resultSize, boolean forceUnsigned) {
        if (bs.equals(ZERO)) {
            throw new ArithmeticException("Cannot divide by ZERO");
        }
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        EBitVector quotient = thisBS.divide(otherBS);
        result.number = thisBS.minus((EBitVector)quotient.multiply((EBitVector)otherBS)).number;
        result = result.from(result);
        return result;
    }

    public EBitVector pow(int exponent) {
        return this.pow(exponent, this.getSize());
    }

    public EBitVector pow(int exponent, int resultSize) {
        EBitVector result = new EBitVector(this.sign, resultSize - 1, 0);
        if (exponent == 0) {
            return result.from(ONE);
        }
        if (this.number.compareTo(BigInteger.ONE) == 0) {
            return result.from(ONE);
        }
        if (exponent < 0 && (this.number.compareTo(BigInteger.valueOf(-1L)) < 0 || this.number.compareTo(BigInteger.ONE) > 0)) {
            return result.from(ZERO);
        }
        if (this.number.compareTo(BigInteger.ZERO) == 0) {
            if (exponent > 0) {
                return result.from(ZERO);
            }
            if (exponent < 0) {
                throw new ArithmeticException("Cannot power ZERO to negative exponent");
            }
        }
        if (this.number.compareTo(BigInteger.valueOf(-1L)) == 0 && exponent < 0) {
            if (exponent % 2 == 0) {
                return result.from(ONE);
            }
            return result.from(NEGATIVE_ONE);
        }
        result.number = this.number.pow(exponent);
        result = result.from(result);
        return result;
    }

    public EBitVector and(EBitVector bs) {
        return this.and(bs, this.getResultSize(bs), false);
    }

    public EBitVector and(EBitVector bs, boolean forceUnsigned) {
        return this.and(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector and(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.and(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector or(EBitVector bs) {
        return this.or(bs, this.getResultSize(bs), false);
    }

    public EBitVector or(EBitVector bs, boolean forceUnsigned) {
        return this.or(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector or(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.or(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector xor(EBitVector bs) {
        return this.xor(bs, this.getResultSize(bs), false);
    }

    public EBitVector xor(EBitVector bs, boolean forceUnsigned) {
        return this.xor(bs, this.getResultSize(bs), forceUnsigned);
    }

    public EBitVector xor(EBitVector bs, int resultSize, boolean forceUnsigned) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        boolean resultSign = forceUnsigned ? false : thisBS.hasSign() && otherBS.hasSign();
        EBitVector result = new EBitVector(resultSign, resultSize - 1, 0);
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        result.number = thisBS.number.xor(otherBS.number);
        result = result.from(result);
        return result;
    }

    public EBitVector shiftLeft(int shl) {
        return this.shiftLeft(shl, this.getSize());
    }

    public EBitVector shiftLeft(int shl, int resultSize) {
        EBitVector result = new EBitVector(this.sign, resultSize - 1, 0);
        result.number = this.number.shiftLeft(shl);
        result = result.from(result);
        return result;
    }

    public EBitVector shiftRight(int shr, boolean keepSign) {
        return this.shiftRight(shr, keepSign, this.getSize());
    }

    public EBitVector shiftRight(int shr, boolean keepSign, int resultSize) {
        EBitVector result = new EBitVector(this.sign, resultSize - 1, 0);
        result.number = this.number;
        if (!keepSign) {
            result.signedToUnsigned();
        }
        result.sign = this.sign;
        result.number = result.number.shiftRight(shr);
        result = result.from(result);
        return result;
    }

    public EBitVector abs() {
        EBitVector result = new EBitVector(false, this.getSize() - 1, 0);
        result.number = result.number.abs();
        return result;
    }

    public EBitVector band() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.getSize()) {
            if (!result) {
                return FALSE;
            }
            result &= this.number.testBit(i);
            ++i;
        }
        return TRUE;
    }

    public EBitVector nband() {
        if (this.band() == TRUE) {
            return FALSE;
        }
        return TRUE;
    }

    public EBitVector bxor() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.getSize()) {
            result ^= this.number.testBit(i);
            ++i;
        }
        if (!result) {
            return FALSE;
        }
        return TRUE;
    }

    public EBitVector nbxor() {
        if (this.bxor() == TRUE) {
            return FALSE;
        }
        return TRUE;
    }

    public EBitVector bor() {
        int i = Math.min(this.left, this.right);
        boolean result = this.number.testBit(i);
        ++i;
        while (i < this.getSize()) {
            if (result) {
                return TRUE;
            }
            result |= this.number.testBit(i);
            ++i;
        }
        return FALSE;
    }

    public EBitVector nbor() {
        if (this.bor() == TRUE) {
            return FALSE;
        }
        return TRUE;
    }

    public boolean gt(EBitVector bs) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        int resultSize = this.getResultSize(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        return thisBS.number.compareTo(otherBS.number) > 0;
    }

    public boolean lt(EBitVector bs) {
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector(bs);
        boolean resultSign = thisBS.hasSign() && otherBS.hasSign();
        int resultSize = this.getResultSize(bs);
        thisBS.left = resultSize - 1;
        thisBS.right = 0;
        otherBS.left = resultSize - 1;
        otherBS.right = 0;
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        return thisBS.number.compareTo(otherBS.number) < 0;
    }

    private EBitVector getRange(int start, int end, boolean forceSign) {
        int min;
        int max;
        if (this.left > this.right && start < end) {
            throw new IllegalArgumentException("Range of part-select is reversed!");
        }
        if (this.left > this.right) {
            max = start - this.right;
            min = end - this.right;
        } else {
            max = start - this.left;
            min = end - this.left;
        }
        int resultSize = max - min;
        EBitVector result = new EBitVector(forceSign, this.left > this.right ? resultSize : 0, this.left > this.right ? 0 : resultSize);
        BigInteger mask = BIG_INTEGER_TWO.pow(max + 1).subtract(BigInteger.ONE).subtract(BIG_INTEGER_TWO.pow(min).subtract(BigInteger.ONE));
        result.number = this.number.and(mask).shiftRight(min);
        return result;
    }

    public EBitVector getRange(int start, int end) {
        return this.getRange(start, end, false);
    }

    public void setRange(EBitVector bs, int start, int end) {
        int min;
        int max;
        if (this.left > this.right && start < end) {
            throw new RuntimeException("Range of part-select is reversed!");
        }
        if (this.left > this.right) {
            max = start - this.right;
            min = end - this.right;
        } else {
            max = start - this.left;
            min = end - this.left;
        }
        int size = this.getSize();
        BigInteger mask = BIG_INTEGER_TWO.pow(size).subtract(BigInteger.ONE).subtract(BIG_INTEGER_TWO.pow(max + 1).subtract(BigInteger.ONE)).add(BIG_INTEGER_TWO.pow(min).subtract(BigInteger.ONE));
        this.number = this.number.and(mask);
        this.number = this.number.or(bs.number.shiftLeft(size - end - 1));
    }

    private void convertInRange() {
        BigInteger minValue;
        BigInteger maxValue;
        int size = this.getSize();
        BigInteger modRange = BIG_INTEGER_TWO.pow(size);
        if (this.hasSign()) {
            maxValue = BIG_INTEGER_TWO.pow(size - 1).subtract(BigInteger.ONE);
            minValue = BIG_INTEGER_TWO.pow(size - 1).negate();
        } else {
            maxValue = BIG_INTEGER_TWO.pow(size).subtract(BigInteger.ONE);
            minValue = BigInteger.ZERO;
        }
        while (this.number.compareTo(minValue) < 0) {
            this.number = this.number.add(modRange);
        }
        while (this.number.compareTo(maxValue) > 0) {
            this.number = this.number.subtract(modRange);
        }
    }

    private void signedToUnsigned() {
        int size = this.getSize();
        BigInteger modRange = BIG_INTEGER_TWO.pow(size);
        while (this.number.compareTo(BigInteger.ZERO) < 0) {
            this.number = this.number.add(modRange);
        }
        this.sign = false;
    }

    public boolean equals(Object obj) {
        boolean resultSign;
        if (!(obj instanceof EBitVector)) {
            return false;
        }
        EBitVector thisBS = new EBitVector(this);
        EBitVector otherBS = new EBitVector((EBitVector)obj);
        boolean bl = resultSign = thisBS.hasSign() && otherBS.hasSign();
        if (!resultSign && thisBS.hasSign()) {
            thisBS.signedToUnsigned();
        }
        if (!resultSign && otherBS.hasSign()) {
            otherBS.signedToUnsigned();
        }
        return thisBS.number.compareTo(otherBS.number) == 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.left;
        result = 31 * result + (this.number == null ? 0 : this.number.hashCode());
        result = 31 * result + this.right;
        result = 31 * result + (this.sign ? 1231 : 1237);
        return result;
    }

    private int getResultSize(EBitVector bs) {
        if (this.getSize() <= 32 && bs.getSize() <= 32) {
            return 32;
        }
        return 64;
    }

    private static class UNDEFINED
    extends EBitVector {
        public UNDEFINED() {
            super(true, 31, 0, BigInteger.ZERO);
        }

        public String toString() {
            return "[undefined]";
        }
    }
}

