/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.util.Arrays;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.utils.AbstractElementListSelectionDialog;
import ro.amiq.dvt.utils.DVTFileUtils;

public class ElementListSelectionDialog
extends AbstractElementListSelectionDialog {
    private Object[] fElements;
    private final boolean isSaveLoadBuildPhaseModel;

    public ElementListSelectionDialog(Shell parent, ILabelProvider renderer, boolean isSaveLoadBuildPhaseModel) {
        super(parent, renderer);
        this.isSaveLoadBuildPhaseModel = isSaveLoadBuildPhaseModel;
    }

    public ElementListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
        this.isSaveLoadBuildPhaseModel = false;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        this.setListElements(this.fElements);
        this.autoResize();
        this.setSelection(this.getInitialElementSelections().toArray());
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        final ElementListSelectionDialog elementDialog = this;
        if (this.isSaveLoadBuildPhaseModel) {
            Button openButton = this.createButton(parent, 11, IDialogConstants.OPEN_LABEL, true);
            openButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    FileDialog dialog = new FileDialog(ElementListSelectionDialog.this.getShell());
                    dialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
                    String path = dialog.open();
                    if (path == null || path.length() == 0) {
                        return;
                    }
                    elementDialog.close();
                    XVMBuildPhaseXMLParser.INSTANCE.parse(new File(path), DVTPlugin.getSelectionManager().getLastSelectedProject());
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }
}

