/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ro.amiq.dvt.utils.ByteBufferInputStream;
import ro.amiq.dvt.utils.PFileInputStream;

public class FileInputStreamUtils {
    private static final boolean USE_MEMORY_MAPPED_FILE = System.getenv("DVT_ENABLE_MMF") != null;
    private static final long MAX_SIZE = 524288L;

    public static InputStream createStream(String fileName) throws IOException {
        return FileInputStreamUtils.createStream(new File(fileName));
    }

    public static InputStream createStream(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("Argument " + file.getName() + " is not a file!");
        }
        if (USE_MEMORY_MAPPED_FILE) {
            return new BufferedInputStream(new ByteBufferInputStream(file));
        }
        long length = file.length();
        if (length < 0L) {
            throw new IOException("Argument " + file.getName() + " has negative size!");
        }
        if (length < 524288L) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        return new PFileInputStream(file, length);
    }
}

