/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

class FileLinkListSelectionDialog
extends ElementListSelectionDialog {
    Text fLinkDesc;
    private Label fLabel;

    public FileLinkListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent, renderer);
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] selectedObjs = this.getSelectedElements();
        if (selectedObjs.length > 0 && selectedObjs[0] != null) {
            this.fLinkDesc.setText(((IResource)selectedObjs[0]).getLocation().toOSString());
            this.fLabel.setText("Full path:");
        } else {
            this.fLinkDesc.setText("");
        }
        this.fLinkDesc.getParent().layout();
    }

    protected Control createDialogArea(Composite parent) {
        Control container = super.createDialogArea(parent);
        Composite composite = new Composite((Composite)container, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 50;
        gd.minimumWidth = 600;
        composite.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        this.fLabel = new Label(composite, 0);
        this.fLabel.setText("");
        this.fLabel.setVisible(true);
        this.fLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fLabel.getParent().layout();
        this.fLinkDesc = new Text(composite, 2048);
        this.fLinkDesc.setText("");
        this.fLinkDesc.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fLinkDesc.setVisible(true);
        this.fLinkDesc.setEditable(false);
        this.fLinkDesc.setEnabled(true);
        this.fLinkDesc.getParent().layout();
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLinkDesc, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fLinkDesc, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor"));
        return container;
    }

    protected Text createFilterText(Composite parent) {
        Text filterText = super.createFilterText(parent);
        filterText.setMessage("Filter list (* = any string, ? = any char)");
        filterText.getParent().redraw();
        return filterText;
    }
}

