/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FloatFieldEditor
extends StringFieldEditor {
    private float minValidValue = -3.4028235E38f;
    private float maxValidValue = Float.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected FloatFieldEditor() {
    }

    public FloatFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, 10, parent);
    }

    public FloatFieldEditor(String name, String labelText, int width, Composite parent) {
        super(name, labelText, width, parent);
        this.setTextLimit(10);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage("Value must be a float");
    }

    public FloatFieldEditor(String name, String labelText, Composite parent, int textLimit, int width) {
        super(name, labelText, width, parent);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage("Value must be a float");
    }

    public void setValidRange(float min, float max) {
        this.minValidValue = min;
        this.maxValidValue = max;
    }

    protected boolean doCheckState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                float number = Float.parseFloat(numberString);
                if (!(number >= this.minValidValue) || !(number <= this.maxValidValue)) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getFloat(this.getPreferenceName());
            text.setText("" + value);
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            float value = this.getPreferenceStore().getDefaultFloat(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), Float.parseFloat(text.getText()));
        }
    }

    public float getFloatValue() throws NumberFormatException {
        return Float.parseFloat(this.getStringValue());
    }
}

