/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTProcessRunner;

public class GCCUtils {
    public static String getGCCPath(IProject project) {
        String gccPath = BuildConfigManager.getGccPath(project);
        if (gccPath != null) {
            return gccPath;
        }
        return GCCUtils.getBinaryPath("gcc");
    }

    public static String getBinaryPath(String name) {
        String[] paths;
        String pathVarValue = System.getenv("PATH");
        if (pathVarValue == null) {
            return null;
        }
        String[] stringArray = paths = pathVarValue.split(File.pathSeparator);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String pathEntry = stringArray[n2];
            File binary = new File(pathEntry, name);
            if (binary.exists() && binary.canExecute()) {
                return binary.getAbsolutePath();
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getCSystemHeadersIncdirs(IProject project) {
        ArrayList<String> incdirPaths = new ArrayList<String>();
        String gccPath = GCCUtils.getGCCPath(project);
        if (gccPath == null) {
            return incdirPaths;
        }
        String gccArgs = BuildConfigManager.getGccArgs(project);
        if (gccArgs == null) {
            gccArgs = "";
        }
        try {
            File file = File.createTempFile("dvt_c_empty_file", ".cpp");
            List<String> cmd = null;
            cmd = gccArgs.isEmpty() ? Arrays.asList(gccPath, "-v", "-E", "-x", "c++", file.getAbsolutePath()) : Arrays.asList(gccPath, gccArgs, "-v", "-E", "-x", "c++", file.getAbsolutePath());
            DVTProcessRunner dvtProcess = new DVTProcessRunner(cmd.toArray(new String[cmd.size()]));
            dvtProcess.run((IProgressMonitor)new NullProgressMonitor());
            String[] stderrLines = dvtProcess.getErrorOutput().split("\\r?\\n");
            boolean getNextPaths = false;
            String[] stringArray = stderrLines;
            int n = stderrLines.length;
            int n2 = 0;
            while (n2 < n) {
                File dir;
                String line = stringArray[n2];
                if (line.equals("#include <...> search starts here:") || line.equals("#include \"...\" search starts here:")) {
                    getNextPaths = true;
                } else if (getNextPaths && (dir = new File(line.trim())).isDirectory() && dir.canRead()) {
                    incdirPaths.add(dir.getAbsolutePath());
                }
                ++n2;
            }
            file.delete();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return incdirPaths;
    }
}

