/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private static ArrayList<ReplacementRule> fPlurals = new ArrayList();
    private static ArrayList<ReplacementRule> fSingulars;
    private static ArrayList<String> fUncountables;

    static {
        fPlurals.add(0, new ReplacementRule("$", "s"));
        fPlurals.add(0, new ReplacementRule("(?i)s$", "s"));
        fPlurals.add(0, new ReplacementRule("(?i)(ax|test)is$", "$1es"));
        fPlurals.add(0, new ReplacementRule("(?i)(octop|vir)us$", "$1i"));
        fPlurals.add(0, new ReplacementRule("(?i)(alias|status)$", "$1es"));
        fPlurals.add(0, new ReplacementRule("(?i)(bu)s$", "$1es"));
        fPlurals.add(0, new ReplacementRule("(?i)(buffal|tomat)o$", "$1oes"));
        fPlurals.add(0, new ReplacementRule("(?i)([ti])um$", "$1a"));
        fPlurals.add(0, new ReplacementRule("sis$", "ses"));
        fPlurals.add(0, new ReplacementRule("(?i)(?:([^f])fe|([lr])f)$", "$1$2ves"));
        fPlurals.add(0, new ReplacementRule("(?i)(hive)$", "$1s"));
        fPlurals.add(0, new ReplacementRule("(?i)([^aeiouy]|qu)y$", "$1ies"));
        fPlurals.add(0, new ReplacementRule("(?i)(x|ch|ss|sh)$", "$1es"));
        fPlurals.add(0, new ReplacementRule("(?i)(matr|vert|ind)(?:ix|ex)$", "$1ices"));
        fPlurals.add(0, new ReplacementRule("(?i)([m|l])ouse$", "$1ice"));
        fPlurals.add(0, new ReplacementRule("^(?i)(ox)$", "$1en"));
        fPlurals.add(0, new ReplacementRule("(?i)(quiz)$", "$1zes"));
        fSingulars = new ArrayList();
        fSingulars.add(0, new ReplacementRule("s$", ""));
        fSingulars.add(0, new ReplacementRule("(n)ews$", "$1ews"));
        fSingulars.add(0, new ReplacementRule("([ti])a$", "$1um"));
        fSingulars.add(0, new ReplacementRule("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis"));
        fSingulars.add(0, new ReplacementRule("(^analy)ses$", "$1sis"));
        fSingulars.add(0, new ReplacementRule("([^f])ves$", "$1fe"));
        fSingulars.add(0, new ReplacementRule("(hive)s$", "$1"));
        fSingulars.add(0, new ReplacementRule("(tive)s$", "$1"));
        fSingulars.add(0, new ReplacementRule("([lr])ves$", "$1f"));
        fSingulars.add(0, new ReplacementRule("([^aeiouy]|qu)ies$", "$1y"));
        fSingulars.add(0, new ReplacementRule("(s)eries$", "$1eries"));
        fSingulars.add(0, new ReplacementRule("(m)ovies$", "$1ovie"));
        fSingulars.add(0, new ReplacementRule("(x|ch|ss|sh)es$", "$1"));
        fSingulars.add(0, new ReplacementRule("([m|l])ice$", "$1ouse"));
        fSingulars.add(0, new ReplacementRule("(bus)es$", "$1"));
        fSingulars.add(0, new ReplacementRule("(o)es$", "$1"));
        fSingulars.add(0, new ReplacementRule("(shoe)s$", "$1"));
        fSingulars.add(0, new ReplacementRule("(cris|ax|test)es$", "$1is"));
        fSingulars.add(0, new ReplacementRule("(octop|vir)i$", "$1us"));
        fSingulars.add(0, new ReplacementRule("(alias|status)es$", "$1"));
        fSingulars.add(0, new ReplacementRule("(ox)en$", "$1"));
        fSingulars.add(0, new ReplacementRule("(virt|ind)ices$", "$1ex"));
        fSingulars.add(0, new ReplacementRule("(matr)ices$", "$1ix"));
        fSingulars.add(0, new ReplacementRule("(quiz)zes$", "$1"));
        Inflector.irregular("person", "people");
        Inflector.irregular("man", "men");
        Inflector.irregular("child", "children");
        Inflector.irregular("sex", "sexes");
        Inflector.irregular("move", "moves");
        Inflector.irregular("cow", "kine");
        fUncountables = new ArrayList(8);
        fUncountables.add("equipment");
        fUncountables.add("information");
        fUncountables.add("rice");
        fUncountables.add("money");
        fUncountables.add("species");
        fUncountables.add("series");
        fUncountables.add("fish");
        fUncountables.add("sheep");
    }

    private static void irregular(String singular, String plural) {
        if (singular.substring(0, 1).equalsIgnoreCase(plural.substring(0, 1))) {
            String regexp = "(?i)(" + singular.substring(0, 1) + ")" + singular.substring(1) + "$";
            String repl = "$1" + plural.substring(1);
            fPlurals.add(0, new ReplacementRule(regexp, repl));
            regexp = "(?i)(" + plural.substring(0, 1) + ")" + plural.substring(1) + "$";
            repl = "$1" + singular.substring(1);
            fSingulars.add(0, new ReplacementRule(regexp, repl));
        } else {
            String regexp = String.valueOf(singular.substring(0, 1).toUpperCase()) + "(?i)" + singular.substring(1) + "$";
            String repl = String.valueOf(plural.substring(0, 1).toUpperCase()) + plural.substring(1);
            fPlurals.add(0, new ReplacementRule(regexp, repl));
            regexp = String.valueOf(singular.substring(0, 1).toLowerCase()) + "(?i)" + singular.substring(1) + "$";
            repl = String.valueOf(plural.substring(0, 1).toLowerCase()) + plural.substring(1);
            fPlurals.add(0, new ReplacementRule(regexp, repl));
            regexp = String.valueOf(plural.substring(0, 1).toUpperCase()) + "(?i)" + plural.substring(1) + "$";
            repl = String.valueOf(singular.substring(0, 1).toUpperCase()) + singular.substring(1);
            fSingulars.add(0, new ReplacementRule(regexp, repl));
            regexp = String.valueOf(plural.substring(0, 1).toLowerCase()) + "(?i)" + plural.substring(1) + "$";
            repl = String.valueOf(singular.substring(0, 1).toLowerCase()) + singular.substring(1);
            fSingulars.add(0, new ReplacementRule(regexp, repl));
        }
    }

    public static String pluralize(String word) {
        String out = word;
        if (out.length() == 0 || !fUncountables.contains(word.toLowerCase())) {
            for (ReplacementRule r : fPlurals) {
                if (!r.find(word)) continue;
                out = r.replace(word);
                break;
            }
        }
        return out;
    }

    public static String singularize(String word) {
        String out = word;
        if (out.length() == 0 || !fUncountables.contains(out.toLowerCase())) {
            for (ReplacementRule r : fSingulars) {
                if (!r.find(word)) continue;
                out = r.replace(word);
                break;
            }
        }
        return out;
    }

    private static class ReplacementRule {
        private Pattern fPattern;
        private Matcher fMatcher;
        private String fString;

        public ReplacementRule(String regexp, String replacement) {
            this.fPattern = Pattern.compile(regexp);
            this.fString = replacement;
        }

        public boolean find(String word) {
            this.fMatcher = this.fPattern.matcher(word);
            return this.fMatcher.find();
        }

        public String replace(String word) {
            this.fMatcher = this.fPattern.matcher(word);
            return this.fMatcher.replaceAll(this.fString);
        }
    }
}

