/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;

public class InsensitiveLinkedMap<V extends IDVTMapElement<String>>
extends DVTLinkedHashMap<String, V> {
    private static final long serialVersionUID = 1L;

    @Override
    public V get(String key) {
        String key2 = InsensitiveLinkedMap.adjustCase(key);
        return super.get(key2);
    }

    private static final String adjustCase(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        char first = key.charAt(0);
        return first == '\\' || first == '\'' ? key : DVTStringUtil.toLowerCase(key);
    }

    @Override
    public void remove(String key) {
        String key2 = InsensitiveLinkedMap.adjustCase(key);
        super.remove(key2);
    }

    @Override
    public boolean containsKey(String key) {
        String key2 = InsensitiveLinkedMap.adjustCase(key);
        return super.containsKey(key2);
    }

    public void putAll(InsensitiveLinkedMap<V> map) {
        for (IDVTMapElement val : map) {
            if (super.containsKey((String)val.getKey())) continue;
            super.put((String)val.getKey(), val);
        }
    }
}

