/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JarUtils {
    private static final int BUFFER_SIZE = 8192;

    public static void extractFile(String fileName, Class<?> packageClass, String destinationDirectory, boolean createDestinationDirectory) throws IOException {
        try (InputStream fileStream = JarUtils.getFileStream(fileName, packageClass);){
            File destinationFile = JarUtils.checkDestinationDirectory(destinationDirectory, createDestinationDirectory);
            JarUtils.copyStreamToFile(fileStream, new File(destinationFile, new File(fileName).getName()));
        }
    }

    public static boolean exists(String fileName, Class<?> packageClass) {
        try {
            Throwable throwable = null;
            Object var3_3 = null;
            try {
                InputStream fileStream = JarUtils.getFileStream(fileName, packageClass);
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public static void extractDirectory(String directoryName, Class<?> packageClass, boolean extractDirectoryContents, String destinationDirectory, boolean createDestinationDirectory) throws IOException {
        Path sourcePath = JarUtils.getCodeSourcePath(packageClass);
        if (sourcePath == null) {
            throw new IOException(new NullPointerException("getCodeSourcePath() result is null!"));
        }
        String directoryResolvedName = JarUtils.resolveName(directoryName, packageClass);
        File destinationFile = JarUtils.checkDestinationDirectory(destinationDirectory, createDestinationDirectory);
        if (sourcePath.getFileName().toString().endsWith(".jar")) {
            int subPathLength = 0;
            if (extractDirectoryContents) {
                subPathLength = directoryResolvedName.length();
            } else {
                subPathLength = directoryResolvedName.lastIndexOf(47);
                if (subPathLength < 0) {
                    subPathLength = 0;
                }
            }
            ++subPathLength;
            try (JarFile jarFile = null;){
                jarFile = new JarFile(sourcePath.toFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String newFileName;
                    String entryName;
                    JarEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(directoryResolvedName) || (newFileName = entryName.substring(subPathLength)).isEmpty()) continue;
                    File file = new File(destinationFile, entryName.substring(subPathLength));
                    JarUtils.checkDestinationDirectory(file.getParent(), true);
                    JarUtils.copyStreamToFile(jarFile.getInputStream(entry), file);
                }
            }
        } else {
            Path rootPath = JarUtils.resolveSourcePath(sourcePath, directoryName.startsWith("/"));
            File directoryFile = new File(rootPath.toFile(), directoryResolvedName);
            File[] fileList = null;
            fileList = extractDirectoryContents ? directoryFile.listFiles() : new File[]{directoryFile};
            JarUtils.copyFilesToDirectory(fileList, destinationFile);
        }
    }

    public static File getDirectory(String directoryName, Class<?> packageClass, boolean getParent) {
        Path sourcePath = JarUtils.getCodeSourcePath(packageClass);
        if (sourcePath == null) {
            return null;
        }
        if (getParent) {
            sourcePath = sourcePath.getParent();
        }
        return new File(sourcePath + File.separator + directoryName);
    }

    public static InputStream getFileStream(String fileName, Class<?> packageClass) throws IOException {
        InputStream fileStream = null;
        if (fileName.startsWith("/")) {
            Path sourcePath = JarUtils.getCodeSourcePath(packageClass);
            if (sourcePath == null) {
                throw new IOException(new NullPointerException("getCodeSourcePath() result is null!"));
            }
            if (!sourcePath.getFileName().toString().endsWith(".jar")) {
                Path rootPath = JarUtils.resolveSourcePath(sourcePath, true);
                try {
                    fileStream = new BufferedInputStream(new FileInputStream(new File(rootPath.toFile(), fileName)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException("File " + fileName + " doesn't exist!");
                }
            } else {
                fileStream = packageClass.getResourceAsStream(fileName);
            }
        } else {
            fileStream = packageClass.getResourceAsStream(fileName);
        }
        if (fileStream == null) {
            throw new IOException("File " + fileName + " doesn't exist!");
        }
        return fileStream;
    }

    public static List<URL> getFileURLs(String fileName, String directoryName, Class<?> packageClass) throws IOException {
        Path sourcePath = JarUtils.getCodeSourcePath(packageClass);
        if (sourcePath == null) {
            throw new IOException(new NullPointerException("getCodeSourcePath() result is null!"));
        }
        String directoryResolvedName = JarUtils.resolveName(directoryName, packageClass);
        if (sourcePath.getFileName().toString().endsWith(".jar")) {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JarFile jarFile = new JarFile(sourcePath.toFile());){
                return jarFile.stream().filter(entry -> entry.getName().startsWith(directoryResolvedName) && entry.getName().endsWith(fileName)).map(entry -> {
                    try {
                        return new URL("jar:" + sourcePath.toUri().toURL() + "!/" + entry.getName());
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }).filter(url -> url != null).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        Path searchPath = JarUtils.resolveSourcePath(sourcePath, directoryName.startsWith("/"));
        Throwable throwable = null;
        Object var7_13 = null;
        try (Stream<Path> paths = Files.walk(searchPath.resolve(directoryResolvedName), FileVisitOption.FOLLOW_LINKS);){
            return paths.filter(path -> path.endsWith(fileName)).map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (Exception exception) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyStreamToFile(InputStream fileStream, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                try (BufferedInputStream is = fileStream instanceof BufferedInputStream ? (BufferedInputStream)fileStream : new BufferedInputStream(fileStream);){
                    byte[] buffer = new byte[8192];
                    int len = 0;
                    while ((len = is.read(buffer)) > 0) {
                        os.write(buffer, 0, len);
                    }
                }
                if (os == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            os.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static Path getCodeSourcePath(Class<?> clazz) {
        URL soruceCodeLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
        Path path = null;
        try {
            path = Paths.get(soruceCodeLocation.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            String stringPath = soruceCodeLocation.getPath();
            try {
                path = Paths.get(stringPath, new String[0]);
            }
            catch (InvalidPathException invalidPathException) {
                stringPath = stringPath.replaceFirst("^/(.:/)", "$1");
                try {
                    path = Paths.get(stringPath, new String[0]);
                }
                catch (InvalidPathException invalidPathException2) {}
            }
        }
        return path;
    }

    private static File checkDestinationDirectory(String destinationDirectory, boolean createDestinationDirectory) throws IOException {
        File destinationFile = new File(destinationDirectory);
        if (!destinationFile.exists()) {
            if (!createDestinationDirectory) {
                throw new IOException("Destination directory " + destinationDirectory + " doesn't exist!");
            }
            boolean created = destinationFile.mkdirs();
            if (!created) {
                throw new IOException("Couldn't create destination directory " + destinationDirectory + "!");
            }
        }
        if (!destinationFile.canWrite()) {
            throw new IOException("Couldn't write in destination directory " + destinationDirectory + "!");
        }
        return destinationFile;
    }

    private static void copyFilesToDirectory(File[] fileList, File destination) throws FileNotFoundException, IOException {
        if (fileList == null) {
            return;
        }
        JarUtils.checkDestinationDirectory(destination.getAbsolutePath(), true);
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            File newFile = new File(destination, file.getName());
            if (file.isFile()) {
                JarUtils.copyStreamToFile(new BufferedInputStream(new FileInputStream(file)), newFile);
            } else if (file.isDirectory()) {
                JarUtils.copyFilesToDirectory(file.listFiles(), newFile);
            }
            ++n2;
        }
    }

    public static String resolveName(String name, Class<?> clazz) {
        String resolvedName = null;
        if (!name.startsWith("/")) {
            Class<?> c = clazz;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            resolvedName = index != -1 ? String.valueOf(baseName.substring(0, index).replace('.', '/')) + "/" + name : name;
        } else {
            resolvedName = name.substring(1);
        }
        if (resolvedName.endsWith("/")) {
            resolvedName = resolvedName.substring(0, resolvedName.length() - 1);
        }
        return resolvedName;
    }

    private static Path resolveSourcePath(Path sourcePath, boolean absoulutePath) {
        Path resolvedPath = null;
        resolvedPath = sourcePath.endsWith("bin") ? (!absoulutePath ? sourcePath.resolveSibling("src") : sourcePath.getParent()) : sourcePath;
        return resolvedPath;
    }
}

