/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public enum MaskType {
    X,
    Z,
    H,
    L,
    U,
    W,
    DASH,
    UNKNOWN,
    supply0,
    strong0,
    pull0,
    weak0,
    highz0,
    highz1,
    weak1,
    pull1,
    strong1,
    supply1;

    public static final EnumSet<MaskType> NonDriveStrengthMasks;
    public static final EnumSet<MaskType> DriveStrengths;
    public static final EnumSet<MaskType> ZeroDriveStrengths;
    public static final EnumSet<MaskType> OneDriveStrengths;
    public static final EnumSet<MaskType> AllMasks;
    public static final Set<String> ZeroDriveStrengthRawNames;
    public static final Set<String> OneDriveStrengthRawNames;
    private static final byte[] VhdlStdLogicEnumOrdinalCache;

    static {
        NonDriveStrengthMasks = EnumSet.of(X, new MaskType[]{Z, H, L, U, W, DASH, UNKNOWN});
        DriveStrengths = EnumSet.of(highz0, new MaskType[]{weak0, pull0, strong0, supply0, highz1, weak1, pull1, strong1, supply1});
        ZeroDriveStrengths = EnumSet.of(highz0, weak0, pull0, strong0, supply0);
        OneDriveStrengths = EnumSet.of(highz1, weak1, pull1, strong1, supply1);
        AllMasks = EnumSet.of(X, new MaskType[]{Z, H, L, U, W, DASH, UNKNOWN, highz0, weak0, pull0, strong0, supply0, highz1, weak1, pull1, strong1, supply1});
        ZeroDriveStrengthRawNames = new LinkedHashSet<String>();
        OneDriveStrengthRawNames = new LinkedHashSet<String>();
        ZeroDriveStrengthRawNames.add("highz0");
        ZeroDriveStrengthRawNames.add("weak0");
        ZeroDriveStrengthRawNames.add("pull0");
        ZeroDriveStrengthRawNames.add("strong0");
        ZeroDriveStrengthRawNames.add("supply0");
        OneDriveStrengthRawNames.add("highz1");
        OneDriveStrengthRawNames.add("weak1");
        OneDriveStrengthRawNames.add("pull1");
        OneDriveStrengthRawNames.add("strong1");
        OneDriveStrengthRawNames.add("supply1");
        VhdlStdLogicEnumOrdinalCache = new byte[46];
        MaskType.VhdlStdLogicEnumOrdinalCache[40] = 0;
        MaskType.VhdlStdLogicEnumOrdinalCache[43] = 1;
        MaskType.VhdlStdLogicEnumOrdinalCache[3] = 2;
        MaskType.VhdlStdLogicEnumOrdinalCache[4] = 3;
        MaskType.VhdlStdLogicEnumOrdinalCache[45] = 4;
        MaskType.VhdlStdLogicEnumOrdinalCache[42] = 5;
        MaskType.VhdlStdLogicEnumOrdinalCache[31] = 6;
        MaskType.VhdlStdLogicEnumOrdinalCache[27] = 7;
        MaskType.VhdlStdLogicEnumOrdinalCache[0] = 8;
    }

    public String toString() {
        if (this == DASH) {
            return "-";
        }
        if (this == UNKNOWN) {
            return "?";
        }
        return this.name();
    }

    public String toNiceString(boolean useLowerCaseMaskType) {
        if (this == DASH) {
            return "-";
        }
        if (this == UNKNOWN) {
            return "?";
        }
        if (useLowerCaseMaskType) {
            return this.name().toLowerCase();
        }
        return this.name();
    }

    public static MaskType getDriveStrength(String rawName) {
        for (MaskType type : DriveStrengths) {
            if (!rawName.equals(type.name())) continue;
            return type;
        }
        return null;
    }

    public static boolean equalDrive(MaskType m1, MaskType m2) {
        if (!DriveStrengths.contains((Object)m1) || !DriveStrengths.contains((Object)m2)) {
            return false;
        }
        return m1 == m2 || m1 == MaskType.complementStrength(m2);
    }

    public static boolean driveStrongerThan(MaskType m1, MaskType m2) {
        if (!DriveStrengths.contains((Object)m1) || !DriveStrengths.contains((Object)m2)) {
            return false;
        }
        boolean m10 = ZeroDriveStrengths.contains((Object)m1);
        boolean m20 = ZeroDriveStrengths.contains((Object)m2);
        if (m10 && !m20 || !m10 && m20) {
            m2 = MaskType.complementStrength(m2);
        }
        return m10 ? m1.ordinal() < m2.ordinal() : m1.ordinal() > m2.ordinal();
    }

    public static MaskType complementStrength(MaskType m) {
        if (!DriveStrengths.contains((Object)m)) {
            return m;
        }
        switch (m) {
            case highz0: {
                return highz1;
            }
            case highz1: {
                return highz0;
            }
            case weak0: {
                return weak1;
            }
            case weak1: {
                return weak0;
            }
            case pull0: {
                return pull1;
            }
            case pull1: {
                return pull0;
            }
            case strong0: {
                return strong1;
            }
            case strong1: {
                return strong0;
            }
            case supply1: {
                return supply0;
            }
            case supply0: {
                return supply1;
            }
        }
        return m;
    }

    public static void updateMaskBit(EnumMap<MaskType, BitSet> masks, MaskType maskType, int bitIndex) {
        BitSet mask = masks.get((Object)maskType);
        if (mask == null) {
            mask = new BitSet();
            masks.put(maskType, mask);
        }
        mask.set(bitIndex);
    }

    public static byte getVhdlStdLogicEnumOrdinal(char bit) {
        int index = bit - 45;
        if (index >= 0 && index < VhdlStdLogicEnumOrdinalCache.length) {
            return VhdlStdLogicEnumOrdinalCache[index];
        }
        return -1;
    }
}

