/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;
import ro.amiq.dvt.startup.core.DVTLogger;

public class MemUtils {
    public static final String COLLECT_STATS_VAR = "DVT_COLLECT_MEMORY_STATISTICS";
    public static final boolean COLLECT_STATS = Boolean.parseBoolean(System.getenv("DVT_COLLECT_MEMORY_STATISTICS"));
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String CLASS_HOTSPOT_BEAN = "com.sun.management.HotSpotDiagnosticMXBean";
    private static final String METHOD_DUMP_HEAP = "dumpHeap";
    private static Object hotspotMBean;

    public static final void forceGC() {
        try {
            long usedMem1 = MemUtils.computeUsedMemory();
            long usedMem2 = Long.MAX_VALUE;
            int i = 0;
            while (usedMem1 < usedMem2 && i < 1000) {
                MemUtils.getGcCount();
                System.runFinalization();
                long before = MemUtils.getGcCount();
                System.gc();
                while (MemUtils.getGcCount() == before) {
                }
                Thread.yield();
                usedMem2 = usedMem1;
                usedMem1 = MemUtils.computeUsedMemory();
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static final long computeUsedMemory(boolean doGcFirst) {
        if (doGcFirst) {
            MemUtils.forceGC();
        }
        return MemUtils.computeUsedMemory();
    }

    private static long computeUsedMemory() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    private static long getGcCount() {
        long sum = 0L;
        for (GarbageCollectorMXBean b : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = b.getCollectionCount();
            if (count == -1L) continue;
            sum += count;
        }
        return sum;
    }

    public static void dumpHeap(String fileName) {
        if (hotspotMBean == null) {
            hotspotMBean = MemUtils.getHotspotMBean();
        }
        try {
            Class<?> clazz = Class.forName(CLASS_HOTSPOT_BEAN);
            if (clazz == null) {
                DVTLogger.INSTANCE.logError("Could not load class com.sun.management.HotSpotDiagnosticMXBean");
                return;
            }
            Method m = clazz.getMethod(METHOD_DUMP_HEAP, String.class, Boolean.TYPE);
            if (m == null) {
                DVTLogger.INSTANCE.logError("Could not find method dumpHeap");
                return;
            }
            m.invoke(hotspotMBean, fileName, false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static Object getHotspotMBean() {
        try {
            Class<?> clazz = Class.forName(CLASS_HOTSPOT_BEAN);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isPossibleMemoryLeak(long startMem, long finalMem) {
        long percentage = finalMem * 100L / startMem;
        long factor1024 = Math.max(25L * (startMem - 512L) / 512L, 0L);
        long factor128 = Math.max(50L * (startMem - 64L) / 64L, 0L);
        return Math.abs(startMem - finalMem) > 16L && (startMem > 1024L ? percentage < 75L || 125L < percentage : (startMem > 128L ? percentage < 50L + factor1024 || 150L - factor1024 < percentage : percentage < 0L + factor128 || 200L - factor128 < percentage));
    }
}

