/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import ro.amiq.dvt.utils.IDVTListElement;

public abstract class OptimizedCollection<K>
implements Collection<K>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Object elements = null;

    @Override
    public final int size() {
        Object elems = this.elements;
        if (elems == null) {
            return 0;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).size();
        }
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        Object elems = this.elements;
        if (elems == null) {
            return true;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).isEmpty();
        }
        return false;
    }

    @Override
    public final boolean contains(Object o) {
        Object elems = this.elements;
        if (elems == null) {
            return false;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).contains(o);
        }
        return elems.equals(o);
    }

    @Override
    public final Iterator<K> iterator() {
        Object elems = this.elements;
        if (elems == null) {
            return new OneValueIterator();
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).iterator();
        }
        return new OneValueIterator();
    }

    @Override
    public final Object[] toArray() {
        if (this.elements == null) {
            return new Object[0];
        }
        if (this.elements instanceof Collection) {
            return ((Collection)this.elements).toArray();
        }
        return new Object[]{this.elements};
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        if (this.elements == null) {
            return a;
        }
        if (this.elements instanceof Collection) {
            return ((Collection)this.elements).toArray(a);
        }
        a[0] = this.elements;
        return a;
    }

    @Override
    public boolean add(K e) {
        Object elems = this.elements;
        if (elems == null) {
            this.elements = e;
            return true;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).add(e);
        }
        Collection<K> collection = this.initializeCollection(3);
        collection.add(elems);
        collection.add(e);
        this.elements = collection;
        return true;
    }

    abstract Collection<K> initializeCollection(int var1);

    @Override
    public final boolean remove(Object o) {
        Object elems = this.elements;
        if (elems == null) {
            return false;
        }
        if (elems instanceof Collection) {
            boolean result = ((Collection)elems).remove(o);
            if (result && ((Collection)elems).size() == 1) {
                this.elements = ((Collection)elems).iterator().next();
            }
            return result;
        }
        if (elems.equals(o)) {
            this.elements = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new NotImplemented("Method 'containsAll(Collection c))' is not implemented");
    }

    @Override
    public final boolean addAll(Collection<? extends K> c) {
        Collection<K> collection = null;
        Object elems = this.elements;
        if (elems == null) {
            if (c.isEmpty()) {
                return true;
            }
            if (c.size() == 1) {
                this.elements = c.iterator().next();
                return true;
            }
            collection = this.initializeCollection(Math.max(c.size() + 1, 4));
            collection.addAll(c);
            if (collection.size() == 1) {
                this.elements = collection.iterator().next();
                return true;
            }
            this.elements = collection;
            return true;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).addAll(c);
        }
        collection = this.initializeCollection(Math.max(c.size() + 2, 4));
        collection.add(elems);
        collection.addAll(c);
        if (collection.size() == 1) {
            this.elements = collection.iterator().next();
            return true;
        }
        this.elements = collection;
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new NotImplemented("Method 'removeAll(Collection c)' is not implemented");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplemented("Method 'retainAll(Collection c)' is not implemented");
    }

    @Override
    public final void clear() {
        Object elems = this.elements;
        if (elems instanceof Collection) {
            ((Collection)elems).clear();
        }
        this.elements = null;
    }

    @Override
    public final int hashCode() {
        Object elems = this.elements;
        if (elems == null) {
            return 1;
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).hashCode();
        }
        return elems.hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        int otherSize;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Collection)) {
            return false;
        }
        int thisSize = this.size();
        if (thisSize != (otherSize = ((Collection)other).size())) {
            return false;
        }
        if (thisSize > 0) {
            Iterator<K> thisIterator = this.iterator();
            Iterator otherIterator = ((Collection)other).iterator();
            while (thisIterator.hasNext()) {
                K o1 = thisIterator.next();
                Object o2 = otherIterator.next();
                if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
                return false;
            }
        }
        return true;
    }

    public void deepClean() {
        Object elems = this.elements;
        if (elems == null) {
            return;
        }
        if (elems instanceof Collection) {
            try {
                for (Object e : (Collection)elems) {
                    if (!(e instanceof IDVTListElement)) continue;
                    ((IDVTListElement)e).deepClean();
                }
                ((Collection)elems).clear();
            }
            catch (Exception exception) {}
        }
        if (elems instanceof IDVTListElement) {
            ((IDVTListElement)elems).deepClean();
        }
        this.elements = null;
    }

    public String toString() {
        Object elems = this.elements;
        if (elems == null) {
            return "[]";
        }
        if (elems instanceof Collection) {
            return ((Collection)elems).toString();
        }
        return "[" + elems.toString() + "]";
    }

    static class NotImplemented
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotImplemented(String message) {
            super(message);
        }
    }

    protected class OneValueIterator
    implements Iterator<K> {
        protected boolean hasNext = true;

        protected OneValueIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                return false;
            }
            return OptimizedCollection.this.elements != null;
        }

        @Override
        public void remove() {
            OptimizedCollection.this.elements = null;
        }

        @Override
        public K next() {
            this.hasNext = false;
            return OptimizedCollection.this.elements;
        }
    }
}

