/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OptimizedHashMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Object elements;

    @Override
    public final int size() {
        Object elems = this.elements;
        if (elems == null) {
            return 0;
        }
        if (elems instanceof Map) {
            return ((Map)elems).size();
        }
        return 1;
    }

    @Override
    public final boolean isEmpty() {
        Object elems = this.elements;
        if (elems == null) {
            return true;
        }
        if (elems instanceof Map) {
            return ((Map)elems).isEmpty();
        }
        return false;
    }

    @Override
    public final void clear() {
        Object elems = this.elements;
        if (elems instanceof Map) {
            ((Map)elems).clear();
        }
        this.elements = null;
    }

    public String toString() {
        Object elems = this.elements;
        if (elems == null) {
            return "[]";
        }
        if (elems instanceof Map) {
            return ((Map)elems).toString();
        }
        return elems.toString();
    }

    @Override
    public final int hashCode() {
        Object elems = this.elements;
        if (elems == null) {
            return 1;
        }
        if (elems instanceof Map) {
            return ((Map)elems).hashCode();
        }
        return elems.hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OptimizedHashMap)) {
            return false;
        }
        Object elems = this.elements;
        Object elems2 = ((OptimizedHashMap)other).elements;
        if (elems == null) {
            return elems2 == null;
        }
        if (elems2 == null) {
            return false;
        }
        if (elems instanceof Map && elems2 instanceof Map) {
            return elems.equals(elems2);
        }
        if (elems instanceof Entry && elems2 instanceof Entry) {
            return elems.equals(elems2);
        }
        return false;
    }

    @Override
    public final boolean containsKey(Object key) {
        Object elems = this.elements;
        if (elems == null) {
            return false;
        }
        if (elems instanceof Map) {
            return ((Map)elems).containsKey(key);
        }
        return ((Entry)elems).key.equals(key);
    }

    @Override
    public final boolean containsValue(Object value) {
        Object elems = this.elements;
        if (elems == null) {
            return false;
        }
        if (elems instanceof Map) {
            return ((Map)elems).containsValue(value);
        }
        return ((Entry)elems).value.equals(value);
    }

    @Override
    public final V get(Object key) {
        Object elems = this.elements;
        if (elems == null) {
            return null;
        }
        if (elems instanceof Map) {
            return ((Map)elems).get(key);
        }
        if (((Entry)elems).key.equals(key)) {
            return ((Entry)elems).value;
        }
        return null;
    }

    @Override
    public final V put(K key, V value) {
        Object elems = this.elements;
        if (elems == null) {
            this.elements = new Entry(key, value);
            return null;
        }
        if (elems instanceof Map) {
            return ((Map)elems).put(key, value);
        }
        if (((Entry)elems).key.equals(key)) {
            Object prev = ((Entry)elems).value;
            ((Entry)elems).value = value;
            return prev;
        }
        Map<K, V> map = this.internalCreateMap(4);
        map.put(((Entry)elems).key, ((Entry)elems).value);
        this.elements = map;
        return map.put(key, value);
    }

    @Override
    public final V remove(Object key) {
        Object elems = this.elements;
        if (elems == null) {
            return null;
        }
        if (elems instanceof Map) {
            Object result = ((Map)elems).remove(key);
            if (((Map)elems).size() == 1) {
                this.elements = new Entry(((Map)elems).entrySet().iterator().next());
            }
            return result;
        }
        if (((Entry)elems).key.equals(key)) {
            Object prev = ((Entry)elems).value;
            this.elements = null;
            return prev;
        }
        return null;
    }

    Map<K, V> internalCreateMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Set<K> keySet() {
        final Object elems = this.elements;
        if (elems == null) {
            return Collections.EMPTY_SET;
        }
        if (elems instanceof Map) {
            return ((Map)elems).keySet();
        }
        return new OneElementSet<K>(this){

            @Override
            K internalGetElement() {
                return ((Entry)elems).key;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Object elems = this.elements;
        if (elems == null) {
            return Collections.EMPTY_SET;
        }
        if (elems instanceof Map) {
            return ((Map)elems).entrySet();
        }
        return new OneElementSet<Map.Entry<K, V>>(this){

            @Override
            Map.Entry<K, V> internalGetElement() {
                return (Map.Entry)elems;
            }
        };
    }

    @Override
    public Collection<V> values() {
        final Object elems = this.elements;
        if (elems == null) {
            return Collections.EMPTY_LIST;
        }
        if (elems instanceof Map) {
            return ((Map)elems).values();
        }
        return new OneElementSet<V>(this){

            @Override
            V internalGetElement() {
                return ((Entry)elems).value;
            }
        };
    }

    class Entry
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public Entry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return null;
        }

        public String toString() {
            return "[" + this.key + ", " + this.value + "]";
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    static class NotImplemented
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotImplemented(String message) {
            super(message);
        }
    }

    private abstract class OneElementSet<T>
    implements Set<T> {
        private OneElementSet() {
        }

        @Override
        public int size() {
            if (OptimizedHashMap.this.elements == null) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return OptimizedHashMap.this.elements == null;
        }

        @Override
        public boolean contains(Object o) {
            if (OptimizedHashMap.this.elements == null) {
                return false;
            }
            return this.internalGetElement().equals(o);
        }

        abstract T internalGetElement();

        @Override
        public Iterator<T> iterator() {
            return new OneValueIterator<T>(OptimizedHashMap.this){

                @Override
                T internalGetElement() {
                    return OneElementSet.this.internalGetElement();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.internalGetElement()};
        }

        @Override
        public <E> E[] toArray(E[] a) {
            a[0] = this.internalGetElement();
            return a;
        }

        @Override
        public boolean add(T e) {
            throw new NotImplemented("Method 'add(Collection c))' is not implemented");
        }

        @Override
        public boolean remove(Object o) {
            if (this.internalGetElement().equals(o)) {
                OptimizedHashMap.this.elements = null;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new NotImplemented("Method 'containsAll(Collection c))' is not implemented");
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new NotImplemented("Method 'addAll(Collection c))' is not implemented");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new NotImplemented("Method 'removeAll(Collection c))' is not implemented");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new NotImplemented("Method 'retainAll(Collection c))' is not implemented");
        }

        @Override
        public void clear() {
            OptimizedHashMap.this.elements = null;
        }
    }

    private abstract class OneValueIterator<T>
    implements Iterator<T> {
        boolean hasNext = true;

        private OneValueIterator() {
        }

        @Override
        public final boolean hasNext() {
            if (!this.hasNext) {
                return false;
            }
            return OptimizedHashMap.this.elements != null;
        }

        abstract T internalGetElement();

        @Override
        public final void remove() {
            OptimizedHashMap.this.elements = null;
        }

        @Override
        public final T next() {
            this.hasNext = false;
            return this.internalGetElement();
        }
    }
}

