/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Collection;
import java.util.Set;
import ro.amiq.dvt.optimized.collections.ExtendedSet;
import ro.amiq.dvt.utils.DVTHashSet;
import ro.amiq.dvt.utils.OptimizedCollection;

public class OptimizedHashSet<K>
extends OptimizedCollection<K>
implements ExtendedSet<K> {
    private static final long serialVersionUID = 1L;

    protected OptimizedHashSet() {
    }

    protected OptimizedHashSet(int capacity) {
        if (capacity > 1) {
            this.elements = this.initializeCollection(capacity);
        }
    }

    protected OptimizedHashSet(Collection<? extends K> c) {
        if (c.isEmpty()) {
            return;
        }
        if (c.size() == 1) {
            this.elements = c.iterator().next();
            return;
        }
        Collection<K> elems = this.initializeCollection(c.size());
        ((Set)elems).addAll(c);
        this.elements = elems;
    }

    @Override
    public final boolean add(K e) {
        Object elems = this.elements;
        if (elems == null) {
            this.elements = e;
            return true;
        }
        if (elems instanceof Set) {
            return ((Set)elems).add(e);
        }
        if (elems.equals(e)) {
            return false;
        }
        Collection<K> collection = this.initializeCollection(3);
        collection.add(elems);
        collection.add(e);
        this.elements = collection;
        return true;
    }

    @Override
    Collection<K> initializeCollection(int capacity) {
        return new DVTHashSet(capacity);
    }

    @Override
    public final K get(K key) {
        Object elems = this.elements;
        if (elems == null) {
            return null;
        }
        if (elems instanceof ExtendedSet) {
            return ((ExtendedSet)elems).get(key);
        }
        if (elems.equals(key)) {
            return (K)elems;
        }
        return null;
    }
}

