/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.utils.OptimizedCollection;

public class OptimizedList<E>
extends OptimizedCollection<E>
implements List<E> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new OptimizedCollection.NotImplemented("Method 'addAll(int index, Collection<? extends E> c)' is not implemented");
    }

    protected OptimizedList() {
    }

    protected OptimizedList(int capacity) {
        if (capacity > 1) {
            this.elements = this.initializeCollection(capacity);
        }
    }

    protected OptimizedList(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return;
        }
        if (c.size() == 1) {
            this.elements = c.iterator().next();
            return;
        }
        Object elems = this.elements = this.initializeCollection(c.size());
        ((List)elems).addAll(c);
    }

    @Override
    public final E get(int index) {
        Object elems = this.elements;
        if (elems == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elems instanceof List) {
            return ((List)elems).get(index);
        }
        if (index > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (E)elems;
    }

    public final E get(int searchIterationsLimit, E object) {
        if (object == null) {
            return null;
        }
        Object elems = this.elements;
        if (elems == null) {
            return null;
        }
        if (elems instanceof List) {
            List list = (List)elems;
            int maxIndex = list.size() - 1;
            int minIndex = Math.max(0, maxIndex - searchIterationsLimit);
            int i = maxIndex;
            while (i >= minIndex) {
                Object existing = list.get(i);
                if (object.equals(existing)) {
                    return existing;
                }
                --i;
            }
            return null;
        }
        if (elems.equals(object)) {
            return (E)elems;
        }
        return null;
    }

    @Override
    public final E set(int index, E element) {
        Object elems = this.elements;
        if (elems == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elems instanceof List) {
            return ((List)elems).set(index, element);
        }
        if (index > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.elements = element;
        return element;
    }

    @Override
    public final void add(int index, E element) {
        Object elems = this.elements;
        if (elems == null && index > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elems == null && index == 0) {
            this.elements = element;
            return;
        }
        if (elems instanceof List) {
            ((List)elems).add(index, element);
            return;
        }
        if (index > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Collection list = this.initializeCollection(4);
        list.add(elems);
        list.add(index, element);
        this.elements = list;
    }

    @Override
    public final E remove(int index) {
        Object elems = this.elements;
        if (elems == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (elems instanceof List) {
            Object result = ((List)elems).remove(index);
            if (result != null && ((List)elems).size() == 1) {
                this.elements = ((List)elems).get(0);
            }
            return result;
        }
        if (index > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object temp = elems;
        this.elements = null;
        return (E)temp;
    }

    @Override
    public final int indexOf(Object o) {
        Object elems = this.elements;
        if (elems == null) {
            return -1;
        }
        if (elems instanceof List) {
            return ((List)elems).indexOf(o);
        }
        if (elems.equals(o)) {
            return 0;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object o) {
        Object elems = this.elements;
        if (elems == null) {
            return -1;
        }
        if (elems instanceof List) {
            return ((List)elems).lastIndexOf(o);
        }
        if (elems.equals(o)) {
            return 0;
        }
        return -1;
    }

    @Override
    public final ListIterator<E> listIterator() {
        Object elems = this.elements;
        if (elems instanceof List) {
            return ((List)elems).listIterator();
        }
        if (elems == null) {
            return Collections.emptyListIterator();
        }
        return new OneValueListIterator(0);
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        Object elems = this.elements;
        if (elems instanceof List) {
            return ((List)elems).listIterator(index);
        }
        if (elems == null) {
            return Collections.emptyListIterator();
        }
        return new OneValueListIterator(index);
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return Collections.EMPTY_LIST;
        }
        if (fromIndex < 0 || toIndex > this.size() || toIndex < fromIndex) {
            throw new IndexOutOfBoundsException();
        }
        Object elems = this.elements;
        if (elems == null) {
            return Collections.EMPTY_LIST;
        }
        if (elems instanceof List) {
            return ((List)elems).subList(fromIndex, toIndex);
        }
        return this;
    }

    @Override
    final List<E> initializeCollection(int capacity) {
        return new ArrayListContainer(capacity);
    }

    private final class OneValueListIterator
    extends OptimizedCollection.OneValueIterator
    implements ListIterator<E> {
        public OneValueListIterator(int index) {
            if (index > 1 || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index == 1) {
                this.hasNext = false;
            }
        }

        @Override
        public final boolean hasPrevious() {
            return !this.hasNext;
        }

        @Override
        public final E previous() {
            this.hasNext = true;
            return OptimizedList.this.elements;
        }

        @Override
        public final int nextIndex() {
            return this.hasNext ? 0 : (OptimizedList.this.elements == null ? 0 : 1);
        }

        @Override
        public final int previousIndex() {
            return this.hasNext ? -1 : (OptimizedList.this.elements == null ? -1 : 0);
        }

        @Override
        public final void set(E e) {
            OptimizedList.this.elements = e;
        }

        @Override
        public void add(E e) {
            throw new OptimizedCollection.NotImplemented("Method 'add(E e)' is not implemented");
        }
    }
}

