/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ExtendedSet;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.IDVTListElement;
import ro.amiq.dvt.utils.OptimizedHashSet;
import ro.amiq.dvt.utils.OptimizedLinkedSet;
import ro.amiq.dvt.utils.OptimizedList;

public class OptimizedUtils {
    public static final <E> List<E> listCreate(Collection<E> c) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            if (c instanceof List) {
                return (List)c;
            }
            return Collections.emptyList();
        }
        OptimizedList<E> result = new OptimizedList<E>(c);
        if (result.elements instanceof List) {
            return (List)result.elements;
        }
        return result;
    }

    public static final <E> List<E> listCreate(int initialCapacity) {
        if (initialCapacity == 0) {
            return null;
        }
        OptimizedList result = new OptimizedList(initialCapacity);
        if (result.elements instanceof List) {
            return (List)result.elements;
        }
        return result;
    }

    public static final <E> List<E> listAdd(Collection<E> c, E e) {
        if (c != null && !(c instanceof List)) {
            throw new RuntimeException("OptimizedUtils listAdd first argument is not a list");
        }
        OptimizedList<E> result = (OptimizedList<E>)c;
        if (result == null || result == Collections.EMPTY_LIST) {
            result = new OptimizedList<E>();
            result.add(e);
            return result;
        }
        result.add(e);
        if (result instanceof OptimizedList && result.size() > 1) {
            return (List)result.elements;
        }
        return result;
    }

    public static final <E> List<E> listAdd(Collection<E> c, Collection<? extends E> e) {
        if (c != null && !(c instanceof List)) {
            throw new RuntimeException("OptimizedUtils listAdd first argument is not a list");
        }
        if (e == null || e.isEmpty()) {
            return (List)c;
        }
        OptimizedList<E> result = (OptimizedList<E>)c;
        if (result == null || result == Collections.EMPTY_LIST) {
            result = new OptimizedList<E>();
            result.addAll(e);
            if (result.size() > 1) {
                return (List)result.elements;
            }
            return result;
        }
        result.addAll(e);
        if (result instanceof OptimizedList && result.size() > 1) {
            return (List)result.elements;
        }
        return result;
    }

    public static final void deepClean(Collection<? extends IDVTListElement> c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (IDVTListElement iDVTListElement : c) {
            iDVTListElement.deepClean();
        }
        c.clear();
    }

    public static final void deepClean(ListContainer<? extends IDVTListElement> c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (IDVTListElement iDVTListElement : c) {
            iDVTListElement.deepClean();
        }
        if (c instanceof List) {
            ((List)((Object)c)).clear();
        }
    }

    public static final <E> Set<E> setCreate(Collection<E> c) {
        if (c == null) {
            return null;
        }
        OptimizedHashSet<E> result = new OptimizedHashSet<E>(c);
        if (result.elements instanceof Set) {
            return (Set)result.elements;
        }
        return result;
    }

    public static final <E> Set<E> setCreate(int initialCapacity) {
        if (initialCapacity == 0) {
            return null;
        }
        OptimizedHashSet result = new OptimizedHashSet(initialCapacity);
        if (result.elements instanceof Set) {
            return (Set)result.elements;
        }
        return result;
    }

    public static final <E> Set<E> setAdd(Collection<E> c, E e) {
        if (c != null && !(c instanceof Set)) {
            throw new RuntimeException("OptimizedUtils setAdd first argument is not a set");
        }
        OptimizedHashSet result = (OptimizedHashSet)c;
        if (result == null || result == Collections.emptySet()) {
            result = new OptimizedHashSet();
            result.add(e);
            return result;
        }
        result.add(e);
        if (result instanceof OptimizedHashSet && result.size() > 1) {
            return (Set)result.elements;
        }
        return result;
    }

    public static final <E> ExtendedSet<E> linkedSetCreate(Collection<E> c) {
        if (c == null) {
            return null;
        }
        OptimizedLinkedSet<E> result = new OptimizedLinkedSet<E>(c);
        if (result.elements instanceof ExtendedSet) {
            return (ExtendedSet)result.elements;
        }
        return result;
    }

    public static final <E> ExtendedSet<E> linkedSetCreate(int initialCapacity) {
        if (initialCapacity == 0) {
            return null;
        }
        OptimizedLinkedSet result = new OptimizedLinkedSet(initialCapacity);
        if (result.elements instanceof ExtendedSet) {
            return (ExtendedSet)result.elements;
        }
        return result;
    }

    public static final <E> Set<E> linkedSetAdd(Set<E> c, E e) {
        Set<E> result = c;
        if (result == null || result == Collections.emptySet()) {
            result = new OptimizedLinkedSet<E>();
            result.add(e);
            return result;
        }
        result.add(e);
        if (result instanceof OptimizedLinkedSet && result.size() > 1) {
            return (Set)((OptimizedLinkedSet)result).elements;
        }
        return result;
    }

    public static <E> ListContainer<E> listContainerCreate(Collection<E> c, boolean avoidCopy) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        if (c.size() == 1) {
            E e = c.iterator().next();
            if (e == null || !(e instanceof ListContainer)) {
                throw new RuntimeException("OptimizedUtils listContainerCreate argument is not a list container element: " + (e == null ? "null" : e.getClass()));
            }
            return (ListContainer)e;
        }
        if (avoidCopy && c instanceof ArrayListContainer) {
            return (ListContainer)((Object)c);
        }
        ArrayListContainer<E> result = new ArrayListContainer<E>(c.size());
        result.addAll(c);
        return result;
    }

    public static final <E> ListContainer<E> listContainerAdd(ListContainer<E> c, E e) {
        if (e == null || !(e instanceof ListContainer)) {
            throw new RuntimeException("OptimizedUtils listHolderAdd second argument is not a list container element: " + (e == null ? "null" : e.getClass()));
        }
        if (c == null || c.isEmpty()) {
            return (ListContainer)e;
        }
        ArrayListContainer<ListContainer<E>> result = null;
        if (c instanceof List) {
            result = (ArrayListContainer<ListContainer<E>>)c;
        } else {
            result = new ArrayListContainer<ListContainer<E>>(2);
            result.add(c);
        }
        result.add((ListContainer<E>)e);
        return result;
    }

    public static final <E> ListContainer<E> listContainerAdd(ListContainer<E> c, int index, E e) {
        if (e == null || !(e instanceof ListContainer)) {
            throw new RuntimeException("OptimizedUtils listHolderAdd second argument is not a list container element: " + (e == null ? "null" : e.getClass()));
        }
        if (c == null || c.isEmpty()) {
            if (index != 0) {
                throw new RuntimeException("OptimizedUtils listHolderAdd index out of bounds: " + index);
            }
            return (ListContainer)e;
        }
        ArrayListContainer<ListContainer<E>> result = null;
        if (c instanceof List) {
            result = (ArrayListContainer<ListContainer<E>>)c;
        } else {
            result = new ArrayListContainer<ListContainer<E>>(2);
            result.add(c);
        }
        result.add(index, (ListContainer<E>)e);
        return result;
    }

    public static <E> ListContainer<E> listContainerRemove(ListContainer<E> c, int index) {
        if (c instanceof List) {
            ((List)((Object)c)).remove(index);
            if (c.isEmpty()) {
                return null;
            }
            if (c.size() == 1) {
                return (ListContainer)((List)((Object)c)).get(0);
            }
            return c;
        }
        if (index > 0 || index < 0) {
            throw new RuntimeException("OptimizedUtils listContainerRemove index out of bounds");
        }
        return null;
    }

    public static <E> ListContainer<E> listContainerRemove(ListContainer<E> c, E e) {
        if (c == null) {
            return null;
        }
        if (c instanceof List) {
            ((List)((Object)c)).remove(e);
            if (c.isEmpty()) {
                return null;
            }
            if (c.size() == 1) {
                return (ListContainer)((List)((Object)c)).get(0);
            }
            return c;
        }
        if (c.equals(e)) {
            return null;
        }
        return c;
    }

    public static <E> ListContainer<E> listContainerClear(ListContainer<E> c) {
        if (c instanceof List) {
            ((List)((Object)c)).clear();
        }
        return null;
    }

    public static <E> List<E> asList(ListContainer<E> c, boolean createCopy) {
        if (c == null) {
            return null;
        }
        if (c.isEmpty()) {
            return Collections.emptyList();
        }
        if (c instanceof List) {
            if (!createCopy) {
                return (List)((Object)c);
            }
            return new ArrayList((List)((Object)c));
        }
        ArrayList<ListContainer<E>> result = new ArrayList<ListContainer<E>>(1);
        result.add(c);
        return result;
    }

    public static int noRehashSize(int capacity) {
        return (int)((float)capacity / 0.75f + 1.0f);
    }
}

