/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class PFileInputStream
extends InputStream {
    private final BlockingQueue<DataBlock> fRQueue;
    private final ReaderRunnable fRRunnable;
    private volatile boolean fIsClosedOrEnded = false;
    private DataBlock fCurrentBlock = null;
    private DataBlock fFirstBlock = null;
    private int fCurrentPosition = 0;
    private boolean fEOF = false;
    private static final long S_64_K = 65536L;
    private static final long S_128_K = 131072L;
    private static final long S_256_K = 262144L;
    private static final long S_512_K = 524288L;
    private static final long S_1024_K = 0x100000L;
    private static final long S_2048_K = 0x200000L;
    private static final long S_4096_K = 0x400000L;
    private static final long S_8192_K = 0x800000L;

    private static final int computeReadSize(long fileSize) {
        if (fileSize <= 524288L) {
            return 65536;
        }
        if (fileSize <= 0x400000L) {
            return 131072;
        }
        return 262144;
    }

    private static final int computeQueueSizes(long fileSize) {
        if (fileSize <= 524288L) {
            return 9;
        }
        if (fileSize <= 0x400000L) {
            return 33;
        }
        return Math.max(128, (int)(fileSize / 262144L) + 1);
    }

    public PFileInputStream(File file) throws FileNotFoundException {
        this(file, file.length());
    }

    public PFileInputStream(File file, long fileSize) throws FileNotFoundException {
        this(file, PFileInputStream.computeReadSize(fileSize), PFileInputStream.computeQueueSizes(fileSize));
    }

    public PFileInputStream(File file, int readSize, int queueSize) throws FileNotFoundException {
        this.fRQueue = new ArrayBlockingQueue<DataBlock>(queueSize);
        this.fRRunnable = new ReaderRunnable(file, this.fRQueue, readSize);
        new Thread((Runnable)this.fRRunnable, "File Reader Thread " + file.getName()).start();
    }

    @Override
    public int read() throws IOException {
        if (this.fIsClosedOrEnded) {
            return -1;
        }
        if (this.fCurrentBlock == null) {
            block9: {
                try {
                    if (!this.fEOF) break block9;
                    return -1;
                }
                catch (InterruptedException interruptedException) {
                    this.close();
                    return -1;
                }
            }
            this.fCurrentBlock = this.fRQueue.take();
            if (this.fFirstBlock == null) {
                this.fFirstBlock = this.fCurrentBlock;
            }
        }
        if (this.fCurrentBlock.fSize < 0) {
            this.close();
            if (this.fCurrentBlock.fException != null) {
                throw this.fCurrentBlock.fException;
            }
            this.fEOF = true;
            return -1;
        }
        int result = this.fCurrentBlock.fData[this.fCurrentPosition++] & 0xFF;
        if (this.fCurrentPosition >= this.fCurrentBlock.fSize) {
            this.fCurrentBlock = null;
            this.fCurrentPosition = 0;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.fFirstBlock == null || this.fCurrentBlock == null || this.fFirstBlock == this.fCurrentBlock || this.fCurrentBlock.fSize < 0) {
            this.fCurrentPosition = 0;
            this.fCurrentBlock = this.fFirstBlock;
            this.fIsClosedOrEnded = false;
        } else {
            super.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.fRRunnable.stop();
        this.fIsClosedOrEnded = true;
    }

    private static class DataBlock {
        public final IOException fException;
        public final byte[] fData;
        public final int fSize;

        public DataBlock(byte[] data, int size) {
            this.fException = null;
            this.fData = data;
            this.fSize = size;
        }

        public DataBlock(IOException exception) {
            this.fException = exception;
            this.fData = null;
            this.fSize = -1;
        }
    }

    private static class ReaderRunnable
    implements Runnable {
        private volatile boolean fRunning = true;
        private final InputStream fFileInputStream;
        private final BlockingQueue<DataBlock> fWQueue;
        private final int fReadSize;

        public ReaderRunnable(File file, BlockingQueue<DataBlock> queue, int readSize) throws FileNotFoundException {
            this.fFileInputStream = new BufferedInputStream(new FileInputStream(file));
            this.fWQueue = queue;
            this.fReadSize = readSize;
        }

        @Override
        public void run() {
            block22: {
                try {
                    byte[] buffer = null;
                    int read = 0;
                    while (this.fRunning) {
                        buffer = new byte[this.fReadSize];
                        read = this.fFileInputStream.read(buffer, 0, this.fReadSize);
                        if (this.fRunning) {
                            if (read == -1) {
                                this.fWQueue.put(new DataBlock(null, -1));
                            } else if (this.fRunning) {
                                this.fWQueue.put(new DataBlock(buffer, read));
                                continue;
                            }
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    try {
                        this.fWQueue.put(new DataBlock(e));
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        this.fFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                catch (InterruptedException interruptedException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            this.fFileInputStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        this.fFileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                try {
                    this.fFileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void stop() {
            this.fRunning = false;
        }
    }
}

